/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The type of the data path value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataPathType implements SdkPojo, Serializable, ToCopyableBuilder<DataPathType.Builder, DataPathType> {
    private static final SdkField<String> PIVOT_TABLE_DATA_PATH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PivotTableDataPathType").getter(getter(DataPathType::pivotTableDataPathTypeAsString))
            .setter(setter(Builder::pivotTableDataPathType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PivotTableDataPathType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PIVOT_TABLE_DATA_PATH_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pivotTableDataPathType;

    private DataPathType(BuilderImpl builder) {
        this.pivotTableDataPathType = builder.pivotTableDataPathType;
    }

    /**
     * <p>
     * The type of data path value utilized in a pivot table. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HIERARCHY_ROWS_LAYOUT_COLUMN</code> - The type of data path for the rows layout column, when
     * <code>RowsLayout</code> is set to <code>HIERARCHY</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MULTIPLE_ROW_METRICS_COLUMN</code> - The type of data path for the metric column when the row is set to
     * Metric Placement.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EMPTY_COLUMN_HEADER</code> - The type of data path for the column with empty column header, when there is
     * no field in <code>ColumnsFieldWell</code> and the row is set to Metric Placement.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COUNT_METRIC_COLUMN</code> - The type of data path for the column with <code>COUNT</code> as the metric,
     * when there is no field in the <code>ValuesFieldWell</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pivotTableDataPathType} will return {@link PivotTableDataPathType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #pivotTableDataPathTypeAsString}.
     * </p>
     * 
     * @return The type of data path value utilized in a pivot table. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HIERARCHY_ROWS_LAYOUT_COLUMN</code> - The type of data path for the rows layout column, when
     *         <code>RowsLayout</code> is set to <code>HIERARCHY</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MULTIPLE_ROW_METRICS_COLUMN</code> - The type of data path for the metric column when the row is
     *         set to Metric Placement.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EMPTY_COLUMN_HEADER</code> - The type of data path for the column with empty column header, when
     *         there is no field in <code>ColumnsFieldWell</code> and the row is set to Metric Placement.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COUNT_METRIC_COLUMN</code> - The type of data path for the column with <code>COUNT</code> as the
     *         metric, when there is no field in the <code>ValuesFieldWell</code>.
     *         </p>
     *         </li>
     * @see PivotTableDataPathType
     */
    public final PivotTableDataPathType pivotTableDataPathType() {
        return PivotTableDataPathType.fromValue(pivotTableDataPathType);
    }

    /**
     * <p>
     * The type of data path value utilized in a pivot table. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HIERARCHY_ROWS_LAYOUT_COLUMN</code> - The type of data path for the rows layout column, when
     * <code>RowsLayout</code> is set to <code>HIERARCHY</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MULTIPLE_ROW_METRICS_COLUMN</code> - The type of data path for the metric column when the row is set to
     * Metric Placement.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EMPTY_COLUMN_HEADER</code> - The type of data path for the column with empty column header, when there is
     * no field in <code>ColumnsFieldWell</code> and the row is set to Metric Placement.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COUNT_METRIC_COLUMN</code> - The type of data path for the column with <code>COUNT</code> as the metric,
     * when there is no field in the <code>ValuesFieldWell</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pivotTableDataPathType} will return {@link PivotTableDataPathType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #pivotTableDataPathTypeAsString}.
     * </p>
     * 
     * @return The type of data path value utilized in a pivot table. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HIERARCHY_ROWS_LAYOUT_COLUMN</code> - The type of data path for the rows layout column, when
     *         <code>RowsLayout</code> is set to <code>HIERARCHY</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MULTIPLE_ROW_METRICS_COLUMN</code> - The type of data path for the metric column when the row is
     *         set to Metric Placement.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EMPTY_COLUMN_HEADER</code> - The type of data path for the column with empty column header, when
     *         there is no field in <code>ColumnsFieldWell</code> and the row is set to Metric Placement.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COUNT_METRIC_COLUMN</code> - The type of data path for the column with <code>COUNT</code> as the
     *         metric, when there is no field in the <code>ValuesFieldWell</code>.
     *         </p>
     *         </li>
     * @see PivotTableDataPathType
     */
    public final String pivotTableDataPathTypeAsString() {
        return pivotTableDataPathType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pivotTableDataPathTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPathType)) {
            return false;
        }
        DataPathType other = (DataPathType) obj;
        return Objects.equals(pivotTableDataPathTypeAsString(), other.pivotTableDataPathTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataPathType").add("PivotTableDataPathType", pivotTableDataPathTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PivotTableDataPathType":
            return Optional.ofNullable(clazz.cast(pivotTableDataPathTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataPathType, T> g) {
        return obj -> g.apply((DataPathType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataPathType> {
        /**
         * <p>
         * The type of data path value utilized in a pivot table. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HIERARCHY_ROWS_LAYOUT_COLUMN</code> - The type of data path for the rows layout column, when
         * <code>RowsLayout</code> is set to <code>HIERARCHY</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MULTIPLE_ROW_METRICS_COLUMN</code> - The type of data path for the metric column when the row is set to
         * Metric Placement.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EMPTY_COLUMN_HEADER</code> - The type of data path for the column with empty column header, when there
         * is no field in <code>ColumnsFieldWell</code> and the row is set to Metric Placement.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COUNT_METRIC_COLUMN</code> - The type of data path for the column with <code>COUNT</code> as the
         * metric, when there is no field in the <code>ValuesFieldWell</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param pivotTableDataPathType
         *        The type of data path value utilized in a pivot table. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HIERARCHY_ROWS_LAYOUT_COLUMN</code> - The type of data path for the rows layout column, when
         *        <code>RowsLayout</code> is set to <code>HIERARCHY</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MULTIPLE_ROW_METRICS_COLUMN</code> - The type of data path for the metric column when the row is
         *        set to Metric Placement.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EMPTY_COLUMN_HEADER</code> - The type of data path for the column with empty column header, when
         *        there is no field in <code>ColumnsFieldWell</code> and the row is set to Metric Placement.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COUNT_METRIC_COLUMN</code> - The type of data path for the column with <code>COUNT</code> as the
         *        metric, when there is no field in the <code>ValuesFieldWell</code>.
         *        </p>
         *        </li>
         * @see PivotTableDataPathType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PivotTableDataPathType
         */
        Builder pivotTableDataPathType(String pivotTableDataPathType);

        /**
         * <p>
         * The type of data path value utilized in a pivot table. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HIERARCHY_ROWS_LAYOUT_COLUMN</code> - The type of data path for the rows layout column, when
         * <code>RowsLayout</code> is set to <code>HIERARCHY</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MULTIPLE_ROW_METRICS_COLUMN</code> - The type of data path for the metric column when the row is set to
         * Metric Placement.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EMPTY_COLUMN_HEADER</code> - The type of data path for the column with empty column header, when there
         * is no field in <code>ColumnsFieldWell</code> and the row is set to Metric Placement.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COUNT_METRIC_COLUMN</code> - The type of data path for the column with <code>COUNT</code> as the
         * metric, when there is no field in the <code>ValuesFieldWell</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param pivotTableDataPathType
         *        The type of data path value utilized in a pivot table. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HIERARCHY_ROWS_LAYOUT_COLUMN</code> - The type of data path for the rows layout column, when
         *        <code>RowsLayout</code> is set to <code>HIERARCHY</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MULTIPLE_ROW_METRICS_COLUMN</code> - The type of data path for the metric column when the row is
         *        set to Metric Placement.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EMPTY_COLUMN_HEADER</code> - The type of data path for the column with empty column header, when
         *        there is no field in <code>ColumnsFieldWell</code> and the row is set to Metric Placement.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COUNT_METRIC_COLUMN</code> - The type of data path for the column with <code>COUNT</code> as the
         *        metric, when there is no field in the <code>ValuesFieldWell</code>.
         *        </p>
         *        </li>
         * @see PivotTableDataPathType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PivotTableDataPathType
         */
        Builder pivotTableDataPathType(PivotTableDataPathType pivotTableDataPathType);
    }

    static final class BuilderImpl implements Builder {
        private String pivotTableDataPathType;

        private BuilderImpl() {
        }

        private BuilderImpl(DataPathType model) {
            pivotTableDataPathType(model.pivotTableDataPathType);
        }

        public final String getPivotTableDataPathType() {
            return pivotTableDataPathType;
        }

        public final void setPivotTableDataPathType(String pivotTableDataPathType) {
            this.pivotTableDataPathType = pivotTableDataPathType;
        }

        @Override
        public final Builder pivotTableDataPathType(String pivotTableDataPathType) {
            this.pivotTableDataPathType = pivotTableDataPathType;
            return this;
        }

        @Override
        public final Builder pivotTableDataPathType(PivotTableDataPathType pivotTableDataPathType) {
            this.pivotTableDataPathType(pivotTableDataPathType == null ? null : pivotTableDataPathType.toString());
            return this;
        }

        @Override
        public DataPathType build() {
            return new DataPathType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
