/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a body section.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BodySectionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BodySectionConfiguration.Builder, BodySectionConfiguration> {
    private static final SdkField<String> SECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SectionId").getter(getter(BodySectionConfiguration::sectionId)).setter(setter(Builder::sectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SectionId").build()).build();

    private static final SdkField<BodySectionContent> CONTENT_FIELD = SdkField
            .<BodySectionContent> builder(MarshallingType.SDK_POJO).memberName("Content")
            .getter(getter(BodySectionConfiguration::content)).setter(setter(Builder::content))
            .constructor(BodySectionContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<SectionStyle> STYLE_FIELD = SdkField.<SectionStyle> builder(MarshallingType.SDK_POJO)
            .memberName("Style").getter(getter(BodySectionConfiguration::style)).setter(setter(Builder::style))
            .constructor(SectionStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Style").build()).build();

    private static final SdkField<SectionPageBreakConfiguration> PAGE_BREAK_CONFIGURATION_FIELD = SdkField
            .<SectionPageBreakConfiguration> builder(MarshallingType.SDK_POJO).memberName("PageBreakConfiguration")
            .getter(getter(BodySectionConfiguration::pageBreakConfiguration)).setter(setter(Builder::pageBreakConfiguration))
            .constructor(SectionPageBreakConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageBreakConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECTION_ID_FIELD,
            CONTENT_FIELD, STYLE_FIELD, PAGE_BREAK_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sectionId;

    private final BodySectionContent content;

    private final SectionStyle style;

    private final SectionPageBreakConfiguration pageBreakConfiguration;

    private BodySectionConfiguration(BuilderImpl builder) {
        this.sectionId = builder.sectionId;
        this.content = builder.content;
        this.style = builder.style;
        this.pageBreakConfiguration = builder.pageBreakConfiguration;
    }

    /**
     * <p>
     * The unique identifier of a body section.
     * </p>
     * 
     * @return The unique identifier of a body section.
     */
    public final String sectionId() {
        return sectionId;
    }

    /**
     * <p>
     * The configuration of content in a body section.
     * </p>
     * 
     * @return The configuration of content in a body section.
     */
    public final BodySectionContent content() {
        return content;
    }

    /**
     * <p>
     * The style options of a body section.
     * </p>
     * 
     * @return The style options of a body section.
     */
    public final SectionStyle style() {
        return style;
    }

    /**
     * <p>
     * The configuration of a page break for a section.
     * </p>
     * 
     * @return The configuration of a page break for a section.
     */
    public final SectionPageBreakConfiguration pageBreakConfiguration() {
        return pageBreakConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sectionId());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(style());
        hashCode = 31 * hashCode + Objects.hashCode(pageBreakConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BodySectionConfiguration)) {
            return false;
        }
        BodySectionConfiguration other = (BodySectionConfiguration) obj;
        return Objects.equals(sectionId(), other.sectionId()) && Objects.equals(content(), other.content())
                && Objects.equals(style(), other.style())
                && Objects.equals(pageBreakConfiguration(), other.pageBreakConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BodySectionConfiguration").add("SectionId", sectionId()).add("Content", content())
                .add("Style", style()).add("PageBreakConfiguration", pageBreakConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SectionId":
            return Optional.ofNullable(clazz.cast(sectionId()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "Style":
            return Optional.ofNullable(clazz.cast(style()));
        case "PageBreakConfiguration":
            return Optional.ofNullable(clazz.cast(pageBreakConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BodySectionConfiguration, T> g) {
        return obj -> g.apply((BodySectionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BodySectionConfiguration> {
        /**
         * <p>
         * The unique identifier of a body section.
         * </p>
         * 
         * @param sectionId
         *        The unique identifier of a body section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sectionId(String sectionId);

        /**
         * <p>
         * The configuration of content in a body section.
         * </p>
         * 
         * @param content
         *        The configuration of content in a body section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(BodySectionContent content);

        /**
         * <p>
         * The configuration of content in a body section.
         * </p>
         * This is a convenience method that creates an instance of the {@link BodySectionContent.Builder} avoiding the
         * need to create one manually via {@link BodySectionContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BodySectionContent.Builder#build()} is called immediately and its
         * result is passed to {@link #content(BodySectionContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link BodySectionContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(BodySectionContent)
         */
        default Builder content(Consumer<BodySectionContent.Builder> content) {
            return content(BodySectionContent.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The style options of a body section.
         * </p>
         * 
         * @param style
         *        The style options of a body section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder style(SectionStyle style);

        /**
         * <p>
         * The style options of a body section.
         * </p>
         * This is a convenience method that creates an instance of the {@link SectionStyle.Builder} avoiding the need
         * to create one manually via {@link SectionStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SectionStyle.Builder#build()} is called immediately and its
         * result is passed to {@link #style(SectionStyle)}.
         * 
         * @param style
         *        a consumer that will call methods on {@link SectionStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #style(SectionStyle)
         */
        default Builder style(Consumer<SectionStyle.Builder> style) {
            return style(SectionStyle.builder().applyMutation(style).build());
        }

        /**
         * <p>
         * The configuration of a page break for a section.
         * </p>
         * 
         * @param pageBreakConfiguration
         *        The configuration of a page break for a section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageBreakConfiguration(SectionPageBreakConfiguration pageBreakConfiguration);

        /**
         * <p>
         * The configuration of a page break for a section.
         * </p>
         * This is a convenience method that creates an instance of the {@link SectionPageBreakConfiguration.Builder}
         * avoiding the need to create one manually via {@link SectionPageBreakConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SectionPageBreakConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #pageBreakConfiguration(SectionPageBreakConfiguration)}.
         * 
         * @param pageBreakConfiguration
         *        a consumer that will call methods on {@link SectionPageBreakConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pageBreakConfiguration(SectionPageBreakConfiguration)
         */
        default Builder pageBreakConfiguration(Consumer<SectionPageBreakConfiguration.Builder> pageBreakConfiguration) {
            return pageBreakConfiguration(SectionPageBreakConfiguration.builder().applyMutation(pageBreakConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sectionId;

        private BodySectionContent content;

        private SectionStyle style;

        private SectionPageBreakConfiguration pageBreakConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(BodySectionConfiguration model) {
            sectionId(model.sectionId);
            content(model.content);
            style(model.style);
            pageBreakConfiguration(model.pageBreakConfiguration);
        }

        public final String getSectionId() {
            return sectionId;
        }

        public final void setSectionId(String sectionId) {
            this.sectionId = sectionId;
        }

        @Override
        public final Builder sectionId(String sectionId) {
            this.sectionId = sectionId;
            return this;
        }

        public final BodySectionContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(BodySectionContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(BodySectionContent content) {
            this.content = content;
            return this;
        }

        public final SectionStyle.Builder getStyle() {
            return style != null ? style.toBuilder() : null;
        }

        public final void setStyle(SectionStyle.BuilderImpl style) {
            this.style = style != null ? style.build() : null;
        }

        @Override
        public final Builder style(SectionStyle style) {
            this.style = style;
            return this;
        }

        public final SectionPageBreakConfiguration.Builder getPageBreakConfiguration() {
            return pageBreakConfiguration != null ? pageBreakConfiguration.toBuilder() : null;
        }

        public final void setPageBreakConfiguration(SectionPageBreakConfiguration.BuilderImpl pageBreakConfiguration) {
            this.pageBreakConfiguration = pageBreakConfiguration != null ? pageBreakConfiguration.build() : null;
        }

        @Override
        public final Builder pageBreakConfiguration(SectionPageBreakConfiguration pageBreakConfiguration) {
            this.pageBreakConfiguration = pageBreakConfiguration;
            return this;
        }

        @Override
        public BodySectionConfiguration build() {
            return new BodySectionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
