/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AxisDisplayOptions;
import software.amazon.awssdk.services.quicksight.model.ChartAxisLabelOptions;
import software.amazon.awssdk.services.quicksight.model.ContributionAnalysisDefault;
import software.amazon.awssdk.services.quicksight.model.ContributionAnalysisDefaultListCopier;
import software.amazon.awssdk.services.quicksight.model.DataLabelOptions;
import software.amazon.awssdk.services.quicksight.model.ForecastConfiguration;
import software.amazon.awssdk.services.quicksight.model.ForecastConfigurationListCopier;
import software.amazon.awssdk.services.quicksight.model.LegendOptions;
import software.amazon.awssdk.services.quicksight.model.LineChartDefaultSeriesSettings;
import software.amazon.awssdk.services.quicksight.model.LineChartFieldWells;
import software.amazon.awssdk.services.quicksight.model.LineChartSortConfiguration;
import software.amazon.awssdk.services.quicksight.model.LineChartType;
import software.amazon.awssdk.services.quicksight.model.LineSeriesAxisDisplayOptions;
import software.amazon.awssdk.services.quicksight.model.ReferenceLine;
import software.amazon.awssdk.services.quicksight.model.ReferenceLineListCopier;
import software.amazon.awssdk.services.quicksight.model.SeriesItem;
import software.amazon.awssdk.services.quicksight.model.SeriesItemListCopier;
import software.amazon.awssdk.services.quicksight.model.SingleAxisOptions;
import software.amazon.awssdk.services.quicksight.model.SmallMultiplesOptions;
import software.amazon.awssdk.services.quicksight.model.TooltipOptions;
import software.amazon.awssdk.services.quicksight.model.VisualInteractionOptions;
import software.amazon.awssdk.services.quicksight.model.VisualPalette;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LineChartConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LineChartConfiguration> {
    private static final SdkField<LineChartFieldWells> FIELD_WELLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FieldWells").getter(LineChartConfiguration.getter(LineChartConfiguration::fieldWells)).setter(LineChartConfiguration.setter(Builder::fieldWells)).constructor(LineChartFieldWells::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()}).build();
    private static final SdkField<LineChartSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SortConfiguration").getter(LineChartConfiguration.getter(LineChartConfiguration::sortConfiguration)).setter(LineChartConfiguration.setter(Builder::sortConfiguration)).constructor(LineChartSortConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()}).build();
    private static final SdkField<List<ForecastConfiguration>> FORECAST_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ForecastConfigurations").getter(LineChartConfiguration.getter(LineChartConfiguration::forecastConfigurations)).setter(LineChartConfiguration.setter(Builder::forecastConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ForecastConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(LineChartConfiguration.getter(LineChartConfiguration::typeAsString)).setter(LineChartConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<SmallMultiplesOptions> SMALL_MULTIPLES_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SmallMultiplesOptions").getter(LineChartConfiguration.getter(LineChartConfiguration::smallMultiplesOptions)).setter(LineChartConfiguration.setter(Builder::smallMultiplesOptions)).constructor(SmallMultiplesOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmallMultiplesOptions").build()}).build();
    private static final SdkField<AxisDisplayOptions> X_AXIS_DISPLAY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("XAxisDisplayOptions").getter(LineChartConfiguration.getter(LineChartConfiguration::xAxisDisplayOptions)).setter(LineChartConfiguration.setter(Builder::xAxisDisplayOptions)).constructor(AxisDisplayOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XAxisDisplayOptions").build()}).build();
    private static final SdkField<ChartAxisLabelOptions> X_AXIS_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("XAxisLabelOptions").getter(LineChartConfiguration.getter(LineChartConfiguration::xAxisLabelOptions)).setter(LineChartConfiguration.setter(Builder::xAxisLabelOptions)).constructor(ChartAxisLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XAxisLabelOptions").build()}).build();
    private static final SdkField<LineSeriesAxisDisplayOptions> PRIMARY_Y_AXIS_DISPLAY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrimaryYAxisDisplayOptions").getter(LineChartConfiguration.getter(LineChartConfiguration::primaryYAxisDisplayOptions)).setter(LineChartConfiguration.setter(Builder::primaryYAxisDisplayOptions)).constructor(LineSeriesAxisDisplayOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryYAxisDisplayOptions").build()}).build();
    private static final SdkField<ChartAxisLabelOptions> PRIMARY_Y_AXIS_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrimaryYAxisLabelOptions").getter(LineChartConfiguration.getter(LineChartConfiguration::primaryYAxisLabelOptions)).setter(LineChartConfiguration.setter(Builder::primaryYAxisLabelOptions)).constructor(ChartAxisLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryYAxisLabelOptions").build()}).build();
    private static final SdkField<LineSeriesAxisDisplayOptions> SECONDARY_Y_AXIS_DISPLAY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecondaryYAxisDisplayOptions").getter(LineChartConfiguration.getter(LineChartConfiguration::secondaryYAxisDisplayOptions)).setter(LineChartConfiguration.setter(Builder::secondaryYAxisDisplayOptions)).constructor(LineSeriesAxisDisplayOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryYAxisDisplayOptions").build()}).build();
    private static final SdkField<ChartAxisLabelOptions> SECONDARY_Y_AXIS_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecondaryYAxisLabelOptions").getter(LineChartConfiguration.getter(LineChartConfiguration::secondaryYAxisLabelOptions)).setter(LineChartConfiguration.setter(Builder::secondaryYAxisLabelOptions)).constructor(ChartAxisLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryYAxisLabelOptions").build()}).build();
    private static final SdkField<SingleAxisOptions> SINGLE_AXIS_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SingleAxisOptions").getter(LineChartConfiguration.getter(LineChartConfiguration::singleAxisOptions)).setter(LineChartConfiguration.setter(Builder::singleAxisOptions)).constructor(SingleAxisOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleAxisOptions").build()}).build();
    private static final SdkField<LineChartDefaultSeriesSettings> DEFAULT_SERIES_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultSeriesSettings").getter(LineChartConfiguration.getter(LineChartConfiguration::defaultSeriesSettings)).setter(LineChartConfiguration.setter(Builder::defaultSeriesSettings)).constructor(LineChartDefaultSeriesSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSeriesSettings").build()}).build();
    private static final SdkField<List<SeriesItem>> SERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Series").getter(LineChartConfiguration.getter(LineChartConfiguration::series)).setter(LineChartConfiguration.setter(Builder::series)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Series").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SeriesItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LegendOptions> LEGEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Legend").getter(LineChartConfiguration.getter(LineChartConfiguration::legend)).setter(LineChartConfiguration.setter(Builder::legend)).constructor(LegendOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legend").build()}).build();
    private static final SdkField<DataLabelOptions> DATA_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataLabels").getter(LineChartConfiguration.getter(LineChartConfiguration::dataLabels)).setter(LineChartConfiguration.setter(Builder::dataLabels)).constructor(DataLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLabels").build()}).build();
    private static final SdkField<List<ReferenceLine>> REFERENCE_LINES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReferenceLines").getter(LineChartConfiguration.getter(LineChartConfiguration::referenceLines)).setter(LineChartConfiguration.setter(Builder::referenceLines)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceLines").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReferenceLine::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TooltipOptions> TOOLTIP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tooltip").getter(LineChartConfiguration.getter(LineChartConfiguration::tooltip)).setter(LineChartConfiguration.setter(Builder::tooltip)).constructor(TooltipOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tooltip").build()}).build();
    private static final SdkField<List<ContributionAnalysisDefault>> CONTRIBUTION_ANALYSIS_DEFAULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContributionAnalysisDefaults").getter(LineChartConfiguration.getter(LineChartConfiguration::contributionAnalysisDefaults)).setter(LineChartConfiguration.setter(Builder::contributionAnalysisDefaults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributionAnalysisDefaults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContributionAnalysisDefault::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VisualPalette> VISUAL_PALETTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisualPalette").getter(LineChartConfiguration.getter(LineChartConfiguration::visualPalette)).setter(LineChartConfiguration.setter(Builder::visualPalette)).constructor(VisualPalette::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualPalette").build()}).build();
    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Interactions").getter(LineChartConfiguration.getter(LineChartConfiguration::interactions)).setter(LineChartConfiguration.setter(Builder::interactions)).constructor(VisualInteractionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD, SORT_CONFIGURATION_FIELD, FORECAST_CONFIGURATIONS_FIELD, TYPE_FIELD, SMALL_MULTIPLES_OPTIONS_FIELD, X_AXIS_DISPLAY_OPTIONS_FIELD, X_AXIS_LABEL_OPTIONS_FIELD, PRIMARY_Y_AXIS_DISPLAY_OPTIONS_FIELD, PRIMARY_Y_AXIS_LABEL_OPTIONS_FIELD, SECONDARY_Y_AXIS_DISPLAY_OPTIONS_FIELD, SECONDARY_Y_AXIS_LABEL_OPTIONS_FIELD, SINGLE_AXIS_OPTIONS_FIELD, DEFAULT_SERIES_SETTINGS_FIELD, SERIES_FIELD, LEGEND_FIELD, DATA_LABELS_FIELD, REFERENCE_LINES_FIELD, TOOLTIP_FIELD, CONTRIBUTION_ANALYSIS_DEFAULTS_FIELD, VISUAL_PALETTE_FIELD, INTERACTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final LineChartFieldWells fieldWells;
    private final LineChartSortConfiguration sortConfiguration;
    private final List<ForecastConfiguration> forecastConfigurations;
    private final String type;
    private final SmallMultiplesOptions smallMultiplesOptions;
    private final AxisDisplayOptions xAxisDisplayOptions;
    private final ChartAxisLabelOptions xAxisLabelOptions;
    private final LineSeriesAxisDisplayOptions primaryYAxisDisplayOptions;
    private final ChartAxisLabelOptions primaryYAxisLabelOptions;
    private final LineSeriesAxisDisplayOptions secondaryYAxisDisplayOptions;
    private final ChartAxisLabelOptions secondaryYAxisLabelOptions;
    private final SingleAxisOptions singleAxisOptions;
    private final LineChartDefaultSeriesSettings defaultSeriesSettings;
    private final List<SeriesItem> series;
    private final LegendOptions legend;
    private final DataLabelOptions dataLabels;
    private final List<ReferenceLine> referenceLines;
    private final TooltipOptions tooltip;
    private final List<ContributionAnalysisDefault> contributionAnalysisDefaults;
    private final VisualPalette visualPalette;
    private final VisualInteractionOptions interactions;

    private LineChartConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.forecastConfigurations = builder.forecastConfigurations;
        this.type = builder.type;
        this.smallMultiplesOptions = builder.smallMultiplesOptions;
        this.xAxisDisplayOptions = builder.xAxisDisplayOptions;
        this.xAxisLabelOptions = builder.xAxisLabelOptions;
        this.primaryYAxisDisplayOptions = builder.primaryYAxisDisplayOptions;
        this.primaryYAxisLabelOptions = builder.primaryYAxisLabelOptions;
        this.secondaryYAxisDisplayOptions = builder.secondaryYAxisDisplayOptions;
        this.secondaryYAxisLabelOptions = builder.secondaryYAxisLabelOptions;
        this.singleAxisOptions = builder.singleAxisOptions;
        this.defaultSeriesSettings = builder.defaultSeriesSettings;
        this.series = builder.series;
        this.legend = builder.legend;
        this.dataLabels = builder.dataLabels;
        this.referenceLines = builder.referenceLines;
        this.tooltip = builder.tooltip;
        this.contributionAnalysisDefaults = builder.contributionAnalysisDefaults;
        this.visualPalette = builder.visualPalette;
        this.interactions = builder.interactions;
    }

    public final LineChartFieldWells fieldWells() {
        return this.fieldWells;
    }

    public final LineChartSortConfiguration sortConfiguration() {
        return this.sortConfiguration;
    }

    public final boolean hasForecastConfigurations() {
        return this.forecastConfigurations != null && !(this.forecastConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ForecastConfiguration> forecastConfigurations() {
        return this.forecastConfigurations;
    }

    public final LineChartType type() {
        return LineChartType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final SmallMultiplesOptions smallMultiplesOptions() {
        return this.smallMultiplesOptions;
    }

    public final AxisDisplayOptions xAxisDisplayOptions() {
        return this.xAxisDisplayOptions;
    }

    public final ChartAxisLabelOptions xAxisLabelOptions() {
        return this.xAxisLabelOptions;
    }

    public final LineSeriesAxisDisplayOptions primaryYAxisDisplayOptions() {
        return this.primaryYAxisDisplayOptions;
    }

    public final ChartAxisLabelOptions primaryYAxisLabelOptions() {
        return this.primaryYAxisLabelOptions;
    }

    public final LineSeriesAxisDisplayOptions secondaryYAxisDisplayOptions() {
        return this.secondaryYAxisDisplayOptions;
    }

    public final ChartAxisLabelOptions secondaryYAxisLabelOptions() {
        return this.secondaryYAxisLabelOptions;
    }

    public final SingleAxisOptions singleAxisOptions() {
        return this.singleAxisOptions;
    }

    public final LineChartDefaultSeriesSettings defaultSeriesSettings() {
        return this.defaultSeriesSettings;
    }

    public final boolean hasSeries() {
        return this.series != null && !(this.series instanceof SdkAutoConstructList);
    }

    public final List<SeriesItem> series() {
        return this.series;
    }

    public final LegendOptions legend() {
        return this.legend;
    }

    public final DataLabelOptions dataLabels() {
        return this.dataLabels;
    }

    public final boolean hasReferenceLines() {
        return this.referenceLines != null && !(this.referenceLines instanceof SdkAutoConstructList);
    }

    public final List<ReferenceLine> referenceLines() {
        return this.referenceLines;
    }

    public final TooltipOptions tooltip() {
        return this.tooltip;
    }

    public final boolean hasContributionAnalysisDefaults() {
        return this.contributionAnalysisDefaults != null && !(this.contributionAnalysisDefaults instanceof SdkAutoConstructList);
    }

    public final List<ContributionAnalysisDefault> contributionAnalysisDefaults() {
        return this.contributionAnalysisDefaults;
    }

    public final VisualPalette visualPalette() {
        return this.visualPalette;
    }

    public final VisualInteractionOptions interactions() {
        return this.interactions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasForecastConfigurations() ? this.forecastConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.smallMultiplesOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.xAxisDisplayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.xAxisLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryYAxisDisplayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryYAxisLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryYAxisDisplayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryYAxisLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleAxisOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultSeriesSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSeries() ? this.series() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.legend());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLabels());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferenceLines() ? this.referenceLines() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tooltip());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContributionAnalysisDefaults() ? this.contributionAnalysisDefaults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.visualPalette());
        hashCode = 31 * hashCode + Objects.hashCode(this.interactions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineChartConfiguration)) {
            return false;
        }
        LineChartConfiguration other = (LineChartConfiguration)obj;
        return Objects.equals(this.fieldWells(), other.fieldWells()) && Objects.equals(this.sortConfiguration(), other.sortConfiguration()) && this.hasForecastConfigurations() == other.hasForecastConfigurations() && Objects.equals(this.forecastConfigurations(), other.forecastConfigurations()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.smallMultiplesOptions(), other.smallMultiplesOptions()) && Objects.equals(this.xAxisDisplayOptions(), other.xAxisDisplayOptions()) && Objects.equals(this.xAxisLabelOptions(), other.xAxisLabelOptions()) && Objects.equals(this.primaryYAxisDisplayOptions(), other.primaryYAxisDisplayOptions()) && Objects.equals(this.primaryYAxisLabelOptions(), other.primaryYAxisLabelOptions()) && Objects.equals(this.secondaryYAxisDisplayOptions(), other.secondaryYAxisDisplayOptions()) && Objects.equals(this.secondaryYAxisLabelOptions(), other.secondaryYAxisLabelOptions()) && Objects.equals(this.singleAxisOptions(), other.singleAxisOptions()) && Objects.equals(this.defaultSeriesSettings(), other.defaultSeriesSettings()) && this.hasSeries() == other.hasSeries() && Objects.equals(this.series(), other.series()) && Objects.equals(this.legend(), other.legend()) && Objects.equals(this.dataLabels(), other.dataLabels()) && this.hasReferenceLines() == other.hasReferenceLines() && Objects.equals(this.referenceLines(), other.referenceLines()) && Objects.equals(this.tooltip(), other.tooltip()) && this.hasContributionAnalysisDefaults() == other.hasContributionAnalysisDefaults() && Objects.equals(this.contributionAnalysisDefaults(), other.contributionAnalysisDefaults()) && Objects.equals(this.visualPalette(), other.visualPalette()) && Objects.equals(this.interactions(), other.interactions());
    }

    public final String toString() {
        return ToString.builder((String)"LineChartConfiguration").add("FieldWells", (Object)this.fieldWells()).add("SortConfiguration", (Object)this.sortConfiguration()).add("ForecastConfigurations", this.hasForecastConfigurations() ? this.forecastConfigurations() : null).add("Type", (Object)this.typeAsString()).add("SmallMultiplesOptions", (Object)this.smallMultiplesOptions()).add("XAxisDisplayOptions", (Object)this.xAxisDisplayOptions()).add("XAxisLabelOptions", (Object)this.xAxisLabelOptions()).add("PrimaryYAxisDisplayOptions", (Object)this.primaryYAxisDisplayOptions()).add("PrimaryYAxisLabelOptions", (Object)this.primaryYAxisLabelOptions()).add("SecondaryYAxisDisplayOptions", (Object)this.secondaryYAxisDisplayOptions()).add("SecondaryYAxisLabelOptions", (Object)this.secondaryYAxisLabelOptions()).add("SingleAxisOptions", (Object)this.singleAxisOptions()).add("DefaultSeriesSettings", (Object)this.defaultSeriesSettings()).add("Series", this.hasSeries() ? this.series() : null).add("Legend", (Object)this.legend()).add("DataLabels", (Object)this.dataLabels()).add("ReferenceLines", this.hasReferenceLines() ? this.referenceLines() : null).add("Tooltip", (Object)this.tooltip()).add("ContributionAnalysisDefaults", this.hasContributionAnalysisDefaults() ? this.contributionAnalysisDefaults() : null).add("VisualPalette", (Object)this.visualPalette()).add("Interactions", (Object)this.interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldWells": {
                return Optional.ofNullable(clazz.cast(this.fieldWells()));
            }
            case "SortConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sortConfiguration()));
            }
            case "ForecastConfigurations": {
                return Optional.ofNullable(clazz.cast(this.forecastConfigurations()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "SmallMultiplesOptions": {
                return Optional.ofNullable(clazz.cast(this.smallMultiplesOptions()));
            }
            case "XAxisDisplayOptions": {
                return Optional.ofNullable(clazz.cast(this.xAxisDisplayOptions()));
            }
            case "XAxisLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.xAxisLabelOptions()));
            }
            case "PrimaryYAxisDisplayOptions": {
                return Optional.ofNullable(clazz.cast(this.primaryYAxisDisplayOptions()));
            }
            case "PrimaryYAxisLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.primaryYAxisLabelOptions()));
            }
            case "SecondaryYAxisDisplayOptions": {
                return Optional.ofNullable(clazz.cast(this.secondaryYAxisDisplayOptions()));
            }
            case "SecondaryYAxisLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.secondaryYAxisLabelOptions()));
            }
            case "SingleAxisOptions": {
                return Optional.ofNullable(clazz.cast(this.singleAxisOptions()));
            }
            case "DefaultSeriesSettings": {
                return Optional.ofNullable(clazz.cast(this.defaultSeriesSettings()));
            }
            case "Series": {
                return Optional.ofNullable(clazz.cast(this.series()));
            }
            case "Legend": {
                return Optional.ofNullable(clazz.cast(this.legend()));
            }
            case "DataLabels": {
                return Optional.ofNullable(clazz.cast(this.dataLabels()));
            }
            case "ReferenceLines": {
                return Optional.ofNullable(clazz.cast(this.referenceLines()));
            }
            case "Tooltip": {
                return Optional.ofNullable(clazz.cast(this.tooltip()));
            }
            case "ContributionAnalysisDefaults": {
                return Optional.ofNullable(clazz.cast(this.contributionAnalysisDefaults()));
            }
            case "VisualPalette": {
                return Optional.ofNullable(clazz.cast(this.visualPalette()));
            }
            case "Interactions": {
                return Optional.ofNullable(clazz.cast(this.interactions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LineChartConfiguration, T> g) {
        return obj -> g.apply((LineChartConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LineChartFieldWells fieldWells;
        private LineChartSortConfiguration sortConfiguration;
        private List<ForecastConfiguration> forecastConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String type;
        private SmallMultiplesOptions smallMultiplesOptions;
        private AxisDisplayOptions xAxisDisplayOptions;
        private ChartAxisLabelOptions xAxisLabelOptions;
        private LineSeriesAxisDisplayOptions primaryYAxisDisplayOptions;
        private ChartAxisLabelOptions primaryYAxisLabelOptions;
        private LineSeriesAxisDisplayOptions secondaryYAxisDisplayOptions;
        private ChartAxisLabelOptions secondaryYAxisLabelOptions;
        private SingleAxisOptions singleAxisOptions;
        private LineChartDefaultSeriesSettings defaultSeriesSettings;
        private List<SeriesItem> series = DefaultSdkAutoConstructList.getInstance();
        private LegendOptions legend;
        private DataLabelOptions dataLabels;
        private List<ReferenceLine> referenceLines = DefaultSdkAutoConstructList.getInstance();
        private TooltipOptions tooltip;
        private List<ContributionAnalysisDefault> contributionAnalysisDefaults = DefaultSdkAutoConstructList.getInstance();
        private VisualPalette visualPalette;
        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(LineChartConfiguration model) {
            this.fieldWells(model.fieldWells);
            this.sortConfiguration(model.sortConfiguration);
            this.forecastConfigurations(model.forecastConfigurations);
            this.type(model.type);
            this.smallMultiplesOptions(model.smallMultiplesOptions);
            this.xAxisDisplayOptions(model.xAxisDisplayOptions);
            this.xAxisLabelOptions(model.xAxisLabelOptions);
            this.primaryYAxisDisplayOptions(model.primaryYAxisDisplayOptions);
            this.primaryYAxisLabelOptions(model.primaryYAxisLabelOptions);
            this.secondaryYAxisDisplayOptions(model.secondaryYAxisDisplayOptions);
            this.secondaryYAxisLabelOptions(model.secondaryYAxisLabelOptions);
            this.singleAxisOptions(model.singleAxisOptions);
            this.defaultSeriesSettings(model.defaultSeriesSettings);
            this.series(model.series);
            this.legend(model.legend);
            this.dataLabels(model.dataLabels);
            this.referenceLines(model.referenceLines);
            this.tooltip(model.tooltip);
            this.contributionAnalysisDefaults(model.contributionAnalysisDefaults);
            this.visualPalette(model.visualPalette);
            this.interactions(model.interactions);
        }

        public final LineChartFieldWells.Builder getFieldWells() {
            return this.fieldWells != null ? this.fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(LineChartFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(LineChartFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final LineChartSortConfiguration.Builder getSortConfiguration() {
            return this.sortConfiguration != null ? this.sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(LineChartSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(LineChartSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final List<ForecastConfiguration.Builder> getForecastConfigurations() {
            List<ForecastConfiguration.Builder> result = ForecastConfigurationListCopier.copyToBuilder(this.forecastConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setForecastConfigurations(Collection<ForecastConfiguration.BuilderImpl> forecastConfigurations) {
            this.forecastConfigurations = ForecastConfigurationListCopier.copyFromBuilder(forecastConfigurations);
        }

        @Override
        public final Builder forecastConfigurations(Collection<ForecastConfiguration> forecastConfigurations) {
            this.forecastConfigurations = ForecastConfigurationListCopier.copy(forecastConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastConfigurations(ForecastConfiguration ... forecastConfigurations) {
            this.forecastConfigurations(Arrays.asList(forecastConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastConfigurations(Consumer<ForecastConfiguration.Builder> ... forecastConfigurations) {
            this.forecastConfigurations(Stream.of(forecastConfigurations).map(c -> (ForecastConfiguration)((ForecastConfiguration.Builder)ForecastConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LineChartType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final SmallMultiplesOptions.Builder getSmallMultiplesOptions() {
            return this.smallMultiplesOptions != null ? this.smallMultiplesOptions.toBuilder() : null;
        }

        public final void setSmallMultiplesOptions(SmallMultiplesOptions.BuilderImpl smallMultiplesOptions) {
            this.smallMultiplesOptions = smallMultiplesOptions != null ? smallMultiplesOptions.build() : null;
        }

        @Override
        public final Builder smallMultiplesOptions(SmallMultiplesOptions smallMultiplesOptions) {
            this.smallMultiplesOptions = smallMultiplesOptions;
            return this;
        }

        public final AxisDisplayOptions.Builder getXAxisDisplayOptions() {
            return this.xAxisDisplayOptions != null ? this.xAxisDisplayOptions.toBuilder() : null;
        }

        public final void setXAxisDisplayOptions(AxisDisplayOptions.BuilderImpl xAxisDisplayOptions) {
            this.xAxisDisplayOptions = xAxisDisplayOptions != null ? xAxisDisplayOptions.build() : null;
        }

        @Override
        public final Builder xAxisDisplayOptions(AxisDisplayOptions xAxisDisplayOptions) {
            this.xAxisDisplayOptions = xAxisDisplayOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getXAxisLabelOptions() {
            return this.xAxisLabelOptions != null ? this.xAxisLabelOptions.toBuilder() : null;
        }

        public final void setXAxisLabelOptions(ChartAxisLabelOptions.BuilderImpl xAxisLabelOptions) {
            this.xAxisLabelOptions = xAxisLabelOptions != null ? xAxisLabelOptions.build() : null;
        }

        @Override
        public final Builder xAxisLabelOptions(ChartAxisLabelOptions xAxisLabelOptions) {
            this.xAxisLabelOptions = xAxisLabelOptions;
            return this;
        }

        public final LineSeriesAxisDisplayOptions.Builder getPrimaryYAxisDisplayOptions() {
            return this.primaryYAxisDisplayOptions != null ? this.primaryYAxisDisplayOptions.toBuilder() : null;
        }

        public final void setPrimaryYAxisDisplayOptions(LineSeriesAxisDisplayOptions.BuilderImpl primaryYAxisDisplayOptions) {
            this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions != null ? primaryYAxisDisplayOptions.build() : null;
        }

        @Override
        public final Builder primaryYAxisDisplayOptions(LineSeriesAxisDisplayOptions primaryYAxisDisplayOptions) {
            this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getPrimaryYAxisLabelOptions() {
            return this.primaryYAxisLabelOptions != null ? this.primaryYAxisLabelOptions.toBuilder() : null;
        }

        public final void setPrimaryYAxisLabelOptions(ChartAxisLabelOptions.BuilderImpl primaryYAxisLabelOptions) {
            this.primaryYAxisLabelOptions = primaryYAxisLabelOptions != null ? primaryYAxisLabelOptions.build() : null;
        }

        @Override
        public final Builder primaryYAxisLabelOptions(ChartAxisLabelOptions primaryYAxisLabelOptions) {
            this.primaryYAxisLabelOptions = primaryYAxisLabelOptions;
            return this;
        }

        public final LineSeriesAxisDisplayOptions.Builder getSecondaryYAxisDisplayOptions() {
            return this.secondaryYAxisDisplayOptions != null ? this.secondaryYAxisDisplayOptions.toBuilder() : null;
        }

        public final void setSecondaryYAxisDisplayOptions(LineSeriesAxisDisplayOptions.BuilderImpl secondaryYAxisDisplayOptions) {
            this.secondaryYAxisDisplayOptions = secondaryYAxisDisplayOptions != null ? secondaryYAxisDisplayOptions.build() : null;
        }

        @Override
        public final Builder secondaryYAxisDisplayOptions(LineSeriesAxisDisplayOptions secondaryYAxisDisplayOptions) {
            this.secondaryYAxisDisplayOptions = secondaryYAxisDisplayOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getSecondaryYAxisLabelOptions() {
            return this.secondaryYAxisLabelOptions != null ? this.secondaryYAxisLabelOptions.toBuilder() : null;
        }

        public final void setSecondaryYAxisLabelOptions(ChartAxisLabelOptions.BuilderImpl secondaryYAxisLabelOptions) {
            this.secondaryYAxisLabelOptions = secondaryYAxisLabelOptions != null ? secondaryYAxisLabelOptions.build() : null;
        }

        @Override
        public final Builder secondaryYAxisLabelOptions(ChartAxisLabelOptions secondaryYAxisLabelOptions) {
            this.secondaryYAxisLabelOptions = secondaryYAxisLabelOptions;
            return this;
        }

        public final SingleAxisOptions.Builder getSingleAxisOptions() {
            return this.singleAxisOptions != null ? this.singleAxisOptions.toBuilder() : null;
        }

        public final void setSingleAxisOptions(SingleAxisOptions.BuilderImpl singleAxisOptions) {
            this.singleAxisOptions = singleAxisOptions != null ? singleAxisOptions.build() : null;
        }

        @Override
        public final Builder singleAxisOptions(SingleAxisOptions singleAxisOptions) {
            this.singleAxisOptions = singleAxisOptions;
            return this;
        }

        public final LineChartDefaultSeriesSettings.Builder getDefaultSeriesSettings() {
            return this.defaultSeriesSettings != null ? this.defaultSeriesSettings.toBuilder() : null;
        }

        public final void setDefaultSeriesSettings(LineChartDefaultSeriesSettings.BuilderImpl defaultSeriesSettings) {
            this.defaultSeriesSettings = defaultSeriesSettings != null ? defaultSeriesSettings.build() : null;
        }

        @Override
        public final Builder defaultSeriesSettings(LineChartDefaultSeriesSettings defaultSeriesSettings) {
            this.defaultSeriesSettings = defaultSeriesSettings;
            return this;
        }

        public final List<SeriesItem.Builder> getSeries() {
            List<SeriesItem.Builder> result = SeriesItemListCopier.copyToBuilder(this.series);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSeries(Collection<SeriesItem.BuilderImpl> series) {
            this.series = SeriesItemListCopier.copyFromBuilder(series);
        }

        @Override
        public final Builder series(Collection<SeriesItem> series) {
            this.series = SeriesItemListCopier.copy(series);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder series(SeriesItem ... series) {
            this.series(Arrays.asList(series));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder series(Consumer<SeriesItem.Builder> ... series) {
            this.series(Stream.of(series).map(c -> (SeriesItem)((SeriesItem.Builder)SeriesItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final LegendOptions.Builder getLegend() {
            return this.legend != null ? this.legend.toBuilder() : null;
        }

        public final void setLegend(LegendOptions.BuilderImpl legend) {
            this.legend = legend != null ? legend.build() : null;
        }

        @Override
        public final Builder legend(LegendOptions legend) {
            this.legend = legend;
            return this;
        }

        public final DataLabelOptions.Builder getDataLabels() {
            return this.dataLabels != null ? this.dataLabels.toBuilder() : null;
        }

        public final void setDataLabels(DataLabelOptions.BuilderImpl dataLabels) {
            this.dataLabels = dataLabels != null ? dataLabels.build() : null;
        }

        @Override
        public final Builder dataLabels(DataLabelOptions dataLabels) {
            this.dataLabels = dataLabels;
            return this;
        }

        public final List<ReferenceLine.Builder> getReferenceLines() {
            List<ReferenceLine.Builder> result = ReferenceLineListCopier.copyToBuilder(this.referenceLines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferenceLines(Collection<ReferenceLine.BuilderImpl> referenceLines) {
            this.referenceLines = ReferenceLineListCopier.copyFromBuilder(referenceLines);
        }

        @Override
        public final Builder referenceLines(Collection<ReferenceLine> referenceLines) {
            this.referenceLines = ReferenceLineListCopier.copy(referenceLines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceLines(ReferenceLine ... referenceLines) {
            this.referenceLines(Arrays.asList(referenceLines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceLines(Consumer<ReferenceLine.Builder> ... referenceLines) {
            this.referenceLines(Stream.of(referenceLines).map(c -> (ReferenceLine)((ReferenceLine.Builder)ReferenceLine.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TooltipOptions.Builder getTooltip() {
            return this.tooltip != null ? this.tooltip.toBuilder() : null;
        }

        public final void setTooltip(TooltipOptions.BuilderImpl tooltip) {
            this.tooltip = tooltip != null ? tooltip.build() : null;
        }

        @Override
        public final Builder tooltip(TooltipOptions tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public final List<ContributionAnalysisDefault.Builder> getContributionAnalysisDefaults() {
            List<ContributionAnalysisDefault.Builder> result = ContributionAnalysisDefaultListCopier.copyToBuilder(this.contributionAnalysisDefaults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContributionAnalysisDefaults(Collection<ContributionAnalysisDefault.BuilderImpl> contributionAnalysisDefaults) {
            this.contributionAnalysisDefaults = ContributionAnalysisDefaultListCopier.copyFromBuilder(contributionAnalysisDefaults);
        }

        @Override
        public final Builder contributionAnalysisDefaults(Collection<ContributionAnalysisDefault> contributionAnalysisDefaults) {
            this.contributionAnalysisDefaults = ContributionAnalysisDefaultListCopier.copy(contributionAnalysisDefaults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributionAnalysisDefaults(ContributionAnalysisDefault ... contributionAnalysisDefaults) {
            this.contributionAnalysisDefaults(Arrays.asList(contributionAnalysisDefaults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributionAnalysisDefaults(Consumer<ContributionAnalysisDefault.Builder> ... contributionAnalysisDefaults) {
            this.contributionAnalysisDefaults(Stream.of(contributionAnalysisDefaults).map(c -> (ContributionAnalysisDefault)((ContributionAnalysisDefault.Builder)ContributionAnalysisDefault.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final VisualPalette.Builder getVisualPalette() {
            return this.visualPalette != null ? this.visualPalette.toBuilder() : null;
        }

        public final void setVisualPalette(VisualPalette.BuilderImpl visualPalette) {
            this.visualPalette = visualPalette != null ? visualPalette.build() : null;
        }

        @Override
        public final Builder visualPalette(VisualPalette visualPalette) {
            this.visualPalette = visualPalette;
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return this.interactions != null ? this.interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        public LineChartConfiguration build() {
            return new LineChartConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LineChartConfiguration> {
        public Builder fieldWells(LineChartFieldWells var1);

        default public Builder fieldWells(Consumer<LineChartFieldWells.Builder> fieldWells) {
            return this.fieldWells((LineChartFieldWells)((LineChartFieldWells.Builder)LineChartFieldWells.builder().applyMutation(fieldWells)).build());
        }

        public Builder sortConfiguration(LineChartSortConfiguration var1);

        default public Builder sortConfiguration(Consumer<LineChartSortConfiguration.Builder> sortConfiguration) {
            return this.sortConfiguration((LineChartSortConfiguration)((LineChartSortConfiguration.Builder)LineChartSortConfiguration.builder().applyMutation(sortConfiguration)).build());
        }

        public Builder forecastConfigurations(Collection<ForecastConfiguration> var1);

        public Builder forecastConfigurations(ForecastConfiguration ... var1);

        public Builder forecastConfigurations(Consumer<ForecastConfiguration.Builder> ... var1);

        public Builder type(String var1);

        public Builder type(LineChartType var1);

        public Builder smallMultiplesOptions(SmallMultiplesOptions var1);

        default public Builder smallMultiplesOptions(Consumer<SmallMultiplesOptions.Builder> smallMultiplesOptions) {
            return this.smallMultiplesOptions((SmallMultiplesOptions)((SmallMultiplesOptions.Builder)SmallMultiplesOptions.builder().applyMutation(smallMultiplesOptions)).build());
        }

        public Builder xAxisDisplayOptions(AxisDisplayOptions var1);

        default public Builder xAxisDisplayOptions(Consumer<AxisDisplayOptions.Builder> xAxisDisplayOptions) {
            return this.xAxisDisplayOptions((AxisDisplayOptions)((AxisDisplayOptions.Builder)AxisDisplayOptions.builder().applyMutation(xAxisDisplayOptions)).build());
        }

        public Builder xAxisLabelOptions(ChartAxisLabelOptions var1);

        default public Builder xAxisLabelOptions(Consumer<ChartAxisLabelOptions.Builder> xAxisLabelOptions) {
            return this.xAxisLabelOptions((ChartAxisLabelOptions)((ChartAxisLabelOptions.Builder)ChartAxisLabelOptions.builder().applyMutation(xAxisLabelOptions)).build());
        }

        public Builder primaryYAxisDisplayOptions(LineSeriesAxisDisplayOptions var1);

        default public Builder primaryYAxisDisplayOptions(Consumer<LineSeriesAxisDisplayOptions.Builder> primaryYAxisDisplayOptions) {
            return this.primaryYAxisDisplayOptions((LineSeriesAxisDisplayOptions)((LineSeriesAxisDisplayOptions.Builder)LineSeriesAxisDisplayOptions.builder().applyMutation(primaryYAxisDisplayOptions)).build());
        }

        public Builder primaryYAxisLabelOptions(ChartAxisLabelOptions var1);

        default public Builder primaryYAxisLabelOptions(Consumer<ChartAxisLabelOptions.Builder> primaryYAxisLabelOptions) {
            return this.primaryYAxisLabelOptions((ChartAxisLabelOptions)((ChartAxisLabelOptions.Builder)ChartAxisLabelOptions.builder().applyMutation(primaryYAxisLabelOptions)).build());
        }

        public Builder secondaryYAxisDisplayOptions(LineSeriesAxisDisplayOptions var1);

        default public Builder secondaryYAxisDisplayOptions(Consumer<LineSeriesAxisDisplayOptions.Builder> secondaryYAxisDisplayOptions) {
            return this.secondaryYAxisDisplayOptions((LineSeriesAxisDisplayOptions)((LineSeriesAxisDisplayOptions.Builder)LineSeriesAxisDisplayOptions.builder().applyMutation(secondaryYAxisDisplayOptions)).build());
        }

        public Builder secondaryYAxisLabelOptions(ChartAxisLabelOptions var1);

        default public Builder secondaryYAxisLabelOptions(Consumer<ChartAxisLabelOptions.Builder> secondaryYAxisLabelOptions) {
            return this.secondaryYAxisLabelOptions((ChartAxisLabelOptions)((ChartAxisLabelOptions.Builder)ChartAxisLabelOptions.builder().applyMutation(secondaryYAxisLabelOptions)).build());
        }

        public Builder singleAxisOptions(SingleAxisOptions var1);

        default public Builder singleAxisOptions(Consumer<SingleAxisOptions.Builder> singleAxisOptions) {
            return this.singleAxisOptions((SingleAxisOptions)((SingleAxisOptions.Builder)SingleAxisOptions.builder().applyMutation(singleAxisOptions)).build());
        }

        public Builder defaultSeriesSettings(LineChartDefaultSeriesSettings var1);

        default public Builder defaultSeriesSettings(Consumer<LineChartDefaultSeriesSettings.Builder> defaultSeriesSettings) {
            return this.defaultSeriesSettings((LineChartDefaultSeriesSettings)((LineChartDefaultSeriesSettings.Builder)LineChartDefaultSeriesSettings.builder().applyMutation(defaultSeriesSettings)).build());
        }

        public Builder series(Collection<SeriesItem> var1);

        public Builder series(SeriesItem ... var1);

        public Builder series(Consumer<SeriesItem.Builder> ... var1);

        public Builder legend(LegendOptions var1);

        default public Builder legend(Consumer<LegendOptions.Builder> legend) {
            return this.legend((LegendOptions)((LegendOptions.Builder)LegendOptions.builder().applyMutation(legend)).build());
        }

        public Builder dataLabels(DataLabelOptions var1);

        default public Builder dataLabels(Consumer<DataLabelOptions.Builder> dataLabels) {
            return this.dataLabels((DataLabelOptions)((DataLabelOptions.Builder)DataLabelOptions.builder().applyMutation(dataLabels)).build());
        }

        public Builder referenceLines(Collection<ReferenceLine> var1);

        public Builder referenceLines(ReferenceLine ... var1);

        public Builder referenceLines(Consumer<ReferenceLine.Builder> ... var1);

        public Builder tooltip(TooltipOptions var1);

        default public Builder tooltip(Consumer<TooltipOptions.Builder> tooltip) {
            return this.tooltip((TooltipOptions)((TooltipOptions.Builder)TooltipOptions.builder().applyMutation(tooltip)).build());
        }

        public Builder contributionAnalysisDefaults(Collection<ContributionAnalysisDefault> var1);

        public Builder contributionAnalysisDefaults(ContributionAnalysisDefault ... var1);

        public Builder contributionAnalysisDefaults(Consumer<ContributionAnalysisDefault.Builder> ... var1);

        public Builder visualPalette(VisualPalette var1);

        default public Builder visualPalette(Consumer<VisualPalette.Builder> visualPalette) {
            return this.visualPalette((VisualPalette)((VisualPalette.Builder)VisualPalette.builder().applyMutation(visualPalette)).build());
        }

        public Builder interactions(VisualInteractionOptions var1);

        default public Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return this.interactions((VisualInteractionOptions)((VisualInteractionOptions.Builder)VisualInteractionOptions.builder().applyMutation(interactions)).build());
        }
    }
}

