/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.GroupsListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRoleMembershipsResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, ListRoleMembershipsResponse> {
    private static final SdkField<List<String>> MEMBERS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MembersList").getter(ListRoleMembershipsResponse.getter(ListRoleMembershipsResponse::membersList)).setter(ListRoleMembershipsResponse.setter(Builder::membersList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MembersList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRoleMembershipsResponse.getter(ListRoleMembershipsResponse::nextToken)).setter(ListRoleMembershipsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(ListRoleMembershipsResponse.getter(ListRoleMembershipsResponse::requestId)).setter(ListRoleMembershipsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(ListRoleMembershipsResponse.getter(ListRoleMembershipsResponse::status)).setter(ListRoleMembershipsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERS_LIST_FIELD, NEXT_TOKEN_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private final List<String> membersList;
    private final String nextToken;
    private final String requestId;
    private final Integer status;

    private ListRoleMembershipsResponse(BuilderImpl builder) {
        super(builder);
        this.membersList = builder.membersList;
        this.nextToken = builder.nextToken;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final boolean hasMembersList() {
        return this.membersList != null && !(this.membersList instanceof SdkAutoConstructList);
    }

    public final List<String> membersList() {
        return this.membersList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMembersList() ? this.membersList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoleMembershipsResponse)) {
            return false;
        }
        ListRoleMembershipsResponse other = (ListRoleMembershipsResponse)((Object)obj);
        return this.hasMembersList() == other.hasMembersList() && Objects.equals(this.membersList(), other.membersList()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"ListRoleMembershipsResponse").add("MembersList", this.hasMembersList() ? this.membersList() : null).add("NextToken", (Object)this.nextToken()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MembersList": {
                return Optional.ofNullable(clazz.cast(this.membersList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRoleMembershipsResponse, T> g) {
        return obj -> g.apply((ListRoleMembershipsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private List<String> membersList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoleMembershipsResponse model) {
            super(model);
            this.membersList(model.membersList);
            this.nextToken(model.nextToken);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final Collection<String> getMembersList() {
            if (this.membersList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.membersList;
        }

        public final void setMembersList(Collection<String> membersList) {
            this.membersList = GroupsListCopier.copy(membersList);
        }

        @Override
        public final Builder membersList(Collection<String> membersList) {
            this.membersList = GroupsListCopier.copy(membersList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder membersList(String ... membersList) {
            this.membersList(Arrays.asList(membersList));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public ListRoleMembershipsResponse build() {
            return new ListRoleMembershipsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRoleMembershipsResponse> {
        public Builder membersList(Collection<String> var1);

        public Builder membersList(String ... var1);

        public Builder nextToken(String var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

