/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a <code>TableVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TableConfiguration.Builder, TableConfiguration> {
    private static final SdkField<TableFieldWells> FIELD_WELLS_FIELD = SdkField
            .<TableFieldWells> builder(MarshallingType.SDK_POJO).memberName("FieldWells")
            .getter(getter(TableConfiguration::fieldWells)).setter(setter(Builder::fieldWells))
            .constructor(TableFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()).build();

    private static final SdkField<TableSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField
            .<TableSortConfiguration> builder(MarshallingType.SDK_POJO).memberName("SortConfiguration")
            .getter(getter(TableConfiguration::sortConfiguration)).setter(setter(Builder::sortConfiguration))
            .constructor(TableSortConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()).build();

    private static final SdkField<TableOptions> TABLE_OPTIONS_FIELD = SdkField.<TableOptions> builder(MarshallingType.SDK_POJO)
            .memberName("TableOptions").getter(getter(TableConfiguration::tableOptions)).setter(setter(Builder::tableOptions))
            .constructor(TableOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableOptions").build()).build();

    private static final SdkField<TotalOptions> TOTAL_OPTIONS_FIELD = SdkField.<TotalOptions> builder(MarshallingType.SDK_POJO)
            .memberName("TotalOptions").getter(getter(TableConfiguration::totalOptions)).setter(setter(Builder::totalOptions))
            .constructor(TotalOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalOptions").build()).build();

    private static final SdkField<TableFieldOptions> FIELD_OPTIONS_FIELD = SdkField
            .<TableFieldOptions> builder(MarshallingType.SDK_POJO).memberName("FieldOptions")
            .getter(getter(TableConfiguration::fieldOptions)).setter(setter(Builder::fieldOptions))
            .constructor(TableFieldOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldOptions").build()).build();

    private static final SdkField<TablePaginatedReportOptions> PAGINATED_REPORT_OPTIONS_FIELD = SdkField
            .<TablePaginatedReportOptions> builder(MarshallingType.SDK_POJO).memberName("PaginatedReportOptions")
            .getter(getter(TableConfiguration::paginatedReportOptions)).setter(setter(Builder::paginatedReportOptions))
            .constructor(TablePaginatedReportOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginatedReportOptions").build())
            .build();

    private static final SdkField<List<TableInlineVisualization>> TABLE_INLINE_VISUALIZATIONS_FIELD = SdkField
            .<List<TableInlineVisualization>> builder(MarshallingType.LIST)
            .memberName("TableInlineVisualizations")
            .getter(getter(TableConfiguration::tableInlineVisualizations))
            .setter(setter(Builder::tableInlineVisualizations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableInlineVisualizations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TableInlineVisualization> builder(MarshallingType.SDK_POJO)
                                            .constructor(TableInlineVisualization::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD,
            SORT_CONFIGURATION_FIELD, TABLE_OPTIONS_FIELD, TOTAL_OPTIONS_FIELD, FIELD_OPTIONS_FIELD,
            PAGINATED_REPORT_OPTIONS_FIELD, TABLE_INLINE_VISUALIZATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final TableFieldWells fieldWells;

    private final TableSortConfiguration sortConfiguration;

    private final TableOptions tableOptions;

    private final TotalOptions totalOptions;

    private final TableFieldOptions fieldOptions;

    private final TablePaginatedReportOptions paginatedReportOptions;

    private final List<TableInlineVisualization> tableInlineVisualizations;

    private TableConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.tableOptions = builder.tableOptions;
        this.totalOptions = builder.totalOptions;
        this.fieldOptions = builder.fieldOptions;
        this.paginatedReportOptions = builder.paginatedReportOptions;
        this.tableInlineVisualizations = builder.tableInlineVisualizations;
    }

    /**
     * <p>
     * The field wells of the visual.
     * </p>
     * 
     * @return The field wells of the visual.
     */
    public final TableFieldWells fieldWells() {
        return fieldWells;
    }

    /**
     * <p>
     * The sort configuration for a <code>TableVisual</code>.
     * </p>
     * 
     * @return The sort configuration for a <code>TableVisual</code>.
     */
    public final TableSortConfiguration sortConfiguration() {
        return sortConfiguration;
    }

    /**
     * <p>
     * The table options for a table visual.
     * </p>
     * 
     * @return The table options for a table visual.
     */
    public final TableOptions tableOptions() {
        return tableOptions;
    }

    /**
     * <p>
     * The total options for a table visual.
     * </p>
     * 
     * @return The total options for a table visual.
     */
    public final TotalOptions totalOptions() {
        return totalOptions;
    }

    /**
     * <p>
     * The field options for a table visual.
     * </p>
     * 
     * @return The field options for a table visual.
     */
    public final TableFieldOptions fieldOptions() {
        return fieldOptions;
    }

    /**
     * <p>
     * The paginated report options for a table visual.
     * </p>
     * 
     * @return The paginated report options for a table visual.
     */
    public final TablePaginatedReportOptions paginatedReportOptions() {
        return paginatedReportOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the TableInlineVisualizations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTableInlineVisualizations() {
        return tableInlineVisualizations != null && !(tableInlineVisualizations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of inline visualizations to display within a chart.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTableInlineVisualizations} method.
     * </p>
     * 
     * @return A collection of inline visualizations to display within a chart.
     */
    public final List<TableInlineVisualization> tableInlineVisualizations() {
        return tableInlineVisualizations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(tableOptions());
        hashCode = 31 * hashCode + Objects.hashCode(totalOptions());
        hashCode = 31 * hashCode + Objects.hashCode(fieldOptions());
        hashCode = 31 * hashCode + Objects.hashCode(paginatedReportOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasTableInlineVisualizations() ? tableInlineVisualizations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableConfiguration)) {
            return false;
        }
        TableConfiguration other = (TableConfiguration) obj;
        return Objects.equals(fieldWells(), other.fieldWells()) && Objects.equals(sortConfiguration(), other.sortConfiguration())
                && Objects.equals(tableOptions(), other.tableOptions()) && Objects.equals(totalOptions(), other.totalOptions())
                && Objects.equals(fieldOptions(), other.fieldOptions())
                && Objects.equals(paginatedReportOptions(), other.paginatedReportOptions())
                && hasTableInlineVisualizations() == other.hasTableInlineVisualizations()
                && Objects.equals(tableInlineVisualizations(), other.tableInlineVisualizations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableConfiguration").add("FieldWells", fieldWells())
                .add("SortConfiguration", sortConfiguration()).add("TableOptions", tableOptions())
                .add("TotalOptions", totalOptions()).add("FieldOptions", fieldOptions())
                .add("PaginatedReportOptions", paginatedReportOptions())
                .add("TableInlineVisualizations", hasTableInlineVisualizations() ? tableInlineVisualizations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldWells":
            return Optional.ofNullable(clazz.cast(fieldWells()));
        case "SortConfiguration":
            return Optional.ofNullable(clazz.cast(sortConfiguration()));
        case "TableOptions":
            return Optional.ofNullable(clazz.cast(tableOptions()));
        case "TotalOptions":
            return Optional.ofNullable(clazz.cast(totalOptions()));
        case "FieldOptions":
            return Optional.ofNullable(clazz.cast(fieldOptions()));
        case "PaginatedReportOptions":
            return Optional.ofNullable(clazz.cast(paginatedReportOptions()));
        case "TableInlineVisualizations":
            return Optional.ofNullable(clazz.cast(tableInlineVisualizations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableConfiguration, T> g) {
        return obj -> g.apply((TableConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableConfiguration> {
        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * 
         * @param fieldWells
         *        The field wells of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldWells(TableFieldWells fieldWells);

        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableFieldWells.Builder} avoiding the
         * need to create one manually via {@link TableFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableFieldWells.Builder#build()} is called immediately and its
         * result is passed to {@link #fieldWells(TableFieldWells)}.
         * 
         * @param fieldWells
         *        a consumer that will call methods on {@link TableFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldWells(TableFieldWells)
         */
        default Builder fieldWells(Consumer<TableFieldWells.Builder> fieldWells) {
            return fieldWells(TableFieldWells.builder().applyMutation(fieldWells).build());
        }

        /**
         * <p>
         * The sort configuration for a <code>TableVisual</code>.
         * </p>
         * 
         * @param sortConfiguration
         *        The sort configuration for a <code>TableVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortConfiguration(TableSortConfiguration sortConfiguration);

        /**
         * <p>
         * The sort configuration for a <code>TableVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableSortConfiguration.Builder} avoiding
         * the need to create one manually via {@link TableSortConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableSortConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #sortConfiguration(TableSortConfiguration)}.
         * 
         * @param sortConfiguration
         *        a consumer that will call methods on {@link TableSortConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortConfiguration(TableSortConfiguration)
         */
        default Builder sortConfiguration(Consumer<TableSortConfiguration.Builder> sortConfiguration) {
            return sortConfiguration(TableSortConfiguration.builder().applyMutation(sortConfiguration).build());
        }

        /**
         * <p>
         * The table options for a table visual.
         * </p>
         * 
         * @param tableOptions
         *        The table options for a table visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableOptions(TableOptions tableOptions);

        /**
         * <p>
         * The table options for a table visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableOptions.Builder} avoiding the need
         * to create one manually via {@link TableOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #tableOptions(TableOptions)}.
         * 
         * @param tableOptions
         *        a consumer that will call methods on {@link TableOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableOptions(TableOptions)
         */
        default Builder tableOptions(Consumer<TableOptions.Builder> tableOptions) {
            return tableOptions(TableOptions.builder().applyMutation(tableOptions).build());
        }

        /**
         * <p>
         * The total options for a table visual.
         * </p>
         * 
         * @param totalOptions
         *        The total options for a table visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalOptions(TotalOptions totalOptions);

        /**
         * <p>
         * The total options for a table visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link TotalOptions.Builder} avoiding the need
         * to create one manually via {@link TotalOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TotalOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #totalOptions(TotalOptions)}.
         * 
         * @param totalOptions
         *        a consumer that will call methods on {@link TotalOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #totalOptions(TotalOptions)
         */
        default Builder totalOptions(Consumer<TotalOptions.Builder> totalOptions) {
            return totalOptions(TotalOptions.builder().applyMutation(totalOptions).build());
        }

        /**
         * <p>
         * The field options for a table visual.
         * </p>
         * 
         * @param fieldOptions
         *        The field options for a table visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldOptions(TableFieldOptions fieldOptions);

        /**
         * <p>
         * The field options for a table visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableFieldOptions.Builder} avoiding the
         * need to create one manually via {@link TableFieldOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableFieldOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #fieldOptions(TableFieldOptions)}.
         * 
         * @param fieldOptions
         *        a consumer that will call methods on {@link TableFieldOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldOptions(TableFieldOptions)
         */
        default Builder fieldOptions(Consumer<TableFieldOptions.Builder> fieldOptions) {
            return fieldOptions(TableFieldOptions.builder().applyMutation(fieldOptions).build());
        }

        /**
         * <p>
         * The paginated report options for a table visual.
         * </p>
         * 
         * @param paginatedReportOptions
         *        The paginated report options for a table visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paginatedReportOptions(TablePaginatedReportOptions paginatedReportOptions);

        /**
         * <p>
         * The paginated report options for a table visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link TablePaginatedReportOptions.Builder}
         * avoiding the need to create one manually via {@link TablePaginatedReportOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TablePaginatedReportOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #paginatedReportOptions(TablePaginatedReportOptions)}.
         * 
         * @param paginatedReportOptions
         *        a consumer that will call methods on {@link TablePaginatedReportOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #paginatedReportOptions(TablePaginatedReportOptions)
         */
        default Builder paginatedReportOptions(Consumer<TablePaginatedReportOptions.Builder> paginatedReportOptions) {
            return paginatedReportOptions(TablePaginatedReportOptions.builder().applyMutation(paginatedReportOptions).build());
        }

        /**
         * <p>
         * A collection of inline visualizations to display within a chart.
         * </p>
         * 
         * @param tableInlineVisualizations
         *        A collection of inline visualizations to display within a chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableInlineVisualizations(Collection<TableInlineVisualization> tableInlineVisualizations);

        /**
         * <p>
         * A collection of inline visualizations to display within a chart.
         * </p>
         * 
         * @param tableInlineVisualizations
         *        A collection of inline visualizations to display within a chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableInlineVisualizations(TableInlineVisualization... tableInlineVisualizations);

        /**
         * <p>
         * A collection of inline visualizations to display within a chart.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.TableInlineVisualization.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.TableInlineVisualization#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.TableInlineVisualization.Builder#build()} is called
         * immediately and its result is passed to {@link #tableInlineVisualizations(List<TableInlineVisualization>)}.
         * 
         * @param tableInlineVisualizations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.TableInlineVisualization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableInlineVisualizations(java.util.Collection<TableInlineVisualization>)
         */
        Builder tableInlineVisualizations(Consumer<TableInlineVisualization.Builder>... tableInlineVisualizations);
    }

    static final class BuilderImpl implements Builder {
        private TableFieldWells fieldWells;

        private TableSortConfiguration sortConfiguration;

        private TableOptions tableOptions;

        private TotalOptions totalOptions;

        private TableFieldOptions fieldOptions;

        private TablePaginatedReportOptions paginatedReportOptions;

        private List<TableInlineVisualization> tableInlineVisualizations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TableConfiguration model) {
            fieldWells(model.fieldWells);
            sortConfiguration(model.sortConfiguration);
            tableOptions(model.tableOptions);
            totalOptions(model.totalOptions);
            fieldOptions(model.fieldOptions);
            paginatedReportOptions(model.paginatedReportOptions);
            tableInlineVisualizations(model.tableInlineVisualizations);
        }

        public final TableFieldWells.Builder getFieldWells() {
            return fieldWells != null ? fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(TableFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(TableFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final TableSortConfiguration.Builder getSortConfiguration() {
            return sortConfiguration != null ? sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(TableSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(TableSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final TableOptions.Builder getTableOptions() {
            return tableOptions != null ? tableOptions.toBuilder() : null;
        }

        public final void setTableOptions(TableOptions.BuilderImpl tableOptions) {
            this.tableOptions = tableOptions != null ? tableOptions.build() : null;
        }

        @Override
        public final Builder tableOptions(TableOptions tableOptions) {
            this.tableOptions = tableOptions;
            return this;
        }

        public final TotalOptions.Builder getTotalOptions() {
            return totalOptions != null ? totalOptions.toBuilder() : null;
        }

        public final void setTotalOptions(TotalOptions.BuilderImpl totalOptions) {
            this.totalOptions = totalOptions != null ? totalOptions.build() : null;
        }

        @Override
        public final Builder totalOptions(TotalOptions totalOptions) {
            this.totalOptions = totalOptions;
            return this;
        }

        public final TableFieldOptions.Builder getFieldOptions() {
            return fieldOptions != null ? fieldOptions.toBuilder() : null;
        }

        public final void setFieldOptions(TableFieldOptions.BuilderImpl fieldOptions) {
            this.fieldOptions = fieldOptions != null ? fieldOptions.build() : null;
        }

        @Override
        public final Builder fieldOptions(TableFieldOptions fieldOptions) {
            this.fieldOptions = fieldOptions;
            return this;
        }

        public final TablePaginatedReportOptions.Builder getPaginatedReportOptions() {
            return paginatedReportOptions != null ? paginatedReportOptions.toBuilder() : null;
        }

        public final void setPaginatedReportOptions(TablePaginatedReportOptions.BuilderImpl paginatedReportOptions) {
            this.paginatedReportOptions = paginatedReportOptions != null ? paginatedReportOptions.build() : null;
        }

        @Override
        public final Builder paginatedReportOptions(TablePaginatedReportOptions paginatedReportOptions) {
            this.paginatedReportOptions = paginatedReportOptions;
            return this;
        }

        public final List<TableInlineVisualization.Builder> getTableInlineVisualizations() {
            List<TableInlineVisualization.Builder> result = TableInlineVisualizationListCopier
                    .copyToBuilder(this.tableInlineVisualizations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTableInlineVisualizations(Collection<TableInlineVisualization.BuilderImpl> tableInlineVisualizations) {
            this.tableInlineVisualizations = TableInlineVisualizationListCopier.copyFromBuilder(tableInlineVisualizations);
        }

        @Override
        public final Builder tableInlineVisualizations(Collection<TableInlineVisualization> tableInlineVisualizations) {
            this.tableInlineVisualizations = TableInlineVisualizationListCopier.copy(tableInlineVisualizations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableInlineVisualizations(TableInlineVisualization... tableInlineVisualizations) {
            tableInlineVisualizations(Arrays.asList(tableInlineVisualizations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableInlineVisualizations(Consumer<TableInlineVisualization.Builder>... tableInlineVisualizations) {
            tableInlineVisualizations(Stream.of(tableInlineVisualizations)
                    .map(c -> TableInlineVisualization.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TableConfiguration build() {
            return new TableConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
