/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An empty visual.
 * </p>
 * <p>
 * Empty visuals are used in layouts but have not been configured to show any data. A new visual created in the Amazon
 * QuickSight console is considered an <code>EmptyVisual</code> until a visual type is selected.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmptyVisual implements SdkPojo, Serializable, ToCopyableBuilder<EmptyVisual.Builder, EmptyVisual> {
    private static final SdkField<String> VISUAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VisualId").getter(getter(EmptyVisual::visualId)).setter(setter(Builder::visualId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualId").build()).build();

    private static final SdkField<String> DATA_SET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetIdentifier").getter(getter(EmptyVisual::dataSetIdentifier))
            .setter(setter(Builder::dataSetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetIdentifier").build()).build();

    private static final SdkField<List<VisualCustomAction>> ACTIONS_FIELD = SdkField
            .<List<VisualCustomAction>> builder(MarshallingType.LIST)
            .memberName("Actions")
            .getter(getter(EmptyVisual::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VisualCustomAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(VisualCustomAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISUAL_ID_FIELD,
            DATA_SET_IDENTIFIER_FIELD, ACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String visualId;

    private final String dataSetIdentifier;

    private final List<VisualCustomAction> actions;

    private EmptyVisual(BuilderImpl builder) {
        this.visualId = builder.visualId;
        this.dataSetIdentifier = builder.dataSetIdentifier;
        this.actions = builder.actions;
    }

    /**
     * <p>
     * The unique identifier of a visual. This identifier must be unique within the context of a dashboard, template, or
     * analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
     * </p>
     * 
     * @return The unique identifier of a visual. This identifier must be unique within the context of a dashboard,
     *         template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
     */
    public final String visualId() {
        return visualId;
    }

    /**
     * <p>
     * The data set that is used in the empty visual. Every visual requires a dataset to render.
     * </p>
     * 
     * @return The data set that is used in the empty visual. Every visual requires a dataset to render.
     */
    public final String dataSetIdentifier() {
        return dataSetIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of custom actions that are configured for a visual.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The list of custom actions that are configured for a visual.
     */
    public final List<VisualCustomAction> actions() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(visualId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmptyVisual)) {
            return false;
        }
        EmptyVisual other = (EmptyVisual) obj;
        return Objects.equals(visualId(), other.visualId()) && Objects.equals(dataSetIdentifier(), other.dataSetIdentifier())
                && hasActions() == other.hasActions() && Objects.equals(actions(), other.actions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmptyVisual").add("VisualId", visualId()).add("DataSetIdentifier", dataSetIdentifier())
                .add("Actions", hasActions() ? actions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VisualId":
            return Optional.ofNullable(clazz.cast(visualId()));
        case "DataSetIdentifier":
            return Optional.ofNullable(clazz.cast(dataSetIdentifier()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmptyVisual, T> g) {
        return obj -> g.apply((EmptyVisual) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmptyVisual> {
        /**
         * <p>
         * The unique identifier of a visual. This identifier must be unique within the context of a dashboard,
         * template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
         * </p>
         * 
         * @param visualId
         *        The unique identifier of a visual. This identifier must be unique within the context of a dashboard,
         *        template, or analysis. Two dashboards, analyses, or templates can have visuals with the same
         *        identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualId(String visualId);

        /**
         * <p>
         * The data set that is used in the empty visual. Every visual requires a dataset to render.
         * </p>
         * 
         * @param dataSetIdentifier
         *        The data set that is used in the empty visual. Every visual requires a dataset to render.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetIdentifier(String dataSetIdentifier);

        /**
         * <p>
         * The list of custom actions that are configured for a visual.
         * </p>
         * 
         * @param actions
         *        The list of custom actions that are configured for a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<VisualCustomAction> actions);

        /**
         * <p>
         * The list of custom actions that are configured for a visual.
         * </p>
         * 
         * @param actions
         *        The list of custom actions that are configured for a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(VisualCustomAction... actions);

        /**
         * <p>
         * The list of custom actions that are configured for a visual.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.VisualCustomAction.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.quicksight.model.VisualCustomAction#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.VisualCustomAction.Builder#build()} is called
         * immediately and its result is passed to {@link #actions(List<VisualCustomAction>)}.
         * 
         * @param actions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.VisualCustomAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(java.util.Collection<VisualCustomAction>)
         */
        Builder actions(Consumer<VisualCustomAction.Builder>... actions);
    }

    static final class BuilderImpl implements Builder {
        private String visualId;

        private String dataSetIdentifier;

        private List<VisualCustomAction> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EmptyVisual model) {
            visualId(model.visualId);
            dataSetIdentifier(model.dataSetIdentifier);
            actions(model.actions);
        }

        public final String getVisualId() {
            return visualId;
        }

        public final void setVisualId(String visualId) {
            this.visualId = visualId;
        }

        @Override
        public final Builder visualId(String visualId) {
            this.visualId = visualId;
            return this;
        }

        public final String getDataSetIdentifier() {
            return dataSetIdentifier;
        }

        public final void setDataSetIdentifier(String dataSetIdentifier) {
            this.dataSetIdentifier = dataSetIdentifier;
        }

        @Override
        public final Builder dataSetIdentifier(String dataSetIdentifier) {
            this.dataSetIdentifier = dataSetIdentifier;
            return this;
        }

        public final List<VisualCustomAction.Builder> getActions() {
            List<VisualCustomAction.Builder> result = VisualCustomActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<VisualCustomAction.BuilderImpl> actions) {
            this.actions = VisualCustomActionListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<VisualCustomAction> actions) {
            this.actions = VisualCustomActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(VisualCustomAction... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<VisualCustomAction.Builder>... actions) {
            actions(Stream.of(actions).map(c -> VisualCustomAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public EmptyVisual build() {
            return new EmptyVisual(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
