/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a <code>ComboChartVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComboChartConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ComboChartConfiguration.Builder, ComboChartConfiguration> {
    private static final SdkField<ComboChartFieldWells> FIELD_WELLS_FIELD = SdkField
            .<ComboChartFieldWells> builder(MarshallingType.SDK_POJO).memberName("FieldWells")
            .getter(getter(ComboChartConfiguration::fieldWells)).setter(setter(Builder::fieldWells))
            .constructor(ComboChartFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()).build();

    private static final SdkField<ComboChartSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField
            .<ComboChartSortConfiguration> builder(MarshallingType.SDK_POJO).memberName("SortConfiguration")
            .getter(getter(ComboChartConfiguration::sortConfiguration)).setter(setter(Builder::sortConfiguration))
            .constructor(ComboChartSortConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()).build();

    private static final SdkField<String> BARS_ARRANGEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BarsArrangement").getter(getter(ComboChartConfiguration::barsArrangementAsString))
            .setter(setter(Builder::barsArrangement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BarsArrangement").build()).build();

    private static final SdkField<AxisDisplayOptions> CATEGORY_AXIS_FIELD = SdkField
            .<AxisDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("CategoryAxis")
            .getter(getter(ComboChartConfiguration::categoryAxis)).setter(setter(Builder::categoryAxis))
            .constructor(AxisDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryAxis").build()).build();

    private static final SdkField<ChartAxisLabelOptions> CATEGORY_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("CategoryLabelOptions")
            .getter(getter(ComboChartConfiguration::categoryLabelOptions)).setter(setter(Builder::categoryLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryLabelOptions").build())
            .build();

    private static final SdkField<AxisDisplayOptions> PRIMARY_Y_AXIS_DISPLAY_OPTIONS_FIELD = SdkField
            .<AxisDisplayOptions> builder(MarshallingType.SDK_POJO)
            .memberName("PrimaryYAxisDisplayOptions")
            .getter(getter(ComboChartConfiguration::primaryYAxisDisplayOptions))
            .setter(setter(Builder::primaryYAxisDisplayOptions))
            .constructor(AxisDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryYAxisDisplayOptions").build())
            .build();

    private static final SdkField<ChartAxisLabelOptions> PRIMARY_Y_AXIS_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("PrimaryYAxisLabelOptions")
            .getter(getter(ComboChartConfiguration::primaryYAxisLabelOptions)).setter(setter(Builder::primaryYAxisLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryYAxisLabelOptions").build())
            .build();

    private static final SdkField<AxisDisplayOptions> SECONDARY_Y_AXIS_DISPLAY_OPTIONS_FIELD = SdkField
            .<AxisDisplayOptions> builder(MarshallingType.SDK_POJO)
            .memberName("SecondaryYAxisDisplayOptions")
            .getter(getter(ComboChartConfiguration::secondaryYAxisDisplayOptions))
            .setter(setter(Builder::secondaryYAxisDisplayOptions))
            .constructor(AxisDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryYAxisDisplayOptions")
                    .build()).build();

    private static final SdkField<ChartAxisLabelOptions> SECONDARY_Y_AXIS_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO)
            .memberName("SecondaryYAxisLabelOptions")
            .getter(getter(ComboChartConfiguration::secondaryYAxisLabelOptions))
            .setter(setter(Builder::secondaryYAxisLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryYAxisLabelOptions").build())
            .build();

    private static final SdkField<SingleAxisOptions> SINGLE_AXIS_OPTIONS_FIELD = SdkField
            .<SingleAxisOptions> builder(MarshallingType.SDK_POJO).memberName("SingleAxisOptions")
            .getter(getter(ComboChartConfiguration::singleAxisOptions)).setter(setter(Builder::singleAxisOptions))
            .constructor(SingleAxisOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleAxisOptions").build()).build();

    private static final SdkField<ChartAxisLabelOptions> COLOR_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("ColorLabelOptions")
            .getter(getter(ComboChartConfiguration::colorLabelOptions)).setter(setter(Builder::colorLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorLabelOptions").build()).build();

    private static final SdkField<LegendOptions> LEGEND_FIELD = SdkField.<LegendOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Legend").getter(getter(ComboChartConfiguration::legend)).setter(setter(Builder::legend))
            .constructor(LegendOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legend").build()).build();

    private static final SdkField<DataLabelOptions> BAR_DATA_LABELS_FIELD = SdkField
            .<DataLabelOptions> builder(MarshallingType.SDK_POJO).memberName("BarDataLabels")
            .getter(getter(ComboChartConfiguration::barDataLabels)).setter(setter(Builder::barDataLabels))
            .constructor(DataLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BarDataLabels").build()).build();

    private static final SdkField<DataLabelOptions> LINE_DATA_LABELS_FIELD = SdkField
            .<DataLabelOptions> builder(MarshallingType.SDK_POJO).memberName("LineDataLabels")
            .getter(getter(ComboChartConfiguration::lineDataLabels)).setter(setter(Builder::lineDataLabels))
            .constructor(DataLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineDataLabels").build()).build();

    private static final SdkField<TooltipOptions> TOOLTIP_FIELD = SdkField.<TooltipOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Tooltip").getter(getter(ComboChartConfiguration::tooltip)).setter(setter(Builder::tooltip))
            .constructor(TooltipOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tooltip").build()).build();

    private static final SdkField<List<ReferenceLine>> REFERENCE_LINES_FIELD = SdkField
            .<List<ReferenceLine>> builder(MarshallingType.LIST)
            .memberName("ReferenceLines")
            .getter(getter(ComboChartConfiguration::referenceLines))
            .setter(setter(Builder::referenceLines))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceLines").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReferenceLine> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReferenceLine::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<VisualPalette> VISUAL_PALETTE_FIELD = SdkField
            .<VisualPalette> builder(MarshallingType.SDK_POJO).memberName("VisualPalette")
            .getter(getter(ComboChartConfiguration::visualPalette)).setter(setter(Builder::visualPalette))
            .constructor(VisualPalette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualPalette").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD,
            SORT_CONFIGURATION_FIELD, BARS_ARRANGEMENT_FIELD, CATEGORY_AXIS_FIELD, CATEGORY_LABEL_OPTIONS_FIELD,
            PRIMARY_Y_AXIS_DISPLAY_OPTIONS_FIELD, PRIMARY_Y_AXIS_LABEL_OPTIONS_FIELD, SECONDARY_Y_AXIS_DISPLAY_OPTIONS_FIELD,
            SECONDARY_Y_AXIS_LABEL_OPTIONS_FIELD, SINGLE_AXIS_OPTIONS_FIELD, COLOR_LABEL_OPTIONS_FIELD, LEGEND_FIELD,
            BAR_DATA_LABELS_FIELD, LINE_DATA_LABELS_FIELD, TOOLTIP_FIELD, REFERENCE_LINES_FIELD, VISUAL_PALETTE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ComboChartFieldWells fieldWells;

    private final ComboChartSortConfiguration sortConfiguration;

    private final String barsArrangement;

    private final AxisDisplayOptions categoryAxis;

    private final ChartAxisLabelOptions categoryLabelOptions;

    private final AxisDisplayOptions primaryYAxisDisplayOptions;

    private final ChartAxisLabelOptions primaryYAxisLabelOptions;

    private final AxisDisplayOptions secondaryYAxisDisplayOptions;

    private final ChartAxisLabelOptions secondaryYAxisLabelOptions;

    private final SingleAxisOptions singleAxisOptions;

    private final ChartAxisLabelOptions colorLabelOptions;

    private final LegendOptions legend;

    private final DataLabelOptions barDataLabels;

    private final DataLabelOptions lineDataLabels;

    private final TooltipOptions tooltip;

    private final List<ReferenceLine> referenceLines;

    private final VisualPalette visualPalette;

    private ComboChartConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.barsArrangement = builder.barsArrangement;
        this.categoryAxis = builder.categoryAxis;
        this.categoryLabelOptions = builder.categoryLabelOptions;
        this.primaryYAxisDisplayOptions = builder.primaryYAxisDisplayOptions;
        this.primaryYAxisLabelOptions = builder.primaryYAxisLabelOptions;
        this.secondaryYAxisDisplayOptions = builder.secondaryYAxisDisplayOptions;
        this.secondaryYAxisLabelOptions = builder.secondaryYAxisLabelOptions;
        this.singleAxisOptions = builder.singleAxisOptions;
        this.colorLabelOptions = builder.colorLabelOptions;
        this.legend = builder.legend;
        this.barDataLabels = builder.barDataLabels;
        this.lineDataLabels = builder.lineDataLabels;
        this.tooltip = builder.tooltip;
        this.referenceLines = builder.referenceLines;
        this.visualPalette = builder.visualPalette;
    }

    /**
     * <p>
     * The field wells of the visual.
     * </p>
     * 
     * @return The field wells of the visual.
     */
    public final ComboChartFieldWells fieldWells() {
        return fieldWells;
    }

    /**
     * <p>
     * The sort configuration of a <code>ComboChartVisual</code>.
     * </p>
     * 
     * @return The sort configuration of a <code>ComboChartVisual</code>.
     */
    public final ComboChartSortConfiguration sortConfiguration() {
        return sortConfiguration;
    }

    /**
     * <p>
     * Determines the bar arrangement in a combo chart. The following are valid values in this structure:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CLUSTERED</code>: For clustered bar combo charts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STACKED</code>: For stacked bar combo charts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STACKED_PERCENT</code>: Do not use. If you use this value, the operation returns a validation error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #barsArrangement}
     * will return {@link BarsArrangement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #barsArrangementAsString}.
     * </p>
     * 
     * @return Determines the bar arrangement in a combo chart. The following are valid values in this structure:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CLUSTERED</code>: For clustered bar combo charts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STACKED</code>: For stacked bar combo charts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STACKED_PERCENT</code>: Do not use. If you use this value, the operation returns a validation
     *         error.
     *         </p>
     *         </li>
     * @see BarsArrangement
     */
    public final BarsArrangement barsArrangement() {
        return BarsArrangement.fromValue(barsArrangement);
    }

    /**
     * <p>
     * Determines the bar arrangement in a combo chart. The following are valid values in this structure:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CLUSTERED</code>: For clustered bar combo charts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STACKED</code>: For stacked bar combo charts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STACKED_PERCENT</code>: Do not use. If you use this value, the operation returns a validation error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #barsArrangement}
     * will return {@link BarsArrangement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #barsArrangementAsString}.
     * </p>
     * 
     * @return Determines the bar arrangement in a combo chart. The following are valid values in this structure:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CLUSTERED</code>: For clustered bar combo charts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STACKED</code>: For stacked bar combo charts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STACKED_PERCENT</code>: Do not use. If you use this value, the operation returns a validation
     *         error.
     *         </p>
     *         </li>
     * @see BarsArrangement
     */
    public final String barsArrangementAsString() {
        return barsArrangement;
    }

    /**
     * <p>
     * The category axis of a combo chart.
     * </p>
     * 
     * @return The category axis of a combo chart.
     */
    public final AxisDisplayOptions categoryAxis() {
        return categoryAxis;
    }

    /**
     * <p>
     * The label options (label text, label visibility, and sort icon visibility) of a combo chart category
     * (group/color) field well.
     * </p>
     * 
     * @return The label options (label text, label visibility, and sort icon visibility) of a combo chart category
     *         (group/color) field well.
     */
    public final ChartAxisLabelOptions categoryLabelOptions() {
        return categoryLabelOptions;
    }

    /**
     * <p>
     * The label display options (grid line, range, scale, and axis step) of a combo chart's primary y-axis (bar) field
     * well.
     * </p>
     * 
     * @return The label display options (grid line, range, scale, and axis step) of a combo chart's primary y-axis
     *         (bar) field well.
     */
    public final AxisDisplayOptions primaryYAxisDisplayOptions() {
        return primaryYAxisDisplayOptions;
    }

    /**
     * <p>
     * The label options (label text, label visibility, and sort icon visibility) of a combo chart's primary y-axis
     * (bar) field well.
     * </p>
     * 
     * @return The label options (label text, label visibility, and sort icon visibility) of a combo chart's primary
     *         y-axis (bar) field well.
     */
    public final ChartAxisLabelOptions primaryYAxisLabelOptions() {
        return primaryYAxisLabelOptions;
    }

    /**
     * <p>
     * The label display options (grid line, range, scale, axis step) of a combo chart's secondary y-axis (line) field
     * well.
     * </p>
     * 
     * @return The label display options (grid line, range, scale, axis step) of a combo chart's secondary y-axis (line)
     *         field well.
     */
    public final AxisDisplayOptions secondaryYAxisDisplayOptions() {
        return secondaryYAxisDisplayOptions;
    }

    /**
     * <p>
     * The label options (label text, label visibility, and sort icon visibility) of a combo chart's secondary
     * y-axis(line) field well.
     * </p>
     * 
     * @return The label options (label text, label visibility, and sort icon visibility) of a combo chart's secondary
     *         y-axis(line) field well.
     */
    public final ChartAxisLabelOptions secondaryYAxisLabelOptions() {
        return secondaryYAxisLabelOptions;
    }

    /**
     * Returns the value of the SingleAxisOptions property for this object.
     * 
     * @return The value of the SingleAxisOptions property for this object.
     */
    public final SingleAxisOptions singleAxisOptions() {
        return singleAxisOptions;
    }

    /**
     * <p>
     * The label options (label text, label visibility, and sort icon visibility) of a combo chart's color field well.
     * </p>
     * 
     * @return The label options (label text, label visibility, and sort icon visibility) of a combo chart's color field
     *         well.
     */
    public final ChartAxisLabelOptions colorLabelOptions() {
        return colorLabelOptions;
    }

    /**
     * <p>
     * The legend display setup of the visual.
     * </p>
     * 
     * @return The legend display setup of the visual.
     */
    public final LegendOptions legend() {
        return legend;
    }

    /**
     * <p>
     * The options that determine if visual data labels are displayed.
     * </p>
     * <p>
     * The data label options for a bar in a combo chart.
     * </p>
     * 
     * @return The options that determine if visual data labels are displayed.</p>
     *         <p>
     *         The data label options for a bar in a combo chart.
     */
    public final DataLabelOptions barDataLabels() {
        return barDataLabels;
    }

    /**
     * <p>
     * The options that determine if visual data labels are displayed.
     * </p>
     * <p>
     * The data label options for a line in a combo chart.
     * </p>
     * 
     * @return The options that determine if visual data labels are displayed.</p>
     *         <p>
     *         The data label options for a line in a combo chart.
     */
    public final DataLabelOptions lineDataLabels() {
        return lineDataLabels;
    }

    /**
     * <p>
     * The legend display setup of the visual.
     * </p>
     * 
     * @return The legend display setup of the visual.
     */
    public final TooltipOptions tooltip() {
        return tooltip;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReferenceLines property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReferenceLines() {
        return referenceLines != null && !(referenceLines instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The reference line setup of the visual.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferenceLines} method.
     * </p>
     * 
     * @return The reference line setup of the visual.
     */
    public final List<ReferenceLine> referenceLines() {
        return referenceLines;
    }

    /**
     * <p>
     * The palette (chart color) display setup of the visual.
     * </p>
     * 
     * @return The palette (chart color) display setup of the visual.
     */
    public final VisualPalette visualPalette() {
        return visualPalette;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(barsArrangementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(categoryAxis());
        hashCode = 31 * hashCode + Objects.hashCode(categoryLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(primaryYAxisDisplayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(primaryYAxisLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryYAxisDisplayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryYAxisLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(singleAxisOptions());
        hashCode = 31 * hashCode + Objects.hashCode(colorLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(legend());
        hashCode = 31 * hashCode + Objects.hashCode(barDataLabels());
        hashCode = 31 * hashCode + Objects.hashCode(lineDataLabels());
        hashCode = 31 * hashCode + Objects.hashCode(tooltip());
        hashCode = 31 * hashCode + Objects.hashCode(hasReferenceLines() ? referenceLines() : null);
        hashCode = 31 * hashCode + Objects.hashCode(visualPalette());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComboChartConfiguration)) {
            return false;
        }
        ComboChartConfiguration other = (ComboChartConfiguration) obj;
        return Objects.equals(fieldWells(), other.fieldWells()) && Objects.equals(sortConfiguration(), other.sortConfiguration())
                && Objects.equals(barsArrangementAsString(), other.barsArrangementAsString())
                && Objects.equals(categoryAxis(), other.categoryAxis())
                && Objects.equals(categoryLabelOptions(), other.categoryLabelOptions())
                && Objects.equals(primaryYAxisDisplayOptions(), other.primaryYAxisDisplayOptions())
                && Objects.equals(primaryYAxisLabelOptions(), other.primaryYAxisLabelOptions())
                && Objects.equals(secondaryYAxisDisplayOptions(), other.secondaryYAxisDisplayOptions())
                && Objects.equals(secondaryYAxisLabelOptions(), other.secondaryYAxisLabelOptions())
                && Objects.equals(singleAxisOptions(), other.singleAxisOptions())
                && Objects.equals(colorLabelOptions(), other.colorLabelOptions()) && Objects.equals(legend(), other.legend())
                && Objects.equals(barDataLabels(), other.barDataLabels())
                && Objects.equals(lineDataLabels(), other.lineDataLabels()) && Objects.equals(tooltip(), other.tooltip())
                && hasReferenceLines() == other.hasReferenceLines() && Objects.equals(referenceLines(), other.referenceLines())
                && Objects.equals(visualPalette(), other.visualPalette());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComboChartConfiguration").add("FieldWells", fieldWells())
                .add("SortConfiguration", sortConfiguration()).add("BarsArrangement", barsArrangementAsString())
                .add("CategoryAxis", categoryAxis()).add("CategoryLabelOptions", categoryLabelOptions())
                .add("PrimaryYAxisDisplayOptions", primaryYAxisDisplayOptions())
                .add("PrimaryYAxisLabelOptions", primaryYAxisLabelOptions())
                .add("SecondaryYAxisDisplayOptions", secondaryYAxisDisplayOptions())
                .add("SecondaryYAxisLabelOptions", secondaryYAxisLabelOptions()).add("SingleAxisOptions", singleAxisOptions())
                .add("ColorLabelOptions", colorLabelOptions()).add("Legend", legend()).add("BarDataLabels", barDataLabels())
                .add("LineDataLabels", lineDataLabels()).add("Tooltip", tooltip())
                .add("ReferenceLines", hasReferenceLines() ? referenceLines() : null).add("VisualPalette", visualPalette())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldWells":
            return Optional.ofNullable(clazz.cast(fieldWells()));
        case "SortConfiguration":
            return Optional.ofNullable(clazz.cast(sortConfiguration()));
        case "BarsArrangement":
            return Optional.ofNullable(clazz.cast(barsArrangementAsString()));
        case "CategoryAxis":
            return Optional.ofNullable(clazz.cast(categoryAxis()));
        case "CategoryLabelOptions":
            return Optional.ofNullable(clazz.cast(categoryLabelOptions()));
        case "PrimaryYAxisDisplayOptions":
            return Optional.ofNullable(clazz.cast(primaryYAxisDisplayOptions()));
        case "PrimaryYAxisLabelOptions":
            return Optional.ofNullable(clazz.cast(primaryYAxisLabelOptions()));
        case "SecondaryYAxisDisplayOptions":
            return Optional.ofNullable(clazz.cast(secondaryYAxisDisplayOptions()));
        case "SecondaryYAxisLabelOptions":
            return Optional.ofNullable(clazz.cast(secondaryYAxisLabelOptions()));
        case "SingleAxisOptions":
            return Optional.ofNullable(clazz.cast(singleAxisOptions()));
        case "ColorLabelOptions":
            return Optional.ofNullable(clazz.cast(colorLabelOptions()));
        case "Legend":
            return Optional.ofNullable(clazz.cast(legend()));
        case "BarDataLabels":
            return Optional.ofNullable(clazz.cast(barDataLabels()));
        case "LineDataLabels":
            return Optional.ofNullable(clazz.cast(lineDataLabels()));
        case "Tooltip":
            return Optional.ofNullable(clazz.cast(tooltip()));
        case "ReferenceLines":
            return Optional.ofNullable(clazz.cast(referenceLines()));
        case "VisualPalette":
            return Optional.ofNullable(clazz.cast(visualPalette()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComboChartConfiguration, T> g) {
        return obj -> g.apply((ComboChartConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComboChartConfiguration> {
        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * 
         * @param fieldWells
         *        The field wells of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldWells(ComboChartFieldWells fieldWells);

        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComboChartFieldWells.Builder} avoiding
         * the need to create one manually via {@link ComboChartFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComboChartFieldWells.Builder#build()} is called immediately and
         * its result is passed to {@link #fieldWells(ComboChartFieldWells)}.
         * 
         * @param fieldWells
         *        a consumer that will call methods on {@link ComboChartFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldWells(ComboChartFieldWells)
         */
        default Builder fieldWells(Consumer<ComboChartFieldWells.Builder> fieldWells) {
            return fieldWells(ComboChartFieldWells.builder().applyMutation(fieldWells).build());
        }

        /**
         * <p>
         * The sort configuration of a <code>ComboChartVisual</code>.
         * </p>
         * 
         * @param sortConfiguration
         *        The sort configuration of a <code>ComboChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortConfiguration(ComboChartSortConfiguration sortConfiguration);

        /**
         * <p>
         * The sort configuration of a <code>ComboChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComboChartSortConfiguration.Builder}
         * avoiding the need to create one manually via {@link ComboChartSortConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComboChartSortConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sortConfiguration(ComboChartSortConfiguration)}.
         * 
         * @param sortConfiguration
         *        a consumer that will call methods on {@link ComboChartSortConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortConfiguration(ComboChartSortConfiguration)
         */
        default Builder sortConfiguration(Consumer<ComboChartSortConfiguration.Builder> sortConfiguration) {
            return sortConfiguration(ComboChartSortConfiguration.builder().applyMutation(sortConfiguration).build());
        }

        /**
         * <p>
         * Determines the bar arrangement in a combo chart. The following are valid values in this structure:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CLUSTERED</code>: For clustered bar combo charts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STACKED</code>: For stacked bar combo charts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STACKED_PERCENT</code>: Do not use. If you use this value, the operation returns a validation error.
         * </p>
         * </li>
         * </ul>
         * 
         * @param barsArrangement
         *        Determines the bar arrangement in a combo chart. The following are valid values in this structure:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CLUSTERED</code>: For clustered bar combo charts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STACKED</code>: For stacked bar combo charts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STACKED_PERCENT</code>: Do not use. If you use this value, the operation returns a validation
         *        error.
         *        </p>
         *        </li>
         * @see BarsArrangement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BarsArrangement
         */
        Builder barsArrangement(String barsArrangement);

        /**
         * <p>
         * Determines the bar arrangement in a combo chart. The following are valid values in this structure:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CLUSTERED</code>: For clustered bar combo charts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STACKED</code>: For stacked bar combo charts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STACKED_PERCENT</code>: Do not use. If you use this value, the operation returns a validation error.
         * </p>
         * </li>
         * </ul>
         * 
         * @param barsArrangement
         *        Determines the bar arrangement in a combo chart. The following are valid values in this structure:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CLUSTERED</code>: For clustered bar combo charts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STACKED</code>: For stacked bar combo charts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STACKED_PERCENT</code>: Do not use. If you use this value, the operation returns a validation
         *        error.
         *        </p>
         *        </li>
         * @see BarsArrangement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BarsArrangement
         */
        Builder barsArrangement(BarsArrangement barsArrangement);

        /**
         * <p>
         * The category axis of a combo chart.
         * </p>
         * 
         * @param categoryAxis
         *        The category axis of a combo chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryAxis(AxisDisplayOptions categoryAxis);

        /**
         * <p>
         * The category axis of a combo chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisDisplayOptions.Builder} avoiding the
         * need to create one manually via {@link AxisDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisDisplayOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #categoryAxis(AxisDisplayOptions)}.
         * 
         * @param categoryAxis
         *        a consumer that will call methods on {@link AxisDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoryAxis(AxisDisplayOptions)
         */
        default Builder categoryAxis(Consumer<AxisDisplayOptions.Builder> categoryAxis) {
            return categoryAxis(AxisDisplayOptions.builder().applyMutation(categoryAxis).build());
        }

        /**
         * <p>
         * The label options (label text, label visibility, and sort icon visibility) of a combo chart category
         * (group/color) field well.
         * </p>
         * 
         * @param categoryLabelOptions
         *        The label options (label text, label visibility, and sort icon visibility) of a combo chart category
         *        (group/color) field well.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryLabelOptions(ChartAxisLabelOptions categoryLabelOptions);

        /**
         * <p>
         * The label options (label text, label visibility, and sort icon visibility) of a combo chart category
         * (group/color) field well.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #categoryLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param categoryLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoryLabelOptions(ChartAxisLabelOptions)
         */
        default Builder categoryLabelOptions(Consumer<ChartAxisLabelOptions.Builder> categoryLabelOptions) {
            return categoryLabelOptions(ChartAxisLabelOptions.builder().applyMutation(categoryLabelOptions).build());
        }

        /**
         * <p>
         * The label display options (grid line, range, scale, and axis step) of a combo chart's primary y-axis (bar)
         * field well.
         * </p>
         * 
         * @param primaryYAxisDisplayOptions
         *        The label display options (grid line, range, scale, and axis step) of a combo chart's primary y-axis
         *        (bar) field well.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryYAxisDisplayOptions(AxisDisplayOptions primaryYAxisDisplayOptions);

        /**
         * <p>
         * The label display options (grid line, range, scale, and axis step) of a combo chart's primary y-axis (bar)
         * field well.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisDisplayOptions.Builder} avoiding the
         * need to create one manually via {@link AxisDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisDisplayOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #primaryYAxisDisplayOptions(AxisDisplayOptions)}.
         * 
         * @param primaryYAxisDisplayOptions
         *        a consumer that will call methods on {@link AxisDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryYAxisDisplayOptions(AxisDisplayOptions)
         */
        default Builder primaryYAxisDisplayOptions(Consumer<AxisDisplayOptions.Builder> primaryYAxisDisplayOptions) {
            return primaryYAxisDisplayOptions(AxisDisplayOptions.builder().applyMutation(primaryYAxisDisplayOptions).build());
        }

        /**
         * <p>
         * The label options (label text, label visibility, and sort icon visibility) of a combo chart's primary y-axis
         * (bar) field well.
         * </p>
         * 
         * @param primaryYAxisLabelOptions
         *        The label options (label text, label visibility, and sort icon visibility) of a combo chart's primary
         *        y-axis (bar) field well.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryYAxisLabelOptions(ChartAxisLabelOptions primaryYAxisLabelOptions);

        /**
         * <p>
         * The label options (label text, label visibility, and sort icon visibility) of a combo chart's primary y-axis
         * (bar) field well.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #primaryYAxisLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param primaryYAxisLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryYAxisLabelOptions(ChartAxisLabelOptions)
         */
        default Builder primaryYAxisLabelOptions(Consumer<ChartAxisLabelOptions.Builder> primaryYAxisLabelOptions) {
            return primaryYAxisLabelOptions(ChartAxisLabelOptions.builder().applyMutation(primaryYAxisLabelOptions).build());
        }

        /**
         * <p>
         * The label display options (grid line, range, scale, axis step) of a combo chart's secondary y-axis (line)
         * field well.
         * </p>
         * 
         * @param secondaryYAxisDisplayOptions
         *        The label display options (grid line, range, scale, axis step) of a combo chart's secondary y-axis
         *        (line) field well.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryYAxisDisplayOptions(AxisDisplayOptions secondaryYAxisDisplayOptions);

        /**
         * <p>
         * The label display options (grid line, range, scale, axis step) of a combo chart's secondary y-axis (line)
         * field well.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisDisplayOptions.Builder} avoiding the
         * need to create one manually via {@link AxisDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisDisplayOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #secondaryYAxisDisplayOptions(AxisDisplayOptions)}.
         * 
         * @param secondaryYAxisDisplayOptions
         *        a consumer that will call methods on {@link AxisDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondaryYAxisDisplayOptions(AxisDisplayOptions)
         */
        default Builder secondaryYAxisDisplayOptions(Consumer<AxisDisplayOptions.Builder> secondaryYAxisDisplayOptions) {
            return secondaryYAxisDisplayOptions(AxisDisplayOptions.builder().applyMutation(secondaryYAxisDisplayOptions).build());
        }

        /**
         * <p>
         * The label options (label text, label visibility, and sort icon visibility) of a combo chart's secondary
         * y-axis(line) field well.
         * </p>
         * 
         * @param secondaryYAxisLabelOptions
         *        The label options (label text, label visibility, and sort icon visibility) of a combo chart's
         *        secondary y-axis(line) field well.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryYAxisLabelOptions(ChartAxisLabelOptions secondaryYAxisLabelOptions);

        /**
         * <p>
         * The label options (label text, label visibility, and sort icon visibility) of a combo chart's secondary
         * y-axis(line) field well.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #secondaryYAxisLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param secondaryYAxisLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondaryYAxisLabelOptions(ChartAxisLabelOptions)
         */
        default Builder secondaryYAxisLabelOptions(Consumer<ChartAxisLabelOptions.Builder> secondaryYAxisLabelOptions) {
            return secondaryYAxisLabelOptions(ChartAxisLabelOptions.builder().applyMutation(secondaryYAxisLabelOptions).build());
        }

        /**
         * Sets the value of the SingleAxisOptions property for this object.
         *
         * @param singleAxisOptions
         *        The new value for the SingleAxisOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleAxisOptions(SingleAxisOptions singleAxisOptions);

        /**
         * Sets the value of the SingleAxisOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SingleAxisOptions.Builder} avoiding the
         * need to create one manually via {@link SingleAxisOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SingleAxisOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #singleAxisOptions(SingleAxisOptions)}.
         * 
         * @param singleAxisOptions
         *        a consumer that will call methods on {@link SingleAxisOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #singleAxisOptions(SingleAxisOptions)
         */
        default Builder singleAxisOptions(Consumer<SingleAxisOptions.Builder> singleAxisOptions) {
            return singleAxisOptions(SingleAxisOptions.builder().applyMutation(singleAxisOptions).build());
        }

        /**
         * <p>
         * The label options (label text, label visibility, and sort icon visibility) of a combo chart's color field
         * well.
         * </p>
         * 
         * @param colorLabelOptions
         *        The label options (label text, label visibility, and sort icon visibility) of a combo chart's color
         *        field well.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colorLabelOptions(ChartAxisLabelOptions colorLabelOptions);

        /**
         * <p>
         * The label options (label text, label visibility, and sort icon visibility) of a combo chart's color field
         * well.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #colorLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param colorLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colorLabelOptions(ChartAxisLabelOptions)
         */
        default Builder colorLabelOptions(Consumer<ChartAxisLabelOptions.Builder> colorLabelOptions) {
            return colorLabelOptions(ChartAxisLabelOptions.builder().applyMutation(colorLabelOptions).build());
        }

        /**
         * <p>
         * The legend display setup of the visual.
         * </p>
         * 
         * @param legend
         *        The legend display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legend(LegendOptions legend);

        /**
         * <p>
         * The legend display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link LegendOptions.Builder} avoiding the need
         * to create one manually via {@link LegendOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LegendOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #legend(LegendOptions)}.
         * 
         * @param legend
         *        a consumer that will call methods on {@link LegendOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #legend(LegendOptions)
         */
        default Builder legend(Consumer<LegendOptions.Builder> legend) {
            return legend(LegendOptions.builder().applyMutation(legend).build());
        }

        /**
         * <p>
         * The options that determine if visual data labels are displayed.
         * </p>
         * <p>
         * The data label options for a bar in a combo chart.
         * </p>
         * 
         * @param barDataLabels
         *        The options that determine if visual data labels are displayed.</p>
         *        <p>
         *        The data label options for a bar in a combo chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder barDataLabels(DataLabelOptions barDataLabels);

        /**
         * <p>
         * The options that determine if visual data labels are displayed.
         * </p>
         * <p>
         * The data label options for a bar in a combo chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLabelOptions.Builder} avoiding the
         * need to create one manually via {@link DataLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLabelOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #barDataLabels(DataLabelOptions)}.
         * 
         * @param barDataLabels
         *        a consumer that will call methods on {@link DataLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #barDataLabels(DataLabelOptions)
         */
        default Builder barDataLabels(Consumer<DataLabelOptions.Builder> barDataLabels) {
            return barDataLabels(DataLabelOptions.builder().applyMutation(barDataLabels).build());
        }

        /**
         * <p>
         * The options that determine if visual data labels are displayed.
         * </p>
         * <p>
         * The data label options for a line in a combo chart.
         * </p>
         * 
         * @param lineDataLabels
         *        The options that determine if visual data labels are displayed.</p>
         *        <p>
         *        The data label options for a line in a combo chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineDataLabels(DataLabelOptions lineDataLabels);

        /**
         * <p>
         * The options that determine if visual data labels are displayed.
         * </p>
         * <p>
         * The data label options for a line in a combo chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLabelOptions.Builder} avoiding the
         * need to create one manually via {@link DataLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLabelOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #lineDataLabels(DataLabelOptions)}.
         * 
         * @param lineDataLabels
         *        a consumer that will call methods on {@link DataLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineDataLabels(DataLabelOptions)
         */
        default Builder lineDataLabels(Consumer<DataLabelOptions.Builder> lineDataLabels) {
            return lineDataLabels(DataLabelOptions.builder().applyMutation(lineDataLabels).build());
        }

        /**
         * <p>
         * The legend display setup of the visual.
         * </p>
         * 
         * @param tooltip
         *        The legend display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooltip(TooltipOptions tooltip);

        /**
         * <p>
         * The legend display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link TooltipOptions.Builder} avoiding the need
         * to create one manually via {@link TooltipOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TooltipOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #tooltip(TooltipOptions)}.
         * 
         * @param tooltip
         *        a consumer that will call methods on {@link TooltipOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tooltip(TooltipOptions)
         */
        default Builder tooltip(Consumer<TooltipOptions.Builder> tooltip) {
            return tooltip(TooltipOptions.builder().applyMutation(tooltip).build());
        }

        /**
         * <p>
         * The reference line setup of the visual.
         * </p>
         * 
         * @param referenceLines
         *        The reference line setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceLines(Collection<ReferenceLine> referenceLines);

        /**
         * <p>
         * The reference line setup of the visual.
         * </p>
         * 
         * @param referenceLines
         *        The reference line setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceLines(ReferenceLine... referenceLines);

        /**
         * <p>
         * The reference line setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ReferenceLine.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.ReferenceLine#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ReferenceLine.Builder#build()} is called immediately
         * and its result is passed to {@link #referenceLines(List<ReferenceLine>)}.
         * 
         * @param referenceLines
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ReferenceLine.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #referenceLines(java.util.Collection<ReferenceLine>)
         */
        Builder referenceLines(Consumer<ReferenceLine.Builder>... referenceLines);

        /**
         * <p>
         * The palette (chart color) display setup of the visual.
         * </p>
         * 
         * @param visualPalette
         *        The palette (chart color) display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualPalette(VisualPalette visualPalette);

        /**
         * <p>
         * The palette (chart color) display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualPalette.Builder} avoiding the need
         * to create one manually via {@link VisualPalette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualPalette.Builder#build()} is called immediately and its
         * result is passed to {@link #visualPalette(VisualPalette)}.
         * 
         * @param visualPalette
         *        a consumer that will call methods on {@link VisualPalette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visualPalette(VisualPalette)
         */
        default Builder visualPalette(Consumer<VisualPalette.Builder> visualPalette) {
            return visualPalette(VisualPalette.builder().applyMutation(visualPalette).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ComboChartFieldWells fieldWells;

        private ComboChartSortConfiguration sortConfiguration;

        private String barsArrangement;

        private AxisDisplayOptions categoryAxis;

        private ChartAxisLabelOptions categoryLabelOptions;

        private AxisDisplayOptions primaryYAxisDisplayOptions;

        private ChartAxisLabelOptions primaryYAxisLabelOptions;

        private AxisDisplayOptions secondaryYAxisDisplayOptions;

        private ChartAxisLabelOptions secondaryYAxisLabelOptions;

        private SingleAxisOptions singleAxisOptions;

        private ChartAxisLabelOptions colorLabelOptions;

        private LegendOptions legend;

        private DataLabelOptions barDataLabels;

        private DataLabelOptions lineDataLabels;

        private TooltipOptions tooltip;

        private List<ReferenceLine> referenceLines = DefaultSdkAutoConstructList.getInstance();

        private VisualPalette visualPalette;

        private BuilderImpl() {
        }

        private BuilderImpl(ComboChartConfiguration model) {
            fieldWells(model.fieldWells);
            sortConfiguration(model.sortConfiguration);
            barsArrangement(model.barsArrangement);
            categoryAxis(model.categoryAxis);
            categoryLabelOptions(model.categoryLabelOptions);
            primaryYAxisDisplayOptions(model.primaryYAxisDisplayOptions);
            primaryYAxisLabelOptions(model.primaryYAxisLabelOptions);
            secondaryYAxisDisplayOptions(model.secondaryYAxisDisplayOptions);
            secondaryYAxisLabelOptions(model.secondaryYAxisLabelOptions);
            singleAxisOptions(model.singleAxisOptions);
            colorLabelOptions(model.colorLabelOptions);
            legend(model.legend);
            barDataLabels(model.barDataLabels);
            lineDataLabels(model.lineDataLabels);
            tooltip(model.tooltip);
            referenceLines(model.referenceLines);
            visualPalette(model.visualPalette);
        }

        public final ComboChartFieldWells.Builder getFieldWells() {
            return fieldWells != null ? fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(ComboChartFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(ComboChartFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final ComboChartSortConfiguration.Builder getSortConfiguration() {
            return sortConfiguration != null ? sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(ComboChartSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(ComboChartSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final String getBarsArrangement() {
            return barsArrangement;
        }

        public final void setBarsArrangement(String barsArrangement) {
            this.barsArrangement = barsArrangement;
        }

        @Override
        public final Builder barsArrangement(String barsArrangement) {
            this.barsArrangement = barsArrangement;
            return this;
        }

        @Override
        public final Builder barsArrangement(BarsArrangement barsArrangement) {
            this.barsArrangement(barsArrangement == null ? null : barsArrangement.toString());
            return this;
        }

        public final AxisDisplayOptions.Builder getCategoryAxis() {
            return categoryAxis != null ? categoryAxis.toBuilder() : null;
        }

        public final void setCategoryAxis(AxisDisplayOptions.BuilderImpl categoryAxis) {
            this.categoryAxis = categoryAxis != null ? categoryAxis.build() : null;
        }

        @Override
        public final Builder categoryAxis(AxisDisplayOptions categoryAxis) {
            this.categoryAxis = categoryAxis;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getCategoryLabelOptions() {
            return categoryLabelOptions != null ? categoryLabelOptions.toBuilder() : null;
        }

        public final void setCategoryLabelOptions(ChartAxisLabelOptions.BuilderImpl categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions != null ? categoryLabelOptions.build() : null;
        }

        @Override
        public final Builder categoryLabelOptions(ChartAxisLabelOptions categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions;
            return this;
        }

        public final AxisDisplayOptions.Builder getPrimaryYAxisDisplayOptions() {
            return primaryYAxisDisplayOptions != null ? primaryYAxisDisplayOptions.toBuilder() : null;
        }

        public final void setPrimaryYAxisDisplayOptions(AxisDisplayOptions.BuilderImpl primaryYAxisDisplayOptions) {
            this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions != null ? primaryYAxisDisplayOptions.build() : null;
        }

        @Override
        public final Builder primaryYAxisDisplayOptions(AxisDisplayOptions primaryYAxisDisplayOptions) {
            this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getPrimaryYAxisLabelOptions() {
            return primaryYAxisLabelOptions != null ? primaryYAxisLabelOptions.toBuilder() : null;
        }

        public final void setPrimaryYAxisLabelOptions(ChartAxisLabelOptions.BuilderImpl primaryYAxisLabelOptions) {
            this.primaryYAxisLabelOptions = primaryYAxisLabelOptions != null ? primaryYAxisLabelOptions.build() : null;
        }

        @Override
        public final Builder primaryYAxisLabelOptions(ChartAxisLabelOptions primaryYAxisLabelOptions) {
            this.primaryYAxisLabelOptions = primaryYAxisLabelOptions;
            return this;
        }

        public final AxisDisplayOptions.Builder getSecondaryYAxisDisplayOptions() {
            return secondaryYAxisDisplayOptions != null ? secondaryYAxisDisplayOptions.toBuilder() : null;
        }

        public final void setSecondaryYAxisDisplayOptions(AxisDisplayOptions.BuilderImpl secondaryYAxisDisplayOptions) {
            this.secondaryYAxisDisplayOptions = secondaryYAxisDisplayOptions != null ? secondaryYAxisDisplayOptions.build()
                    : null;
        }

        @Override
        public final Builder secondaryYAxisDisplayOptions(AxisDisplayOptions secondaryYAxisDisplayOptions) {
            this.secondaryYAxisDisplayOptions = secondaryYAxisDisplayOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getSecondaryYAxisLabelOptions() {
            return secondaryYAxisLabelOptions != null ? secondaryYAxisLabelOptions.toBuilder() : null;
        }

        public final void setSecondaryYAxisLabelOptions(ChartAxisLabelOptions.BuilderImpl secondaryYAxisLabelOptions) {
            this.secondaryYAxisLabelOptions = secondaryYAxisLabelOptions != null ? secondaryYAxisLabelOptions.build() : null;
        }

        @Override
        public final Builder secondaryYAxisLabelOptions(ChartAxisLabelOptions secondaryYAxisLabelOptions) {
            this.secondaryYAxisLabelOptions = secondaryYAxisLabelOptions;
            return this;
        }

        public final SingleAxisOptions.Builder getSingleAxisOptions() {
            return singleAxisOptions != null ? singleAxisOptions.toBuilder() : null;
        }

        public final void setSingleAxisOptions(SingleAxisOptions.BuilderImpl singleAxisOptions) {
            this.singleAxisOptions = singleAxisOptions != null ? singleAxisOptions.build() : null;
        }

        @Override
        public final Builder singleAxisOptions(SingleAxisOptions singleAxisOptions) {
            this.singleAxisOptions = singleAxisOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getColorLabelOptions() {
            return colorLabelOptions != null ? colorLabelOptions.toBuilder() : null;
        }

        public final void setColorLabelOptions(ChartAxisLabelOptions.BuilderImpl colorLabelOptions) {
            this.colorLabelOptions = colorLabelOptions != null ? colorLabelOptions.build() : null;
        }

        @Override
        public final Builder colorLabelOptions(ChartAxisLabelOptions colorLabelOptions) {
            this.colorLabelOptions = colorLabelOptions;
            return this;
        }

        public final LegendOptions.Builder getLegend() {
            return legend != null ? legend.toBuilder() : null;
        }

        public final void setLegend(LegendOptions.BuilderImpl legend) {
            this.legend = legend != null ? legend.build() : null;
        }

        @Override
        public final Builder legend(LegendOptions legend) {
            this.legend = legend;
            return this;
        }

        public final DataLabelOptions.Builder getBarDataLabels() {
            return barDataLabels != null ? barDataLabels.toBuilder() : null;
        }

        public final void setBarDataLabels(DataLabelOptions.BuilderImpl barDataLabels) {
            this.barDataLabels = barDataLabels != null ? barDataLabels.build() : null;
        }

        @Override
        public final Builder barDataLabels(DataLabelOptions barDataLabels) {
            this.barDataLabels = barDataLabels;
            return this;
        }

        public final DataLabelOptions.Builder getLineDataLabels() {
            return lineDataLabels != null ? lineDataLabels.toBuilder() : null;
        }

        public final void setLineDataLabels(DataLabelOptions.BuilderImpl lineDataLabels) {
            this.lineDataLabels = lineDataLabels != null ? lineDataLabels.build() : null;
        }

        @Override
        public final Builder lineDataLabels(DataLabelOptions lineDataLabels) {
            this.lineDataLabels = lineDataLabels;
            return this;
        }

        public final TooltipOptions.Builder getTooltip() {
            return tooltip != null ? tooltip.toBuilder() : null;
        }

        public final void setTooltip(TooltipOptions.BuilderImpl tooltip) {
            this.tooltip = tooltip != null ? tooltip.build() : null;
        }

        @Override
        public final Builder tooltip(TooltipOptions tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public final List<ReferenceLine.Builder> getReferenceLines() {
            List<ReferenceLine.Builder> result = ReferenceLineListCopier.copyToBuilder(this.referenceLines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferenceLines(Collection<ReferenceLine.BuilderImpl> referenceLines) {
            this.referenceLines = ReferenceLineListCopier.copyFromBuilder(referenceLines);
        }

        @Override
        public final Builder referenceLines(Collection<ReferenceLine> referenceLines) {
            this.referenceLines = ReferenceLineListCopier.copy(referenceLines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceLines(ReferenceLine... referenceLines) {
            referenceLines(Arrays.asList(referenceLines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceLines(Consumer<ReferenceLine.Builder>... referenceLines) {
            referenceLines(Stream.of(referenceLines).map(c -> ReferenceLine.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final VisualPalette.Builder getVisualPalette() {
            return visualPalette != null ? visualPalette.toBuilder() : null;
        }

        public final void setVisualPalette(VisualPalette.BuilderImpl visualPalette) {
            this.visualPalette = visualPalette != null ? visualPalette.build() : null;
        }

        @Override
        public final Builder visualPalette(VisualPalette visualPalette) {
            this.visualPalette = visualPalette;
            return this;
        }

        @Override
        public ComboChartConfiguration build() {
            return new ComboChartConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
