/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains a list of permissions to be applied to a list of analysis IDs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetBundleImportJobAnalysisOverridePermissions
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AssetBundleImportJobAnalysisOverridePermissions.Builder, AssetBundleImportJobAnalysisOverridePermissions> {
    private static final SdkField<List<String>> ANALYSIS_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AnalysisIds")
            .getter(getter(AssetBundleImportJobAnalysisOverridePermissions::analysisIds))
            .setter(setter(Builder::analysisIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AssetBundleResourcePermissions> PERMISSIONS_FIELD = SdkField
            .<AssetBundleResourcePermissions> builder(MarshallingType.SDK_POJO).memberName("Permissions")
            .getter(getter(AssetBundleImportJobAnalysisOverridePermissions::permissions)).setter(setter(Builder::permissions))
            .constructor(AssetBundleResourcePermissions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_IDS_FIELD,
            PERMISSIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> analysisIds;

    private final AssetBundleResourcePermissions permissions;

    private AssetBundleImportJobAnalysisOverridePermissions(BuilderImpl builder) {
        this.analysisIds = builder.analysisIds;
        this.permissions = builder.permissions;
    }

    /**
     * For responses, this returns true if the service returned a value for the AnalysisIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnalysisIds() {
        return analysisIds != null && !(analysisIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of analysis IDs that you want to apply overrides to. You can use <code>*</code> to override all analyses
     * in this asset bundle.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnalysisIds} method.
     * </p>
     * 
     * @return A list of analysis IDs that you want to apply overrides to. You can use <code>*</code> to override all
     *         analyses in this asset bundle.
     */
    public final List<String> analysisIds() {
        return analysisIds;
    }

    /**
     * <p>
     * A list of permissions for the analyses that you want to apply overrides to.
     * </p>
     * 
     * @return A list of permissions for the analyses that you want to apply overrides to.
     */
    public final AssetBundleResourcePermissions permissions() {
        return permissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAnalysisIds() ? analysisIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(permissions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobAnalysisOverridePermissions)) {
            return false;
        }
        AssetBundleImportJobAnalysisOverridePermissions other = (AssetBundleImportJobAnalysisOverridePermissions) obj;
        return hasAnalysisIds() == other.hasAnalysisIds() && Objects.equals(analysisIds(), other.analysisIds())
                && Objects.equals(permissions(), other.permissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetBundleImportJobAnalysisOverridePermissions")
                .add("AnalysisIds", hasAnalysisIds() ? analysisIds() : null).add("Permissions", permissions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnalysisIds":
            return Optional.ofNullable(clazz.cast(analysisIds()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobAnalysisOverridePermissions, T> g) {
        return obj -> g.apply((AssetBundleImportJobAnalysisOverridePermissions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetBundleImportJobAnalysisOverridePermissions> {
        /**
         * <p>
         * A list of analysis IDs that you want to apply overrides to. You can use <code>*</code> to override all
         * analyses in this asset bundle.
         * </p>
         * 
         * @param analysisIds
         *        A list of analysis IDs that you want to apply overrides to. You can use <code>*</code> to override all
         *        analyses in this asset bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisIds(Collection<String> analysisIds);

        /**
         * <p>
         * A list of analysis IDs that you want to apply overrides to. You can use <code>*</code> to override all
         * analyses in this asset bundle.
         * </p>
         * 
         * @param analysisIds
         *        A list of analysis IDs that you want to apply overrides to. You can use <code>*</code> to override all
         *        analyses in this asset bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisIds(String... analysisIds);

        /**
         * <p>
         * A list of permissions for the analyses that you want to apply overrides to.
         * </p>
         * 
         * @param permissions
         *        A list of permissions for the analyses that you want to apply overrides to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(AssetBundleResourcePermissions permissions);

        /**
         * <p>
         * A list of permissions for the analyses that you want to apply overrides to.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetBundleResourcePermissions.Builder}
         * avoiding the need to create one manually via {@link AssetBundleResourcePermissions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetBundleResourcePermissions.Builder#build()} is called
         * immediately and its result is passed to {@link #permissions(AssetBundleResourcePermissions)}.
         * 
         * @param permissions
         *        a consumer that will call methods on {@link AssetBundleResourcePermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(AssetBundleResourcePermissions)
         */
        default Builder permissions(Consumer<AssetBundleResourcePermissions.Builder> permissions) {
            return permissions(AssetBundleResourcePermissions.builder().applyMutation(permissions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> analysisIds = DefaultSdkAutoConstructList.getInstance();

        private AssetBundleResourcePermissions permissions;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobAnalysisOverridePermissions model) {
            analysisIds(model.analysisIds);
            permissions(model.permissions);
        }

        public final Collection<String> getAnalysisIds() {
            if (analysisIds instanceof SdkAutoConstructList) {
                return null;
            }
            return analysisIds;
        }

        public final void setAnalysisIds(Collection<String> analysisIds) {
            this.analysisIds = AssetBundleRestrictiveResourceIdListCopier.copy(analysisIds);
        }

        @Override
        public final Builder analysisIds(Collection<String> analysisIds) {
            this.analysisIds = AssetBundleRestrictiveResourceIdListCopier.copy(analysisIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisIds(String... analysisIds) {
            analysisIds(Arrays.asList(analysisIds));
            return this;
        }

        public final AssetBundleResourcePermissions.Builder getPermissions() {
            return permissions != null ? permissions.toBuilder() : null;
        }

        public final void setPermissions(AssetBundleResourcePermissions.BuilderImpl permissions) {
            this.permissions = permissions != null ? permissions.build() : null;
        }

        @Override
        public final Builder permissions(AssetBundleResourcePermissions permissions) {
            this.permissions = permissions;
            return this;
        }

        @Override
        public AssetBundleImportJobAnalysisOverridePermissions build() {
            return new AssetBundleImportJobAnalysisOverridePermissions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
