/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An optional collection of CloudFormation property configurations that control how the export job is generated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetBundleCloudFormationOverridePropertyConfiguration
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AssetBundleCloudFormationOverridePropertyConfiguration.Builder, AssetBundleCloudFormationOverridePropertyConfiguration> {
    private static final SdkField<AssetBundleExportJobResourceIdOverrideConfiguration> RESOURCE_ID_OVERRIDE_CONFIGURATION_FIELD = SdkField
            .<AssetBundleExportJobResourceIdOverrideConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ResourceIdOverrideConfiguration")
            .getter(getter(AssetBundleCloudFormationOverridePropertyConfiguration::resourceIdOverrideConfiguration))
            .setter(setter(Builder::resourceIdOverrideConfiguration))
            .constructor(AssetBundleExportJobResourceIdOverrideConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdOverrideConfiguration")
                    .build()).build();

    private static final SdkField<List<AssetBundleExportJobVPCConnectionOverrideProperties>> VPC_CONNECTIONS_FIELD = SdkField
            .<List<AssetBundleExportJobVPCConnectionOverrideProperties>> builder(MarshallingType.LIST)
            .memberName("VPCConnections")
            .getter(getter(AssetBundleCloudFormationOverridePropertyConfiguration::vpcConnections))
            .setter(setter(Builder::vpcConnections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCConnections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleExportJobVPCConnectionOverrideProperties> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleExportJobVPCConnectionOverrideProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleExportJobRefreshScheduleOverrideProperties>> REFRESH_SCHEDULES_FIELD = SdkField
            .<List<AssetBundleExportJobRefreshScheduleOverrideProperties>> builder(MarshallingType.LIST)
            .memberName("RefreshSchedules")
            .getter(getter(AssetBundleCloudFormationOverridePropertyConfiguration::refreshSchedules))
            .setter(setter(Builder::refreshSchedules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshSchedules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleExportJobRefreshScheduleOverrideProperties> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleExportJobRefreshScheduleOverrideProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleExportJobDataSourceOverrideProperties>> DATA_SOURCES_FIELD = SdkField
            .<List<AssetBundleExportJobDataSourceOverrideProperties>> builder(MarshallingType.LIST)
            .memberName("DataSources")
            .getter(getter(AssetBundleCloudFormationOverridePropertyConfiguration::dataSources))
            .setter(setter(Builder::dataSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleExportJobDataSourceOverrideProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleExportJobDataSourceOverrideProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleExportJobDataSetOverrideProperties>> DATA_SETS_FIELD = SdkField
            .<List<AssetBundleExportJobDataSetOverrideProperties>> builder(MarshallingType.LIST)
            .memberName("DataSets")
            .getter(getter(AssetBundleCloudFormationOverridePropertyConfiguration::dataSets))
            .setter(setter(Builder::dataSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleExportJobDataSetOverrideProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleExportJobDataSetOverrideProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleExportJobThemeOverrideProperties>> THEMES_FIELD = SdkField
            .<List<AssetBundleExportJobThemeOverrideProperties>> builder(MarshallingType.LIST)
            .memberName("Themes")
            .getter(getter(AssetBundleCloudFormationOverridePropertyConfiguration::themes))
            .setter(setter(Builder::themes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Themes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleExportJobThemeOverrideProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleExportJobThemeOverrideProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleExportJobAnalysisOverrideProperties>> ANALYSES_FIELD = SdkField
            .<List<AssetBundleExportJobAnalysisOverrideProperties>> builder(MarshallingType.LIST)
            .memberName("Analyses")
            .getter(getter(AssetBundleCloudFormationOverridePropertyConfiguration::analyses))
            .setter(setter(Builder::analyses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Analyses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleExportJobAnalysisOverrideProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleExportJobAnalysisOverrideProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleExportJobDashboardOverrideProperties>> DASHBOARDS_FIELD = SdkField
            .<List<AssetBundleExportJobDashboardOverrideProperties>> builder(MarshallingType.LIST)
            .memberName("Dashboards")
            .getter(getter(AssetBundleCloudFormationOverridePropertyConfiguration::dashboards))
            .setter(setter(Builder::dashboards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dashboards").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleExportJobDashboardOverrideProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleExportJobDashboardOverrideProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESOURCE_ID_OVERRIDE_CONFIGURATION_FIELD, VPC_CONNECTIONS_FIELD, REFRESH_SCHEDULES_FIELD, DATA_SOURCES_FIELD,
            DATA_SETS_FIELD, THEMES_FIELD, ANALYSES_FIELD, DASHBOARDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AssetBundleExportJobResourceIdOverrideConfiguration resourceIdOverrideConfiguration;

    private final List<AssetBundleExportJobVPCConnectionOverrideProperties> vpcConnections;

    private final List<AssetBundleExportJobRefreshScheduleOverrideProperties> refreshSchedules;

    private final List<AssetBundleExportJobDataSourceOverrideProperties> dataSources;

    private final List<AssetBundleExportJobDataSetOverrideProperties> dataSets;

    private final List<AssetBundleExportJobThemeOverrideProperties> themes;

    private final List<AssetBundleExportJobAnalysisOverrideProperties> analyses;

    private final List<AssetBundleExportJobDashboardOverrideProperties> dashboards;

    private AssetBundleCloudFormationOverridePropertyConfiguration(BuilderImpl builder) {
        this.resourceIdOverrideConfiguration = builder.resourceIdOverrideConfiguration;
        this.vpcConnections = builder.vpcConnections;
        this.refreshSchedules = builder.refreshSchedules;
        this.dataSources = builder.dataSources;
        this.dataSets = builder.dataSets;
        this.themes = builder.themes;
        this.analyses = builder.analyses;
        this.dashboards = builder.dashboards;
    }

    /**
     * <p>
     * An optional list of structures that control how resource IDs are parameterized in the returned CloudFormation
     * template.
     * </p>
     * 
     * @return An optional list of structures that control how resource IDs are parameterized in the returned
     *         CloudFormation template.
     */
    public final AssetBundleExportJobResourceIdOverrideConfiguration resourceIdOverrideConfiguration() {
        return resourceIdOverrideConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the VPCConnections property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcConnections() {
        return vpcConnections != null && !(vpcConnections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional list of structures that control how <code>VPCConnection</code> resources are parameterized in the
     * returned CloudFormation template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcConnections} method.
     * </p>
     * 
     * @return An optional list of structures that control how <code>VPCConnection</code> resources are parameterized in
     *         the returned CloudFormation template.
     */
    public final List<AssetBundleExportJobVPCConnectionOverrideProperties> vpcConnections() {
        return vpcConnections;
    }

    /**
     * For responses, this returns true if the service returned a value for the RefreshSchedules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRefreshSchedules() {
        return refreshSchedules != null && !(refreshSchedules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional list of structures that control how <code>RefreshSchedule</code> resources are parameterized in the
     * returned CloudFormation template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRefreshSchedules} method.
     * </p>
     * 
     * @return An optional list of structures that control how <code>RefreshSchedule</code> resources are parameterized
     *         in the returned CloudFormation template.
     */
    public final List<AssetBundleExportJobRefreshScheduleOverrideProperties> refreshSchedules() {
        return refreshSchedules;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataSources() {
        return dataSources != null && !(dataSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional list of structures that control how <code>DataSource</code> resources are parameterized in the
     * returned CloudFormation template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSources} method.
     * </p>
     * 
     * @return An optional list of structures that control how <code>DataSource</code> resources are parameterized in
     *         the returned CloudFormation template.
     */
    public final List<AssetBundleExportJobDataSourceOverrideProperties> dataSources() {
        return dataSources;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDataSets() {
        return dataSets != null && !(dataSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional list of structures that control how <code>DataSet</code> resources are parameterized in the returned
     * CloudFormation template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSets} method.
     * </p>
     * 
     * @return An optional list of structures that control how <code>DataSet</code> resources are parameterized in the
     *         returned CloudFormation template.
     */
    public final List<AssetBundleExportJobDataSetOverrideProperties> dataSets() {
        return dataSets;
    }

    /**
     * For responses, this returns true if the service returned a value for the Themes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasThemes() {
        return themes != null && !(themes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional list of structures that control how <code>Theme</code> resources are parameterized in the returned
     * CloudFormation template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThemes} method.
     * </p>
     * 
     * @return An optional list of structures that control how <code>Theme</code> resources are parameterized in the
     *         returned CloudFormation template.
     */
    public final List<AssetBundleExportJobThemeOverrideProperties> themes() {
        return themes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Analyses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAnalyses() {
        return analyses != null && !(analyses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional list of structures that control how <code>Analysis</code> resources are parameterized in the returned
     * CloudFormation template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnalyses} method.
     * </p>
     * 
     * @return An optional list of structures that control how <code>Analysis</code> resources are parameterized in the
     *         returned CloudFormation template.
     */
    public final List<AssetBundleExportJobAnalysisOverrideProperties> analyses() {
        return analyses;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dashboards property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDashboards() {
        return dashboards != null && !(dashboards instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional list of structures that control how <code>Dashboard</code> resources are parameterized in the
     * returned CloudFormation template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDashboards} method.
     * </p>
     * 
     * @return An optional list of structures that control how <code>Dashboard</code> resources are parameterized in the
     *         returned CloudFormation template.
     */
    public final List<AssetBundleExportJobDashboardOverrideProperties> dashboards() {
        return dashboards;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdOverrideConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcConnections() ? vpcConnections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRefreshSchedules() ? refreshSchedules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSources() ? dataSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSets() ? dataSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasThemes() ? themes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAnalyses() ? analyses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDashboards() ? dashboards() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleCloudFormationOverridePropertyConfiguration)) {
            return false;
        }
        AssetBundleCloudFormationOverridePropertyConfiguration other = (AssetBundleCloudFormationOverridePropertyConfiguration) obj;
        return Objects.equals(resourceIdOverrideConfiguration(), other.resourceIdOverrideConfiguration())
                && hasVpcConnections() == other.hasVpcConnections() && Objects.equals(vpcConnections(), other.vpcConnections())
                && hasRefreshSchedules() == other.hasRefreshSchedules()
                && Objects.equals(refreshSchedules(), other.refreshSchedules()) && hasDataSources() == other.hasDataSources()
                && Objects.equals(dataSources(), other.dataSources()) && hasDataSets() == other.hasDataSets()
                && Objects.equals(dataSets(), other.dataSets()) && hasThemes() == other.hasThemes()
                && Objects.equals(themes(), other.themes()) && hasAnalyses() == other.hasAnalyses()
                && Objects.equals(analyses(), other.analyses()) && hasDashboards() == other.hasDashboards()
                && Objects.equals(dashboards(), other.dashboards());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetBundleCloudFormationOverridePropertyConfiguration")
                .add("ResourceIdOverrideConfiguration", resourceIdOverrideConfiguration())
                .add("VPCConnections", hasVpcConnections() ? vpcConnections() : null)
                .add("RefreshSchedules", hasRefreshSchedules() ? refreshSchedules() : null)
                .add("DataSources", hasDataSources() ? dataSources() : null).add("DataSets", hasDataSets() ? dataSets() : null)
                .add("Themes", hasThemes() ? themes() : null).add("Analyses", hasAnalyses() ? analyses() : null)
                .add("Dashboards", hasDashboards() ? dashboards() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceIdOverrideConfiguration":
            return Optional.ofNullable(clazz.cast(resourceIdOverrideConfiguration()));
        case "VPCConnections":
            return Optional.ofNullable(clazz.cast(vpcConnections()));
        case "RefreshSchedules":
            return Optional.ofNullable(clazz.cast(refreshSchedules()));
        case "DataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        case "DataSets":
            return Optional.ofNullable(clazz.cast(dataSets()));
        case "Themes":
            return Optional.ofNullable(clazz.cast(themes()));
        case "Analyses":
            return Optional.ofNullable(clazz.cast(analyses()));
        case "Dashboards":
            return Optional.ofNullable(clazz.cast(dashboards()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleCloudFormationOverridePropertyConfiguration, T> g) {
        return obj -> g.apply((AssetBundleCloudFormationOverridePropertyConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetBundleCloudFormationOverridePropertyConfiguration> {
        /**
         * <p>
         * An optional list of structures that control how resource IDs are parameterized in the returned CloudFormation
         * template.
         * </p>
         * 
         * @param resourceIdOverrideConfiguration
         *        An optional list of structures that control how resource IDs are parameterized in the returned
         *        CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdOverrideConfiguration(
                AssetBundleExportJobResourceIdOverrideConfiguration resourceIdOverrideConfiguration);

        /**
         * <p>
         * An optional list of structures that control how resource IDs are parameterized in the returned CloudFormation
         * template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AssetBundleExportJobResourceIdOverrideConfiguration.Builder} avoiding the need to create one manually
         * via {@link AssetBundleExportJobResourceIdOverrideConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AssetBundleExportJobResourceIdOverrideConfiguration.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #resourceIdOverrideConfiguration(AssetBundleExportJobResourceIdOverrideConfiguration)}.
         * 
         * @param resourceIdOverrideConfiguration
         *        a consumer that will call methods on
         *        {@link AssetBundleExportJobResourceIdOverrideConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceIdOverrideConfiguration(AssetBundleExportJobResourceIdOverrideConfiguration)
         */
        default Builder resourceIdOverrideConfiguration(
                Consumer<AssetBundleExportJobResourceIdOverrideConfiguration.Builder> resourceIdOverrideConfiguration) {
            return resourceIdOverrideConfiguration(AssetBundleExportJobResourceIdOverrideConfiguration.builder()
                    .applyMutation(resourceIdOverrideConfiguration).build());
        }

        /**
         * <p>
         * An optional list of structures that control how <code>VPCConnection</code> resources are parameterized in the
         * returned CloudFormation template.
         * </p>
         * 
         * @param vpcConnections
         *        An optional list of structures that control how <code>VPCConnection</code> resources are parameterized
         *        in the returned CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConnections(Collection<AssetBundleExportJobVPCConnectionOverrideProperties> vpcConnections);

        /**
         * <p>
         * An optional list of structures that control how <code>VPCConnection</code> resources are parameterized in the
         * returned CloudFormation template.
         * </p>
         * 
         * @param vpcConnections
         *        An optional list of structures that control how <code>VPCConnection</code> resources are parameterized
         *        in the returned CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConnections(AssetBundleExportJobVPCConnectionOverrideProperties... vpcConnections);

        /**
         * <p>
         * An optional list of structures that control how <code>VPCConnection</code> resources are parameterized in the
         * returned CloudFormation template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobVPCConnectionOverrideProperties.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobVPCConnectionOverrideProperties#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobVPCConnectionOverrideProperties.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #vpcConnections(List<AssetBundleExportJobVPCConnectionOverrideProperties>)}.
         * 
         * @param vpcConnections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobVPCConnectionOverrideProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConnections(java.util.Collection<AssetBundleExportJobVPCConnectionOverrideProperties>)
         */
        Builder vpcConnections(Consumer<AssetBundleExportJobVPCConnectionOverrideProperties.Builder>... vpcConnections);

        /**
         * <p>
         * An optional list of structures that control how <code>RefreshSchedule</code> resources are parameterized in
         * the returned CloudFormation template.
         * </p>
         * 
         * @param refreshSchedules
         *        An optional list of structures that control how <code>RefreshSchedule</code> resources are
         *        parameterized in the returned CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshSchedules(Collection<AssetBundleExportJobRefreshScheduleOverrideProperties> refreshSchedules);

        /**
         * <p>
         * An optional list of structures that control how <code>RefreshSchedule</code> resources are parameterized in
         * the returned CloudFormation template.
         * </p>
         * 
         * @param refreshSchedules
         *        An optional list of structures that control how <code>RefreshSchedule</code> resources are
         *        parameterized in the returned CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshSchedules(AssetBundleExportJobRefreshScheduleOverrideProperties... refreshSchedules);

        /**
         * <p>
         * An optional list of structures that control how <code>RefreshSchedule</code> resources are parameterized in
         * the returned CloudFormation template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobRefreshScheduleOverrideProperties.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobRefreshScheduleOverrideProperties#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobRefreshScheduleOverrideProperties.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #refreshSchedules(List<AssetBundleExportJobRefreshScheduleOverrideProperties>)}.
         * 
         * @param refreshSchedules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobRefreshScheduleOverrideProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #refreshSchedules(java.util.Collection<AssetBundleExportJobRefreshScheduleOverrideProperties>)
         */
        Builder refreshSchedules(Consumer<AssetBundleExportJobRefreshScheduleOverrideProperties.Builder>... refreshSchedules);

        /**
         * <p>
         * An optional list of structures that control how <code>DataSource</code> resources are parameterized in the
         * returned CloudFormation template.
         * </p>
         * 
         * @param dataSources
         *        An optional list of structures that control how <code>DataSource</code> resources are parameterized in
         *        the returned CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(Collection<AssetBundleExportJobDataSourceOverrideProperties> dataSources);

        /**
         * <p>
         * An optional list of structures that control how <code>DataSource</code> resources are parameterized in the
         * returned CloudFormation template.
         * </p>
         * 
         * @param dataSources
         *        An optional list of structures that control how <code>DataSource</code> resources are parameterized in
         *        the returned CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(AssetBundleExportJobDataSourceOverrideProperties... dataSources);

        /**
         * <p>
         * An optional list of structures that control how <code>DataSource</code> resources are parameterized in the
         * returned CloudFormation template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobDataSourceOverrideProperties.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobDataSourceOverrideProperties#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobDataSourceOverrideProperties.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #dataSources(List<AssetBundleExportJobDataSourceOverrideProperties>)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobDataSourceOverrideProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(java.util.Collection<AssetBundleExportJobDataSourceOverrideProperties>)
         */
        Builder dataSources(Consumer<AssetBundleExportJobDataSourceOverrideProperties.Builder>... dataSources);

        /**
         * <p>
         * An optional list of structures that control how <code>DataSet</code> resources are parameterized in the
         * returned CloudFormation template.
         * </p>
         * 
         * @param dataSets
         *        An optional list of structures that control how <code>DataSet</code> resources are parameterized in
         *        the returned CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSets(Collection<AssetBundleExportJobDataSetOverrideProperties> dataSets);

        /**
         * <p>
         * An optional list of structures that control how <code>DataSet</code> resources are parameterized in the
         * returned CloudFormation template.
         * </p>
         * 
         * @param dataSets
         *        An optional list of structures that control how <code>DataSet</code> resources are parameterized in
         *        the returned CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSets(AssetBundleExportJobDataSetOverrideProperties... dataSets);

        /**
         * <p>
         * An optional list of structures that control how <code>DataSet</code> resources are parameterized in the
         * returned CloudFormation template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobDataSetOverrideProperties.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobDataSetOverrideProperties#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobDataSetOverrideProperties.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #dataSets(List<AssetBundleExportJobDataSetOverrideProperties>)}.
         * 
         * @param dataSets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobDataSetOverrideProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSets(java.util.Collection<AssetBundleExportJobDataSetOverrideProperties>)
         */
        Builder dataSets(Consumer<AssetBundleExportJobDataSetOverrideProperties.Builder>... dataSets);

        /**
         * <p>
         * An optional list of structures that control how <code>Theme</code> resources are parameterized in the
         * returned CloudFormation template.
         * </p>
         * 
         * @param themes
         *        An optional list of structures that control how <code>Theme</code> resources are parameterized in the
         *        returned CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themes(Collection<AssetBundleExportJobThemeOverrideProperties> themes);

        /**
         * <p>
         * An optional list of structures that control how <code>Theme</code> resources are parameterized in the
         * returned CloudFormation template.
         * </p>
         * 
         * @param themes
         *        An optional list of structures that control how <code>Theme</code> resources are parameterized in the
         *        returned CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themes(AssetBundleExportJobThemeOverrideProperties... themes);

        /**
         * <p>
         * An optional list of structures that control how <code>Theme</code> resources are parameterized in the
         * returned CloudFormation template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobThemeOverrideProperties.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobThemeOverrideProperties#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobThemeOverrideProperties.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #themes(List<AssetBundleExportJobThemeOverrideProperties>)}.
         * 
         * @param themes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobThemeOverrideProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #themes(java.util.Collection<AssetBundleExportJobThemeOverrideProperties>)
         */
        Builder themes(Consumer<AssetBundleExportJobThemeOverrideProperties.Builder>... themes);

        /**
         * <p>
         * An optional list of structures that control how <code>Analysis</code> resources are parameterized in the
         * returned CloudFormation template.
         * </p>
         * 
         * @param analyses
         *        An optional list of structures that control how <code>Analysis</code> resources are parameterized in
         *        the returned CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyses(Collection<AssetBundleExportJobAnalysisOverrideProperties> analyses);

        /**
         * <p>
         * An optional list of structures that control how <code>Analysis</code> resources are parameterized in the
         * returned CloudFormation template.
         * </p>
         * 
         * @param analyses
         *        An optional list of structures that control how <code>Analysis</code> resources are parameterized in
         *        the returned CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyses(AssetBundleExportJobAnalysisOverrideProperties... analyses);

        /**
         * <p>
         * An optional list of structures that control how <code>Analysis</code> resources are parameterized in the
         * returned CloudFormation template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobAnalysisOverrideProperties.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobAnalysisOverrideProperties#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobAnalysisOverrideProperties.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #analyses(List<AssetBundleExportJobAnalysisOverrideProperties>)}.
         * 
         * @param analyses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobAnalysisOverrideProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analyses(java.util.Collection<AssetBundleExportJobAnalysisOverrideProperties>)
         */
        Builder analyses(Consumer<AssetBundleExportJobAnalysisOverrideProperties.Builder>... analyses);

        /**
         * <p>
         * An optional list of structures that control how <code>Dashboard</code> resources are parameterized in the
         * returned CloudFormation template.
         * </p>
         * 
         * @param dashboards
         *        An optional list of structures that control how <code>Dashboard</code> resources are parameterized in
         *        the returned CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboards(Collection<AssetBundleExportJobDashboardOverrideProperties> dashboards);

        /**
         * <p>
         * An optional list of structures that control how <code>Dashboard</code> resources are parameterized in the
         * returned CloudFormation template.
         * </p>
         * 
         * @param dashboards
         *        An optional list of structures that control how <code>Dashboard</code> resources are parameterized in
         *        the returned CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboards(AssetBundleExportJobDashboardOverrideProperties... dashboards);

        /**
         * <p>
         * An optional list of structures that control how <code>Dashboard</code> resources are parameterized in the
         * returned CloudFormation template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobDashboardOverrideProperties.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobDashboardOverrideProperties#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobDashboardOverrideProperties.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #dashboards(List<AssetBundleExportJobDashboardOverrideProperties>)}.
         * 
         * @param dashboards
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobDashboardOverrideProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashboards(java.util.Collection<AssetBundleExportJobDashboardOverrideProperties>)
         */
        Builder dashboards(Consumer<AssetBundleExportJobDashboardOverrideProperties.Builder>... dashboards);
    }

    static final class BuilderImpl implements Builder {
        private AssetBundleExportJobResourceIdOverrideConfiguration resourceIdOverrideConfiguration;

        private List<AssetBundleExportJobVPCConnectionOverrideProperties> vpcConnections = DefaultSdkAutoConstructList
                .getInstance();

        private List<AssetBundleExportJobRefreshScheduleOverrideProperties> refreshSchedules = DefaultSdkAutoConstructList
                .getInstance();

        private List<AssetBundleExportJobDataSourceOverrideProperties> dataSources = DefaultSdkAutoConstructList.getInstance();

        private List<AssetBundleExportJobDataSetOverrideProperties> dataSets = DefaultSdkAutoConstructList.getInstance();

        private List<AssetBundleExportJobThemeOverrideProperties> themes = DefaultSdkAutoConstructList.getInstance();

        private List<AssetBundleExportJobAnalysisOverrideProperties> analyses = DefaultSdkAutoConstructList.getInstance();

        private List<AssetBundleExportJobDashboardOverrideProperties> dashboards = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleCloudFormationOverridePropertyConfiguration model) {
            resourceIdOverrideConfiguration(model.resourceIdOverrideConfiguration);
            vpcConnections(model.vpcConnections);
            refreshSchedules(model.refreshSchedules);
            dataSources(model.dataSources);
            dataSets(model.dataSets);
            themes(model.themes);
            analyses(model.analyses);
            dashboards(model.dashboards);
        }

        public final AssetBundleExportJobResourceIdOverrideConfiguration.Builder getResourceIdOverrideConfiguration() {
            return resourceIdOverrideConfiguration != null ? resourceIdOverrideConfiguration.toBuilder() : null;
        }

        public final void setResourceIdOverrideConfiguration(
                AssetBundleExportJobResourceIdOverrideConfiguration.BuilderImpl resourceIdOverrideConfiguration) {
            this.resourceIdOverrideConfiguration = resourceIdOverrideConfiguration != null ? resourceIdOverrideConfiguration
                    .build() : null;
        }

        @Override
        public final Builder resourceIdOverrideConfiguration(
                AssetBundleExportJobResourceIdOverrideConfiguration resourceIdOverrideConfiguration) {
            this.resourceIdOverrideConfiguration = resourceIdOverrideConfiguration;
            return this;
        }

        public final List<AssetBundleExportJobVPCConnectionOverrideProperties.Builder> getVpcConnections() {
            List<AssetBundleExportJobVPCConnectionOverrideProperties.Builder> result = AssetBundleExportJobVPCConnectionOverridePropertiesListCopier
                    .copyToBuilder(this.vpcConnections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcConnections(
                Collection<AssetBundleExportJobVPCConnectionOverrideProperties.BuilderImpl> vpcConnections) {
            this.vpcConnections = AssetBundleExportJobVPCConnectionOverridePropertiesListCopier.copyFromBuilder(vpcConnections);
        }

        @Override
        public final Builder vpcConnections(Collection<AssetBundleExportJobVPCConnectionOverrideProperties> vpcConnections) {
            this.vpcConnections = AssetBundleExportJobVPCConnectionOverridePropertiesListCopier.copy(vpcConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConnections(AssetBundleExportJobVPCConnectionOverrideProperties... vpcConnections) {
            vpcConnections(Arrays.asList(vpcConnections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConnections(
                Consumer<AssetBundleExportJobVPCConnectionOverrideProperties.Builder>... vpcConnections) {
            vpcConnections(Stream.of(vpcConnections)
                    .map(c -> AssetBundleExportJobVPCConnectionOverrideProperties.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleExportJobRefreshScheduleOverrideProperties.Builder> getRefreshSchedules() {
            List<AssetBundleExportJobRefreshScheduleOverrideProperties.Builder> result = AssetBundleExportJobRefreshScheduleOverridePropertiesListCopier
                    .copyToBuilder(this.refreshSchedules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRefreshSchedules(
                Collection<AssetBundleExportJobRefreshScheduleOverrideProperties.BuilderImpl> refreshSchedules) {
            this.refreshSchedules = AssetBundleExportJobRefreshScheduleOverridePropertiesListCopier
                    .copyFromBuilder(refreshSchedules);
        }

        @Override
        public final Builder refreshSchedules(Collection<AssetBundleExportJobRefreshScheduleOverrideProperties> refreshSchedules) {
            this.refreshSchedules = AssetBundleExportJobRefreshScheduleOverridePropertiesListCopier.copy(refreshSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder refreshSchedules(AssetBundleExportJobRefreshScheduleOverrideProperties... refreshSchedules) {
            refreshSchedules(Arrays.asList(refreshSchedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder refreshSchedules(
                Consumer<AssetBundleExportJobRefreshScheduleOverrideProperties.Builder>... refreshSchedules) {
            refreshSchedules(Stream.of(refreshSchedules)
                    .map(c -> AssetBundleExportJobRefreshScheduleOverrideProperties.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleExportJobDataSourceOverrideProperties.Builder> getDataSources() {
            List<AssetBundleExportJobDataSourceOverrideProperties.Builder> result = AssetBundleExportJobDataSourceOverridePropertiesListCopier
                    .copyToBuilder(this.dataSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSources(Collection<AssetBundleExportJobDataSourceOverrideProperties.BuilderImpl> dataSources) {
            this.dataSources = AssetBundleExportJobDataSourceOverridePropertiesListCopier.copyFromBuilder(dataSources);
        }

        @Override
        public final Builder dataSources(Collection<AssetBundleExportJobDataSourceOverrideProperties> dataSources) {
            this.dataSources = AssetBundleExportJobDataSourceOverridePropertiesListCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(AssetBundleExportJobDataSourceOverrideProperties... dataSources) {
            dataSources(Arrays.asList(dataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(Consumer<AssetBundleExportJobDataSourceOverrideProperties.Builder>... dataSources) {
            dataSources(Stream.of(dataSources)
                    .map(c -> AssetBundleExportJobDataSourceOverrideProperties.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleExportJobDataSetOverrideProperties.Builder> getDataSets() {
            List<AssetBundleExportJobDataSetOverrideProperties.Builder> result = AssetBundleExportJobDataSetOverridePropertiesListCopier
                    .copyToBuilder(this.dataSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSets(Collection<AssetBundleExportJobDataSetOverrideProperties.BuilderImpl> dataSets) {
            this.dataSets = AssetBundleExportJobDataSetOverridePropertiesListCopier.copyFromBuilder(dataSets);
        }

        @Override
        public final Builder dataSets(Collection<AssetBundleExportJobDataSetOverrideProperties> dataSets) {
            this.dataSets = AssetBundleExportJobDataSetOverridePropertiesListCopier.copy(dataSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(AssetBundleExportJobDataSetOverrideProperties... dataSets) {
            dataSets(Arrays.asList(dataSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(Consumer<AssetBundleExportJobDataSetOverrideProperties.Builder>... dataSets) {
            dataSets(Stream.of(dataSets)
                    .map(c -> AssetBundleExportJobDataSetOverrideProperties.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleExportJobThemeOverrideProperties.Builder> getThemes() {
            List<AssetBundleExportJobThemeOverrideProperties.Builder> result = AssetBundleExportJobThemeOverridePropertiesListCopier
                    .copyToBuilder(this.themes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThemes(Collection<AssetBundleExportJobThemeOverrideProperties.BuilderImpl> themes) {
            this.themes = AssetBundleExportJobThemeOverridePropertiesListCopier.copyFromBuilder(themes);
        }

        @Override
        public final Builder themes(Collection<AssetBundleExportJobThemeOverrideProperties> themes) {
            this.themes = AssetBundleExportJobThemeOverridePropertiesListCopier.copy(themes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder themes(AssetBundleExportJobThemeOverrideProperties... themes) {
            themes(Arrays.asList(themes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder themes(Consumer<AssetBundleExportJobThemeOverrideProperties.Builder>... themes) {
            themes(Stream.of(themes).map(c -> AssetBundleExportJobThemeOverrideProperties.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleExportJobAnalysisOverrideProperties.Builder> getAnalyses() {
            List<AssetBundleExportJobAnalysisOverrideProperties.Builder> result = AssetBundleExportJobAnalysisOverridePropertiesListCopier
                    .copyToBuilder(this.analyses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalyses(Collection<AssetBundleExportJobAnalysisOverrideProperties.BuilderImpl> analyses) {
            this.analyses = AssetBundleExportJobAnalysisOverridePropertiesListCopier.copyFromBuilder(analyses);
        }

        @Override
        public final Builder analyses(Collection<AssetBundleExportJobAnalysisOverrideProperties> analyses) {
            this.analyses = AssetBundleExportJobAnalysisOverridePropertiesListCopier.copy(analyses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyses(AssetBundleExportJobAnalysisOverrideProperties... analyses) {
            analyses(Arrays.asList(analyses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyses(Consumer<AssetBundleExportJobAnalysisOverrideProperties.Builder>... analyses) {
            analyses(Stream.of(analyses)
                    .map(c -> AssetBundleExportJobAnalysisOverrideProperties.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleExportJobDashboardOverrideProperties.Builder> getDashboards() {
            List<AssetBundleExportJobDashboardOverrideProperties.Builder> result = AssetBundleExportJobDashboardOverridePropertiesListCopier
                    .copyToBuilder(this.dashboards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDashboards(Collection<AssetBundleExportJobDashboardOverrideProperties.BuilderImpl> dashboards) {
            this.dashboards = AssetBundleExportJobDashboardOverridePropertiesListCopier.copyFromBuilder(dashboards);
        }

        @Override
        public final Builder dashboards(Collection<AssetBundleExportJobDashboardOverrideProperties> dashboards) {
            this.dashboards = AssetBundleExportJobDashboardOverridePropertiesListCopier.copy(dashboards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboards(AssetBundleExportJobDashboardOverrideProperties... dashboards) {
            dashboards(Arrays.asList(dashboards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboards(Consumer<AssetBundleExportJobDashboardOverrideProperties.Builder>... dashboards) {
            dashboards(Stream.of(dashboards)
                    .map(c -> AssetBundleExportJobDashboardOverrideProperties.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AssetBundleCloudFormationOverridePropertyConfiguration build() {
            return new AssetBundleCloudFormationOverridePropertyConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
