/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.CustomColor;
import software.amazon.awssdk.services.quicksight.model.CustomColorsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ColorsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ColorsConfiguration> {
    private static final SdkField<List<CustomColor>> CUSTOM_COLORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomColors").getter(ColorsConfiguration.getter(ColorsConfiguration::customColors)).setter(ColorsConfiguration.setter(Builder::customColors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomColors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomColor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_COLORS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<CustomColor> customColors;

    private ColorsConfiguration(BuilderImpl builder) {
        this.customColors = builder.customColors;
    }

    public final boolean hasCustomColors() {
        return this.customColors != null && !(this.customColors instanceof SdkAutoConstructList);
    }

    public final List<CustomColor> customColors() {
        return this.customColors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomColors() ? this.customColors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColorsConfiguration)) {
            return false;
        }
        ColorsConfiguration other = (ColorsConfiguration)obj;
        return this.hasCustomColors() == other.hasCustomColors() && Objects.equals(this.customColors(), other.customColors());
    }

    public final String toString() {
        return ToString.builder((String)"ColorsConfiguration").add("CustomColors", this.hasCustomColors() ? this.customColors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomColors": {
                return Optional.ofNullable(clazz.cast(this.customColors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColorsConfiguration, T> g) {
        return obj -> g.apply((ColorsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CustomColor> customColors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ColorsConfiguration model) {
            this.customColors(model.customColors);
        }

        public final List<CustomColor.Builder> getCustomColors() {
            List<CustomColor.Builder> result = CustomColorsListCopier.copyToBuilder(this.customColors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomColors(Collection<CustomColor.BuilderImpl> customColors) {
            this.customColors = CustomColorsListCopier.copyFromBuilder(customColors);
        }

        @Override
        public final Builder customColors(Collection<CustomColor> customColors) {
            this.customColors = CustomColorsListCopier.copy(customColors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customColors(CustomColor ... customColors) {
            this.customColors(Arrays.asList(customColors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customColors(Consumer<CustomColor.Builder> ... customColors) {
            this.customColors(Stream.of(customColors).map(c -> (CustomColor)((CustomColor.Builder)CustomColor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ColorsConfiguration build() {
            return new ColorsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ColorsConfiguration> {
        public Builder customColors(Collection<CustomColor> var1);

        public Builder customColors(CustomColor ... var1);

        public Builder customColors(Consumer<CustomColor.Builder> ... var1);
    }
}

