/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.FontConfiguration;
import software.amazon.awssdk.services.quicksight.model.GlobalTableBorderOptions;
import software.amazon.awssdk.services.quicksight.model.HorizontalTextAlignment;
import software.amazon.awssdk.services.quicksight.model.TextWrap;
import software.amazon.awssdk.services.quicksight.model.VerticalTextAlignment;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableCellStyle
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableCellStyle> {
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(TableCellStyle.getter(TableCellStyle::visibilityAsString)).setter(TableCellStyle.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<FontConfiguration> FONT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FontConfiguration").getter(TableCellStyle.getter(TableCellStyle::fontConfiguration)).setter(TableCellStyle.setter(Builder::fontConfiguration)).constructor(FontConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontConfiguration").build()}).build();
    private static final SdkField<String> TEXT_WRAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TextWrap").getter(TableCellStyle.getter(TableCellStyle::textWrapAsString)).setter(TableCellStyle.setter(Builder::textWrap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextWrap").build()}).build();
    private static final SdkField<String> HORIZONTAL_TEXT_ALIGNMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HorizontalTextAlignment").getter(TableCellStyle.getter(TableCellStyle::horizontalTextAlignmentAsString)).setter(TableCellStyle.setter(Builder::horizontalTextAlignment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HorizontalTextAlignment").build()}).build();
    private static final SdkField<String> VERTICAL_TEXT_ALIGNMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerticalTextAlignment").getter(TableCellStyle.getter(TableCellStyle::verticalTextAlignmentAsString)).setter(TableCellStyle.setter(Builder::verticalTextAlignment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerticalTextAlignment").build()}).build();
    private static final SdkField<String> BACKGROUND_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackgroundColor").getter(TableCellStyle.getter(TableCellStyle::backgroundColor)).setter(TableCellStyle.setter(Builder::backgroundColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackgroundColor").build()}).build();
    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Height").getter(TableCellStyle.getter(TableCellStyle::height)).setter(TableCellStyle.setter(Builder::height)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Height").build()}).build();
    private static final SdkField<GlobalTableBorderOptions> BORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Border").getter(TableCellStyle.getter(TableCellStyle::border)).setter(TableCellStyle.setter(Builder::border)).constructor(GlobalTableBorderOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Border").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISIBILITY_FIELD, FONT_CONFIGURATION_FIELD, TEXT_WRAP_FIELD, HORIZONTAL_TEXT_ALIGNMENT_FIELD, VERTICAL_TEXT_ALIGNMENT_FIELD, BACKGROUND_COLOR_FIELD, HEIGHT_FIELD, BORDER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String visibility;
    private final FontConfiguration fontConfiguration;
    private final String textWrap;
    private final String horizontalTextAlignment;
    private final String verticalTextAlignment;
    private final String backgroundColor;
    private final Integer height;
    private final GlobalTableBorderOptions border;

    private TableCellStyle(BuilderImpl builder) {
        this.visibility = builder.visibility;
        this.fontConfiguration = builder.fontConfiguration;
        this.textWrap = builder.textWrap;
        this.horizontalTextAlignment = builder.horizontalTextAlignment;
        this.verticalTextAlignment = builder.verticalTextAlignment;
        this.backgroundColor = builder.backgroundColor;
        this.height = builder.height;
        this.border = builder.border;
    }

    public final Visibility visibility() {
        return Visibility.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public final FontConfiguration fontConfiguration() {
        return this.fontConfiguration;
    }

    public final TextWrap textWrap() {
        return TextWrap.fromValue(this.textWrap);
    }

    public final String textWrapAsString() {
        return this.textWrap;
    }

    public final HorizontalTextAlignment horizontalTextAlignment() {
        return HorizontalTextAlignment.fromValue(this.horizontalTextAlignment);
    }

    public final String horizontalTextAlignmentAsString() {
        return this.horizontalTextAlignment;
    }

    public final VerticalTextAlignment verticalTextAlignment() {
        return VerticalTextAlignment.fromValue(this.verticalTextAlignment);
    }

    public final String verticalTextAlignmentAsString() {
        return this.verticalTextAlignment;
    }

    public final String backgroundColor() {
        return this.backgroundColor;
    }

    public final Integer height() {
        return this.height;
    }

    public final GlobalTableBorderOptions border() {
        return this.border;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fontConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.textWrapAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.horizontalTextAlignmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.verticalTextAlignmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.backgroundColor());
        hashCode = 31 * hashCode + Objects.hashCode(this.height());
        hashCode = 31 * hashCode + Objects.hashCode(this.border());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableCellStyle)) {
            return false;
        }
        TableCellStyle other = (TableCellStyle)obj;
        return Objects.equals(this.visibilityAsString(), other.visibilityAsString()) && Objects.equals(this.fontConfiguration(), other.fontConfiguration()) && Objects.equals(this.textWrapAsString(), other.textWrapAsString()) && Objects.equals(this.horizontalTextAlignmentAsString(), other.horizontalTextAlignmentAsString()) && Objects.equals(this.verticalTextAlignmentAsString(), other.verticalTextAlignmentAsString()) && Objects.equals(this.backgroundColor(), other.backgroundColor()) && Objects.equals(this.height(), other.height()) && Objects.equals(this.border(), other.border());
    }

    public final String toString() {
        return ToString.builder((String)"TableCellStyle").add("Visibility", (Object)this.visibilityAsString()).add("FontConfiguration", (Object)this.fontConfiguration()).add("TextWrap", (Object)this.textWrapAsString()).add("HorizontalTextAlignment", (Object)this.horizontalTextAlignmentAsString()).add("VerticalTextAlignment", (Object)this.verticalTextAlignmentAsString()).add("BackgroundColor", (Object)this.backgroundColor()).add("Height", (Object)this.height()).add("Border", (Object)this.border()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
            case "FontConfiguration": {
                return Optional.ofNullable(clazz.cast(this.fontConfiguration()));
            }
            case "TextWrap": {
                return Optional.ofNullable(clazz.cast(this.textWrapAsString()));
            }
            case "HorizontalTextAlignment": {
                return Optional.ofNullable(clazz.cast(this.horizontalTextAlignmentAsString()));
            }
            case "VerticalTextAlignment": {
                return Optional.ofNullable(clazz.cast(this.verticalTextAlignmentAsString()));
            }
            case "BackgroundColor": {
                return Optional.ofNullable(clazz.cast(this.backgroundColor()));
            }
            case "Height": {
                return Optional.ofNullable(clazz.cast(this.height()));
            }
            case "Border": {
                return Optional.ofNullable(clazz.cast(this.border()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableCellStyle, T> g) {
        return obj -> g.apply((TableCellStyle)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String visibility;
        private FontConfiguration fontConfiguration;
        private String textWrap;
        private String horizontalTextAlignment;
        private String verticalTextAlignment;
        private String backgroundColor;
        private Integer height;
        private GlobalTableBorderOptions border;

        private BuilderImpl() {
        }

        private BuilderImpl(TableCellStyle model) {
            this.visibility(model.visibility);
            this.fontConfiguration(model.fontConfiguration);
            this.textWrap(model.textWrap);
            this.horizontalTextAlignment(model.horizontalTextAlignment);
            this.verticalTextAlignment(model.verticalTextAlignment);
            this.backgroundColor(model.backgroundColor);
            this.height(model.height);
            this.border(model.border);
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final FontConfiguration.Builder getFontConfiguration() {
            return this.fontConfiguration != null ? this.fontConfiguration.toBuilder() : null;
        }

        public final void setFontConfiguration(FontConfiguration.BuilderImpl fontConfiguration) {
            this.fontConfiguration = fontConfiguration != null ? fontConfiguration.build() : null;
        }

        @Override
        public final Builder fontConfiguration(FontConfiguration fontConfiguration) {
            this.fontConfiguration = fontConfiguration;
            return this;
        }

        public final String getTextWrap() {
            return this.textWrap;
        }

        public final void setTextWrap(String textWrap) {
            this.textWrap = textWrap;
        }

        @Override
        public final Builder textWrap(String textWrap) {
            this.textWrap = textWrap;
            return this;
        }

        @Override
        public final Builder textWrap(TextWrap textWrap) {
            this.textWrap(textWrap == null ? null : textWrap.toString());
            return this;
        }

        public final String getHorizontalTextAlignment() {
            return this.horizontalTextAlignment;
        }

        public final void setHorizontalTextAlignment(String horizontalTextAlignment) {
            this.horizontalTextAlignment = horizontalTextAlignment;
        }

        @Override
        public final Builder horizontalTextAlignment(String horizontalTextAlignment) {
            this.horizontalTextAlignment = horizontalTextAlignment;
            return this;
        }

        @Override
        public final Builder horizontalTextAlignment(HorizontalTextAlignment horizontalTextAlignment) {
            this.horizontalTextAlignment(horizontalTextAlignment == null ? null : horizontalTextAlignment.toString());
            return this;
        }

        public final String getVerticalTextAlignment() {
            return this.verticalTextAlignment;
        }

        public final void setVerticalTextAlignment(String verticalTextAlignment) {
            this.verticalTextAlignment = verticalTextAlignment;
        }

        @Override
        public final Builder verticalTextAlignment(String verticalTextAlignment) {
            this.verticalTextAlignment = verticalTextAlignment;
            return this;
        }

        @Override
        public final Builder verticalTextAlignment(VerticalTextAlignment verticalTextAlignment) {
            this.verticalTextAlignment(verticalTextAlignment == null ? null : verticalTextAlignment.toString());
            return this;
        }

        public final String getBackgroundColor() {
            return this.backgroundColor;
        }

        public final void setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        @Override
        public final Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public final Integer getHeight() {
            return this.height;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final GlobalTableBorderOptions.Builder getBorder() {
            return this.border != null ? this.border.toBuilder() : null;
        }

        public final void setBorder(GlobalTableBorderOptions.BuilderImpl border) {
            this.border = border != null ? border.build() : null;
        }

        @Override
        public final Builder border(GlobalTableBorderOptions border) {
            this.border = border;
            return this;
        }

        public TableCellStyle build() {
            return new TableCellStyle(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableCellStyle> {
        public Builder visibility(String var1);

        public Builder visibility(Visibility var1);

        public Builder fontConfiguration(FontConfiguration var1);

        default public Builder fontConfiguration(Consumer<FontConfiguration.Builder> fontConfiguration) {
            return this.fontConfiguration((FontConfiguration)((FontConfiguration.Builder)FontConfiguration.builder().applyMutation(fontConfiguration)).build());
        }

        public Builder textWrap(String var1);

        public Builder textWrap(TextWrap var1);

        public Builder horizontalTextAlignment(String var1);

        public Builder horizontalTextAlignment(HorizontalTextAlignment var1);

        public Builder verticalTextAlignment(String var1);

        public Builder verticalTextAlignment(VerticalTextAlignment var1);

        public Builder backgroundColor(String var1);

        public Builder height(Integer var1);

        public Builder border(GlobalTableBorderOptions var1);

        default public Builder border(Consumer<GlobalTableBorderOptions.Builder> border) {
            return this.border((GlobalTableBorderOptions)((GlobalTableBorderOptions.Builder)GlobalTableBorderOptions.builder().applyMutation(border)).build());
        }
    }
}

