/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field well configuration of a waterfall visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaterfallChartFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<WaterfallChartFieldWells.Builder, WaterfallChartFieldWells> {
    private static final SdkField<WaterfallChartAggregatedFieldWells> WATERFALL_CHART_AGGREGATED_FIELD_WELLS_FIELD = SdkField
            .<WaterfallChartAggregatedFieldWells> builder(MarshallingType.SDK_POJO)
            .memberName("WaterfallChartAggregatedFieldWells")
            .getter(getter(WaterfallChartFieldWells::waterfallChartAggregatedFieldWells))
            .setter(setter(Builder::waterfallChartAggregatedFieldWells))
            .constructor(WaterfallChartAggregatedFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaterfallChartAggregatedFieldWells")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(WATERFALL_CHART_AGGREGATED_FIELD_WELLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final WaterfallChartAggregatedFieldWells waterfallChartAggregatedFieldWells;

    private WaterfallChartFieldWells(BuilderImpl builder) {
        this.waterfallChartAggregatedFieldWells = builder.waterfallChartAggregatedFieldWells;
    }

    /**
     * <p>
     * The field well configuration of a waterfall visual.
     * </p>
     * 
     * @return The field well configuration of a waterfall visual.
     */
    public final WaterfallChartAggregatedFieldWells waterfallChartAggregatedFieldWells() {
        return waterfallChartAggregatedFieldWells;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(waterfallChartAggregatedFieldWells());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaterfallChartFieldWells)) {
            return false;
        }
        WaterfallChartFieldWells other = (WaterfallChartFieldWells) obj;
        return Objects.equals(waterfallChartAggregatedFieldWells(), other.waterfallChartAggregatedFieldWells());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaterfallChartFieldWells")
                .add("WaterfallChartAggregatedFieldWells", waterfallChartAggregatedFieldWells()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WaterfallChartAggregatedFieldWells":
            return Optional.ofNullable(clazz.cast(waterfallChartAggregatedFieldWells()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WaterfallChartFieldWells, T> g) {
        return obj -> g.apply((WaterfallChartFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaterfallChartFieldWells> {
        /**
         * <p>
         * The field well configuration of a waterfall visual.
         * </p>
         * 
         * @param waterfallChartAggregatedFieldWells
         *        The field well configuration of a waterfall visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waterfallChartAggregatedFieldWells(WaterfallChartAggregatedFieldWells waterfallChartAggregatedFieldWells);

        /**
         * <p>
         * The field well configuration of a waterfall visual.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WaterfallChartAggregatedFieldWells.Builder} avoiding the need to create one manually via
         * {@link WaterfallChartAggregatedFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaterfallChartAggregatedFieldWells.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #waterfallChartAggregatedFieldWells(WaterfallChartAggregatedFieldWells)}.
         * 
         * @param waterfallChartAggregatedFieldWells
         *        a consumer that will call methods on {@link WaterfallChartAggregatedFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #waterfallChartAggregatedFieldWells(WaterfallChartAggregatedFieldWells)
         */
        default Builder waterfallChartAggregatedFieldWells(
                Consumer<WaterfallChartAggregatedFieldWells.Builder> waterfallChartAggregatedFieldWells) {
            return waterfallChartAggregatedFieldWells(WaterfallChartAggregatedFieldWells.builder()
                    .applyMutation(waterfallChartAggregatedFieldWells).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private WaterfallChartAggregatedFieldWells waterfallChartAggregatedFieldWells;

        private BuilderImpl() {
        }

        private BuilderImpl(WaterfallChartFieldWells model) {
            waterfallChartAggregatedFieldWells(model.waterfallChartAggregatedFieldWells);
        }

        public final WaterfallChartAggregatedFieldWells.Builder getWaterfallChartAggregatedFieldWells() {
            return waterfallChartAggregatedFieldWells != null ? waterfallChartAggregatedFieldWells.toBuilder() : null;
        }

        public final void setWaterfallChartAggregatedFieldWells(
                WaterfallChartAggregatedFieldWells.BuilderImpl waterfallChartAggregatedFieldWells) {
            this.waterfallChartAggregatedFieldWells = waterfallChartAggregatedFieldWells != null ? waterfallChartAggregatedFieldWells
                    .build() : null;
        }

        @Override
        public final Builder waterfallChartAggregatedFieldWells(
                WaterfallChartAggregatedFieldWells waterfallChartAggregatedFieldWells) {
            this.waterfallChartAggregatedFieldWells = waterfallChartAggregatedFieldWells;
            return this;
        }

        @Override
        public WaterfallChartFieldWells build() {
            return new WaterfallChartFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
