/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Q search bar embedding experience.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisteredUserQSearchBarEmbeddingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RegisteredUserQSearchBarEmbeddingConfiguration.Builder, RegisteredUserQSearchBarEmbeddingConfiguration> {
    private static final SdkField<String> INITIAL_TOPIC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitialTopicId").getter(getter(RegisteredUserQSearchBarEmbeddingConfiguration::initialTopicId))
            .setter(setter(Builder::initialTopicId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialTopicId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIAL_TOPIC_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String initialTopicId;

    private RegisteredUserQSearchBarEmbeddingConfiguration(BuilderImpl builder) {
        this.initialTopicId = builder.initialTopicId;
    }

    /**
     * <p>
     * The ID of the Q topic that you want to make the starting topic in the Q search bar. You can find a topic ID by
     * navigating to the Topics pane in the Amazon QuickSight application and opening a topic. The ID is in the URL for
     * the topic that you open.
     * </p>
     * <p>
     * If you don't specify an initial topic, a list of all shared topics is shown in the Q bar for your readers. When
     * you select an initial topic, you can specify whether or not readers are allowed to select other topics from the
     * available ones in the list.
     * </p>
     * 
     * @return The ID of the Q topic that you want to make the starting topic in the Q search bar. You can find a topic
     *         ID by navigating to the Topics pane in the Amazon QuickSight application and opening a topic. The ID is
     *         in the URL for the topic that you open.</p>
     *         <p>
     *         If you don't specify an initial topic, a list of all shared topics is shown in the Q bar for your
     *         readers. When you select an initial topic, you can specify whether or not readers are allowed to select
     *         other topics from the available ones in the list.
     */
    public final String initialTopicId() {
        return initialTopicId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(initialTopicId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisteredUserQSearchBarEmbeddingConfiguration)) {
            return false;
        }
        RegisteredUserQSearchBarEmbeddingConfiguration other = (RegisteredUserQSearchBarEmbeddingConfiguration) obj;
        return Objects.equals(initialTopicId(), other.initialTopicId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisteredUserQSearchBarEmbeddingConfiguration").add("InitialTopicId", initialTopicId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InitialTopicId":
            return Optional.ofNullable(clazz.cast(initialTopicId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisteredUserQSearchBarEmbeddingConfiguration, T> g) {
        return obj -> g.apply((RegisteredUserQSearchBarEmbeddingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegisteredUserQSearchBarEmbeddingConfiguration> {
        /**
         * <p>
         * The ID of the Q topic that you want to make the starting topic in the Q search bar. You can find a topic ID
         * by navigating to the Topics pane in the Amazon QuickSight application and opening a topic. The ID is in the
         * URL for the topic that you open.
         * </p>
         * <p>
         * If you don't specify an initial topic, a list of all shared topics is shown in the Q bar for your readers.
         * When you select an initial topic, you can specify whether or not readers are allowed to select other topics
         * from the available ones in the list.
         * </p>
         * 
         * @param initialTopicId
         *        The ID of the Q topic that you want to make the starting topic in the Q search bar. You can find a
         *        topic ID by navigating to the Topics pane in the Amazon QuickSight application and opening a topic.
         *        The ID is in the URL for the topic that you open.</p>
         *        <p>
         *        If you don't specify an initial topic, a list of all shared topics is shown in the Q bar for your
         *        readers. When you select an initial topic, you can specify whether or not readers are allowed to
         *        select other topics from the available ones in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialTopicId(String initialTopicId);
    }

    static final class BuilderImpl implements Builder {
        private String initialTopicId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisteredUserQSearchBarEmbeddingConfiguration model) {
            initialTopicId(model.initialTopicId);
        }

        public final String getInitialTopicId() {
            return initialTopicId;
        }

        public final void setInitialTopicId(String initialTopicId) {
            this.initialTopicId = initialTopicId;
        }

        @Override
        public final Builder initialTopicId(String initialTopicId) {
            this.initialTopicId = initialTopicId;
            return this;
        }

        @Override
        public RegisteredUserQSearchBarEmbeddingConfiguration build() {
            return new RegisteredUserQSearchBarEmbeddingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
