/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metric comparison computation configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricComparisonComputation implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricComparisonComputation.Builder, MetricComparisonComputation> {
    private static final SdkField<String> COMPUTATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputationId").getter(getter(MetricComparisonComputation::computationId))
            .setter(setter(Builder::computationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputationId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(MetricComparisonComputation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<DimensionField> TIME_FIELD = SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
            .memberName("Time").getter(getter(MetricComparisonComputation::time)).setter(setter(Builder::time))
            .constructor(DimensionField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Time").build()).build();

    private static final SdkField<MeasureField> FROM_VALUE_FIELD = SdkField.<MeasureField> builder(MarshallingType.SDK_POJO)
            .memberName("FromValue").getter(getter(MetricComparisonComputation::fromValue)).setter(setter(Builder::fromValue))
            .constructor(MeasureField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromValue").build()).build();

    private static final SdkField<MeasureField> TARGET_VALUE_FIELD = SdkField.<MeasureField> builder(MarshallingType.SDK_POJO)
            .memberName("TargetValue").getter(getter(MetricComparisonComputation::targetValue))
            .setter(setter(Builder::targetValue)).constructor(MeasureField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_ID_FIELD,
            NAME_FIELD, TIME_FIELD, FROM_VALUE_FIELD, TARGET_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String computationId;

    private final String name;

    private final DimensionField time;

    private final MeasureField fromValue;

    private final MeasureField targetValue;

    private MetricComparisonComputation(BuilderImpl builder) {
        this.computationId = builder.computationId;
        this.name = builder.name;
        this.time = builder.time;
        this.fromValue = builder.fromValue;
        this.targetValue = builder.targetValue;
    }

    /**
     * <p>
     * The ID for a computation.
     * </p>
     * 
     * @return The ID for a computation.
     */
    public final String computationId() {
        return computationId;
    }

    /**
     * <p>
     * The name of a computation.
     * </p>
     * 
     * @return The name of a computation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The time field that is used in a computation.
     * </p>
     * 
     * @return The time field that is used in a computation.
     */
    public final DimensionField time() {
        return time;
    }

    /**
     * <p>
     * The field that is used in a metric comparison from value setup.
     * </p>
     * 
     * @return The field that is used in a metric comparison from value setup.
     */
    public final MeasureField fromValue() {
        return fromValue;
    }

    /**
     * <p>
     * The field that is used in a metric comparison to value setup.
     * </p>
     * 
     * @return The field that is used in a metric comparison to value setup.
     */
    public final MeasureField targetValue() {
        return targetValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(computationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(time());
        hashCode = 31 * hashCode + Objects.hashCode(fromValue());
        hashCode = 31 * hashCode + Objects.hashCode(targetValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricComparisonComputation)) {
            return false;
        }
        MetricComparisonComputation other = (MetricComparisonComputation) obj;
        return Objects.equals(computationId(), other.computationId()) && Objects.equals(name(), other.name())
                && Objects.equals(time(), other.time()) && Objects.equals(fromValue(), other.fromValue())
                && Objects.equals(targetValue(), other.targetValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricComparisonComputation").add("ComputationId", computationId()).add("Name", name())
                .add("Time", time()).add("FromValue", fromValue()).add("TargetValue", targetValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComputationId":
            return Optional.ofNullable(clazz.cast(computationId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Time":
            return Optional.ofNullable(clazz.cast(time()));
        case "FromValue":
            return Optional.ofNullable(clazz.cast(fromValue()));
        case "TargetValue":
            return Optional.ofNullable(clazz.cast(targetValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricComparisonComputation, T> g) {
        return obj -> g.apply((MetricComparisonComputation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricComparisonComputation> {
        /**
         * <p>
         * The ID for a computation.
         * </p>
         * 
         * @param computationId
         *        The ID for a computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationId(String computationId);

        /**
         * <p>
         * The name of a computation.
         * </p>
         * 
         * @param name
         *        The name of a computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time field that is used in a computation.
         * </p>
         * 
         * @param time
         *        The time field that is used in a computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder time(DimensionField time);

        /**
         * <p>
         * The time field that is used in a computation.
         * </p>
         * This is a convenience method that creates an instance of the {@link DimensionField.Builder} avoiding the need
         * to create one manually via {@link DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DimensionField.Builder#build()} is called immediately and its
         * result is passed to {@link #time(DimensionField)}.
         * 
         * @param time
         *        a consumer that will call methods on {@link DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #time(DimensionField)
         */
        default Builder time(Consumer<DimensionField.Builder> time) {
            return time(DimensionField.builder().applyMutation(time).build());
        }

        /**
         * <p>
         * The field that is used in a metric comparison from value setup.
         * </p>
         * 
         * @param fromValue
         *        The field that is used in a metric comparison from value setup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromValue(MeasureField fromValue);

        /**
         * <p>
         * The field that is used in a metric comparison from value setup.
         * </p>
         * This is a convenience method that creates an instance of the {@link MeasureField.Builder} avoiding the need
         * to create one manually via {@link MeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MeasureField.Builder#build()} is called immediately and its
         * result is passed to {@link #fromValue(MeasureField)}.
         * 
         * @param fromValue
         *        a consumer that will call methods on {@link MeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fromValue(MeasureField)
         */
        default Builder fromValue(Consumer<MeasureField.Builder> fromValue) {
            return fromValue(MeasureField.builder().applyMutation(fromValue).build());
        }

        /**
         * <p>
         * The field that is used in a metric comparison to value setup.
         * </p>
         * 
         * @param targetValue
         *        The field that is used in a metric comparison to value setup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetValue(MeasureField targetValue);

        /**
         * <p>
         * The field that is used in a metric comparison to value setup.
         * </p>
         * This is a convenience method that creates an instance of the {@link MeasureField.Builder} avoiding the need
         * to create one manually via {@link MeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MeasureField.Builder#build()} is called immediately and its
         * result is passed to {@link #targetValue(MeasureField)}.
         * 
         * @param targetValue
         *        a consumer that will call methods on {@link MeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetValue(MeasureField)
         */
        default Builder targetValue(Consumer<MeasureField.Builder> targetValue) {
            return targetValue(MeasureField.builder().applyMutation(targetValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String computationId;

        private String name;

        private DimensionField time;

        private MeasureField fromValue;

        private MeasureField targetValue;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricComparisonComputation model) {
            computationId(model.computationId);
            name(model.name);
            time(model.time);
            fromValue(model.fromValue);
            targetValue(model.targetValue);
        }

        public final String getComputationId() {
            return computationId;
        }

        public final void setComputationId(String computationId) {
            this.computationId = computationId;
        }

        @Override
        public final Builder computationId(String computationId) {
            this.computationId = computationId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DimensionField.Builder getTime() {
            return time != null ? time.toBuilder() : null;
        }

        public final void setTime(DimensionField.BuilderImpl time) {
            this.time = time != null ? time.build() : null;
        }

        @Override
        public final Builder time(DimensionField time) {
            this.time = time;
            return this;
        }

        public final MeasureField.Builder getFromValue() {
            return fromValue != null ? fromValue.toBuilder() : null;
        }

        public final void setFromValue(MeasureField.BuilderImpl fromValue) {
            this.fromValue = fromValue != null ? fromValue.build() : null;
        }

        @Override
        public final Builder fromValue(MeasureField fromValue) {
            this.fromValue = fromValue;
            return this;
        }

        public final MeasureField.Builder getTargetValue() {
            return targetValue != null ? targetValue.toBuilder() : null;
        }

        public final void setTargetValue(MeasureField.BuilderImpl targetValue) {
            this.targetValue = targetValue != null ? targetValue.build() : null;
        }

        @Override
        public final Builder targetValue(MeasureField targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        @Override
        public MetricComparisonComputation build() {
            return new MetricComparisonComputation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
