/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The share label options for the labels.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelOptions implements SdkPojo, Serializable, ToCopyableBuilder<LabelOptions.Builder, LabelOptions> {
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(LabelOptions::visibilityAsString)).setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<FontConfiguration> FONT_CONFIGURATION_FIELD = SdkField
            .<FontConfiguration> builder(MarshallingType.SDK_POJO).memberName("FontConfiguration")
            .getter(getter(LabelOptions::fontConfiguration)).setter(setter(Builder::fontConfiguration))
            .constructor(FontConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontConfiguration").build()).build();

    private static final SdkField<String> CUSTOM_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomLabel").getter(getter(LabelOptions::customLabel)).setter(setter(Builder::customLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLabel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISIBILITY_FIELD,
            FONT_CONFIGURATION_FIELD, CUSTOM_LABEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String visibility;

    private final FontConfiguration fontConfiguration;

    private final String customLabel;

    private LabelOptions(BuilderImpl builder) {
        this.visibility = builder.visibility;
        this.fontConfiguration = builder.fontConfiguration;
        this.customLabel = builder.customLabel;
    }

    /**
     * <p>
     * Determines whether or not the label is visible.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return Determines whether or not the label is visible.
     * @see Visibility
     */
    public final Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * Determines whether or not the label is visible.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return Determines whether or not the label is visible.
     * @see Visibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    /**
     * <p>
     * The font configuration of the label.
     * </p>
     * 
     * @return The font configuration of the label.
     */
    public final FontConfiguration fontConfiguration() {
        return fontConfiguration;
    }

    /**
     * <p>
     * The text for the label.
     * </p>
     * 
     * @return The text for the label.
     */
    public final String customLabel() {
        return customLabel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fontConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(customLabel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelOptions)) {
            return false;
        }
        LabelOptions other = (LabelOptions) obj;
        return Objects.equals(visibilityAsString(), other.visibilityAsString())
                && Objects.equals(fontConfiguration(), other.fontConfiguration())
                && Objects.equals(customLabel(), other.customLabel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LabelOptions").add("Visibility", visibilityAsString())
                .add("FontConfiguration", fontConfiguration()).add("CustomLabel", customLabel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        case "FontConfiguration":
            return Optional.ofNullable(clazz.cast(fontConfiguration()));
        case "CustomLabel":
            return Optional.ofNullable(clazz.cast(customLabel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelOptions, T> g) {
        return obj -> g.apply((LabelOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LabelOptions> {
        /**
         * <p>
         * Determines whether or not the label is visible.
         * </p>
         * 
         * @param visibility
         *        Determines whether or not the label is visible.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * Determines whether or not the label is visible.
         * </p>
         * 
         * @param visibility
         *        Determines whether or not the label is visible.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);

        /**
         * <p>
         * The font configuration of the label.
         * </p>
         * 
         * @param fontConfiguration
         *        The font configuration of the label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontConfiguration(FontConfiguration fontConfiguration);

        /**
         * <p>
         * The font configuration of the label.
         * </p>
         * This is a convenience method that creates an instance of the {@link FontConfiguration.Builder} avoiding the
         * need to create one manually via {@link FontConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FontConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #fontConfiguration(FontConfiguration)}.
         * 
         * @param fontConfiguration
         *        a consumer that will call methods on {@link FontConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fontConfiguration(FontConfiguration)
         */
        default Builder fontConfiguration(Consumer<FontConfiguration.Builder> fontConfiguration) {
            return fontConfiguration(FontConfiguration.builder().applyMutation(fontConfiguration).build());
        }

        /**
         * <p>
         * The text for the label.
         * </p>
         * 
         * @param customLabel
         *        The text for the label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customLabel(String customLabel);
    }

    static final class BuilderImpl implements Builder {
        private String visibility;

        private FontConfiguration fontConfiguration;

        private String customLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelOptions model) {
            visibility(model.visibility);
            fontConfiguration(model.fontConfiguration);
            customLabel(model.customLabel);
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final FontConfiguration.Builder getFontConfiguration() {
            return fontConfiguration != null ? fontConfiguration.toBuilder() : null;
        }

        public final void setFontConfiguration(FontConfiguration.BuilderImpl fontConfiguration) {
            this.fontConfiguration = fontConfiguration != null ? fontConfiguration.build() : null;
        }

        @Override
        public final Builder fontConfiguration(FontConfiguration fontConfiguration) {
            this.fontConfiguration = fontConfiguration;
            return this;
        }

        public final String getCustomLabel() {
            return customLabel;
        }

        public final void setCustomLabel(String customLabel) {
            this.customLabel = customLabel;
        }

        @Override
        public final Builder customLabel(String customLabel) {
            this.customLabel = customLabel;
            return this;
        }

        @Override
        public LabelOptions build() {
            return new LabelOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
