/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options that determine the sizing of the canvas used in a grid layout.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GridLayoutScreenCanvasSizeOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<GridLayoutScreenCanvasSizeOptions.Builder, GridLayoutScreenCanvasSizeOptions> {
    private static final SdkField<String> RESIZE_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResizeOption").getter(getter(GridLayoutScreenCanvasSizeOptions::resizeOptionAsString))
            .setter(setter(Builder::resizeOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResizeOption").build()).build();

    private static final SdkField<String> OPTIMIZED_VIEW_PORT_WIDTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptimizedViewPortWidth").getter(getter(GridLayoutScreenCanvasSizeOptions::optimizedViewPortWidth))
            .setter(setter(Builder::optimizedViewPortWidth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizedViewPortWidth").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESIZE_OPTION_FIELD,
            OPTIMIZED_VIEW_PORT_WIDTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resizeOption;

    private final String optimizedViewPortWidth;

    private GridLayoutScreenCanvasSizeOptions(BuilderImpl builder) {
        this.resizeOption = builder.resizeOption;
        this.optimizedViewPortWidth = builder.optimizedViewPortWidth;
    }

    /**
     * <p>
     * This value determines the layout behavior when the viewport is resized.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FIXED</code>: A fixed width will be used when optimizing the layout. In the Amazon QuickSight console, this
     * option is called <code>Classic</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESPONSIVE</code>: The width of the canvas will be responsive and optimized to the view port. In the Amazon
     * QuickSight console, this option is called <code>Tiled</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resizeOption} will
     * return {@link ResizeOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resizeOptionAsString}.
     * </p>
     * 
     * @return This value determines the layout behavior when the viewport is resized.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FIXED</code>: A fixed width will be used when optimizing the layout. In the Amazon QuickSight
     *         console, this option is called <code>Classic</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESPONSIVE</code>: The width of the canvas will be responsive and optimized to the view port. In
     *         the Amazon QuickSight console, this option is called <code>Tiled</code>.
     *         </p>
     *         </li>
     * @see ResizeOption
     */
    public final ResizeOption resizeOption() {
        return ResizeOption.fromValue(resizeOption);
    }

    /**
     * <p>
     * This value determines the layout behavior when the viewport is resized.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FIXED</code>: A fixed width will be used when optimizing the layout. In the Amazon QuickSight console, this
     * option is called <code>Classic</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESPONSIVE</code>: The width of the canvas will be responsive and optimized to the view port. In the Amazon
     * QuickSight console, this option is called <code>Tiled</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resizeOption} will
     * return {@link ResizeOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resizeOptionAsString}.
     * </p>
     * 
     * @return This value determines the layout behavior when the viewport is resized.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FIXED</code>: A fixed width will be used when optimizing the layout. In the Amazon QuickSight
     *         console, this option is called <code>Classic</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESPONSIVE</code>: The width of the canvas will be responsive and optimized to the view port. In
     *         the Amazon QuickSight console, this option is called <code>Tiled</code>.
     *         </p>
     *         </li>
     * @see ResizeOption
     */
    public final String resizeOptionAsString() {
        return resizeOption;
    }

    /**
     * <p>
     * The width that the view port will be optimized for when the layout renders.
     * </p>
     * 
     * @return The width that the view port will be optimized for when the layout renders.
     */
    public final String optimizedViewPortWidth() {
        return optimizedViewPortWidth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resizeOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(optimizedViewPortWidth());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GridLayoutScreenCanvasSizeOptions)) {
            return false;
        }
        GridLayoutScreenCanvasSizeOptions other = (GridLayoutScreenCanvasSizeOptions) obj;
        return Objects.equals(resizeOptionAsString(), other.resizeOptionAsString())
                && Objects.equals(optimizedViewPortWidth(), other.optimizedViewPortWidth());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GridLayoutScreenCanvasSizeOptions").add("ResizeOption", resizeOptionAsString())
                .add("OptimizedViewPortWidth", optimizedViewPortWidth()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResizeOption":
            return Optional.ofNullable(clazz.cast(resizeOptionAsString()));
        case "OptimizedViewPortWidth":
            return Optional.ofNullable(clazz.cast(optimizedViewPortWidth()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GridLayoutScreenCanvasSizeOptions, T> g) {
        return obj -> g.apply((GridLayoutScreenCanvasSizeOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GridLayoutScreenCanvasSizeOptions> {
        /**
         * <p>
         * This value determines the layout behavior when the viewport is resized.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FIXED</code>: A fixed width will be used when optimizing the layout. In the Amazon QuickSight console,
         * this option is called <code>Classic</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESPONSIVE</code>: The width of the canvas will be responsive and optimized to the view port. In the
         * Amazon QuickSight console, this option is called <code>Tiled</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resizeOption
         *        This value determines the layout behavior when the viewport is resized.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FIXED</code>: A fixed width will be used when optimizing the layout. In the Amazon QuickSight
         *        console, this option is called <code>Classic</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESPONSIVE</code>: The width of the canvas will be responsive and optimized to the view port. In
         *        the Amazon QuickSight console, this option is called <code>Tiled</code>.
         *        </p>
         *        </li>
         * @see ResizeOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResizeOption
         */
        Builder resizeOption(String resizeOption);

        /**
         * <p>
         * This value determines the layout behavior when the viewport is resized.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FIXED</code>: A fixed width will be used when optimizing the layout. In the Amazon QuickSight console,
         * this option is called <code>Classic</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESPONSIVE</code>: The width of the canvas will be responsive and optimized to the view port. In the
         * Amazon QuickSight console, this option is called <code>Tiled</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resizeOption
         *        This value determines the layout behavior when the viewport is resized.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FIXED</code>: A fixed width will be used when optimizing the layout. In the Amazon QuickSight
         *        console, this option is called <code>Classic</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESPONSIVE</code>: The width of the canvas will be responsive and optimized to the view port. In
         *        the Amazon QuickSight console, this option is called <code>Tiled</code>.
         *        </p>
         *        </li>
         * @see ResizeOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResizeOption
         */
        Builder resizeOption(ResizeOption resizeOption);

        /**
         * <p>
         * The width that the view port will be optimized for when the layout renders.
         * </p>
         * 
         * @param optimizedViewPortWidth
         *        The width that the view port will be optimized for when the layout renders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizedViewPortWidth(String optimizedViewPortWidth);
    }

    static final class BuilderImpl implements Builder {
        private String resizeOption;

        private String optimizedViewPortWidth;

        private BuilderImpl() {
        }

        private BuilderImpl(GridLayoutScreenCanvasSizeOptions model) {
            resizeOption(model.resizeOption);
            optimizedViewPortWidth(model.optimizedViewPortWidth);
        }

        public final String getResizeOption() {
            return resizeOption;
        }

        public final void setResizeOption(String resizeOption) {
            this.resizeOption = resizeOption;
        }

        @Override
        public final Builder resizeOption(String resizeOption) {
            this.resizeOption = resizeOption;
            return this;
        }

        @Override
        public final Builder resizeOption(ResizeOption resizeOption) {
            this.resizeOption(resizeOption == null ? null : resizeOption.toString());
            return this;
        }

        public final String getOptimizedViewPortWidth() {
            return optimizedViewPortWidth;
        }

        public final void setOptimizedViewPortWidth(String optimizedViewPortWidth) {
            this.optimizedViewPortWidth = optimizedViewPortWidth;
        }

        @Override
        public final Builder optimizedViewPortWidth(String optimizedViewPortWidth) {
            this.optimizedViewPortWidth = optimizedViewPortWidth;
            return this;
        }

        @Override
        public GridLayoutScreenCanvasSizeOptions build() {
            return new GridLayoutScreenCanvasSizeOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
