/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An asset in a Amazon QuickSight folder, such as a dashboard, analysis, or dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FolderMember implements SdkPojo, Serializable, ToCopyableBuilder<FolderMember.Builder, FolderMember> {
    private static final SdkField<String> MEMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberId").getter(getter(FolderMember::memberId)).setter(setter(Builder::memberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberId").build()).build();

    private static final SdkField<String> MEMBER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberType").getter(getter(FolderMember::memberTypeAsString)).setter(setter(Builder::memberType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_ID_FIELD,
            MEMBER_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String memberId;

    private final String memberType;

    private FolderMember(BuilderImpl builder) {
        this.memberId = builder.memberId;
        this.memberType = builder.memberType;
    }

    /**
     * <p>
     * The ID of an asset in the folder.
     * </p>
     * 
     * @return The ID of an asset in the folder.
     */
    public final String memberId() {
        return memberId;
    }

    /**
     * <p>
     * The type of asset that it is.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memberType} will
     * return {@link MemberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #memberTypeAsString}.
     * </p>
     * 
     * @return The type of asset that it is.
     * @see MemberType
     */
    public final MemberType memberType() {
        return MemberType.fromValue(memberType);
    }

    /**
     * <p>
     * The type of asset that it is.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #memberType} will
     * return {@link MemberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #memberTypeAsString}.
     * </p>
     * 
     * @return The type of asset that it is.
     * @see MemberType
     */
    public final String memberTypeAsString() {
        return memberType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(memberId());
        hashCode = 31 * hashCode + Objects.hashCode(memberTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FolderMember)) {
            return false;
        }
        FolderMember other = (FolderMember) obj;
        return Objects.equals(memberId(), other.memberId()) && Objects.equals(memberTypeAsString(), other.memberTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FolderMember").add("MemberId", memberId()).add("MemberType", memberTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MemberId":
            return Optional.ofNullable(clazz.cast(memberId()));
        case "MemberType":
            return Optional.ofNullable(clazz.cast(memberTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FolderMember, T> g) {
        return obj -> g.apply((FolderMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FolderMember> {
        /**
         * <p>
         * The ID of an asset in the folder.
         * </p>
         * 
         * @param memberId
         *        The ID of an asset in the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberId(String memberId);

        /**
         * <p>
         * The type of asset that it is.
         * </p>
         * 
         * @param memberType
         *        The type of asset that it is.
         * @see MemberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberType
         */
        Builder memberType(String memberType);

        /**
         * <p>
         * The type of asset that it is.
         * </p>
         * 
         * @param memberType
         *        The type of asset that it is.
         * @see MemberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberType
         */
        Builder memberType(MemberType memberType);
    }

    static final class BuilderImpl implements Builder {
        private String memberId;

        private String memberType;

        private BuilderImpl() {
        }

        private BuilderImpl(FolderMember model) {
            memberId(model.memberId);
            memberType(model.memberType);
        }

        public final String getMemberId() {
            return memberId;
        }

        public final void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        @Override
        public final Builder memberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public final String getMemberType() {
            return memberType;
        }

        public final void setMemberType(String memberType) {
            this.memberType = memberType;
        }

        @Override
        public final Builder memberType(String memberType) {
            this.memberType = memberType;
            return this;
        }

        @Override
        public final Builder memberType(MemberType memberType) {
            this.memberType(memberType == null ? null : memberType.toString());
            return this;
        }

        @Override
        public FolderMember build() {
            return new FolderMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
