/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAssetBundleImportJobResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeAssetBundleImportJobResponse.Builder, DescribeAssetBundleImportJobResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(DescribeAssetBundleImportJobResponse::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<List<AssetBundleImportJobError>> ERRORS_FIELD = SdkField
            .<List<AssetBundleImportJobError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(DescribeAssetBundleImportJobResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleImportJobError> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleImportJobError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleImportJobError>> ROLLBACK_ERRORS_FIELD = SdkField
            .<List<AssetBundleImportJobError>> builder(MarshallingType.LIST)
            .memberName("RollbackErrors")
            .getter(getter(DescribeAssetBundleImportJobResponse::rollbackErrors))
            .setter(setter(Builder::rollbackErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleImportJobError> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleImportJobError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribeAssetBundleImportJobResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(DescribeAssetBundleImportJobResponse::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> ASSET_BUNDLE_IMPORT_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssetBundleImportJobId").getter(getter(DescribeAssetBundleImportJobResponse::assetBundleImportJobId))
            .setter(setter(Builder::assetBundleImportJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetBundleImportJobId").build())
            .build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(DescribeAssetBundleImportJobResponse::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()).build();

    private static final SdkField<AssetBundleImportSourceDescription> ASSET_BUNDLE_IMPORT_SOURCE_FIELD = SdkField
            .<AssetBundleImportSourceDescription> builder(MarshallingType.SDK_POJO).memberName("AssetBundleImportSource")
            .getter(getter(DescribeAssetBundleImportJobResponse::assetBundleImportSource))
            .setter(setter(Builder::assetBundleImportSource)).constructor(AssetBundleImportSourceDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetBundleImportSource").build())
            .build();

    private static final SdkField<AssetBundleImportJobOverrideParameters> OVERRIDE_PARAMETERS_FIELD = SdkField
            .<AssetBundleImportJobOverrideParameters> builder(MarshallingType.SDK_POJO).memberName("OverrideParameters")
            .getter(getter(DescribeAssetBundleImportJobResponse::overrideParameters)).setter(setter(Builder::overrideParameters))
            .constructor(AssetBundleImportJobOverrideParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideParameters").build())
            .build();

    private static final SdkField<String> FAILURE_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureAction").getter(getter(DescribeAssetBundleImportJobResponse::failureActionAsString))
            .setter(setter(Builder::failureAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureAction").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeAssetBundleImportJobResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DescribeAssetBundleImportJobResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD,
            ERRORS_FIELD, ROLLBACK_ERRORS_FIELD, ARN_FIELD, CREATED_TIME_FIELD, ASSET_BUNDLE_IMPORT_JOB_ID_FIELD,
            AWS_ACCOUNT_ID_FIELD, ASSET_BUNDLE_IMPORT_SOURCE_FIELD, OVERRIDE_PARAMETERS_FIELD, FAILURE_ACTION_FIELD,
            REQUEST_ID_FIELD, STATUS_FIELD));

    private final String jobStatus;

    private final List<AssetBundleImportJobError> errors;

    private final List<AssetBundleImportJobError> rollbackErrors;

    private final String arn;

    private final Instant createdTime;

    private final String assetBundleImportJobId;

    private final String awsAccountId;

    private final AssetBundleImportSourceDescription assetBundleImportSource;

    private final AssetBundleImportJobOverrideParameters overrideParameters;

    private final String failureAction;

    private final String requestId;

    private final Integer status;

    private DescribeAssetBundleImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.errors = builder.errors;
        this.rollbackErrors = builder.rollbackErrors;
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.assetBundleImportJobId = builder.assetBundleImportJobId;
        this.awsAccountId = builder.awsAccountId;
        this.assetBundleImportSource = builder.assetBundleImportSource;
        this.overrideParameters = builder.overrideParameters;
        this.failureAction = builder.failureAction;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * Indicates the status of a job through its queuing and execution.
     * </p>
     * <p>
     * Poll the <code>DescribeAssetBundleImport</code> API until <code>JobStatus</code> returns one of the following
     * values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUCCESSFUL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED_ROLLBACK_COMPLETED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED_ROLLBACK_ERROR</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link AssetBundleImportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #jobStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of a job through its queuing and execution.</p>
     *         <p>
     *         Poll the <code>DescribeAssetBundleImport</code> API until <code>JobStatus</code> returns one of the
     *         following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUCCESSFUL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED_ROLLBACK_COMPLETED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED_ROLLBACK_ERROR</code>
     *         </p>
     *         </li>
     * @see AssetBundleImportJobStatus
     */
    public final AssetBundleImportJobStatus jobStatus() {
        return AssetBundleImportJobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * Indicates the status of a job through its queuing and execution.
     * </p>
     * <p>
     * Poll the <code>DescribeAssetBundleImport</code> API until <code>JobStatus</code> returns one of the following
     * values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUCCESSFUL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED_ROLLBACK_COMPLETED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED_ROLLBACK_ERROR</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link AssetBundleImportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #jobStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of a job through its queuing and execution.</p>
     *         <p>
     *         Poll the <code>DescribeAssetBundleImport</code> API until <code>JobStatus</code> returns one of the
     *         following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUCCESSFUL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED_ROLLBACK_COMPLETED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED_ROLLBACK_ERROR</code>
     *         </p>
     *         </li>
     * @see AssetBundleImportJobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of error records that describes any failures that occurred during the export job processing.
     * </p>
     * <p>
     * Error records accumulate while the job is still running. The complete set of error records is available after the
     * job has completed and failed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return An array of error records that describes any failures that occurred during the export job processing.</p>
     *         <p>
     *         Error records accumulate while the job is still running. The complete set of error records is available
     *         after the job has completed and failed.
     */
    public final List<AssetBundleImportJobError> errors() {
        return errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the RollbackErrors property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRollbackErrors() {
        return rollbackErrors != null && !(rollbackErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of error records that describes any failures that occurred while an import job was attempting a
     * rollback.
     * </p>
     * <p>
     * Error records accumulate while the job is still running. The complete set of error records is available after the
     * job has completed and failed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRollbackErrors} method.
     * </p>
     * 
     * @return An array of error records that describes any failures that occurred while an import job was attempting a
     *         rollback.</p>
     *         <p>
     *         Error records accumulate while the job is still running. The complete set of error records is available
     *         after the job has completed and failed.
     */
    public final List<AssetBundleImportJobError> rollbackErrors() {
        return rollbackErrors;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the import job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the import job.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time that the import job was created.
     * </p>
     * 
     * @return The time that the import job was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The ID of the job. The job ID is set when you start a new job with a <code>StartAssetBundleImportJob</code> API
     * call.
     * </p>
     * 
     * @return The ID of the job. The job ID is set when you start a new job with a
     *         <code>StartAssetBundleImportJob</code> API call.
     */
    public final String assetBundleImportJobId() {
        return assetBundleImportJobId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account the import job was executed in.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account the import job was executed in.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The source of the asset bundle zip file that contains the data that is imported by the job.
     * </p>
     * 
     * @return The source of the asset bundle zip file that contains the data that is imported by the job.
     */
    public final AssetBundleImportSourceDescription assetBundleImportSource() {
        return assetBundleImportSource;
    }

    /**
     * <p>
     * Optional overrides to be applied to the resource configuration before import.
     * </p>
     * 
     * @return Optional overrides to be applied to the resource configuration before import.
     */
    public final AssetBundleImportJobOverrideParameters overrideParameters() {
        return overrideParameters;
    }

    /**
     * <p>
     * The failure action for the import job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureAction}
     * will return {@link AssetBundleImportFailureAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #failureActionAsString}.
     * </p>
     * 
     * @return The failure action for the import job.
     * @see AssetBundleImportFailureAction
     */
    public final AssetBundleImportFailureAction failureAction() {
        return AssetBundleImportFailureAction.fromValue(failureAction);
    }

    /**
     * <p>
     * The failure action for the import job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureAction}
     * will return {@link AssetBundleImportFailureAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #failureActionAsString}.
     * </p>
     * 
     * @return The failure action for the import job.
     * @see AssetBundleImportFailureAction
     */
    public final String failureActionAsString() {
        return failureAction;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the response.
     * </p>
     * 
     * @return The HTTP status of the response.
     */
    public final Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRollbackErrors() ? rollbackErrors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(assetBundleImportJobId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(assetBundleImportSource());
        hashCode = 31 * hashCode + Objects.hashCode(overrideParameters());
        hashCode = 31 * hashCode + Objects.hashCode(failureActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssetBundleImportJobResponse)) {
            return false;
        }
        DescribeAssetBundleImportJobResponse other = (DescribeAssetBundleImportJobResponse) obj;
        return Objects.equals(jobStatusAsString(), other.jobStatusAsString()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors()) && hasRollbackErrors() == other.hasRollbackErrors()
                && Objects.equals(rollbackErrors(), other.rollbackErrors()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(assetBundleImportJobId(), other.assetBundleImportJobId())
                && Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(assetBundleImportSource(), other.assetBundleImportSource())
                && Objects.equals(overrideParameters(), other.overrideParameters())
                && Objects.equals(failureActionAsString(), other.failureActionAsString())
                && Objects.equals(requestId(), other.requestId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAssetBundleImportJobResponse").add("JobStatus", jobStatusAsString())
                .add("Errors", hasErrors() ? errors() : null)
                .add("RollbackErrors", hasRollbackErrors() ? rollbackErrors() : null).add("Arn", arn())
                .add("CreatedTime", createdTime()).add("AssetBundleImportJobId", assetBundleImportJobId())
                .add("AwsAccountId", awsAccountId()).add("AssetBundleImportSource", assetBundleImportSource())
                .add("OverrideParameters", overrideParameters()).add("FailureAction", failureActionAsString())
                .add("RequestId", requestId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "RollbackErrors":
            return Optional.ofNullable(clazz.cast(rollbackErrors()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "AssetBundleImportJobId":
            return Optional.ofNullable(clazz.cast(assetBundleImportJobId()));
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "AssetBundleImportSource":
            return Optional.ofNullable(clazz.cast(assetBundleImportSource()));
        case "OverrideParameters":
            return Optional.ofNullable(clazz.cast(overrideParameters()));
        case "FailureAction":
            return Optional.ofNullable(clazz.cast(failureActionAsString()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssetBundleImportJobResponse, T> g) {
        return obj -> g.apply((DescribeAssetBundleImportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAssetBundleImportJobResponse> {
        /**
         * <p>
         * Indicates the status of a job through its queuing and execution.
         * </p>
         * <p>
         * Poll the <code>DescribeAssetBundleImport</code> API until <code>JobStatus</code> returns one of the following
         * values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUCCESSFUL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED_ROLLBACK_COMPLETED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED_ROLLBACK_ERROR</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobStatus
         *        Indicates the status of a job through its queuing and execution.</p>
         *        <p>
         *        Poll the <code>DescribeAssetBundleImport</code> API until <code>JobStatus</code> returns one of the
         *        following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUCCESSFUL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED_ROLLBACK_COMPLETED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED_ROLLBACK_ERROR</code>
         *        </p>
         *        </li>
         * @see AssetBundleImportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetBundleImportJobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * Indicates the status of a job through its queuing and execution.
         * </p>
         * <p>
         * Poll the <code>DescribeAssetBundleImport</code> API until <code>JobStatus</code> returns one of the following
         * values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUCCESSFUL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED_ROLLBACK_COMPLETED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED_ROLLBACK_ERROR</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobStatus
         *        Indicates the status of a job through its queuing and execution.</p>
         *        <p>
         *        Poll the <code>DescribeAssetBundleImport</code> API until <code>JobStatus</code> returns one of the
         *        following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUCCESSFUL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED_ROLLBACK_COMPLETED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED_ROLLBACK_ERROR</code>
         *        </p>
         *        </li>
         * @see AssetBundleImportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetBundleImportJobStatus
         */
        Builder jobStatus(AssetBundleImportJobStatus jobStatus);

        /**
         * <p>
         * An array of error records that describes any failures that occurred during the export job processing.
         * </p>
         * <p>
         * Error records accumulate while the job is still running. The complete set of error records is available after
         * the job has completed and failed.
         * </p>
         * 
         * @param errors
         *        An array of error records that describes any failures that occurred during the export job
         *        processing.</p>
         *        <p>
         *        Error records accumulate while the job is still running. The complete set of error records is
         *        available after the job has completed and failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<AssetBundleImportJobError> errors);

        /**
         * <p>
         * An array of error records that describes any failures that occurred during the export job processing.
         * </p>
         * <p>
         * Error records accumulate while the job is still running. The complete set of error records is available after
         * the job has completed and failed.
         * </p>
         * 
         * @param errors
         *        An array of error records that describes any failures that occurred during the export job
         *        processing.</p>
         *        <p>
         *        Error records accumulate while the job is still running. The complete set of error records is
         *        available after the job has completed and failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(AssetBundleImportJobError... errors);

        /**
         * <p>
         * An array of error records that describes any failures that occurred during the export job processing.
         * </p>
         * <p>
         * Error records accumulate while the job is still running. The complete set of error records is available after
         * the job has completed and failed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobError.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobError.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<AssetBundleImportJobError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<AssetBundleImportJobError>)
         */
        Builder errors(Consumer<AssetBundleImportJobError.Builder>... errors);

        /**
         * <p>
         * An array of error records that describes any failures that occurred while an import job was attempting a
         * rollback.
         * </p>
         * <p>
         * Error records accumulate while the job is still running. The complete set of error records is available after
         * the job has completed and failed.
         * </p>
         * 
         * @param rollbackErrors
         *        An array of error records that describes any failures that occurred while an import job was attempting
         *        a rollback.</p>
         *        <p>
         *        Error records accumulate while the job is still running. The complete set of error records is
         *        available after the job has completed and failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackErrors(Collection<AssetBundleImportJobError> rollbackErrors);

        /**
         * <p>
         * An array of error records that describes any failures that occurred while an import job was attempting a
         * rollback.
         * </p>
         * <p>
         * Error records accumulate while the job is still running. The complete set of error records is available after
         * the job has completed and failed.
         * </p>
         * 
         * @param rollbackErrors
         *        An array of error records that describes any failures that occurred while an import job was attempting
         *        a rollback.</p>
         *        <p>
         *        Error records accumulate while the job is still running. The complete set of error records is
         *        available after the job has completed and failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollbackErrors(AssetBundleImportJobError... rollbackErrors);

        /**
         * <p>
         * An array of error records that describes any failures that occurred while an import job was attempting a
         * rollback.
         * </p>
         * <p>
         * Error records accumulate while the job is still running. The complete set of error records is available after
         * the job has completed and failed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobError.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobError.Builder#build()} is called
         * immediately and its result is passed to {@link #rollbackErrors(List<AssetBundleImportJobError>)}.
         * 
         * @param rollbackErrors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rollbackErrors(java.util.Collection<AssetBundleImportJobError>)
         */
        Builder rollbackErrors(Consumer<AssetBundleImportJobError.Builder>... rollbackErrors);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the import job.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time that the import job was created.
         * </p>
         * 
         * @param createdTime
         *        The time that the import job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The ID of the job. The job ID is set when you start a new job with a <code>StartAssetBundleImportJob</code>
         * API call.
         * </p>
         * 
         * @param assetBundleImportJobId
         *        The ID of the job. The job ID is set when you start a new job with a
         *        <code>StartAssetBundleImportJob</code> API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetBundleImportJobId(String assetBundleImportJobId);

        /**
         * <p>
         * The ID of the Amazon Web Services account the import job was executed in.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account the import job was executed in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The source of the asset bundle zip file that contains the data that is imported by the job.
         * </p>
         * 
         * @param assetBundleImportSource
         *        The source of the asset bundle zip file that contains the data that is imported by the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetBundleImportSource(AssetBundleImportSourceDescription assetBundleImportSource);

        /**
         * <p>
         * The source of the asset bundle zip file that contains the data that is imported by the job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AssetBundleImportSourceDescription.Builder} avoiding the need to create one manually via
         * {@link AssetBundleImportSourceDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetBundleImportSourceDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #assetBundleImportSource(AssetBundleImportSourceDescription)}.
         * 
         * @param assetBundleImportSource
         *        a consumer that will call methods on {@link AssetBundleImportSourceDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetBundleImportSource(AssetBundleImportSourceDescription)
         */
        default Builder assetBundleImportSource(Consumer<AssetBundleImportSourceDescription.Builder> assetBundleImportSource) {
            return assetBundleImportSource(AssetBundleImportSourceDescription.builder().applyMutation(assetBundleImportSource)
                    .build());
        }

        /**
         * <p>
         * Optional overrides to be applied to the resource configuration before import.
         * </p>
         * 
         * @param overrideParameters
         *        Optional overrides to be applied to the resource configuration before import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideParameters(AssetBundleImportJobOverrideParameters overrideParameters);

        /**
         * <p>
         * Optional overrides to be applied to the resource configuration before import.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AssetBundleImportJobOverrideParameters.Builder} avoiding the need to create one manually via
         * {@link AssetBundleImportJobOverrideParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetBundleImportJobOverrideParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #overrideParameters(AssetBundleImportJobOverrideParameters)}.
         * 
         * @param overrideParameters
         *        a consumer that will call methods on {@link AssetBundleImportJobOverrideParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrideParameters(AssetBundleImportJobOverrideParameters)
         */
        default Builder overrideParameters(Consumer<AssetBundleImportJobOverrideParameters.Builder> overrideParameters) {
            return overrideParameters(AssetBundleImportJobOverrideParameters.builder().applyMutation(overrideParameters).build());
        }

        /**
         * <p>
         * The failure action for the import job.
         * </p>
         * 
         * @param failureAction
         *        The failure action for the import job.
         * @see AssetBundleImportFailureAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetBundleImportFailureAction
         */
        Builder failureAction(String failureAction);

        /**
         * <p>
         * The failure action for the import job.
         * </p>
         * 
         * @param failureAction
         *        The failure action for the import job.
         * @see AssetBundleImportFailureAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetBundleImportFailureAction
         */
        Builder failureAction(AssetBundleImportFailureAction failureAction);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the response.
         * </p>
         * 
         * @param status
         *        The HTTP status of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String jobStatus;

        private List<AssetBundleImportJobError> errors = DefaultSdkAutoConstructList.getInstance();

        private List<AssetBundleImportJobError> rollbackErrors = DefaultSdkAutoConstructList.getInstance();

        private String arn;

        private Instant createdTime;

        private String assetBundleImportJobId;

        private String awsAccountId;

        private AssetBundleImportSourceDescription assetBundleImportSource;

        private AssetBundleImportJobOverrideParameters overrideParameters;

        private String failureAction;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssetBundleImportJobResponse model) {
            super(model);
            jobStatus(model.jobStatus);
            errors(model.errors);
            rollbackErrors(model.rollbackErrors);
            arn(model.arn);
            createdTime(model.createdTime);
            assetBundleImportJobId(model.assetBundleImportJobId);
            awsAccountId(model.awsAccountId);
            assetBundleImportSource(model.assetBundleImportSource);
            overrideParameters(model.overrideParameters);
            failureAction(model.failureAction);
            requestId(model.requestId);
            status(model.status);
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(AssetBundleImportJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final List<AssetBundleImportJobError.Builder> getErrors() {
            List<AssetBundleImportJobError.Builder> result = AssetBundleImportJobErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<AssetBundleImportJobError.BuilderImpl> errors) {
            this.errors = AssetBundleImportJobErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<AssetBundleImportJobError> errors) {
            this.errors = AssetBundleImportJobErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(AssetBundleImportJobError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<AssetBundleImportJobError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> AssetBundleImportJobError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleImportJobError.Builder> getRollbackErrors() {
            List<AssetBundleImportJobError.Builder> result = AssetBundleImportJobErrorListCopier
                    .copyToBuilder(this.rollbackErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRollbackErrors(Collection<AssetBundleImportJobError.BuilderImpl> rollbackErrors) {
            this.rollbackErrors = AssetBundleImportJobErrorListCopier.copyFromBuilder(rollbackErrors);
        }

        @Override
        public final Builder rollbackErrors(Collection<AssetBundleImportJobError> rollbackErrors) {
            this.rollbackErrors = AssetBundleImportJobErrorListCopier.copy(rollbackErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rollbackErrors(AssetBundleImportJobError... rollbackErrors) {
            rollbackErrors(Arrays.asList(rollbackErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rollbackErrors(Consumer<AssetBundleImportJobError.Builder>... rollbackErrors) {
            rollbackErrors(Stream.of(rollbackErrors).map(c -> AssetBundleImportJobError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getAssetBundleImportJobId() {
            return assetBundleImportJobId;
        }

        public final void setAssetBundleImportJobId(String assetBundleImportJobId) {
            this.assetBundleImportJobId = assetBundleImportJobId;
        }

        @Override
        public final Builder assetBundleImportJobId(String assetBundleImportJobId) {
            this.assetBundleImportJobId = assetBundleImportJobId;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final AssetBundleImportSourceDescription.Builder getAssetBundleImportSource() {
            return assetBundleImportSource != null ? assetBundleImportSource.toBuilder() : null;
        }

        public final void setAssetBundleImportSource(AssetBundleImportSourceDescription.BuilderImpl assetBundleImportSource) {
            this.assetBundleImportSource = assetBundleImportSource != null ? assetBundleImportSource.build() : null;
        }

        @Override
        public final Builder assetBundleImportSource(AssetBundleImportSourceDescription assetBundleImportSource) {
            this.assetBundleImportSource = assetBundleImportSource;
            return this;
        }

        public final AssetBundleImportJobOverrideParameters.Builder getOverrideParameters() {
            return overrideParameters != null ? overrideParameters.toBuilder() : null;
        }

        public final void setOverrideParameters(AssetBundleImportJobOverrideParameters.BuilderImpl overrideParameters) {
            this.overrideParameters = overrideParameters != null ? overrideParameters.build() : null;
        }

        @Override
        public final Builder overrideParameters(AssetBundleImportJobOverrideParameters overrideParameters) {
            this.overrideParameters = overrideParameters;
            return this;
        }

        public final String getFailureAction() {
            return failureAction;
        }

        public final void setFailureAction(String failureAction) {
            this.failureAction = failureAction;
        }

        @Override
        public final Builder failureAction(String failureAction) {
            this.failureAction = failureAction;
            return this;
        }

        @Override
        public final Builder failureAction(AssetBundleImportFailureAction failureAction) {
            this.failureAction(failureAction == null ? null : failureAction.toString());
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public DescribeAssetBundleImportJobResponse build() {
            return new DescribeAssetBundleImportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
