/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSet implements SdkPojo, Serializable, ToCopyableBuilder<DataSet.Builder, DataSet> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DataSet::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetId").getter(getter(DataSet::dataSetId)).setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DataSet::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(DataSet::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(DataSet::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<Map<String, PhysicalTable>> PHYSICAL_TABLE_MAP_FIELD = SdkField
            .<Map<String, PhysicalTable>> builder(MarshallingType.MAP)
            .memberName("PhysicalTableMap")
            .getter(getter(DataSet::physicalTableMap))
            .setter(setter(Builder::physicalTableMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalTableMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<PhysicalTable> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhysicalTable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, LogicalTable>> LOGICAL_TABLE_MAP_FIELD = SdkField
            .<Map<String, LogicalTable>> builder(MarshallingType.MAP)
            .memberName("LogicalTableMap")
            .getter(getter(DataSet::logicalTableMap))
            .setter(setter(Builder::logicalTableMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalTableMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<LogicalTable> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogicalTable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<OutputColumn>> OUTPUT_COLUMNS_FIELD = SdkField
            .<List<OutputColumn>> builder(MarshallingType.LIST)
            .memberName("OutputColumns")
            .getter(getter(DataSet::outputColumns))
            .setter(setter(Builder::outputColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputColumn> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputColumn::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IMPORT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImportMode").getter(getter(DataSet::importModeAsString)).setter(setter(Builder::importMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportMode").build()).build();

    private static final SdkField<Long> CONSUMED_SPICE_CAPACITY_IN_BYTES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ConsumedSpiceCapacityInBytes")
            .getter(getter(DataSet::consumedSpiceCapacityInBytes))
            .setter(setter(Builder::consumedSpiceCapacityInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedSpiceCapacityInBytes")
                    .build()).build();

    private static final SdkField<List<ColumnGroup>> COLUMN_GROUPS_FIELD = SdkField
            .<List<ColumnGroup>> builder(MarshallingType.LIST)
            .memberName("ColumnGroups")
            .getter(getter(DataSet::columnGroups))
            .setter(setter(Builder::columnGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, FieldFolder>> FIELD_FOLDERS_FIELD = SdkField
            .<Map<String, FieldFolder>> builder(MarshallingType.MAP)
            .memberName("FieldFolders")
            .getter(getter(DataSet::fieldFolders))
            .setter(setter(Builder::fieldFolders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldFolders").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<FieldFolder> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldFolder::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<RowLevelPermissionDataSet> ROW_LEVEL_PERMISSION_DATA_SET_FIELD = SdkField
            .<RowLevelPermissionDataSet> builder(MarshallingType.SDK_POJO).memberName("RowLevelPermissionDataSet")
            .getter(getter(DataSet::rowLevelPermissionDataSet)).setter(setter(Builder::rowLevelPermissionDataSet))
            .constructor(RowLevelPermissionDataSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowLevelPermissionDataSet").build())
            .build();

    private static final SdkField<RowLevelPermissionTagConfiguration> ROW_LEVEL_PERMISSION_TAG_CONFIGURATION_FIELD = SdkField
            .<RowLevelPermissionTagConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("RowLevelPermissionTagConfiguration")
            .getter(getter(DataSet::rowLevelPermissionTagConfiguration))
            .setter(setter(Builder::rowLevelPermissionTagConfiguration))
            .constructor(RowLevelPermissionTagConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowLevelPermissionTagConfiguration")
                    .build()).build();

    private static final SdkField<List<ColumnLevelPermissionRule>> COLUMN_LEVEL_PERMISSION_RULES_FIELD = SdkField
            .<List<ColumnLevelPermissionRule>> builder(MarshallingType.LIST)
            .memberName("ColumnLevelPermissionRules")
            .getter(getter(DataSet::columnLevelPermissionRules))
            .setter(setter(Builder::columnLevelPermissionRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnLevelPermissionRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnLevelPermissionRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnLevelPermissionRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DataSetUsageConfiguration> DATA_SET_USAGE_CONFIGURATION_FIELD = SdkField
            .<DataSetUsageConfiguration> builder(MarshallingType.SDK_POJO).memberName("DataSetUsageConfiguration")
            .getter(getter(DataSet::dataSetUsageConfiguration)).setter(setter(Builder::dataSetUsageConfiguration))
            .constructor(DataSetUsageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetUsageConfiguration").build())
            .build();

    private static final SdkField<List<DatasetParameter>> DATASET_PARAMETERS_FIELD = SdkField
            .<List<DatasetParameter>> builder(MarshallingType.LIST)
            .memberName("DatasetParameters")
            .getter(getter(DataSet::datasetParameters))
            .setter(setter(Builder::datasetParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatasetParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatasetParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DATA_SET_ID_FIELD,
            NAME_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, PHYSICAL_TABLE_MAP_FIELD, LOGICAL_TABLE_MAP_FIELD,
            OUTPUT_COLUMNS_FIELD, IMPORT_MODE_FIELD, CONSUMED_SPICE_CAPACITY_IN_BYTES_FIELD, COLUMN_GROUPS_FIELD,
            FIELD_FOLDERS_FIELD, ROW_LEVEL_PERMISSION_DATA_SET_FIELD, ROW_LEVEL_PERMISSION_TAG_CONFIGURATION_FIELD,
            COLUMN_LEVEL_PERMISSION_RULES_FIELD, DATA_SET_USAGE_CONFIGURATION_FIELD, DATASET_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String dataSetId;

    private final String name;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private final Map<String, PhysicalTable> physicalTableMap;

    private final Map<String, LogicalTable> logicalTableMap;

    private final List<OutputColumn> outputColumns;

    private final String importMode;

    private final Long consumedSpiceCapacityInBytes;

    private final List<ColumnGroup> columnGroups;

    private final Map<String, FieldFolder> fieldFolders;

    private final RowLevelPermissionDataSet rowLevelPermissionDataSet;

    private final RowLevelPermissionTagConfiguration rowLevelPermissionTagConfiguration;

    private final List<ColumnLevelPermissionRule> columnLevelPermissionRules;

    private final DataSetUsageConfiguration dataSetUsageConfiguration;

    private final List<DatasetParameter> datasetParameters;

    private DataSet(BuilderImpl builder) {
        this.arn = builder.arn;
        this.dataSetId = builder.dataSetId;
        this.name = builder.name;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.physicalTableMap = builder.physicalTableMap;
        this.logicalTableMap = builder.logicalTableMap;
        this.outputColumns = builder.outputColumns;
        this.importMode = builder.importMode;
        this.consumedSpiceCapacityInBytes = builder.consumedSpiceCapacityInBytes;
        this.columnGroups = builder.columnGroups;
        this.fieldFolders = builder.fieldFolders;
        this.rowLevelPermissionDataSet = builder.rowLevelPermissionDataSet;
        this.rowLevelPermissionTagConfiguration = builder.rowLevelPermissionTagConfiguration;
        this.columnLevelPermissionRules = builder.columnLevelPermissionRules;
        this.dataSetUsageConfiguration = builder.dataSetUsageConfiguration;
        this.datasetParameters = builder.datasetParameters;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the dataset.
     * </p>
     * 
     * @return The ID of the dataset.
     */
    public final String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * A display name for the dataset.
     * </p>
     * 
     * @return A display name for the dataset.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The time that this dataset was created.
     * </p>
     * 
     * @return The time that this dataset was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The last time that this dataset was updated.
     * </p>
     * 
     * @return The last time that this dataset was updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the PhysicalTableMap property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPhysicalTableMap() {
        return physicalTableMap != null && !(physicalTableMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Declares the physical tables that are available in the underlying data sources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhysicalTableMap} method.
     * </p>
     * 
     * @return Declares the physical tables that are available in the underlying data sources.
     */
    public final Map<String, PhysicalTable> physicalTableMap() {
        return physicalTableMap;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogicalTableMap property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogicalTableMap() {
        return logicalTableMap != null && !(logicalTableMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Configures the combination and transformation of the data from the physical tables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogicalTableMap} method.
     * </p>
     * 
     * @return Configures the combination and transformation of the data from the physical tables.
     */
    public final Map<String, LogicalTable> logicalTableMap() {
        return logicalTableMap;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputColumns() {
        return outputColumns != null && !(outputColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of columns after all transforms. These columns are available in templates, analyses, and dashboards.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputColumns} method.
     * </p>
     * 
     * @return The list of columns after all transforms. These columns are available in templates, analyses, and
     *         dashboards.
     */
    public final List<OutputColumn> outputColumns() {
        return outputColumns;
    }

    /**
     * <p>
     * A value that indicates whether you want to import the data into SPICE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importMode} will
     * return {@link DataSetImportMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importModeAsString}.
     * </p>
     * 
     * @return A value that indicates whether you want to import the data into SPICE.
     * @see DataSetImportMode
     */
    public final DataSetImportMode importMode() {
        return DataSetImportMode.fromValue(importMode);
    }

    /**
     * <p>
     * A value that indicates whether you want to import the data into SPICE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importMode} will
     * return {@link DataSetImportMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importModeAsString}.
     * </p>
     * 
     * @return A value that indicates whether you want to import the data into SPICE.
     * @see DataSetImportMode
     */
    public final String importModeAsString() {
        return importMode;
    }

    /**
     * <p>
     * The amount of SPICE capacity used by this dataset. This is 0 if the dataset isn't imported into SPICE.
     * </p>
     * 
     * @return The amount of SPICE capacity used by this dataset. This is 0 if the dataset isn't imported into SPICE.
     */
    public final Long consumedSpiceCapacityInBytes() {
        return consumedSpiceCapacityInBytes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasColumnGroups() {
        return columnGroups != null && !(columnGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial
     * hierarchy is supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnGroups} method.
     * </p>
     * 
     * @return Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial
     *         hierarchy is supported.
     */
    public final List<ColumnGroup> columnGroups() {
        return columnGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldFolders property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFieldFolders() {
        return fieldFolders != null && !(fieldFolders instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The folder that contains fields and nested subfolders for your dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldFolders} method.
     * </p>
     * 
     * @return The folder that contains fields and nested subfolders for your dataset.
     */
    public final Map<String, FieldFolder> fieldFolders() {
        return fieldFolders;
    }

    /**
     * <p>
     * The row-level security configuration for the dataset.
     * </p>
     * 
     * @return The row-level security configuration for the dataset.
     */
    public final RowLevelPermissionDataSet rowLevelPermissionDataSet() {
        return rowLevelPermissionDataSet;
    }

    /**
     * <p>
     * The element you can use to define tags for row-level security.
     * </p>
     * 
     * @return The element you can use to define tags for row-level security.
     */
    public final RowLevelPermissionTagConfiguration rowLevelPermissionTagConfiguration() {
        return rowLevelPermissionTagConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnLevelPermissionRules property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasColumnLevelPermissionRules() {
        return columnLevelPermissionRules != null && !(columnLevelPermissionRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of one or more definitions of a
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>
     * .
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnLevelPermissionRules} method.
     * </p>
     * 
     * @return A set of one or more definitions of a
     *         <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>
     *         .
     */
    public final List<ColumnLevelPermissionRule> columnLevelPermissionRules() {
        return columnLevelPermissionRules;
    }

    /**
     * <p>
     * The usage configuration to apply to child datasets that reference this dataset as a source.
     * </p>
     * 
     * @return The usage configuration to apply to child datasets that reference this dataset as a source.
     */
    public final DataSetUsageConfiguration dataSetUsageConfiguration() {
        return dataSetUsageConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the DatasetParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDatasetParameters() {
        return datasetParameters != null && !(datasetParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameters that are declared in a dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatasetParameters} method.
     * </p>
     * 
     * @return The parameters that are declared in a dataset.
     */
    public final List<DatasetParameter> datasetParameters() {
        return datasetParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasPhysicalTableMap() ? physicalTableMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLogicalTableMap() ? logicalTableMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputColumns() ? outputColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(importModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(consumedSpiceCapacityInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnGroups() ? columnGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldFolders() ? fieldFolders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(rowLevelPermissionDataSet());
        hashCode = 31 * hashCode + Objects.hashCode(rowLevelPermissionTagConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnLevelPermissionRules() ? columnLevelPermissionRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataSetUsageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasDatasetParameters() ? datasetParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSet)) {
            return false;
        }
        DataSet other = (DataSet) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(dataSetId(), other.dataSetId())
                && Objects.equals(name(), other.name()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && hasPhysicalTableMap() == other.hasPhysicalTableMap()
                && Objects.equals(physicalTableMap(), other.physicalTableMap())
                && hasLogicalTableMap() == other.hasLogicalTableMap()
                && Objects.equals(logicalTableMap(), other.logicalTableMap()) && hasOutputColumns() == other.hasOutputColumns()
                && Objects.equals(outputColumns(), other.outputColumns())
                && Objects.equals(importModeAsString(), other.importModeAsString())
                && Objects.equals(consumedSpiceCapacityInBytes(), other.consumedSpiceCapacityInBytes())
                && hasColumnGroups() == other.hasColumnGroups() && Objects.equals(columnGroups(), other.columnGroups())
                && hasFieldFolders() == other.hasFieldFolders() && Objects.equals(fieldFolders(), other.fieldFolders())
                && Objects.equals(rowLevelPermissionDataSet(), other.rowLevelPermissionDataSet())
                && Objects.equals(rowLevelPermissionTagConfiguration(), other.rowLevelPermissionTagConfiguration())
                && hasColumnLevelPermissionRules() == other.hasColumnLevelPermissionRules()
                && Objects.equals(columnLevelPermissionRules(), other.columnLevelPermissionRules())
                && Objects.equals(dataSetUsageConfiguration(), other.dataSetUsageConfiguration())
                && hasDatasetParameters() == other.hasDatasetParameters()
                && Objects.equals(datasetParameters(), other.datasetParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSet").add("Arn", arn()).add("DataSetId", dataSetId()).add("Name", name())
                .add("CreatedTime", createdTime()).add("LastUpdatedTime", lastUpdatedTime())
                .add("PhysicalTableMap", hasPhysicalTableMap() ? physicalTableMap() : null)
                .add("LogicalTableMap", hasLogicalTableMap() ? logicalTableMap() : null)
                .add("OutputColumns", hasOutputColumns() ? outputColumns() : null).add("ImportMode", importModeAsString())
                .add("ConsumedSpiceCapacityInBytes", consumedSpiceCapacityInBytes())
                .add("ColumnGroups", hasColumnGroups() ? columnGroups() : null)
                .add("FieldFolders", hasFieldFolders() ? fieldFolders() : null)
                .add("RowLevelPermissionDataSet", rowLevelPermissionDataSet())
                .add("RowLevelPermissionTagConfiguration", rowLevelPermissionTagConfiguration())
                .add("ColumnLevelPermissionRules", hasColumnLevelPermissionRules() ? columnLevelPermissionRules() : null)
                .add("DataSetUsageConfiguration", dataSetUsageConfiguration())
                .add("DatasetParameters", hasDatasetParameters() ? datasetParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "PhysicalTableMap":
            return Optional.ofNullable(clazz.cast(physicalTableMap()));
        case "LogicalTableMap":
            return Optional.ofNullable(clazz.cast(logicalTableMap()));
        case "OutputColumns":
            return Optional.ofNullable(clazz.cast(outputColumns()));
        case "ImportMode":
            return Optional.ofNullable(clazz.cast(importModeAsString()));
        case "ConsumedSpiceCapacityInBytes":
            return Optional.ofNullable(clazz.cast(consumedSpiceCapacityInBytes()));
        case "ColumnGroups":
            return Optional.ofNullable(clazz.cast(columnGroups()));
        case "FieldFolders":
            return Optional.ofNullable(clazz.cast(fieldFolders()));
        case "RowLevelPermissionDataSet":
            return Optional.ofNullable(clazz.cast(rowLevelPermissionDataSet()));
        case "RowLevelPermissionTagConfiguration":
            return Optional.ofNullable(clazz.cast(rowLevelPermissionTagConfiguration()));
        case "ColumnLevelPermissionRules":
            return Optional.ofNullable(clazz.cast(columnLevelPermissionRules()));
        case "DataSetUsageConfiguration":
            return Optional.ofNullable(clazz.cast(dataSetUsageConfiguration()));
        case "DatasetParameters":
            return Optional.ofNullable(clazz.cast(datasetParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSet, T> g) {
        return obj -> g.apply((DataSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSet> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the dataset.
         * </p>
         * 
         * @param dataSetId
         *        The ID of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * A display name for the dataset.
         * </p>
         * 
         * @param name
         *        A display name for the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time that this dataset was created.
         * </p>
         * 
         * @param createdTime
         *        The time that this dataset was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The last time that this dataset was updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The last time that this dataset was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * Declares the physical tables that are available in the underlying data sources.
         * </p>
         * 
         * @param physicalTableMap
         *        Declares the physical tables that are available in the underlying data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalTableMap(Map<String, PhysicalTable> physicalTableMap);

        /**
         * <p>
         * Configures the combination and transformation of the data from the physical tables.
         * </p>
         * 
         * @param logicalTableMap
         *        Configures the combination and transformation of the data from the physical tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalTableMap(Map<String, LogicalTable> logicalTableMap);

        /**
         * <p>
         * The list of columns after all transforms. These columns are available in templates, analyses, and dashboards.
         * </p>
         * 
         * @param outputColumns
         *        The list of columns after all transforms. These columns are available in templates, analyses, and
         *        dashboards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputColumns(Collection<OutputColumn> outputColumns);

        /**
         * <p>
         * The list of columns after all transforms. These columns are available in templates, analyses, and dashboards.
         * </p>
         * 
         * @param outputColumns
         *        The list of columns after all transforms. These columns are available in templates, analyses, and
         *        dashboards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputColumns(OutputColumn... outputColumns);

        /**
         * <p>
         * The list of columns after all transforms. These columns are available in templates, analyses, and dashboards.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.OutputColumn.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.OutputColumn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.OutputColumn.Builder#build()} is called immediately
         * and its result is passed to {@link #outputColumns(List<OutputColumn>)}.
         * 
         * @param outputColumns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.OutputColumn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputColumns(java.util.Collection<OutputColumn>)
         */
        Builder outputColumns(Consumer<OutputColumn.Builder>... outputColumns);

        /**
         * <p>
         * A value that indicates whether you want to import the data into SPICE.
         * </p>
         * 
         * @param importMode
         *        A value that indicates whether you want to import the data into SPICE.
         * @see DataSetImportMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSetImportMode
         */
        Builder importMode(String importMode);

        /**
         * <p>
         * A value that indicates whether you want to import the data into SPICE.
         * </p>
         * 
         * @param importMode
         *        A value that indicates whether you want to import the data into SPICE.
         * @see DataSetImportMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSetImportMode
         */
        Builder importMode(DataSetImportMode importMode);

        /**
         * <p>
         * The amount of SPICE capacity used by this dataset. This is 0 if the dataset isn't imported into SPICE.
         * </p>
         * 
         * @param consumedSpiceCapacityInBytes
         *        The amount of SPICE capacity used by this dataset. This is 0 if the dataset isn't imported into SPICE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedSpiceCapacityInBytes(Long consumedSpiceCapacityInBytes);

        /**
         * <p>
         * Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial
         * hierarchy is supported.
         * </p>
         * 
         * @param columnGroups
         *        Groupings of columns that work together in certain Amazon QuickSight features. Currently, only
         *        geospatial hierarchy is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnGroups(Collection<ColumnGroup> columnGroups);

        /**
         * <p>
         * Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial
         * hierarchy is supported.
         * </p>
         * 
         * @param columnGroups
         *        Groupings of columns that work together in certain Amazon QuickSight features. Currently, only
         *        geospatial hierarchy is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnGroups(ColumnGroup... columnGroups);

        /**
         * <p>
         * Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial
         * hierarchy is supported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ColumnGroup.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.ColumnGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ColumnGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #columnGroups(List<ColumnGroup>)}.
         * 
         * @param columnGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ColumnGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnGroups(java.util.Collection<ColumnGroup>)
         */
        Builder columnGroups(Consumer<ColumnGroup.Builder>... columnGroups);

        /**
         * <p>
         * The folder that contains fields and nested subfolders for your dataset.
         * </p>
         * 
         * @param fieldFolders
         *        The folder that contains fields and nested subfolders for your dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldFolders(Map<String, FieldFolder> fieldFolders);

        /**
         * <p>
         * The row-level security configuration for the dataset.
         * </p>
         * 
         * @param rowLevelPermissionDataSet
         *        The row-level security configuration for the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowLevelPermissionDataSet(RowLevelPermissionDataSet rowLevelPermissionDataSet);

        /**
         * <p>
         * The row-level security configuration for the dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link RowLevelPermissionDataSet.Builder}
         * avoiding the need to create one manually via {@link RowLevelPermissionDataSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RowLevelPermissionDataSet.Builder#build()} is called immediately
         * and its result is passed to {@link #rowLevelPermissionDataSet(RowLevelPermissionDataSet)}.
         * 
         * @param rowLevelPermissionDataSet
         *        a consumer that will call methods on {@link RowLevelPermissionDataSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowLevelPermissionDataSet(RowLevelPermissionDataSet)
         */
        default Builder rowLevelPermissionDataSet(Consumer<RowLevelPermissionDataSet.Builder> rowLevelPermissionDataSet) {
            return rowLevelPermissionDataSet(RowLevelPermissionDataSet.builder().applyMutation(rowLevelPermissionDataSet).build());
        }

        /**
         * <p>
         * The element you can use to define tags for row-level security.
         * </p>
         * 
         * @param rowLevelPermissionTagConfiguration
         *        The element you can use to define tags for row-level security.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowLevelPermissionTagConfiguration(RowLevelPermissionTagConfiguration rowLevelPermissionTagConfiguration);

        /**
         * <p>
         * The element you can use to define tags for row-level security.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RowLevelPermissionTagConfiguration.Builder} avoiding the need to create one manually via
         * {@link RowLevelPermissionTagConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RowLevelPermissionTagConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #rowLevelPermissionTagConfiguration(RowLevelPermissionTagConfiguration)}.
         * 
         * @param rowLevelPermissionTagConfiguration
         *        a consumer that will call methods on {@link RowLevelPermissionTagConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowLevelPermissionTagConfiguration(RowLevelPermissionTagConfiguration)
         */
        default Builder rowLevelPermissionTagConfiguration(
                Consumer<RowLevelPermissionTagConfiguration.Builder> rowLevelPermissionTagConfiguration) {
            return rowLevelPermissionTagConfiguration(RowLevelPermissionTagConfiguration.builder()
                    .applyMutation(rowLevelPermissionTagConfiguration).build());
        }

        /**
         * <p>
         * A set of one or more definitions of a
         * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>
         * .
         * </p>
         * 
         * @param columnLevelPermissionRules
         *        A set of one or more definitions of a
         *        <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnLevelPermissionRules(Collection<ColumnLevelPermissionRule> columnLevelPermissionRules);

        /**
         * <p>
         * A set of one or more definitions of a
         * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>
         * .
         * </p>
         * 
         * @param columnLevelPermissionRules
         *        A set of one or more definitions of a
         *        <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnLevelPermissionRules(ColumnLevelPermissionRule... columnLevelPermissionRules);

        /**
         * <p>
         * A set of one or more definitions of a
         * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html">ColumnLevelPermissionRule</a> </code>
         * .
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ColumnLevelPermissionRule.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.ColumnLevelPermissionRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ColumnLevelPermissionRule.Builder#build()} is called
         * immediately and its result is passed to {@link #columnLevelPermissionRules(List<ColumnLevelPermissionRule>)}.
         * 
         * @param columnLevelPermissionRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ColumnLevelPermissionRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnLevelPermissionRules(java.util.Collection<ColumnLevelPermissionRule>)
         */
        Builder columnLevelPermissionRules(Consumer<ColumnLevelPermissionRule.Builder>... columnLevelPermissionRules);

        /**
         * <p>
         * The usage configuration to apply to child datasets that reference this dataset as a source.
         * </p>
         * 
         * @param dataSetUsageConfiguration
         *        The usage configuration to apply to child datasets that reference this dataset as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetUsageConfiguration(DataSetUsageConfiguration dataSetUsageConfiguration);

        /**
         * <p>
         * The usage configuration to apply to child datasets that reference this dataset as a source.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSetUsageConfiguration.Builder}
         * avoiding the need to create one manually via {@link DataSetUsageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSetUsageConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #dataSetUsageConfiguration(DataSetUsageConfiguration)}.
         * 
         * @param dataSetUsageConfiguration
         *        a consumer that will call methods on {@link DataSetUsageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSetUsageConfiguration(DataSetUsageConfiguration)
         */
        default Builder dataSetUsageConfiguration(Consumer<DataSetUsageConfiguration.Builder> dataSetUsageConfiguration) {
            return dataSetUsageConfiguration(DataSetUsageConfiguration.builder().applyMutation(dataSetUsageConfiguration).build());
        }

        /**
         * <p>
         * The parameters that are declared in a dataset.
         * </p>
         * 
         * @param datasetParameters
         *        The parameters that are declared in a dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetParameters(Collection<DatasetParameter> datasetParameters);

        /**
         * <p>
         * The parameters that are declared in a dataset.
         * </p>
         * 
         * @param datasetParameters
         *        The parameters that are declared in a dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetParameters(DatasetParameter... datasetParameters);

        /**
         * <p>
         * The parameters that are declared in a dataset.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DatasetParameter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.DatasetParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DatasetParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #datasetParameters(List<DatasetParameter>)}.
         * 
         * @param datasetParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DatasetParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetParameters(java.util.Collection<DatasetParameter>)
         */
        Builder datasetParameters(Consumer<DatasetParameter.Builder>... datasetParameters);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String dataSetId;

        private String name;

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private Map<String, PhysicalTable> physicalTableMap = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, LogicalTable> logicalTableMap = DefaultSdkAutoConstructMap.getInstance();

        private List<OutputColumn> outputColumns = DefaultSdkAutoConstructList.getInstance();

        private String importMode;

        private Long consumedSpiceCapacityInBytes;

        private List<ColumnGroup> columnGroups = DefaultSdkAutoConstructList.getInstance();

        private Map<String, FieldFolder> fieldFolders = DefaultSdkAutoConstructMap.getInstance();

        private RowLevelPermissionDataSet rowLevelPermissionDataSet;

        private RowLevelPermissionTagConfiguration rowLevelPermissionTagConfiguration;

        private List<ColumnLevelPermissionRule> columnLevelPermissionRules = DefaultSdkAutoConstructList.getInstance();

        private DataSetUsageConfiguration dataSetUsageConfiguration;

        private List<DatasetParameter> datasetParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataSet model) {
            arn(model.arn);
            dataSetId(model.dataSetId);
            name(model.name);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
            physicalTableMap(model.physicalTableMap);
            logicalTableMap(model.logicalTableMap);
            outputColumns(model.outputColumns);
            importMode(model.importMode);
            consumedSpiceCapacityInBytes(model.consumedSpiceCapacityInBytes);
            columnGroups(model.columnGroups);
            fieldFolders(model.fieldFolders);
            rowLevelPermissionDataSet(model.rowLevelPermissionDataSet);
            rowLevelPermissionTagConfiguration(model.rowLevelPermissionTagConfiguration);
            columnLevelPermissionRules(model.columnLevelPermissionRules);
            dataSetUsageConfiguration(model.dataSetUsageConfiguration);
            datasetParameters(model.datasetParameters);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Map<String, PhysicalTable.Builder> getPhysicalTableMap() {
            Map<String, PhysicalTable.Builder> result = PhysicalTableMapCopier.copyToBuilder(this.physicalTableMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPhysicalTableMap(Map<String, PhysicalTable.BuilderImpl> physicalTableMap) {
            this.physicalTableMap = PhysicalTableMapCopier.copyFromBuilder(physicalTableMap);
        }

        @Override
        public final Builder physicalTableMap(Map<String, PhysicalTable> physicalTableMap) {
            this.physicalTableMap = PhysicalTableMapCopier.copy(physicalTableMap);
            return this;
        }

        public final Map<String, LogicalTable.Builder> getLogicalTableMap() {
            Map<String, LogicalTable.Builder> result = LogicalTableMapCopier.copyToBuilder(this.logicalTableMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setLogicalTableMap(Map<String, LogicalTable.BuilderImpl> logicalTableMap) {
            this.logicalTableMap = LogicalTableMapCopier.copyFromBuilder(logicalTableMap);
        }

        @Override
        public final Builder logicalTableMap(Map<String, LogicalTable> logicalTableMap) {
            this.logicalTableMap = LogicalTableMapCopier.copy(logicalTableMap);
            return this;
        }

        public final List<OutputColumn.Builder> getOutputColumns() {
            List<OutputColumn.Builder> result = OutputColumnListCopier.copyToBuilder(this.outputColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputColumns(Collection<OutputColumn.BuilderImpl> outputColumns) {
            this.outputColumns = OutputColumnListCopier.copyFromBuilder(outputColumns);
        }

        @Override
        public final Builder outputColumns(Collection<OutputColumn> outputColumns) {
            this.outputColumns = OutputColumnListCopier.copy(outputColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputColumns(OutputColumn... outputColumns) {
            outputColumns(Arrays.asList(outputColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputColumns(Consumer<OutputColumn.Builder>... outputColumns) {
            outputColumns(Stream.of(outputColumns).map(c -> OutputColumn.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getImportMode() {
            return importMode;
        }

        public final void setImportMode(String importMode) {
            this.importMode = importMode;
        }

        @Override
        public final Builder importMode(String importMode) {
            this.importMode = importMode;
            return this;
        }

        @Override
        public final Builder importMode(DataSetImportMode importMode) {
            this.importMode(importMode == null ? null : importMode.toString());
            return this;
        }

        public final Long getConsumedSpiceCapacityInBytes() {
            return consumedSpiceCapacityInBytes;
        }

        public final void setConsumedSpiceCapacityInBytes(Long consumedSpiceCapacityInBytes) {
            this.consumedSpiceCapacityInBytes = consumedSpiceCapacityInBytes;
        }

        @Override
        public final Builder consumedSpiceCapacityInBytes(Long consumedSpiceCapacityInBytes) {
            this.consumedSpiceCapacityInBytes = consumedSpiceCapacityInBytes;
            return this;
        }

        public final List<ColumnGroup.Builder> getColumnGroups() {
            List<ColumnGroup.Builder> result = ColumnGroupListCopier.copyToBuilder(this.columnGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnGroups(Collection<ColumnGroup.BuilderImpl> columnGroups) {
            this.columnGroups = ColumnGroupListCopier.copyFromBuilder(columnGroups);
        }

        @Override
        public final Builder columnGroups(Collection<ColumnGroup> columnGroups) {
            this.columnGroups = ColumnGroupListCopier.copy(columnGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnGroups(ColumnGroup... columnGroups) {
            columnGroups(Arrays.asList(columnGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnGroups(Consumer<ColumnGroup.Builder>... columnGroups) {
            columnGroups(Stream.of(columnGroups).map(c -> ColumnGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, FieldFolder.Builder> getFieldFolders() {
            Map<String, FieldFolder.Builder> result = FieldFolderMapCopier.copyToBuilder(this.fieldFolders);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFieldFolders(Map<String, FieldFolder.BuilderImpl> fieldFolders) {
            this.fieldFolders = FieldFolderMapCopier.copyFromBuilder(fieldFolders);
        }

        @Override
        public final Builder fieldFolders(Map<String, FieldFolder> fieldFolders) {
            this.fieldFolders = FieldFolderMapCopier.copy(fieldFolders);
            return this;
        }

        public final RowLevelPermissionDataSet.Builder getRowLevelPermissionDataSet() {
            return rowLevelPermissionDataSet != null ? rowLevelPermissionDataSet.toBuilder() : null;
        }

        public final void setRowLevelPermissionDataSet(RowLevelPermissionDataSet.BuilderImpl rowLevelPermissionDataSet) {
            this.rowLevelPermissionDataSet = rowLevelPermissionDataSet != null ? rowLevelPermissionDataSet.build() : null;
        }

        @Override
        public final Builder rowLevelPermissionDataSet(RowLevelPermissionDataSet rowLevelPermissionDataSet) {
            this.rowLevelPermissionDataSet = rowLevelPermissionDataSet;
            return this;
        }

        public final RowLevelPermissionTagConfiguration.Builder getRowLevelPermissionTagConfiguration() {
            return rowLevelPermissionTagConfiguration != null ? rowLevelPermissionTagConfiguration.toBuilder() : null;
        }

        public final void setRowLevelPermissionTagConfiguration(
                RowLevelPermissionTagConfiguration.BuilderImpl rowLevelPermissionTagConfiguration) {
            this.rowLevelPermissionTagConfiguration = rowLevelPermissionTagConfiguration != null ? rowLevelPermissionTagConfiguration
                    .build() : null;
        }

        @Override
        public final Builder rowLevelPermissionTagConfiguration(
                RowLevelPermissionTagConfiguration rowLevelPermissionTagConfiguration) {
            this.rowLevelPermissionTagConfiguration = rowLevelPermissionTagConfiguration;
            return this;
        }

        public final List<ColumnLevelPermissionRule.Builder> getColumnLevelPermissionRules() {
            List<ColumnLevelPermissionRule.Builder> result = ColumnLevelPermissionRuleListCopier
                    .copyToBuilder(this.columnLevelPermissionRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnLevelPermissionRules(
                Collection<ColumnLevelPermissionRule.BuilderImpl> columnLevelPermissionRules) {
            this.columnLevelPermissionRules = ColumnLevelPermissionRuleListCopier.copyFromBuilder(columnLevelPermissionRules);
        }

        @Override
        public final Builder columnLevelPermissionRules(Collection<ColumnLevelPermissionRule> columnLevelPermissionRules) {
            this.columnLevelPermissionRules = ColumnLevelPermissionRuleListCopier.copy(columnLevelPermissionRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnLevelPermissionRules(ColumnLevelPermissionRule... columnLevelPermissionRules) {
            columnLevelPermissionRules(Arrays.asList(columnLevelPermissionRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnLevelPermissionRules(Consumer<ColumnLevelPermissionRule.Builder>... columnLevelPermissionRules) {
            columnLevelPermissionRules(Stream.of(columnLevelPermissionRules)
                    .map(c -> ColumnLevelPermissionRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final DataSetUsageConfiguration.Builder getDataSetUsageConfiguration() {
            return dataSetUsageConfiguration != null ? dataSetUsageConfiguration.toBuilder() : null;
        }

        public final void setDataSetUsageConfiguration(DataSetUsageConfiguration.BuilderImpl dataSetUsageConfiguration) {
            this.dataSetUsageConfiguration = dataSetUsageConfiguration != null ? dataSetUsageConfiguration.build() : null;
        }

        @Override
        public final Builder dataSetUsageConfiguration(DataSetUsageConfiguration dataSetUsageConfiguration) {
            this.dataSetUsageConfiguration = dataSetUsageConfiguration;
            return this;
        }

        public final List<DatasetParameter.Builder> getDatasetParameters() {
            List<DatasetParameter.Builder> result = DatasetParameterListCopier.copyToBuilder(this.datasetParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatasetParameters(Collection<DatasetParameter.BuilderImpl> datasetParameters) {
            this.datasetParameters = DatasetParameterListCopier.copyFromBuilder(datasetParameters);
        }

        @Override
        public final Builder datasetParameters(Collection<DatasetParameter> datasetParameters) {
            this.datasetParameters = DatasetParameterListCopier.copy(datasetParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetParameters(DatasetParameter... datasetParameters) {
            datasetParameters(Arrays.asList(datasetParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetParameters(Consumer<DatasetParameter.Builder>... datasetParameters) {
            datasetParameters(Stream.of(datasetParameters).map(c -> DatasetParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DataSet build() {
            return new DataSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
