/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Determines the color that is applied to a particular data value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataColor implements SdkPojo, Serializable, ToCopyableBuilder<DataColor.Builder, DataColor> {
    private static final SdkField<String> COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Color")
            .getter(getter(DataColor::color)).setter(setter(Builder::color))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Color").build()).build();

    private static final SdkField<Double> DATA_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("DataValue").getter(getter(DataColor::dataValue)).setter(setter(Builder::dataValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(COLOR_FIELD, DATA_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String color;

    private final Double dataValue;

    private DataColor(BuilderImpl builder) {
        this.color = builder.color;
        this.dataValue = builder.dataValue;
    }

    /**
     * <p>
     * The color that is applied to the data value.
     * </p>
     * 
     * @return The color that is applied to the data value.
     */
    public final String color() {
        return color;
    }

    /**
     * <p>
     * The data value that the color is applied to.
     * </p>
     * 
     * @return The data value that the color is applied to.
     */
    public final Double dataValue() {
        return dataValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(color());
        hashCode = 31 * hashCode + Objects.hashCode(dataValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataColor)) {
            return false;
        }
        DataColor other = (DataColor) obj;
        return Objects.equals(color(), other.color()) && Objects.equals(dataValue(), other.dataValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataColor").add("Color", color()).add("DataValue", dataValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Color":
            return Optional.ofNullable(clazz.cast(color()));
        case "DataValue":
            return Optional.ofNullable(clazz.cast(dataValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataColor, T> g) {
        return obj -> g.apply((DataColor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataColor> {
        /**
         * <p>
         * The color that is applied to the data value.
         * </p>
         * 
         * @param color
         *        The color that is applied to the data value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder color(String color);

        /**
         * <p>
         * The data value that the color is applied to.
         * </p>
         * 
         * @param dataValue
         *        The data value that the color is applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataValue(Double dataValue);
    }

    static final class BuilderImpl implements Builder {
        private String color;

        private Double dataValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DataColor model) {
            color(model.color);
            dataValue(model.dataValue);
        }

        public final String getColor() {
            return color;
        }

        public final void setColor(String color) {
            this.color = color;
        }

        @Override
        public final Builder color(String color) {
            this.color = color;
            return this;
        }

        public final Double getDataValue() {
            return dataValue;
        }

        public final void setDataValue(Double dataValue) {
            this.dataValue = dataValue;
        }

        @Override
        public final Builder dataValue(Double dataValue) {
            this.dataValue = dataValue;
            return this;
        }

        @Override
        public DataColor build() {
            return new DataColor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
