/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The customized parameter values.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomParameterValues implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomParameterValues.Builder, CustomParameterValues> {
    private static final SdkField<List<String>> STRING_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StringValues")
            .getter(getter(CustomParameterValues::stringValues))
            .setter(setter(Builder::stringValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Long>> INTEGER_VALUES_FIELD = SdkField
            .<List<Long>> builder(MarshallingType.LIST)
            .memberName("IntegerValues")
            .getter(getter(CustomParameterValues::integerValues))
            .setter(setter(Builder::integerValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Long> builder(MarshallingType.LONG)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Double>> DECIMAL_VALUES_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("DecimalValues")
            .getter(getter(CustomParameterValues::decimalValues))
            .setter(setter(Builder::decimalValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecimalValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Instant>> DATE_TIME_VALUES_FIELD = SdkField
            .<List<Instant>> builder(MarshallingType.LIST)
            .memberName("DateTimeValues")
            .getter(getter(CustomParameterValues::dateTimeValues))
            .setter(setter(Builder::dateTimeValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateTimeValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Instant> builder(MarshallingType.INSTANT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_VALUES_FIELD,
            INTEGER_VALUES_FIELD, DECIMAL_VALUES_FIELD, DATE_TIME_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> stringValues;

    private final List<Long> integerValues;

    private final List<Double> decimalValues;

    private final List<Instant> dateTimeValues;

    private CustomParameterValues(BuilderImpl builder) {
        this.stringValues = builder.stringValues;
        this.integerValues = builder.integerValues;
        this.decimalValues = builder.decimalValues;
        this.dateTimeValues = builder.dateTimeValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the StringValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStringValues() {
        return stringValues != null && !(stringValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of string-type parameter values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStringValues} method.
     * </p>
     * 
     * @return A list of string-type parameter values.
     */
    public final List<String> stringValues() {
        return stringValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the IntegerValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIntegerValues() {
        return integerValues != null && !(integerValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of integer-type parameter values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntegerValues} method.
     * </p>
     * 
     * @return A list of integer-type parameter values.
     */
    public final List<Long> integerValues() {
        return integerValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the DecimalValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDecimalValues() {
        return decimalValues != null && !(decimalValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of decimal-type parameter values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDecimalValues} method.
     * </p>
     * 
     * @return A list of decimal-type parameter values.
     */
    public final List<Double> decimalValues() {
        return decimalValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the DateTimeValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDateTimeValues() {
        return dateTimeValues != null && !(dateTimeValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of datetime-type parameter values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDateTimeValues} method.
     * </p>
     * 
     * @return A list of datetime-type parameter values.
     */
    public final List<Instant> dateTimeValues() {
        return dateTimeValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStringValues() ? stringValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIntegerValues() ? integerValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDecimalValues() ? decimalValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDateTimeValues() ? dateTimeValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomParameterValues)) {
            return false;
        }
        CustomParameterValues other = (CustomParameterValues) obj;
        return hasStringValues() == other.hasStringValues() && Objects.equals(stringValues(), other.stringValues())
                && hasIntegerValues() == other.hasIntegerValues() && Objects.equals(integerValues(), other.integerValues())
                && hasDecimalValues() == other.hasDecimalValues() && Objects.equals(decimalValues(), other.decimalValues())
                && hasDateTimeValues() == other.hasDateTimeValues() && Objects.equals(dateTimeValues(), other.dateTimeValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomParameterValues")
                .add("StringValues", stringValues() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IntegerValues", integerValues() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DecimalValues", decimalValues() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DateTimeValues", dateTimeValues() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringValues":
            return Optional.ofNullable(clazz.cast(stringValues()));
        case "IntegerValues":
            return Optional.ofNullable(clazz.cast(integerValues()));
        case "DecimalValues":
            return Optional.ofNullable(clazz.cast(decimalValues()));
        case "DateTimeValues":
            return Optional.ofNullable(clazz.cast(dateTimeValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomParameterValues, T> g) {
        return obj -> g.apply((CustomParameterValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomParameterValues> {
        /**
         * <p>
         * A list of string-type parameter values.
         * </p>
         * 
         * @param stringValues
         *        A list of string-type parameter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValues(Collection<String> stringValues);

        /**
         * <p>
         * A list of string-type parameter values.
         * </p>
         * 
         * @param stringValues
         *        A list of string-type parameter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValues(String... stringValues);

        /**
         * <p>
         * A list of integer-type parameter values.
         * </p>
         * 
         * @param integerValues
         *        A list of integer-type parameter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerValues(Collection<Long> integerValues);

        /**
         * <p>
         * A list of integer-type parameter values.
         * </p>
         * 
         * @param integerValues
         *        A list of integer-type parameter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerValues(Long... integerValues);

        /**
         * <p>
         * A list of decimal-type parameter values.
         * </p>
         * 
         * @param decimalValues
         *        A list of decimal-type parameter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decimalValues(Collection<Double> decimalValues);

        /**
         * <p>
         * A list of decimal-type parameter values.
         * </p>
         * 
         * @param decimalValues
         *        A list of decimal-type parameter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decimalValues(Double... decimalValues);

        /**
         * <p>
         * A list of datetime-type parameter values.
         * </p>
         * 
         * @param dateTimeValues
         *        A list of datetime-type parameter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateTimeValues(Collection<Instant> dateTimeValues);

        /**
         * <p>
         * A list of datetime-type parameter values.
         * </p>
         * 
         * @param dateTimeValues
         *        A list of datetime-type parameter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateTimeValues(Instant... dateTimeValues);
    }

    static final class BuilderImpl implements Builder {
        private List<String> stringValues = DefaultSdkAutoConstructList.getInstance();

        private List<Long> integerValues = DefaultSdkAutoConstructList.getInstance();

        private List<Double> decimalValues = DefaultSdkAutoConstructList.getInstance();

        private List<Instant> dateTimeValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomParameterValues model) {
            stringValues(model.stringValues);
            integerValues(model.integerValues);
            decimalValues(model.decimalValues);
            dateTimeValues(model.dateTimeValues);
        }

        public final Collection<String> getStringValues() {
            if (stringValues instanceof SdkAutoConstructList) {
                return null;
            }
            return stringValues;
        }

        public final void setStringValues(Collection<String> stringValues) {
            this.stringValues = StringDefaultValueListCopier.copy(stringValues);
        }

        @Override
        public final Builder stringValues(Collection<String> stringValues) {
            this.stringValues = StringDefaultValueListCopier.copy(stringValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringValues(String... stringValues) {
            stringValues(Arrays.asList(stringValues));
            return this;
        }

        public final Collection<Long> getIntegerValues() {
            if (integerValues instanceof SdkAutoConstructList) {
                return null;
            }
            return integerValues;
        }

        public final void setIntegerValues(Collection<Long> integerValues) {
            this.integerValues = IntegerDefaultValueListCopier.copy(integerValues);
        }

        @Override
        public final Builder integerValues(Collection<Long> integerValues) {
            this.integerValues = IntegerDefaultValueListCopier.copy(integerValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerValues(Long... integerValues) {
            integerValues(Arrays.asList(integerValues));
            return this;
        }

        public final Collection<Double> getDecimalValues() {
            if (decimalValues instanceof SdkAutoConstructList) {
                return null;
            }
            return decimalValues;
        }

        public final void setDecimalValues(Collection<Double> decimalValues) {
            this.decimalValues = DecimalDefaultValueListCopier.copy(decimalValues);
        }

        @Override
        public final Builder decimalValues(Collection<Double> decimalValues) {
            this.decimalValues = DecimalDefaultValueListCopier.copy(decimalValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder decimalValues(Double... decimalValues) {
            decimalValues(Arrays.asList(decimalValues));
            return this;
        }

        public final Collection<Instant> getDateTimeValues() {
            if (dateTimeValues instanceof SdkAutoConstructList) {
                return null;
            }
            return dateTimeValues;
        }

        public final void setDateTimeValues(Collection<Instant> dateTimeValues) {
            this.dateTimeValues = DateTimeDefaultValueListCopier.copy(dateTimeValues);
        }

        @Override
        public final Builder dateTimeValues(Collection<Instant> dateTimeValues) {
            this.dateTimeValues = DateTimeDefaultValueListCopier.copy(dateTimeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dateTimeValues(Instant... dateTimeValues) {
            dateTimeValues(Arrays.asList(dateTimeValues));
            return this;
        }

        @Override
        public CustomParameterValues build() {
            return new CustomParameterValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
