/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConstantType {
    SINGULAR("SINGULAR"),
    RANGE("RANGE"),
    COLLECTIVE("COLLECTIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConstantType> VALUE_MAP;
    private final String value;

    private ConstantType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConstantType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConstantType> knownValues() {
        EnumSet<ConstantType> knownValues = EnumSet.allOf(ConstantType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConstantType.class, ConstantType::toString);
    }
}

