/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobSummary;
import software.amazon.awssdk.services.quicksight.model.ListAssetBundleImportJobsRequest;
import software.amazon.awssdk.services.quicksight.model.ListAssetBundleImportJobsResponse;

public class ListAssetBundleImportJobsPublisher
implements SdkPublisher<ListAssetBundleImportJobsResponse> {
    private final QuickSightAsyncClient client;
    private final ListAssetBundleImportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssetBundleImportJobsPublisher(QuickSightAsyncClient client, ListAssetBundleImportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssetBundleImportJobsPublisher(QuickSightAsyncClient client, ListAssetBundleImportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssetBundleImportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssetBundleImportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssetBundleImportJobSummary> assetBundleImportJobSummaryList() {
        Function<ListAssetBundleImportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assetBundleImportJobSummaryList() != null) {
                return response.assetBundleImportJobSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAssetBundleImportJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAssetBundleImportJobsResponseFetcher
    implements AsyncPageFetcher<ListAssetBundleImportJobsResponse> {
        private ListAssetBundleImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetBundleImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssetBundleImportJobsResponse> nextPage(ListAssetBundleImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListAssetBundleImportJobsPublisher.this.client.listAssetBundleImportJobs(ListAssetBundleImportJobsPublisher.this.firstRequest);
            }
            return ListAssetBundleImportJobsPublisher.this.client.listAssetBundleImportJobs((ListAssetBundleImportJobsRequest)((Object)ListAssetBundleImportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

