/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DefaultAggregation {
    SUM("SUM"),
    MAX("MAX"),
    MIN("MIN"),
    COUNT("COUNT"),
    DISTINCT_COUNT("DISTINCT_COUNT"),
    AVERAGE("AVERAGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DefaultAggregation> VALUE_MAP;
    private final String value;

    private DefaultAggregation(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DefaultAggregation fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DefaultAggregation> knownValues() {
        EnumSet<DefaultAggregation> knownValues = EnumSet.allOf(DefaultAggregation.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DefaultAggregation.class, DefaultAggregation::toString);
    }
}

