/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.quicksight.DefaultQuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.DefaultQuickSightBaseClientBuilder;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClientBuilder;
import software.amazon.awssdk.services.quicksight.QuickSightServiceClientConfiguration;
import software.amazon.awssdk.services.quicksight.endpoints.QuickSightEndpointProvider;

@SdkInternalApi
final class DefaultQuickSightAsyncClientBuilder
extends DefaultQuickSightBaseClientBuilder<QuickSightAsyncClientBuilder, QuickSightAsyncClient>
implements QuickSightAsyncClientBuilder {
    DefaultQuickSightAsyncClientBuilder() {
    }

    @Override
    public DefaultQuickSightAsyncClientBuilder endpointProvider(QuickSightEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final QuickSightAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultQuickSightAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        QuickSightServiceClientConfiguration serviceClientConfiguration = QuickSightServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultQuickSightAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

