/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ColumnTagName;
import software.amazon.awssdk.services.quicksight.model.ColumnTagNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UntagColumnOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UntagColumnOperation> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColumnName").getter(UntagColumnOperation.getter(UntagColumnOperation::columnName)).setter(UntagColumnOperation.setter(Builder::columnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()}).build();
    private static final SdkField<List<String>> TAG_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagNames").getter(UntagColumnOperation.getter(UntagColumnOperation::tagNamesAsStrings)).setter(UntagColumnOperation.setter(Builder::tagNamesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD, TAG_NAMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String columnName;
    private final List<String> tagNames;

    private UntagColumnOperation(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.tagNames = builder.tagNames;
    }

    public final String columnName() {
        return this.columnName;
    }

    public final List<ColumnTagName> tagNames() {
        return ColumnTagNamesCopier.copyStringToEnum(this.tagNames);
    }

    public final boolean hasTagNames() {
        return this.tagNames != null && !(this.tagNames instanceof SdkAutoConstructList);
    }

    public final List<String> tagNamesAsStrings() {
        return this.tagNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.columnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagNames() ? this.tagNamesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagColumnOperation)) {
            return false;
        }
        UntagColumnOperation other = (UntagColumnOperation)obj;
        return Objects.equals(this.columnName(), other.columnName()) && this.hasTagNames() == other.hasTagNames() && Objects.equals(this.tagNamesAsStrings(), other.tagNamesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"UntagColumnOperation").add("ColumnName", (Object)this.columnName()).add("TagNames", this.hasTagNames() ? this.tagNamesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColumnName": {
                return Optional.ofNullable(clazz.cast(this.columnName()));
            }
            case "TagNames": {
                return Optional.ofNullable(clazz.cast(this.tagNamesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UntagColumnOperation, T> g) {
        return obj -> g.apply((UntagColumnOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String columnName;
        private List<String> tagNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UntagColumnOperation model) {
            this.columnName(model.columnName);
            this.tagNamesWithStrings(model.tagNames);
        }

        public final String getColumnName() {
            return this.columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final Collection<String> getTagNames() {
            if (this.tagNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagNames;
        }

        public final void setTagNames(Collection<String> tagNames) {
            this.tagNames = ColumnTagNamesCopier.copy(tagNames);
        }

        @Override
        public final Builder tagNamesWithStrings(Collection<String> tagNames) {
            this.tagNames = ColumnTagNamesCopier.copy(tagNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagNamesWithStrings(String ... tagNames) {
            this.tagNamesWithStrings(Arrays.asList(tagNames));
            return this;
        }

        @Override
        public final Builder tagNames(Collection<ColumnTagName> tagNames) {
            this.tagNames = ColumnTagNamesCopier.copyEnumToString(tagNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagNames(ColumnTagName ... tagNames) {
            this.tagNames(Arrays.asList(tagNames));
            return this;
        }

        public UntagColumnOperation build() {
            return new UntagColumnOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UntagColumnOperation> {
        public Builder columnName(String var1);

        public Builder tagNamesWithStrings(Collection<String> var1);

        public Builder tagNamesWithStrings(String ... var1);

        public Builder tagNames(Collection<ColumnTagName> var1);

        public Builder tagNames(ColumnTagName ... var1);
    }
}

