/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.FolderSummary;
import software.amazon.awssdk.services.quicksight.model.ListFoldersRequest;
import software.amazon.awssdk.services.quicksight.model.ListFoldersResponse;

public class ListFoldersIterable
implements SdkIterable<ListFoldersResponse> {
    private final QuickSightClient client;
    private final ListFoldersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFoldersIterable(QuickSightClient client, ListFoldersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFoldersResponseFetcher();
    }

    public Iterator<ListFoldersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FolderSummary> folderSummaryList() {
        Function<ListFoldersResponse, Iterator> getIterator = response -> {
            if (response != null && response.folderSummaryList() != null) {
                return response.folderSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFoldersResponseFetcher
    implements SyncPageFetcher<ListFoldersResponse> {
        private ListFoldersResponseFetcher() {
        }

        public boolean hasNextPage(ListFoldersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFoldersResponse nextPage(ListFoldersResponse previousPage) {
            if (previousPage == null) {
                return ListFoldersIterable.this.client.listFolders(ListFoldersIterable.this.firstRequest);
            }
            return ListFoldersIterable.this.client.listFolders((ListFoldersRequest)((Object)ListFoldersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

