/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MemberType {
    DASHBOARD("DASHBOARD"),
    ANALYSIS("ANALYSIS"),
    DATASET("DATASET"),
    TOPIC("TOPIC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MemberType> VALUE_MAP;
    private final String value;

    private MemberType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MemberType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MemberType> knownValues() {
        EnumSet<MemberType> knownValues = EnumSet.allOf(MemberType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MemberType.class, MemberType::toString);
    }
}

