/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.LabelOptions;
import software.amazon.awssdk.services.quicksight.model.SheetControlInfoIconLabelOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DateTimePickerControlDisplayOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DateTimePickerControlDisplayOptions> {
    private static final SdkField<LabelOptions> TITLE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TitleOptions").getter(DateTimePickerControlDisplayOptions.getter(DateTimePickerControlDisplayOptions::titleOptions)).setter(DateTimePickerControlDisplayOptions.setter(Builder::titleOptions)).constructor(LabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TitleOptions").build()}).build();
    private static final SdkField<String> DATE_TIME_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DateTimeFormat").getter(DateTimePickerControlDisplayOptions.getter(DateTimePickerControlDisplayOptions::dateTimeFormat)).setter(DateTimePickerControlDisplayOptions.setter(Builder::dateTimeFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateTimeFormat").build()}).build();
    private static final SdkField<SheetControlInfoIconLabelOptions> INFO_ICON_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InfoIconLabelOptions").getter(DateTimePickerControlDisplayOptions.getter(DateTimePickerControlDisplayOptions::infoIconLabelOptions)).setter(DateTimePickerControlDisplayOptions.setter(Builder::infoIconLabelOptions)).constructor(SheetControlInfoIconLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfoIconLabelOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_OPTIONS_FIELD, DATE_TIME_FORMAT_FIELD, INFO_ICON_LABEL_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final LabelOptions titleOptions;
    private final String dateTimeFormat;
    private final SheetControlInfoIconLabelOptions infoIconLabelOptions;

    private DateTimePickerControlDisplayOptions(BuilderImpl builder) {
        this.titleOptions = builder.titleOptions;
        this.dateTimeFormat = builder.dateTimeFormat;
        this.infoIconLabelOptions = builder.infoIconLabelOptions;
    }

    public final LabelOptions titleOptions() {
        return this.titleOptions;
    }

    public final String dateTimeFormat() {
        return this.dateTimeFormat;
    }

    public final SheetControlInfoIconLabelOptions infoIconLabelOptions() {
        return this.infoIconLabelOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.titleOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateTimeFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.infoIconLabelOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimePickerControlDisplayOptions)) {
            return false;
        }
        DateTimePickerControlDisplayOptions other = (DateTimePickerControlDisplayOptions)obj;
        return Objects.equals(this.titleOptions(), other.titleOptions()) && Objects.equals(this.dateTimeFormat(), other.dateTimeFormat()) && Objects.equals(this.infoIconLabelOptions(), other.infoIconLabelOptions());
    }

    public final String toString() {
        return ToString.builder((String)"DateTimePickerControlDisplayOptions").add("TitleOptions", (Object)this.titleOptions()).add("DateTimeFormat", (Object)this.dateTimeFormat()).add("InfoIconLabelOptions", (Object)this.infoIconLabelOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TitleOptions": {
                return Optional.ofNullable(clazz.cast(this.titleOptions()));
            }
            case "DateTimeFormat": {
                return Optional.ofNullable(clazz.cast(this.dateTimeFormat()));
            }
            case "InfoIconLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.infoIconLabelOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DateTimePickerControlDisplayOptions, T> g) {
        return obj -> g.apply((DateTimePickerControlDisplayOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LabelOptions titleOptions;
        private String dateTimeFormat;
        private SheetControlInfoIconLabelOptions infoIconLabelOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DateTimePickerControlDisplayOptions model) {
            this.titleOptions(model.titleOptions);
            this.dateTimeFormat(model.dateTimeFormat);
            this.infoIconLabelOptions(model.infoIconLabelOptions);
        }

        public final LabelOptions.Builder getTitleOptions() {
            return this.titleOptions != null ? this.titleOptions.toBuilder() : null;
        }

        public final void setTitleOptions(LabelOptions.BuilderImpl titleOptions) {
            this.titleOptions = titleOptions != null ? titleOptions.build() : null;
        }

        @Override
        public final Builder titleOptions(LabelOptions titleOptions) {
            this.titleOptions = titleOptions;
            return this;
        }

        public final String getDateTimeFormat() {
            return this.dateTimeFormat;
        }

        public final void setDateTimeFormat(String dateTimeFormat) {
            this.dateTimeFormat = dateTimeFormat;
        }

        @Override
        public final Builder dateTimeFormat(String dateTimeFormat) {
            this.dateTimeFormat = dateTimeFormat;
            return this;
        }

        public final SheetControlInfoIconLabelOptions.Builder getInfoIconLabelOptions() {
            return this.infoIconLabelOptions != null ? this.infoIconLabelOptions.toBuilder() : null;
        }

        public final void setInfoIconLabelOptions(SheetControlInfoIconLabelOptions.BuilderImpl infoIconLabelOptions) {
            this.infoIconLabelOptions = infoIconLabelOptions != null ? infoIconLabelOptions.build() : null;
        }

        @Override
        public final Builder infoIconLabelOptions(SheetControlInfoIconLabelOptions infoIconLabelOptions) {
            this.infoIconLabelOptions = infoIconLabelOptions;
            return this;
        }

        public DateTimePickerControlDisplayOptions build() {
            return new DateTimePickerControlDisplayOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DateTimePickerControlDisplayOptions> {
        public Builder titleOptions(LabelOptions var1);

        default public Builder titleOptions(Consumer<LabelOptions.Builder> titleOptions) {
            return this.titleOptions((LabelOptions)((LabelOptions.Builder)LabelOptions.builder().applyMutation(titleOptions)).build());
        }

        public Builder dateTimeFormat(String var1);

        public Builder infoIconLabelOptions(SheetControlInfoIconLabelOptions var1);

        default public Builder infoIconLabelOptions(Consumer<SheetControlInfoIconLabelOptions.Builder> infoIconLabelOptions) {
            return this.infoIconLabelOptions((SheetControlInfoIconLabelOptions)((SheetControlInfoIconLabelOptions.Builder)SheetControlInfoIconLabelOptions.builder().applyMutation(infoIconLabelOptions)).build());
        }
    }
}

