/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.SnapshotFile;
import software.amazon.awssdk.services.quicksight.model.SnapshotFileListCopier;
import software.amazon.awssdk.services.quicksight.model.SnapshotJobS3Result;
import software.amazon.awssdk.services.quicksight.model.SnapshotJobS3ResultListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnapshotJobResultFileGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnapshotJobResultFileGroup> {
    private static final SdkField<List<SnapshotFile>> FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Files").getter(SnapshotJobResultFileGroup.getter(SnapshotJobResultFileGroup::files)).setter(SnapshotJobResultFileGroup.setter(Builder::files)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Files").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SnapshotFile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SnapshotJobS3Result>> S3_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("S3Results").getter(SnapshotJobResultFileGroup.getter(SnapshotJobResultFileGroup::s3Results)).setter(SnapshotJobResultFileGroup.setter(Builder::s3Results)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Results").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SnapshotJobS3Result::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILES_FIELD, S3_RESULTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<SnapshotFile> files;
    private final List<SnapshotJobS3Result> s3Results;

    private SnapshotJobResultFileGroup(BuilderImpl builder) {
        this.files = builder.files;
        this.s3Results = builder.s3Results;
    }

    public final boolean hasFiles() {
        return this.files != null && !(this.files instanceof SdkAutoConstructList);
    }

    public final List<SnapshotFile> files() {
        return this.files;
    }

    public final boolean hasS3Results() {
        return this.s3Results != null && !(this.s3Results instanceof SdkAutoConstructList);
    }

    public final List<SnapshotJobS3Result> s3Results() {
        return this.s3Results;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFiles() ? this.files() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasS3Results() ? this.s3Results() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotJobResultFileGroup)) {
            return false;
        }
        SnapshotJobResultFileGroup other = (SnapshotJobResultFileGroup)obj;
        return this.hasFiles() == other.hasFiles() && Objects.equals(this.files(), other.files()) && this.hasS3Results() == other.hasS3Results() && Objects.equals(this.s3Results(), other.s3Results());
    }

    public final String toString() {
        return ToString.builder((String)"SnapshotJobResultFileGroup").add("Files", this.hasFiles() ? this.files() : null).add("S3Results", this.hasS3Results() ? this.s3Results() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Files": {
                return Optional.ofNullable(clazz.cast(this.files()));
            }
            case "S3Results": {
                return Optional.ofNullable(clazz.cast(this.s3Results()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotJobResultFileGroup, T> g) {
        return obj -> g.apply((SnapshotJobResultFileGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<SnapshotFile> files = DefaultSdkAutoConstructList.getInstance();
        private List<SnapshotJobS3Result> s3Results = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotJobResultFileGroup model) {
            this.files(model.files);
            this.s3Results(model.s3Results);
        }

        public final List<SnapshotFile.Builder> getFiles() {
            List<SnapshotFile.Builder> result = SnapshotFileListCopier.copyToBuilder(this.files);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFiles(Collection<SnapshotFile.BuilderImpl> files) {
            this.files = SnapshotFileListCopier.copyFromBuilder(files);
        }

        @Override
        public final Builder files(Collection<SnapshotFile> files) {
            this.files = SnapshotFileListCopier.copy(files);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(SnapshotFile ... files) {
            this.files(Arrays.asList(files));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(Consumer<SnapshotFile.Builder> ... files) {
            this.files(Stream.of(files).map(c -> (SnapshotFile)((SnapshotFile.Builder)SnapshotFile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SnapshotJobS3Result.Builder> getS3Results() {
            List<SnapshotJobS3Result.Builder> result = SnapshotJobS3ResultListCopier.copyToBuilder(this.s3Results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setS3Results(Collection<SnapshotJobS3Result.BuilderImpl> s3Results) {
            this.s3Results = SnapshotJobS3ResultListCopier.copyFromBuilder(s3Results);
        }

        @Override
        public final Builder s3Results(Collection<SnapshotJobS3Result> s3Results) {
            this.s3Results = SnapshotJobS3ResultListCopier.copy(s3Results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Results(SnapshotJobS3Result ... s3Results) {
            this.s3Results(Arrays.asList(s3Results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Results(Consumer<SnapshotJobS3Result.Builder> ... s3Results) {
            this.s3Results(Stream.of(s3Results).map(c -> (SnapshotJobS3Result)((SnapshotJobS3Result.Builder)SnapshotJobS3Result.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SnapshotJobResultFileGroup build() {
            return new SnapshotJobResultFileGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnapshotJobResultFileGroup> {
        public Builder files(Collection<SnapshotFile> var1);

        public Builder files(SnapshotFile ... var1);

        public Builder files(Consumer<SnapshotFile.Builder> ... var1);

        public Builder s3Results(Collection<SnapshotJobS3Result> var1);

        public Builder s3Results(SnapshotJobS3Result ... var1);

        public Builder s3Results(Consumer<SnapshotJobS3Result.Builder> ... var1);
    }
}

