/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters that Amazon QuickSight uses to connect to your underlying data source. This is a variant type
 * structure. For this structure to be valid, only one of the attributes can be non-null.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceParameters.Builder, DataSourceParameters> {
    private static final SdkField<AmazonElasticsearchParameters> AMAZON_ELASTICSEARCH_PARAMETERS_FIELD = SdkField
            .<AmazonElasticsearchParameters> builder(MarshallingType.SDK_POJO)
            .memberName("AmazonElasticsearchParameters")
            .getter(getter(DataSourceParameters::amazonElasticsearchParameters))
            .setter(setter(Builder::amazonElasticsearchParameters))
            .constructor(AmazonElasticsearchParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonElasticsearchParameters")
                    .build()).build();

    private static final SdkField<AthenaParameters> ATHENA_PARAMETERS_FIELD = SdkField
            .<AthenaParameters> builder(MarshallingType.SDK_POJO).memberName("AthenaParameters")
            .getter(getter(DataSourceParameters::athenaParameters)).setter(setter(Builder::athenaParameters))
            .constructor(AthenaParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AthenaParameters").build()).build();

    private static final SdkField<AuroraParameters> AURORA_PARAMETERS_FIELD = SdkField
            .<AuroraParameters> builder(MarshallingType.SDK_POJO).memberName("AuroraParameters")
            .getter(getter(DataSourceParameters::auroraParameters)).setter(setter(Builder::auroraParameters))
            .constructor(AuroraParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuroraParameters").build()).build();

    private static final SdkField<AuroraPostgreSqlParameters> AURORA_POSTGRE_SQL_PARAMETERS_FIELD = SdkField
            .<AuroraPostgreSqlParameters> builder(MarshallingType.SDK_POJO)
            .memberName("AuroraPostgreSqlParameters")
            .getter(getter(DataSourceParameters::auroraPostgreSqlParameters))
            .setter(setter(Builder::auroraPostgreSqlParameters))
            .constructor(AuroraPostgreSqlParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuroraPostgreSqlParameters").build())
            .build();

    private static final SdkField<AwsIotAnalyticsParameters> AWS_IOT_ANALYTICS_PARAMETERS_FIELD = SdkField
            .<AwsIotAnalyticsParameters> builder(MarshallingType.SDK_POJO).memberName("AwsIotAnalyticsParameters")
            .getter(getter(DataSourceParameters::awsIotAnalyticsParameters)).setter(setter(Builder::awsIotAnalyticsParameters))
            .constructor(AwsIotAnalyticsParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsIotAnalyticsParameters").build())
            .build();

    private static final SdkField<JiraParameters> JIRA_PARAMETERS_FIELD = SdkField
            .<JiraParameters> builder(MarshallingType.SDK_POJO).memberName("JiraParameters")
            .getter(getter(DataSourceParameters::jiraParameters)).setter(setter(Builder::jiraParameters))
            .constructor(JiraParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JiraParameters").build()).build();

    private static final SdkField<MariaDbParameters> MARIA_DB_PARAMETERS_FIELD = SdkField
            .<MariaDbParameters> builder(MarshallingType.SDK_POJO).memberName("MariaDbParameters")
            .getter(getter(DataSourceParameters::mariaDbParameters)).setter(setter(Builder::mariaDbParameters))
            .constructor(MariaDbParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MariaDbParameters").build()).build();

    private static final SdkField<MySqlParameters> MY_SQL_PARAMETERS_FIELD = SdkField
            .<MySqlParameters> builder(MarshallingType.SDK_POJO).memberName("MySqlParameters")
            .getter(getter(DataSourceParameters::mySqlParameters)).setter(setter(Builder::mySqlParameters))
            .constructor(MySqlParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MySqlParameters").build()).build();

    private static final SdkField<OracleParameters> ORACLE_PARAMETERS_FIELD = SdkField
            .<OracleParameters> builder(MarshallingType.SDK_POJO).memberName("OracleParameters")
            .getter(getter(DataSourceParameters::oracleParameters)).setter(setter(Builder::oracleParameters))
            .constructor(OracleParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OracleParameters").build()).build();

    private static final SdkField<PostgreSqlParameters> POSTGRE_SQL_PARAMETERS_FIELD = SdkField
            .<PostgreSqlParameters> builder(MarshallingType.SDK_POJO).memberName("PostgreSqlParameters")
            .getter(getter(DataSourceParameters::postgreSqlParameters)).setter(setter(Builder::postgreSqlParameters))
            .constructor(PostgreSqlParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostgreSqlParameters").build())
            .build();

    private static final SdkField<PrestoParameters> PRESTO_PARAMETERS_FIELD = SdkField
            .<PrestoParameters> builder(MarshallingType.SDK_POJO).memberName("PrestoParameters")
            .getter(getter(DataSourceParameters::prestoParameters)).setter(setter(Builder::prestoParameters))
            .constructor(PrestoParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrestoParameters").build()).build();

    private static final SdkField<RdsParameters> RDS_PARAMETERS_FIELD = SdkField
            .<RdsParameters> builder(MarshallingType.SDK_POJO).memberName("RdsParameters")
            .getter(getter(DataSourceParameters::rdsParameters)).setter(setter(Builder::rdsParameters))
            .constructor(RdsParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsParameters").build()).build();

    private static final SdkField<RedshiftParameters> REDSHIFT_PARAMETERS_FIELD = SdkField
            .<RedshiftParameters> builder(MarshallingType.SDK_POJO).memberName("RedshiftParameters")
            .getter(getter(DataSourceParameters::redshiftParameters)).setter(setter(Builder::redshiftParameters))
            .constructor(RedshiftParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftParameters").build())
            .build();

    private static final SdkField<S3Parameters> S3_PARAMETERS_FIELD = SdkField.<S3Parameters> builder(MarshallingType.SDK_POJO)
            .memberName("S3Parameters").getter(getter(DataSourceParameters::s3Parameters)).setter(setter(Builder::s3Parameters))
            .constructor(S3Parameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Parameters").build()).build();

    private static final SdkField<ServiceNowParameters> SERVICE_NOW_PARAMETERS_FIELD = SdkField
            .<ServiceNowParameters> builder(MarshallingType.SDK_POJO).memberName("ServiceNowParameters")
            .getter(getter(DataSourceParameters::serviceNowParameters)).setter(setter(Builder::serviceNowParameters))
            .constructor(ServiceNowParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNowParameters").build())
            .build();

    private static final SdkField<SnowflakeParameters> SNOWFLAKE_PARAMETERS_FIELD = SdkField
            .<SnowflakeParameters> builder(MarshallingType.SDK_POJO).memberName("SnowflakeParameters")
            .getter(getter(DataSourceParameters::snowflakeParameters)).setter(setter(Builder::snowflakeParameters))
            .constructor(SnowflakeParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowflakeParameters").build())
            .build();

    private static final SdkField<SparkParameters> SPARK_PARAMETERS_FIELD = SdkField
            .<SparkParameters> builder(MarshallingType.SDK_POJO).memberName("SparkParameters")
            .getter(getter(DataSourceParameters::sparkParameters)).setter(setter(Builder::sparkParameters))
            .constructor(SparkParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SparkParameters").build()).build();

    private static final SdkField<SqlServerParameters> SQL_SERVER_PARAMETERS_FIELD = SdkField
            .<SqlServerParameters> builder(MarshallingType.SDK_POJO).memberName("SqlServerParameters")
            .getter(getter(DataSourceParameters::sqlServerParameters)).setter(setter(Builder::sqlServerParameters))
            .constructor(SqlServerParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlServerParameters").build())
            .build();

    private static final SdkField<TeradataParameters> TERADATA_PARAMETERS_FIELD = SdkField
            .<TeradataParameters> builder(MarshallingType.SDK_POJO).memberName("TeradataParameters")
            .getter(getter(DataSourceParameters::teradataParameters)).setter(setter(Builder::teradataParameters))
            .constructor(TeradataParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeradataParameters").build())
            .build();

    private static final SdkField<TwitterParameters> TWITTER_PARAMETERS_FIELD = SdkField
            .<TwitterParameters> builder(MarshallingType.SDK_POJO).memberName("TwitterParameters")
            .getter(getter(DataSourceParameters::twitterParameters)).setter(setter(Builder::twitterParameters))
            .constructor(TwitterParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TwitterParameters").build()).build();

    private static final SdkField<AmazonOpenSearchParameters> AMAZON_OPEN_SEARCH_PARAMETERS_FIELD = SdkField
            .<AmazonOpenSearchParameters> builder(MarshallingType.SDK_POJO)
            .memberName("AmazonOpenSearchParameters")
            .getter(getter(DataSourceParameters::amazonOpenSearchParameters))
            .setter(setter(Builder::amazonOpenSearchParameters))
            .constructor(AmazonOpenSearchParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonOpenSearchParameters").build())
            .build();

    private static final SdkField<ExasolParameters> EXASOL_PARAMETERS_FIELD = SdkField
            .<ExasolParameters> builder(MarshallingType.SDK_POJO).memberName("ExasolParameters")
            .getter(getter(DataSourceParameters::exasolParameters)).setter(setter(Builder::exasolParameters))
            .constructor(ExasolParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExasolParameters").build()).build();

    private static final SdkField<DatabricksParameters> DATABRICKS_PARAMETERS_FIELD = SdkField
            .<DatabricksParameters> builder(MarshallingType.SDK_POJO).memberName("DatabricksParameters")
            .getter(getter(DataSourceParameters::databricksParameters)).setter(setter(Builder::databricksParameters))
            .constructor(DatabricksParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabricksParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AMAZON_ELASTICSEARCH_PARAMETERS_FIELD, ATHENA_PARAMETERS_FIELD, AURORA_PARAMETERS_FIELD,
            AURORA_POSTGRE_SQL_PARAMETERS_FIELD, AWS_IOT_ANALYTICS_PARAMETERS_FIELD, JIRA_PARAMETERS_FIELD,
            MARIA_DB_PARAMETERS_FIELD, MY_SQL_PARAMETERS_FIELD, ORACLE_PARAMETERS_FIELD, POSTGRE_SQL_PARAMETERS_FIELD,
            PRESTO_PARAMETERS_FIELD, RDS_PARAMETERS_FIELD, REDSHIFT_PARAMETERS_FIELD, S3_PARAMETERS_FIELD,
            SERVICE_NOW_PARAMETERS_FIELD, SNOWFLAKE_PARAMETERS_FIELD, SPARK_PARAMETERS_FIELD, SQL_SERVER_PARAMETERS_FIELD,
            TERADATA_PARAMETERS_FIELD, TWITTER_PARAMETERS_FIELD, AMAZON_OPEN_SEARCH_PARAMETERS_FIELD, EXASOL_PARAMETERS_FIELD,
            DATABRICKS_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AmazonElasticsearchParameters amazonElasticsearchParameters;

    private final AthenaParameters athenaParameters;

    private final AuroraParameters auroraParameters;

    private final AuroraPostgreSqlParameters auroraPostgreSqlParameters;

    private final AwsIotAnalyticsParameters awsIotAnalyticsParameters;

    private final JiraParameters jiraParameters;

    private final MariaDbParameters mariaDbParameters;

    private final MySqlParameters mySqlParameters;

    private final OracleParameters oracleParameters;

    private final PostgreSqlParameters postgreSqlParameters;

    private final PrestoParameters prestoParameters;

    private final RdsParameters rdsParameters;

    private final RedshiftParameters redshiftParameters;

    private final S3Parameters s3Parameters;

    private final ServiceNowParameters serviceNowParameters;

    private final SnowflakeParameters snowflakeParameters;

    private final SparkParameters sparkParameters;

    private final SqlServerParameters sqlServerParameters;

    private final TeradataParameters teradataParameters;

    private final TwitterParameters twitterParameters;

    private final AmazonOpenSearchParameters amazonOpenSearchParameters;

    private final ExasolParameters exasolParameters;

    private final DatabricksParameters databricksParameters;

    private final Type type;

    private DataSourceParameters(BuilderImpl builder) {
        this.amazonElasticsearchParameters = builder.amazonElasticsearchParameters;
        this.athenaParameters = builder.athenaParameters;
        this.auroraParameters = builder.auroraParameters;
        this.auroraPostgreSqlParameters = builder.auroraPostgreSqlParameters;
        this.awsIotAnalyticsParameters = builder.awsIotAnalyticsParameters;
        this.jiraParameters = builder.jiraParameters;
        this.mariaDbParameters = builder.mariaDbParameters;
        this.mySqlParameters = builder.mySqlParameters;
        this.oracleParameters = builder.oracleParameters;
        this.postgreSqlParameters = builder.postgreSqlParameters;
        this.prestoParameters = builder.prestoParameters;
        this.rdsParameters = builder.rdsParameters;
        this.redshiftParameters = builder.redshiftParameters;
        this.s3Parameters = builder.s3Parameters;
        this.serviceNowParameters = builder.serviceNowParameters;
        this.snowflakeParameters = builder.snowflakeParameters;
        this.sparkParameters = builder.sparkParameters;
        this.sqlServerParameters = builder.sqlServerParameters;
        this.teradataParameters = builder.teradataParameters;
        this.twitterParameters = builder.twitterParameters;
        this.amazonOpenSearchParameters = builder.amazonOpenSearchParameters;
        this.exasolParameters = builder.exasolParameters;
        this.databricksParameters = builder.databricksParameters;
        this.type = builder.type;
    }

    /**
     * <p>
     * The parameters for OpenSearch.
     * </p>
     * 
     * @return The parameters for OpenSearch.
     */
    public final AmazonElasticsearchParameters amazonElasticsearchParameters() {
        return amazonElasticsearchParameters;
    }

    /**
     * <p>
     * The parameters for Amazon Athena.
     * </p>
     * 
     * @return The parameters for Amazon Athena.
     */
    public final AthenaParameters athenaParameters() {
        return athenaParameters;
    }

    /**
     * <p>
     * The parameters for Amazon Aurora MySQL.
     * </p>
     * 
     * @return The parameters for Amazon Aurora MySQL.
     */
    public final AuroraParameters auroraParameters() {
        return auroraParameters;
    }

    /**
     * <p>
     * The parameters for Amazon Aurora.
     * </p>
     * 
     * @return The parameters for Amazon Aurora.
     */
    public final AuroraPostgreSqlParameters auroraPostgreSqlParameters() {
        return auroraPostgreSqlParameters;
    }

    /**
     * <p>
     * The parameters for IoT Analytics.
     * </p>
     * 
     * @return The parameters for IoT Analytics.
     */
    public final AwsIotAnalyticsParameters awsIotAnalyticsParameters() {
        return awsIotAnalyticsParameters;
    }

    /**
     * <p>
     * The parameters for Jira.
     * </p>
     * 
     * @return The parameters for Jira.
     */
    public final JiraParameters jiraParameters() {
        return jiraParameters;
    }

    /**
     * <p>
     * The parameters for MariaDB.
     * </p>
     * 
     * @return The parameters for MariaDB.
     */
    public final MariaDbParameters mariaDbParameters() {
        return mariaDbParameters;
    }

    /**
     * <p>
     * The parameters for MySQL.
     * </p>
     * 
     * @return The parameters for MySQL.
     */
    public final MySqlParameters mySqlParameters() {
        return mySqlParameters;
    }

    /**
     * <p>
     * The parameters for Oracle.
     * </p>
     * 
     * @return The parameters for Oracle.
     */
    public final OracleParameters oracleParameters() {
        return oracleParameters;
    }

    /**
     * <p>
     * The parameters for PostgreSQL.
     * </p>
     * 
     * @return The parameters for PostgreSQL.
     */
    public final PostgreSqlParameters postgreSqlParameters() {
        return postgreSqlParameters;
    }

    /**
     * <p>
     * The parameters for Presto.
     * </p>
     * 
     * @return The parameters for Presto.
     */
    public final PrestoParameters prestoParameters() {
        return prestoParameters;
    }

    /**
     * <p>
     * The parameters for Amazon RDS.
     * </p>
     * 
     * @return The parameters for Amazon RDS.
     */
    public final RdsParameters rdsParameters() {
        return rdsParameters;
    }

    /**
     * <p>
     * The parameters for Amazon Redshift.
     * </p>
     * 
     * @return The parameters for Amazon Redshift.
     */
    public final RedshiftParameters redshiftParameters() {
        return redshiftParameters;
    }

    /**
     * <p>
     * The parameters for S3.
     * </p>
     * 
     * @return The parameters for S3.
     */
    public final S3Parameters s3Parameters() {
        return s3Parameters;
    }

    /**
     * <p>
     * The parameters for ServiceNow.
     * </p>
     * 
     * @return The parameters for ServiceNow.
     */
    public final ServiceNowParameters serviceNowParameters() {
        return serviceNowParameters;
    }

    /**
     * <p>
     * The parameters for Snowflake.
     * </p>
     * 
     * @return The parameters for Snowflake.
     */
    public final SnowflakeParameters snowflakeParameters() {
        return snowflakeParameters;
    }

    /**
     * <p>
     * The parameters for Spark.
     * </p>
     * 
     * @return The parameters for Spark.
     */
    public final SparkParameters sparkParameters() {
        return sparkParameters;
    }

    /**
     * <p>
     * The parameters for SQL Server.
     * </p>
     * 
     * @return The parameters for SQL Server.
     */
    public final SqlServerParameters sqlServerParameters() {
        return sqlServerParameters;
    }

    /**
     * <p>
     * The parameters for Teradata.
     * </p>
     * 
     * @return The parameters for Teradata.
     */
    public final TeradataParameters teradataParameters() {
        return teradataParameters;
    }

    /**
     * <p>
     * The parameters for Twitter.
     * </p>
     * 
     * @return The parameters for Twitter.
     */
    public final TwitterParameters twitterParameters() {
        return twitterParameters;
    }

    /**
     * <p>
     * The parameters for OpenSearch.
     * </p>
     * 
     * @return The parameters for OpenSearch.
     */
    public final AmazonOpenSearchParameters amazonOpenSearchParameters() {
        return amazonOpenSearchParameters;
    }

    /**
     * <p>
     * The parameters for Exasol.
     * </p>
     * 
     * @return The parameters for Exasol.
     */
    public final ExasolParameters exasolParameters() {
        return exasolParameters;
    }

    /**
     * <p>
     * The required parameters that are needed to connect to a Databricks data source.
     * </p>
     * 
     * @return The required parameters that are needed to connect to a Databricks data source.
     */
    public final DatabricksParameters databricksParameters() {
        return databricksParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amazonElasticsearchParameters());
        hashCode = 31 * hashCode + Objects.hashCode(athenaParameters());
        hashCode = 31 * hashCode + Objects.hashCode(auroraParameters());
        hashCode = 31 * hashCode + Objects.hashCode(auroraPostgreSqlParameters());
        hashCode = 31 * hashCode + Objects.hashCode(awsIotAnalyticsParameters());
        hashCode = 31 * hashCode + Objects.hashCode(jiraParameters());
        hashCode = 31 * hashCode + Objects.hashCode(mariaDbParameters());
        hashCode = 31 * hashCode + Objects.hashCode(mySqlParameters());
        hashCode = 31 * hashCode + Objects.hashCode(oracleParameters());
        hashCode = 31 * hashCode + Objects.hashCode(postgreSqlParameters());
        hashCode = 31 * hashCode + Objects.hashCode(prestoParameters());
        hashCode = 31 * hashCode + Objects.hashCode(rdsParameters());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftParameters());
        hashCode = 31 * hashCode + Objects.hashCode(s3Parameters());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNowParameters());
        hashCode = 31 * hashCode + Objects.hashCode(snowflakeParameters());
        hashCode = 31 * hashCode + Objects.hashCode(sparkParameters());
        hashCode = 31 * hashCode + Objects.hashCode(sqlServerParameters());
        hashCode = 31 * hashCode + Objects.hashCode(teradataParameters());
        hashCode = 31 * hashCode + Objects.hashCode(twitterParameters());
        hashCode = 31 * hashCode + Objects.hashCode(amazonOpenSearchParameters());
        hashCode = 31 * hashCode + Objects.hashCode(exasolParameters());
        hashCode = 31 * hashCode + Objects.hashCode(databricksParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceParameters)) {
            return false;
        }
        DataSourceParameters other = (DataSourceParameters) obj;
        return Objects.equals(amazonElasticsearchParameters(), other.amazonElasticsearchParameters())
                && Objects.equals(athenaParameters(), other.athenaParameters())
                && Objects.equals(auroraParameters(), other.auroraParameters())
                && Objects.equals(auroraPostgreSqlParameters(), other.auroraPostgreSqlParameters())
                && Objects.equals(awsIotAnalyticsParameters(), other.awsIotAnalyticsParameters())
                && Objects.equals(jiraParameters(), other.jiraParameters())
                && Objects.equals(mariaDbParameters(), other.mariaDbParameters())
                && Objects.equals(mySqlParameters(), other.mySqlParameters())
                && Objects.equals(oracleParameters(), other.oracleParameters())
                && Objects.equals(postgreSqlParameters(), other.postgreSqlParameters())
                && Objects.equals(prestoParameters(), other.prestoParameters())
                && Objects.equals(rdsParameters(), other.rdsParameters())
                && Objects.equals(redshiftParameters(), other.redshiftParameters())
                && Objects.equals(s3Parameters(), other.s3Parameters())
                && Objects.equals(serviceNowParameters(), other.serviceNowParameters())
                && Objects.equals(snowflakeParameters(), other.snowflakeParameters())
                && Objects.equals(sparkParameters(), other.sparkParameters())
                && Objects.equals(sqlServerParameters(), other.sqlServerParameters())
                && Objects.equals(teradataParameters(), other.teradataParameters())
                && Objects.equals(twitterParameters(), other.twitterParameters())
                && Objects.equals(amazonOpenSearchParameters(), other.amazonOpenSearchParameters())
                && Objects.equals(exasolParameters(), other.exasolParameters())
                && Objects.equals(databricksParameters(), other.databricksParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceParameters").add("AmazonElasticsearchParameters", amazonElasticsearchParameters())
                .add("AthenaParameters", athenaParameters()).add("AuroraParameters", auroraParameters())
                .add("AuroraPostgreSqlParameters", auroraPostgreSqlParameters())
                .add("AwsIotAnalyticsParameters", awsIotAnalyticsParameters()).add("JiraParameters", jiraParameters())
                .add("MariaDbParameters", mariaDbParameters()).add("MySqlParameters", mySqlParameters())
                .add("OracleParameters", oracleParameters()).add("PostgreSqlParameters", postgreSqlParameters())
                .add("PrestoParameters", prestoParameters()).add("RdsParameters", rdsParameters())
                .add("RedshiftParameters", redshiftParameters()).add("S3Parameters", s3Parameters())
                .add("ServiceNowParameters", serviceNowParameters()).add("SnowflakeParameters", snowflakeParameters())
                .add("SparkParameters", sparkParameters()).add("SqlServerParameters", sqlServerParameters())
                .add("TeradataParameters", teradataParameters()).add("TwitterParameters", twitterParameters())
                .add("AmazonOpenSearchParameters", amazonOpenSearchParameters()).add("ExasolParameters", exasolParameters())
                .add("DatabricksParameters", databricksParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmazonElasticsearchParameters":
            return Optional.ofNullable(clazz.cast(amazonElasticsearchParameters()));
        case "AthenaParameters":
            return Optional.ofNullable(clazz.cast(athenaParameters()));
        case "AuroraParameters":
            return Optional.ofNullable(clazz.cast(auroraParameters()));
        case "AuroraPostgreSqlParameters":
            return Optional.ofNullable(clazz.cast(auroraPostgreSqlParameters()));
        case "AwsIotAnalyticsParameters":
            return Optional.ofNullable(clazz.cast(awsIotAnalyticsParameters()));
        case "JiraParameters":
            return Optional.ofNullable(clazz.cast(jiraParameters()));
        case "MariaDbParameters":
            return Optional.ofNullable(clazz.cast(mariaDbParameters()));
        case "MySqlParameters":
            return Optional.ofNullable(clazz.cast(mySqlParameters()));
        case "OracleParameters":
            return Optional.ofNullable(clazz.cast(oracleParameters()));
        case "PostgreSqlParameters":
            return Optional.ofNullable(clazz.cast(postgreSqlParameters()));
        case "PrestoParameters":
            return Optional.ofNullable(clazz.cast(prestoParameters()));
        case "RdsParameters":
            return Optional.ofNullable(clazz.cast(rdsParameters()));
        case "RedshiftParameters":
            return Optional.ofNullable(clazz.cast(redshiftParameters()));
        case "S3Parameters":
            return Optional.ofNullable(clazz.cast(s3Parameters()));
        case "ServiceNowParameters":
            return Optional.ofNullable(clazz.cast(serviceNowParameters()));
        case "SnowflakeParameters":
            return Optional.ofNullable(clazz.cast(snowflakeParameters()));
        case "SparkParameters":
            return Optional.ofNullable(clazz.cast(sparkParameters()));
        case "SqlServerParameters":
            return Optional.ofNullable(clazz.cast(sqlServerParameters()));
        case "TeradataParameters":
            return Optional.ofNullable(clazz.cast(teradataParameters()));
        case "TwitterParameters":
            return Optional.ofNullable(clazz.cast(twitterParameters()));
        case "AmazonOpenSearchParameters":
            return Optional.ofNullable(clazz.cast(amazonOpenSearchParameters()));
        case "ExasolParameters":
            return Optional.ofNullable(clazz.cast(exasolParameters()));
        case "DatabricksParameters":
            return Optional.ofNullable(clazz.cast(databricksParameters()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #amazonElasticsearchParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for OpenSearch.
     * </p>
     * 
     * @param amazonElasticsearchParameters
     *        The parameters for OpenSearch.
     */
    public static DataSourceParameters fromAmazonElasticsearchParameters(
            AmazonElasticsearchParameters amazonElasticsearchParameters) {
        return builder().amazonElasticsearchParameters(amazonElasticsearchParameters).build();
    }

    /**
     * Create an instance of this class with {@link #amazonElasticsearchParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for OpenSearch.
     * </p>
     * 
     * @param amazonElasticsearchParameters
     *        The parameters for OpenSearch.
     */
    public static DataSourceParameters fromAmazonElasticsearchParameters(
            Consumer<AmazonElasticsearchParameters.Builder> amazonElasticsearchParameters) {
        AmazonElasticsearchParameters.Builder builder = AmazonElasticsearchParameters.builder();
        amazonElasticsearchParameters.accept(builder);
        return fromAmazonElasticsearchParameters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #athenaParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Amazon Athena.
     * </p>
     * 
     * @param athenaParameters
     *        The parameters for Amazon Athena.
     */
    public static DataSourceParameters fromAthenaParameters(AthenaParameters athenaParameters) {
        return builder().athenaParameters(athenaParameters).build();
    }

    /**
     * Create an instance of this class with {@link #athenaParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Amazon Athena.
     * </p>
     * 
     * @param athenaParameters
     *        The parameters for Amazon Athena.
     */
    public static DataSourceParameters fromAthenaParameters(Consumer<AthenaParameters.Builder> athenaParameters) {
        AthenaParameters.Builder builder = AthenaParameters.builder();
        athenaParameters.accept(builder);
        return fromAthenaParameters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #auroraParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Amazon Aurora MySQL.
     * </p>
     * 
     * @param auroraParameters
     *        The parameters for Amazon Aurora MySQL.
     */
    public static DataSourceParameters fromAuroraParameters(AuroraParameters auroraParameters) {
        return builder().auroraParameters(auroraParameters).build();
    }

    /**
     * Create an instance of this class with {@link #auroraParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Amazon Aurora MySQL.
     * </p>
     * 
     * @param auroraParameters
     *        The parameters for Amazon Aurora MySQL.
     */
    public static DataSourceParameters fromAuroraParameters(Consumer<AuroraParameters.Builder> auroraParameters) {
        AuroraParameters.Builder builder = AuroraParameters.builder();
        auroraParameters.accept(builder);
        return fromAuroraParameters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #auroraPostgreSqlParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Amazon Aurora.
     * </p>
     * 
     * @param auroraPostgreSqlParameters
     *        The parameters for Amazon Aurora.
     */
    public static DataSourceParameters fromAuroraPostgreSqlParameters(AuroraPostgreSqlParameters auroraPostgreSqlParameters) {
        return builder().auroraPostgreSqlParameters(auroraPostgreSqlParameters).build();
    }

    /**
     * Create an instance of this class with {@link #auroraPostgreSqlParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Amazon Aurora.
     * </p>
     * 
     * @param auroraPostgreSqlParameters
     *        The parameters for Amazon Aurora.
     */
    public static DataSourceParameters fromAuroraPostgreSqlParameters(
            Consumer<AuroraPostgreSqlParameters.Builder> auroraPostgreSqlParameters) {
        AuroraPostgreSqlParameters.Builder builder = AuroraPostgreSqlParameters.builder();
        auroraPostgreSqlParameters.accept(builder);
        return fromAuroraPostgreSqlParameters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #awsIotAnalyticsParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for IoT Analytics.
     * </p>
     * 
     * @param awsIotAnalyticsParameters
     *        The parameters for IoT Analytics.
     */
    public static DataSourceParameters fromAwsIotAnalyticsParameters(AwsIotAnalyticsParameters awsIotAnalyticsParameters) {
        return builder().awsIotAnalyticsParameters(awsIotAnalyticsParameters).build();
    }

    /**
     * Create an instance of this class with {@link #awsIotAnalyticsParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for IoT Analytics.
     * </p>
     * 
     * @param awsIotAnalyticsParameters
     *        The parameters for IoT Analytics.
     */
    public static DataSourceParameters fromAwsIotAnalyticsParameters(
            Consumer<AwsIotAnalyticsParameters.Builder> awsIotAnalyticsParameters) {
        AwsIotAnalyticsParameters.Builder builder = AwsIotAnalyticsParameters.builder();
        awsIotAnalyticsParameters.accept(builder);
        return fromAwsIotAnalyticsParameters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #jiraParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Jira.
     * </p>
     * 
     * @param jiraParameters
     *        The parameters for Jira.
     */
    public static DataSourceParameters fromJiraParameters(JiraParameters jiraParameters) {
        return builder().jiraParameters(jiraParameters).build();
    }

    /**
     * Create an instance of this class with {@link #jiraParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Jira.
     * </p>
     * 
     * @param jiraParameters
     *        The parameters for Jira.
     */
    public static DataSourceParameters fromJiraParameters(Consumer<JiraParameters.Builder> jiraParameters) {
        JiraParameters.Builder builder = JiraParameters.builder();
        jiraParameters.accept(builder);
        return fromJiraParameters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #mariaDbParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for MariaDB.
     * </p>
     * 
     * @param mariaDbParameters
     *        The parameters for MariaDB.
     */
    public static DataSourceParameters fromMariaDbParameters(MariaDbParameters mariaDbParameters) {
        return builder().mariaDbParameters(mariaDbParameters).build();
    }

    /**
     * Create an instance of this class with {@link #mariaDbParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for MariaDB.
     * </p>
     * 
     * @param mariaDbParameters
     *        The parameters for MariaDB.
     */
    public static DataSourceParameters fromMariaDbParameters(Consumer<MariaDbParameters.Builder> mariaDbParameters) {
        MariaDbParameters.Builder builder = MariaDbParameters.builder();
        mariaDbParameters.accept(builder);
        return fromMariaDbParameters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #mySqlParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for MySQL.
     * </p>
     * 
     * @param mySqlParameters
     *        The parameters for MySQL.
     */
    public static DataSourceParameters fromMySqlParameters(MySqlParameters mySqlParameters) {
        return builder().mySqlParameters(mySqlParameters).build();
    }

    /**
     * Create an instance of this class with {@link #mySqlParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for MySQL.
     * </p>
     * 
     * @param mySqlParameters
     *        The parameters for MySQL.
     */
    public static DataSourceParameters fromMySqlParameters(Consumer<MySqlParameters.Builder> mySqlParameters) {
        MySqlParameters.Builder builder = MySqlParameters.builder();
        mySqlParameters.accept(builder);
        return fromMySqlParameters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #oracleParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Oracle.
     * </p>
     * 
     * @param oracleParameters
     *        The parameters for Oracle.
     */
    public static DataSourceParameters fromOracleParameters(OracleParameters oracleParameters) {
        return builder().oracleParameters(oracleParameters).build();
    }

    /**
     * Create an instance of this class with {@link #oracleParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Oracle.
     * </p>
     * 
     * @param oracleParameters
     *        The parameters for Oracle.
     */
    public static DataSourceParameters fromOracleParameters(Consumer<OracleParameters.Builder> oracleParameters) {
        OracleParameters.Builder builder = OracleParameters.builder();
        oracleParameters.accept(builder);
        return fromOracleParameters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #postgreSqlParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for PostgreSQL.
     * </p>
     * 
     * @param postgreSqlParameters
     *        The parameters for PostgreSQL.
     */
    public static DataSourceParameters fromPostgreSqlParameters(PostgreSqlParameters postgreSqlParameters) {
        return builder().postgreSqlParameters(postgreSqlParameters).build();
    }

    /**
     * Create an instance of this class with {@link #postgreSqlParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for PostgreSQL.
     * </p>
     * 
     * @param postgreSqlParameters
     *        The parameters for PostgreSQL.
     */
    public static DataSourceParameters fromPostgreSqlParameters(Consumer<PostgreSqlParameters.Builder> postgreSqlParameters) {
        PostgreSqlParameters.Builder builder = PostgreSqlParameters.builder();
        postgreSqlParameters.accept(builder);
        return fromPostgreSqlParameters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #prestoParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Presto.
     * </p>
     * 
     * @param prestoParameters
     *        The parameters for Presto.
     */
    public static DataSourceParameters fromPrestoParameters(PrestoParameters prestoParameters) {
        return builder().prestoParameters(prestoParameters).build();
    }

    /**
     * Create an instance of this class with {@link #prestoParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Presto.
     * </p>
     * 
     * @param prestoParameters
     *        The parameters for Presto.
     */
    public static DataSourceParameters fromPrestoParameters(Consumer<PrestoParameters.Builder> prestoParameters) {
        PrestoParameters.Builder builder = PrestoParameters.builder();
        prestoParameters.accept(builder);
        return fromPrestoParameters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #rdsParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Amazon RDS.
     * </p>
     * 
     * @param rdsParameters
     *        The parameters for Amazon RDS.
     */
    public static DataSourceParameters fromRdsParameters(RdsParameters rdsParameters) {
        return builder().rdsParameters(rdsParameters).build();
    }

    /**
     * Create an instance of this class with {@link #rdsParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Amazon RDS.
     * </p>
     * 
     * @param rdsParameters
     *        The parameters for Amazon RDS.
     */
    public static DataSourceParameters fromRdsParameters(Consumer<RdsParameters.Builder> rdsParameters) {
        RdsParameters.Builder builder = RdsParameters.builder();
        rdsParameters.accept(builder);
        return fromRdsParameters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #redshiftParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Amazon Redshift.
     * </p>
     * 
     * @param redshiftParameters
     *        The parameters for Amazon Redshift.
     */
    public static DataSourceParameters fromRedshiftParameters(RedshiftParameters redshiftParameters) {
        return builder().redshiftParameters(redshiftParameters).build();
    }

    /**
     * Create an instance of this class with {@link #redshiftParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Amazon Redshift.
     * </p>
     * 
     * @param redshiftParameters
     *        The parameters for Amazon Redshift.
     */
    public static DataSourceParameters fromRedshiftParameters(Consumer<RedshiftParameters.Builder> redshiftParameters) {
        RedshiftParameters.Builder builder = RedshiftParameters.builder();
        redshiftParameters.accept(builder);
        return fromRedshiftParameters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #s3Parameters()} initialized to the given value.
     *
     * <p>
     * The parameters for S3.
     * </p>
     * 
     * @param s3Parameters
     *        The parameters for S3.
     */
    public static DataSourceParameters fromS3Parameters(S3Parameters s3Parameters) {
        return builder().s3Parameters(s3Parameters).build();
    }

    /**
     * Create an instance of this class with {@link #s3Parameters()} initialized to the given value.
     *
     * <p>
     * The parameters for S3.
     * </p>
     * 
     * @param s3Parameters
     *        The parameters for S3.
     */
    public static DataSourceParameters fromS3Parameters(Consumer<S3Parameters.Builder> s3Parameters) {
        S3Parameters.Builder builder = S3Parameters.builder();
        s3Parameters.accept(builder);
        return fromS3Parameters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #serviceNowParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for ServiceNow.
     * </p>
     * 
     * @param serviceNowParameters
     *        The parameters for ServiceNow.
     */
    public static DataSourceParameters fromServiceNowParameters(ServiceNowParameters serviceNowParameters) {
        return builder().serviceNowParameters(serviceNowParameters).build();
    }

    /**
     * Create an instance of this class with {@link #serviceNowParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for ServiceNow.
     * </p>
     * 
     * @param serviceNowParameters
     *        The parameters for ServiceNow.
     */
    public static DataSourceParameters fromServiceNowParameters(Consumer<ServiceNowParameters.Builder> serviceNowParameters) {
        ServiceNowParameters.Builder builder = ServiceNowParameters.builder();
        serviceNowParameters.accept(builder);
        return fromServiceNowParameters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #snowflakeParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Snowflake.
     * </p>
     * 
     * @param snowflakeParameters
     *        The parameters for Snowflake.
     */
    public static DataSourceParameters fromSnowflakeParameters(SnowflakeParameters snowflakeParameters) {
        return builder().snowflakeParameters(snowflakeParameters).build();
    }

    /**
     * Create an instance of this class with {@link #snowflakeParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Snowflake.
     * </p>
     * 
     * @param snowflakeParameters
     *        The parameters for Snowflake.
     */
    public static DataSourceParameters fromSnowflakeParameters(Consumer<SnowflakeParameters.Builder> snowflakeParameters) {
        SnowflakeParameters.Builder builder = SnowflakeParameters.builder();
        snowflakeParameters.accept(builder);
        return fromSnowflakeParameters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sparkParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Spark.
     * </p>
     * 
     * @param sparkParameters
     *        The parameters for Spark.
     */
    public static DataSourceParameters fromSparkParameters(SparkParameters sparkParameters) {
        return builder().sparkParameters(sparkParameters).build();
    }

    /**
     * Create an instance of this class with {@link #sparkParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Spark.
     * </p>
     * 
     * @param sparkParameters
     *        The parameters for Spark.
     */
    public static DataSourceParameters fromSparkParameters(Consumer<SparkParameters.Builder> sparkParameters) {
        SparkParameters.Builder builder = SparkParameters.builder();
        sparkParameters.accept(builder);
        return fromSparkParameters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sqlServerParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for SQL Server.
     * </p>
     * 
     * @param sqlServerParameters
     *        The parameters for SQL Server.
     */
    public static DataSourceParameters fromSqlServerParameters(SqlServerParameters sqlServerParameters) {
        return builder().sqlServerParameters(sqlServerParameters).build();
    }

    /**
     * Create an instance of this class with {@link #sqlServerParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for SQL Server.
     * </p>
     * 
     * @param sqlServerParameters
     *        The parameters for SQL Server.
     */
    public static DataSourceParameters fromSqlServerParameters(Consumer<SqlServerParameters.Builder> sqlServerParameters) {
        SqlServerParameters.Builder builder = SqlServerParameters.builder();
        sqlServerParameters.accept(builder);
        return fromSqlServerParameters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #teradataParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Teradata.
     * </p>
     * 
     * @param teradataParameters
     *        The parameters for Teradata.
     */
    public static DataSourceParameters fromTeradataParameters(TeradataParameters teradataParameters) {
        return builder().teradataParameters(teradataParameters).build();
    }

    /**
     * Create an instance of this class with {@link #teradataParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Teradata.
     * </p>
     * 
     * @param teradataParameters
     *        The parameters for Teradata.
     */
    public static DataSourceParameters fromTeradataParameters(Consumer<TeradataParameters.Builder> teradataParameters) {
        TeradataParameters.Builder builder = TeradataParameters.builder();
        teradataParameters.accept(builder);
        return fromTeradataParameters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #twitterParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Twitter.
     * </p>
     * 
     * @param twitterParameters
     *        The parameters for Twitter.
     */
    public static DataSourceParameters fromTwitterParameters(TwitterParameters twitterParameters) {
        return builder().twitterParameters(twitterParameters).build();
    }

    /**
     * Create an instance of this class with {@link #twitterParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Twitter.
     * </p>
     * 
     * @param twitterParameters
     *        The parameters for Twitter.
     */
    public static DataSourceParameters fromTwitterParameters(Consumer<TwitterParameters.Builder> twitterParameters) {
        TwitterParameters.Builder builder = TwitterParameters.builder();
        twitterParameters.accept(builder);
        return fromTwitterParameters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #amazonOpenSearchParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for OpenSearch.
     * </p>
     * 
     * @param amazonOpenSearchParameters
     *        The parameters for OpenSearch.
     */
    public static DataSourceParameters fromAmazonOpenSearchParameters(AmazonOpenSearchParameters amazonOpenSearchParameters) {
        return builder().amazonOpenSearchParameters(amazonOpenSearchParameters).build();
    }

    /**
     * Create an instance of this class with {@link #amazonOpenSearchParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for OpenSearch.
     * </p>
     * 
     * @param amazonOpenSearchParameters
     *        The parameters for OpenSearch.
     */
    public static DataSourceParameters fromAmazonOpenSearchParameters(
            Consumer<AmazonOpenSearchParameters.Builder> amazonOpenSearchParameters) {
        AmazonOpenSearchParameters.Builder builder = AmazonOpenSearchParameters.builder();
        amazonOpenSearchParameters.accept(builder);
        return fromAmazonOpenSearchParameters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #exasolParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Exasol.
     * </p>
     * 
     * @param exasolParameters
     *        The parameters for Exasol.
     */
    public static DataSourceParameters fromExasolParameters(ExasolParameters exasolParameters) {
        return builder().exasolParameters(exasolParameters).build();
    }

    /**
     * Create an instance of this class with {@link #exasolParameters()} initialized to the given value.
     *
     * <p>
     * The parameters for Exasol.
     * </p>
     * 
     * @param exasolParameters
     *        The parameters for Exasol.
     */
    public static DataSourceParameters fromExasolParameters(Consumer<ExasolParameters.Builder> exasolParameters) {
        ExasolParameters.Builder builder = ExasolParameters.builder();
        exasolParameters.accept(builder);
        return fromExasolParameters(builder.build());
    }

    /**
     * Create an instance of this class with {@link #databricksParameters()} initialized to the given value.
     *
     * <p>
     * The required parameters that are needed to connect to a Databricks data source.
     * </p>
     * 
     * @param databricksParameters
     *        The required parameters that are needed to connect to a Databricks data source.
     */
    public static DataSourceParameters fromDatabricksParameters(DatabricksParameters databricksParameters) {
        return builder().databricksParameters(databricksParameters).build();
    }

    /**
     * Create an instance of this class with {@link #databricksParameters()} initialized to the given value.
     *
     * <p>
     * The required parameters that are needed to connect to a Databricks data source.
     * </p>
     * 
     * @param databricksParameters
     *        The required parameters that are needed to connect to a Databricks data source.
     */
    public static DataSourceParameters fromDatabricksParameters(Consumer<DatabricksParameters.Builder> databricksParameters) {
        DatabricksParameters.Builder builder = DatabricksParameters.builder();
        databricksParameters.accept(builder);
        return fromDatabricksParameters(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceParameters, T> g) {
        return obj -> g.apply((DataSourceParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceParameters> {
        /**
         * <p>
         * The parameters for OpenSearch.
         * </p>
         * 
         * @param amazonElasticsearchParameters
         *        The parameters for OpenSearch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonElasticsearchParameters(AmazonElasticsearchParameters amazonElasticsearchParameters);

        /**
         * <p>
         * The parameters for OpenSearch.
         * </p>
         * This is a convenience method that creates an instance of the {@link AmazonElasticsearchParameters.Builder}
         * avoiding the need to create one manually via {@link AmazonElasticsearchParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmazonElasticsearchParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #amazonElasticsearchParameters(AmazonElasticsearchParameters)}.
         * 
         * @param amazonElasticsearchParameters
         *        a consumer that will call methods on {@link AmazonElasticsearchParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amazonElasticsearchParameters(AmazonElasticsearchParameters)
         */
        default Builder amazonElasticsearchParameters(
                Consumer<AmazonElasticsearchParameters.Builder> amazonElasticsearchParameters) {
            return amazonElasticsearchParameters(AmazonElasticsearchParameters.builder()
                    .applyMutation(amazonElasticsearchParameters).build());
        }

        /**
         * <p>
         * The parameters for Amazon Athena.
         * </p>
         * 
         * @param athenaParameters
         *        The parameters for Amazon Athena.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder athenaParameters(AthenaParameters athenaParameters);

        /**
         * <p>
         * The parameters for Amazon Athena.
         * </p>
         * This is a convenience method that creates an instance of the {@link AthenaParameters.Builder} avoiding the
         * need to create one manually via {@link AthenaParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AthenaParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #athenaParameters(AthenaParameters)}.
         * 
         * @param athenaParameters
         *        a consumer that will call methods on {@link AthenaParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #athenaParameters(AthenaParameters)
         */
        default Builder athenaParameters(Consumer<AthenaParameters.Builder> athenaParameters) {
            return athenaParameters(AthenaParameters.builder().applyMutation(athenaParameters).build());
        }

        /**
         * <p>
         * The parameters for Amazon Aurora MySQL.
         * </p>
         * 
         * @param auroraParameters
         *        The parameters for Amazon Aurora MySQL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auroraParameters(AuroraParameters auroraParameters);

        /**
         * <p>
         * The parameters for Amazon Aurora MySQL.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuroraParameters.Builder} avoiding the
         * need to create one manually via {@link AuroraParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuroraParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #auroraParameters(AuroraParameters)}.
         * 
         * @param auroraParameters
         *        a consumer that will call methods on {@link AuroraParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auroraParameters(AuroraParameters)
         */
        default Builder auroraParameters(Consumer<AuroraParameters.Builder> auroraParameters) {
            return auroraParameters(AuroraParameters.builder().applyMutation(auroraParameters).build());
        }

        /**
         * <p>
         * The parameters for Amazon Aurora.
         * </p>
         * 
         * @param auroraPostgreSqlParameters
         *        The parameters for Amazon Aurora.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auroraPostgreSqlParameters(AuroraPostgreSqlParameters auroraPostgreSqlParameters);

        /**
         * <p>
         * The parameters for Amazon Aurora.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuroraPostgreSqlParameters.Builder}
         * avoiding the need to create one manually via {@link AuroraPostgreSqlParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuroraPostgreSqlParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #auroraPostgreSqlParameters(AuroraPostgreSqlParameters)}.
         * 
         * @param auroraPostgreSqlParameters
         *        a consumer that will call methods on {@link AuroraPostgreSqlParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auroraPostgreSqlParameters(AuroraPostgreSqlParameters)
         */
        default Builder auroraPostgreSqlParameters(Consumer<AuroraPostgreSqlParameters.Builder> auroraPostgreSqlParameters) {
            return auroraPostgreSqlParameters(AuroraPostgreSqlParameters.builder().applyMutation(auroraPostgreSqlParameters)
                    .build());
        }

        /**
         * <p>
         * The parameters for IoT Analytics.
         * </p>
         * 
         * @param awsIotAnalyticsParameters
         *        The parameters for IoT Analytics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsIotAnalyticsParameters(AwsIotAnalyticsParameters awsIotAnalyticsParameters);

        /**
         * <p>
         * The parameters for IoT Analytics.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsIotAnalyticsParameters.Builder}
         * avoiding the need to create one manually via {@link AwsIotAnalyticsParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsIotAnalyticsParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #awsIotAnalyticsParameters(AwsIotAnalyticsParameters)}.
         * 
         * @param awsIotAnalyticsParameters
         *        a consumer that will call methods on {@link AwsIotAnalyticsParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsIotAnalyticsParameters(AwsIotAnalyticsParameters)
         */
        default Builder awsIotAnalyticsParameters(Consumer<AwsIotAnalyticsParameters.Builder> awsIotAnalyticsParameters) {
            return awsIotAnalyticsParameters(AwsIotAnalyticsParameters.builder().applyMutation(awsIotAnalyticsParameters).build());
        }

        /**
         * <p>
         * The parameters for Jira.
         * </p>
         * 
         * @param jiraParameters
         *        The parameters for Jira.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jiraParameters(JiraParameters jiraParameters);

        /**
         * <p>
         * The parameters for Jira.
         * </p>
         * This is a convenience method that creates an instance of the {@link JiraParameters.Builder} avoiding the need
         * to create one manually via {@link JiraParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JiraParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #jiraParameters(JiraParameters)}.
         * 
         * @param jiraParameters
         *        a consumer that will call methods on {@link JiraParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jiraParameters(JiraParameters)
         */
        default Builder jiraParameters(Consumer<JiraParameters.Builder> jiraParameters) {
            return jiraParameters(JiraParameters.builder().applyMutation(jiraParameters).build());
        }

        /**
         * <p>
         * The parameters for MariaDB.
         * </p>
         * 
         * @param mariaDbParameters
         *        The parameters for MariaDB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mariaDbParameters(MariaDbParameters mariaDbParameters);

        /**
         * <p>
         * The parameters for MariaDB.
         * </p>
         * This is a convenience method that creates an instance of the {@link MariaDbParameters.Builder} avoiding the
         * need to create one manually via {@link MariaDbParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MariaDbParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #mariaDbParameters(MariaDbParameters)}.
         * 
         * @param mariaDbParameters
         *        a consumer that will call methods on {@link MariaDbParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mariaDbParameters(MariaDbParameters)
         */
        default Builder mariaDbParameters(Consumer<MariaDbParameters.Builder> mariaDbParameters) {
            return mariaDbParameters(MariaDbParameters.builder().applyMutation(mariaDbParameters).build());
        }

        /**
         * <p>
         * The parameters for MySQL.
         * </p>
         * 
         * @param mySqlParameters
         *        The parameters for MySQL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mySqlParameters(MySqlParameters mySqlParameters);

        /**
         * <p>
         * The parameters for MySQL.
         * </p>
         * This is a convenience method that creates an instance of the {@link MySqlParameters.Builder} avoiding the
         * need to create one manually via {@link MySqlParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MySqlParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #mySqlParameters(MySqlParameters)}.
         * 
         * @param mySqlParameters
         *        a consumer that will call methods on {@link MySqlParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mySqlParameters(MySqlParameters)
         */
        default Builder mySqlParameters(Consumer<MySqlParameters.Builder> mySqlParameters) {
            return mySqlParameters(MySqlParameters.builder().applyMutation(mySqlParameters).build());
        }

        /**
         * <p>
         * The parameters for Oracle.
         * </p>
         * 
         * @param oracleParameters
         *        The parameters for Oracle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oracleParameters(OracleParameters oracleParameters);

        /**
         * <p>
         * The parameters for Oracle.
         * </p>
         * This is a convenience method that creates an instance of the {@link OracleParameters.Builder} avoiding the
         * need to create one manually via {@link OracleParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OracleParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #oracleParameters(OracleParameters)}.
         * 
         * @param oracleParameters
         *        a consumer that will call methods on {@link OracleParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oracleParameters(OracleParameters)
         */
        default Builder oracleParameters(Consumer<OracleParameters.Builder> oracleParameters) {
            return oracleParameters(OracleParameters.builder().applyMutation(oracleParameters).build());
        }

        /**
         * <p>
         * The parameters for PostgreSQL.
         * </p>
         * 
         * @param postgreSqlParameters
         *        The parameters for PostgreSQL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postgreSqlParameters(PostgreSqlParameters postgreSqlParameters);

        /**
         * <p>
         * The parameters for PostgreSQL.
         * </p>
         * This is a convenience method that creates an instance of the {@link PostgreSqlParameters.Builder} avoiding
         * the need to create one manually via {@link PostgreSqlParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PostgreSqlParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #postgreSqlParameters(PostgreSqlParameters)}.
         * 
         * @param postgreSqlParameters
         *        a consumer that will call methods on {@link PostgreSqlParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postgreSqlParameters(PostgreSqlParameters)
         */
        default Builder postgreSqlParameters(Consumer<PostgreSqlParameters.Builder> postgreSqlParameters) {
            return postgreSqlParameters(PostgreSqlParameters.builder().applyMutation(postgreSqlParameters).build());
        }

        /**
         * <p>
         * The parameters for Presto.
         * </p>
         * 
         * @param prestoParameters
         *        The parameters for Presto.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prestoParameters(PrestoParameters prestoParameters);

        /**
         * <p>
         * The parameters for Presto.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrestoParameters.Builder} avoiding the
         * need to create one manually via {@link PrestoParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrestoParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #prestoParameters(PrestoParameters)}.
         * 
         * @param prestoParameters
         *        a consumer that will call methods on {@link PrestoParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prestoParameters(PrestoParameters)
         */
        default Builder prestoParameters(Consumer<PrestoParameters.Builder> prestoParameters) {
            return prestoParameters(PrestoParameters.builder().applyMutation(prestoParameters).build());
        }

        /**
         * <p>
         * The parameters for Amazon RDS.
         * </p>
         * 
         * @param rdsParameters
         *        The parameters for Amazon RDS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsParameters(RdsParameters rdsParameters);

        /**
         * <p>
         * The parameters for Amazon RDS.
         * </p>
         * This is a convenience method that creates an instance of the {@link RdsParameters.Builder} avoiding the need
         * to create one manually via {@link RdsParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RdsParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #rdsParameters(RdsParameters)}.
         * 
         * @param rdsParameters
         *        a consumer that will call methods on {@link RdsParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rdsParameters(RdsParameters)
         */
        default Builder rdsParameters(Consumer<RdsParameters.Builder> rdsParameters) {
            return rdsParameters(RdsParameters.builder().applyMutation(rdsParameters).build());
        }

        /**
         * <p>
         * The parameters for Amazon Redshift.
         * </p>
         * 
         * @param redshiftParameters
         *        The parameters for Amazon Redshift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftParameters(RedshiftParameters redshiftParameters);

        /**
         * <p>
         * The parameters for Amazon Redshift.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftParameters.Builder} avoiding the
         * need to create one manually via {@link RedshiftParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #redshiftParameters(RedshiftParameters)}.
         * 
         * @param redshiftParameters
         *        a consumer that will call methods on {@link RedshiftParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftParameters(RedshiftParameters)
         */
        default Builder redshiftParameters(Consumer<RedshiftParameters.Builder> redshiftParameters) {
            return redshiftParameters(RedshiftParameters.builder().applyMutation(redshiftParameters).build());
        }

        /**
         * <p>
         * The parameters for S3.
         * </p>
         * 
         * @param s3Parameters
         *        The parameters for S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Parameters(S3Parameters s3Parameters);

        /**
         * <p>
         * The parameters for S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Parameters.Builder} avoiding the need
         * to create one manually via {@link S3Parameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Parameters.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Parameters(S3Parameters)}.
         * 
         * @param s3Parameters
         *        a consumer that will call methods on {@link S3Parameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Parameters(S3Parameters)
         */
        default Builder s3Parameters(Consumer<S3Parameters.Builder> s3Parameters) {
            return s3Parameters(S3Parameters.builder().applyMutation(s3Parameters).build());
        }

        /**
         * <p>
         * The parameters for ServiceNow.
         * </p>
         * 
         * @param serviceNowParameters
         *        The parameters for ServiceNow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNowParameters(ServiceNowParameters serviceNowParameters);

        /**
         * <p>
         * The parameters for ServiceNow.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceNowParameters.Builder} avoiding
         * the need to create one manually via {@link ServiceNowParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceNowParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceNowParameters(ServiceNowParameters)}.
         * 
         * @param serviceNowParameters
         *        a consumer that will call methods on {@link ServiceNowParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceNowParameters(ServiceNowParameters)
         */
        default Builder serviceNowParameters(Consumer<ServiceNowParameters.Builder> serviceNowParameters) {
            return serviceNowParameters(ServiceNowParameters.builder().applyMutation(serviceNowParameters).build());
        }

        /**
         * <p>
         * The parameters for Snowflake.
         * </p>
         * 
         * @param snowflakeParameters
         *        The parameters for Snowflake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snowflakeParameters(SnowflakeParameters snowflakeParameters);

        /**
         * <p>
         * The parameters for Snowflake.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnowflakeParameters.Builder} avoiding the
         * need to create one manually via {@link SnowflakeParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnowflakeParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #snowflakeParameters(SnowflakeParameters)}.
         * 
         * @param snowflakeParameters
         *        a consumer that will call methods on {@link SnowflakeParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snowflakeParameters(SnowflakeParameters)
         */
        default Builder snowflakeParameters(Consumer<SnowflakeParameters.Builder> snowflakeParameters) {
            return snowflakeParameters(SnowflakeParameters.builder().applyMutation(snowflakeParameters).build());
        }

        /**
         * <p>
         * The parameters for Spark.
         * </p>
         * 
         * @param sparkParameters
         *        The parameters for Spark.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparkParameters(SparkParameters sparkParameters);

        /**
         * <p>
         * The parameters for Spark.
         * </p>
         * This is a convenience method that creates an instance of the {@link SparkParameters.Builder} avoiding the
         * need to create one manually via {@link SparkParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SparkParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #sparkParameters(SparkParameters)}.
         * 
         * @param sparkParameters
         *        a consumer that will call methods on {@link SparkParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sparkParameters(SparkParameters)
         */
        default Builder sparkParameters(Consumer<SparkParameters.Builder> sparkParameters) {
            return sparkParameters(SparkParameters.builder().applyMutation(sparkParameters).build());
        }

        /**
         * <p>
         * The parameters for SQL Server.
         * </p>
         * 
         * @param sqlServerParameters
         *        The parameters for SQL Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlServerParameters(SqlServerParameters sqlServerParameters);

        /**
         * <p>
         * The parameters for SQL Server.
         * </p>
         * This is a convenience method that creates an instance of the {@link SqlServerParameters.Builder} avoiding the
         * need to create one manually via {@link SqlServerParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SqlServerParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #sqlServerParameters(SqlServerParameters)}.
         * 
         * @param sqlServerParameters
         *        a consumer that will call methods on {@link SqlServerParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqlServerParameters(SqlServerParameters)
         */
        default Builder sqlServerParameters(Consumer<SqlServerParameters.Builder> sqlServerParameters) {
            return sqlServerParameters(SqlServerParameters.builder().applyMutation(sqlServerParameters).build());
        }

        /**
         * <p>
         * The parameters for Teradata.
         * </p>
         * 
         * @param teradataParameters
         *        The parameters for Teradata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teradataParameters(TeradataParameters teradataParameters);

        /**
         * <p>
         * The parameters for Teradata.
         * </p>
         * This is a convenience method that creates an instance of the {@link TeradataParameters.Builder} avoiding the
         * need to create one manually via {@link TeradataParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TeradataParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #teradataParameters(TeradataParameters)}.
         * 
         * @param teradataParameters
         *        a consumer that will call methods on {@link TeradataParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #teradataParameters(TeradataParameters)
         */
        default Builder teradataParameters(Consumer<TeradataParameters.Builder> teradataParameters) {
            return teradataParameters(TeradataParameters.builder().applyMutation(teradataParameters).build());
        }

        /**
         * <p>
         * The parameters for Twitter.
         * </p>
         * 
         * @param twitterParameters
         *        The parameters for Twitter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder twitterParameters(TwitterParameters twitterParameters);

        /**
         * <p>
         * The parameters for Twitter.
         * </p>
         * This is a convenience method that creates an instance of the {@link TwitterParameters.Builder} avoiding the
         * need to create one manually via {@link TwitterParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TwitterParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #twitterParameters(TwitterParameters)}.
         * 
         * @param twitterParameters
         *        a consumer that will call methods on {@link TwitterParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #twitterParameters(TwitterParameters)
         */
        default Builder twitterParameters(Consumer<TwitterParameters.Builder> twitterParameters) {
            return twitterParameters(TwitterParameters.builder().applyMutation(twitterParameters).build());
        }

        /**
         * <p>
         * The parameters for OpenSearch.
         * </p>
         * 
         * @param amazonOpenSearchParameters
         *        The parameters for OpenSearch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonOpenSearchParameters(AmazonOpenSearchParameters amazonOpenSearchParameters);

        /**
         * <p>
         * The parameters for OpenSearch.
         * </p>
         * This is a convenience method that creates an instance of the {@link AmazonOpenSearchParameters.Builder}
         * avoiding the need to create one manually via {@link AmazonOpenSearchParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmazonOpenSearchParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #amazonOpenSearchParameters(AmazonOpenSearchParameters)}.
         * 
         * @param amazonOpenSearchParameters
         *        a consumer that will call methods on {@link AmazonOpenSearchParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amazonOpenSearchParameters(AmazonOpenSearchParameters)
         */
        default Builder amazonOpenSearchParameters(Consumer<AmazonOpenSearchParameters.Builder> amazonOpenSearchParameters) {
            return amazonOpenSearchParameters(AmazonOpenSearchParameters.builder().applyMutation(amazonOpenSearchParameters)
                    .build());
        }

        /**
         * <p>
         * The parameters for Exasol.
         * </p>
         * 
         * @param exasolParameters
         *        The parameters for Exasol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exasolParameters(ExasolParameters exasolParameters);

        /**
         * <p>
         * The parameters for Exasol.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExasolParameters.Builder} avoiding the
         * need to create one manually via {@link ExasolParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExasolParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #exasolParameters(ExasolParameters)}.
         * 
         * @param exasolParameters
         *        a consumer that will call methods on {@link ExasolParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exasolParameters(ExasolParameters)
         */
        default Builder exasolParameters(Consumer<ExasolParameters.Builder> exasolParameters) {
            return exasolParameters(ExasolParameters.builder().applyMutation(exasolParameters).build());
        }

        /**
         * <p>
         * The required parameters that are needed to connect to a Databricks data source.
         * </p>
         * 
         * @param databricksParameters
         *        The required parameters that are needed to connect to a Databricks data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databricksParameters(DatabricksParameters databricksParameters);

        /**
         * <p>
         * The required parameters that are needed to connect to a Databricks data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatabricksParameters.Builder} avoiding
         * the need to create one manually via {@link DatabricksParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatabricksParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #databricksParameters(DatabricksParameters)}.
         * 
         * @param databricksParameters
         *        a consumer that will call methods on {@link DatabricksParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #databricksParameters(DatabricksParameters)
         */
        default Builder databricksParameters(Consumer<DatabricksParameters.Builder> databricksParameters) {
            return databricksParameters(DatabricksParameters.builder().applyMutation(databricksParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AmazonElasticsearchParameters amazonElasticsearchParameters;

        private AthenaParameters athenaParameters;

        private AuroraParameters auroraParameters;

        private AuroraPostgreSqlParameters auroraPostgreSqlParameters;

        private AwsIotAnalyticsParameters awsIotAnalyticsParameters;

        private JiraParameters jiraParameters;

        private MariaDbParameters mariaDbParameters;

        private MySqlParameters mySqlParameters;

        private OracleParameters oracleParameters;

        private PostgreSqlParameters postgreSqlParameters;

        private PrestoParameters prestoParameters;

        private RdsParameters rdsParameters;

        private RedshiftParameters redshiftParameters;

        private S3Parameters s3Parameters;

        private ServiceNowParameters serviceNowParameters;

        private SnowflakeParameters snowflakeParameters;

        private SparkParameters sparkParameters;

        private SqlServerParameters sqlServerParameters;

        private TeradataParameters teradataParameters;

        private TwitterParameters twitterParameters;

        private AmazonOpenSearchParameters amazonOpenSearchParameters;

        private ExasolParameters exasolParameters;

        private DatabricksParameters databricksParameters;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceParameters model) {
            amazonElasticsearchParameters(model.amazonElasticsearchParameters);
            athenaParameters(model.athenaParameters);
            auroraParameters(model.auroraParameters);
            auroraPostgreSqlParameters(model.auroraPostgreSqlParameters);
            awsIotAnalyticsParameters(model.awsIotAnalyticsParameters);
            jiraParameters(model.jiraParameters);
            mariaDbParameters(model.mariaDbParameters);
            mySqlParameters(model.mySqlParameters);
            oracleParameters(model.oracleParameters);
            postgreSqlParameters(model.postgreSqlParameters);
            prestoParameters(model.prestoParameters);
            rdsParameters(model.rdsParameters);
            redshiftParameters(model.redshiftParameters);
            s3Parameters(model.s3Parameters);
            serviceNowParameters(model.serviceNowParameters);
            snowflakeParameters(model.snowflakeParameters);
            sparkParameters(model.sparkParameters);
            sqlServerParameters(model.sqlServerParameters);
            teradataParameters(model.teradataParameters);
            twitterParameters(model.twitterParameters);
            amazonOpenSearchParameters(model.amazonOpenSearchParameters);
            exasolParameters(model.exasolParameters);
            databricksParameters(model.databricksParameters);
        }

        public final AmazonElasticsearchParameters.Builder getAmazonElasticsearchParameters() {
            return amazonElasticsearchParameters != null ? amazonElasticsearchParameters.toBuilder() : null;
        }

        public final void setAmazonElasticsearchParameters(AmazonElasticsearchParameters.BuilderImpl amazonElasticsearchParameters) {
            Object oldValue = this.amazonElasticsearchParameters;
            this.amazonElasticsearchParameters = amazonElasticsearchParameters != null ? amazonElasticsearchParameters.build()
                    : null;
            handleUnionValueChange(Type.AMAZON_ELASTICSEARCH_PARAMETERS, oldValue, this.amazonElasticsearchParameters);
        }

        @Override
        public final Builder amazonElasticsearchParameters(AmazonElasticsearchParameters amazonElasticsearchParameters) {
            Object oldValue = this.amazonElasticsearchParameters;
            this.amazonElasticsearchParameters = amazonElasticsearchParameters;
            handleUnionValueChange(Type.AMAZON_ELASTICSEARCH_PARAMETERS, oldValue, this.amazonElasticsearchParameters);
            return this;
        }

        public final AthenaParameters.Builder getAthenaParameters() {
            return athenaParameters != null ? athenaParameters.toBuilder() : null;
        }

        public final void setAthenaParameters(AthenaParameters.BuilderImpl athenaParameters) {
            Object oldValue = this.athenaParameters;
            this.athenaParameters = athenaParameters != null ? athenaParameters.build() : null;
            handleUnionValueChange(Type.ATHENA_PARAMETERS, oldValue, this.athenaParameters);
        }

        @Override
        public final Builder athenaParameters(AthenaParameters athenaParameters) {
            Object oldValue = this.athenaParameters;
            this.athenaParameters = athenaParameters;
            handleUnionValueChange(Type.ATHENA_PARAMETERS, oldValue, this.athenaParameters);
            return this;
        }

        public final AuroraParameters.Builder getAuroraParameters() {
            return auroraParameters != null ? auroraParameters.toBuilder() : null;
        }

        public final void setAuroraParameters(AuroraParameters.BuilderImpl auroraParameters) {
            Object oldValue = this.auroraParameters;
            this.auroraParameters = auroraParameters != null ? auroraParameters.build() : null;
            handleUnionValueChange(Type.AURORA_PARAMETERS, oldValue, this.auroraParameters);
        }

        @Override
        public final Builder auroraParameters(AuroraParameters auroraParameters) {
            Object oldValue = this.auroraParameters;
            this.auroraParameters = auroraParameters;
            handleUnionValueChange(Type.AURORA_PARAMETERS, oldValue, this.auroraParameters);
            return this;
        }

        public final AuroraPostgreSqlParameters.Builder getAuroraPostgreSqlParameters() {
            return auroraPostgreSqlParameters != null ? auroraPostgreSqlParameters.toBuilder() : null;
        }

        public final void setAuroraPostgreSqlParameters(AuroraPostgreSqlParameters.BuilderImpl auroraPostgreSqlParameters) {
            Object oldValue = this.auroraPostgreSqlParameters;
            this.auroraPostgreSqlParameters = auroraPostgreSqlParameters != null ? auroraPostgreSqlParameters.build() : null;
            handleUnionValueChange(Type.AURORA_POSTGRE_SQL_PARAMETERS, oldValue, this.auroraPostgreSqlParameters);
        }

        @Override
        public final Builder auroraPostgreSqlParameters(AuroraPostgreSqlParameters auroraPostgreSqlParameters) {
            Object oldValue = this.auroraPostgreSqlParameters;
            this.auroraPostgreSqlParameters = auroraPostgreSqlParameters;
            handleUnionValueChange(Type.AURORA_POSTGRE_SQL_PARAMETERS, oldValue, this.auroraPostgreSqlParameters);
            return this;
        }

        public final AwsIotAnalyticsParameters.Builder getAwsIotAnalyticsParameters() {
            return awsIotAnalyticsParameters != null ? awsIotAnalyticsParameters.toBuilder() : null;
        }

        public final void setAwsIotAnalyticsParameters(AwsIotAnalyticsParameters.BuilderImpl awsIotAnalyticsParameters) {
            Object oldValue = this.awsIotAnalyticsParameters;
            this.awsIotAnalyticsParameters = awsIotAnalyticsParameters != null ? awsIotAnalyticsParameters.build() : null;
            handleUnionValueChange(Type.AWS_IOT_ANALYTICS_PARAMETERS, oldValue, this.awsIotAnalyticsParameters);
        }

        @Override
        public final Builder awsIotAnalyticsParameters(AwsIotAnalyticsParameters awsIotAnalyticsParameters) {
            Object oldValue = this.awsIotAnalyticsParameters;
            this.awsIotAnalyticsParameters = awsIotAnalyticsParameters;
            handleUnionValueChange(Type.AWS_IOT_ANALYTICS_PARAMETERS, oldValue, this.awsIotAnalyticsParameters);
            return this;
        }

        public final JiraParameters.Builder getJiraParameters() {
            return jiraParameters != null ? jiraParameters.toBuilder() : null;
        }

        public final void setJiraParameters(JiraParameters.BuilderImpl jiraParameters) {
            Object oldValue = this.jiraParameters;
            this.jiraParameters = jiraParameters != null ? jiraParameters.build() : null;
            handleUnionValueChange(Type.JIRA_PARAMETERS, oldValue, this.jiraParameters);
        }

        @Override
        public final Builder jiraParameters(JiraParameters jiraParameters) {
            Object oldValue = this.jiraParameters;
            this.jiraParameters = jiraParameters;
            handleUnionValueChange(Type.JIRA_PARAMETERS, oldValue, this.jiraParameters);
            return this;
        }

        public final MariaDbParameters.Builder getMariaDbParameters() {
            return mariaDbParameters != null ? mariaDbParameters.toBuilder() : null;
        }

        public final void setMariaDbParameters(MariaDbParameters.BuilderImpl mariaDbParameters) {
            Object oldValue = this.mariaDbParameters;
            this.mariaDbParameters = mariaDbParameters != null ? mariaDbParameters.build() : null;
            handleUnionValueChange(Type.MARIA_DB_PARAMETERS, oldValue, this.mariaDbParameters);
        }

        @Override
        public final Builder mariaDbParameters(MariaDbParameters mariaDbParameters) {
            Object oldValue = this.mariaDbParameters;
            this.mariaDbParameters = mariaDbParameters;
            handleUnionValueChange(Type.MARIA_DB_PARAMETERS, oldValue, this.mariaDbParameters);
            return this;
        }

        public final MySqlParameters.Builder getMySqlParameters() {
            return mySqlParameters != null ? mySqlParameters.toBuilder() : null;
        }

        public final void setMySqlParameters(MySqlParameters.BuilderImpl mySqlParameters) {
            Object oldValue = this.mySqlParameters;
            this.mySqlParameters = mySqlParameters != null ? mySqlParameters.build() : null;
            handleUnionValueChange(Type.MY_SQL_PARAMETERS, oldValue, this.mySqlParameters);
        }

        @Override
        public final Builder mySqlParameters(MySqlParameters mySqlParameters) {
            Object oldValue = this.mySqlParameters;
            this.mySqlParameters = mySqlParameters;
            handleUnionValueChange(Type.MY_SQL_PARAMETERS, oldValue, this.mySqlParameters);
            return this;
        }

        public final OracleParameters.Builder getOracleParameters() {
            return oracleParameters != null ? oracleParameters.toBuilder() : null;
        }

        public final void setOracleParameters(OracleParameters.BuilderImpl oracleParameters) {
            Object oldValue = this.oracleParameters;
            this.oracleParameters = oracleParameters != null ? oracleParameters.build() : null;
            handleUnionValueChange(Type.ORACLE_PARAMETERS, oldValue, this.oracleParameters);
        }

        @Override
        public final Builder oracleParameters(OracleParameters oracleParameters) {
            Object oldValue = this.oracleParameters;
            this.oracleParameters = oracleParameters;
            handleUnionValueChange(Type.ORACLE_PARAMETERS, oldValue, this.oracleParameters);
            return this;
        }

        public final PostgreSqlParameters.Builder getPostgreSqlParameters() {
            return postgreSqlParameters != null ? postgreSqlParameters.toBuilder() : null;
        }

        public final void setPostgreSqlParameters(PostgreSqlParameters.BuilderImpl postgreSqlParameters) {
            Object oldValue = this.postgreSqlParameters;
            this.postgreSqlParameters = postgreSqlParameters != null ? postgreSqlParameters.build() : null;
            handleUnionValueChange(Type.POSTGRE_SQL_PARAMETERS, oldValue, this.postgreSqlParameters);
        }

        @Override
        public final Builder postgreSqlParameters(PostgreSqlParameters postgreSqlParameters) {
            Object oldValue = this.postgreSqlParameters;
            this.postgreSqlParameters = postgreSqlParameters;
            handleUnionValueChange(Type.POSTGRE_SQL_PARAMETERS, oldValue, this.postgreSqlParameters);
            return this;
        }

        public final PrestoParameters.Builder getPrestoParameters() {
            return prestoParameters != null ? prestoParameters.toBuilder() : null;
        }

        public final void setPrestoParameters(PrestoParameters.BuilderImpl prestoParameters) {
            Object oldValue = this.prestoParameters;
            this.prestoParameters = prestoParameters != null ? prestoParameters.build() : null;
            handleUnionValueChange(Type.PRESTO_PARAMETERS, oldValue, this.prestoParameters);
        }

        @Override
        public final Builder prestoParameters(PrestoParameters prestoParameters) {
            Object oldValue = this.prestoParameters;
            this.prestoParameters = prestoParameters;
            handleUnionValueChange(Type.PRESTO_PARAMETERS, oldValue, this.prestoParameters);
            return this;
        }

        public final RdsParameters.Builder getRdsParameters() {
            return rdsParameters != null ? rdsParameters.toBuilder() : null;
        }

        public final void setRdsParameters(RdsParameters.BuilderImpl rdsParameters) {
            Object oldValue = this.rdsParameters;
            this.rdsParameters = rdsParameters != null ? rdsParameters.build() : null;
            handleUnionValueChange(Type.RDS_PARAMETERS, oldValue, this.rdsParameters);
        }

        @Override
        public final Builder rdsParameters(RdsParameters rdsParameters) {
            Object oldValue = this.rdsParameters;
            this.rdsParameters = rdsParameters;
            handleUnionValueChange(Type.RDS_PARAMETERS, oldValue, this.rdsParameters);
            return this;
        }

        public final RedshiftParameters.Builder getRedshiftParameters() {
            return redshiftParameters != null ? redshiftParameters.toBuilder() : null;
        }

        public final void setRedshiftParameters(RedshiftParameters.BuilderImpl redshiftParameters) {
            Object oldValue = this.redshiftParameters;
            this.redshiftParameters = redshiftParameters != null ? redshiftParameters.build() : null;
            handleUnionValueChange(Type.REDSHIFT_PARAMETERS, oldValue, this.redshiftParameters);
        }

        @Override
        public final Builder redshiftParameters(RedshiftParameters redshiftParameters) {
            Object oldValue = this.redshiftParameters;
            this.redshiftParameters = redshiftParameters;
            handleUnionValueChange(Type.REDSHIFT_PARAMETERS, oldValue, this.redshiftParameters);
            return this;
        }

        public final S3Parameters.Builder getS3Parameters() {
            return s3Parameters != null ? s3Parameters.toBuilder() : null;
        }

        public final void setS3Parameters(S3Parameters.BuilderImpl s3Parameters) {
            Object oldValue = this.s3Parameters;
            this.s3Parameters = s3Parameters != null ? s3Parameters.build() : null;
            handleUnionValueChange(Type.S3_PARAMETERS, oldValue, this.s3Parameters);
        }

        @Override
        public final Builder s3Parameters(S3Parameters s3Parameters) {
            Object oldValue = this.s3Parameters;
            this.s3Parameters = s3Parameters;
            handleUnionValueChange(Type.S3_PARAMETERS, oldValue, this.s3Parameters);
            return this;
        }

        public final ServiceNowParameters.Builder getServiceNowParameters() {
            return serviceNowParameters != null ? serviceNowParameters.toBuilder() : null;
        }

        public final void setServiceNowParameters(ServiceNowParameters.BuilderImpl serviceNowParameters) {
            Object oldValue = this.serviceNowParameters;
            this.serviceNowParameters = serviceNowParameters != null ? serviceNowParameters.build() : null;
            handleUnionValueChange(Type.SERVICE_NOW_PARAMETERS, oldValue, this.serviceNowParameters);
        }

        @Override
        public final Builder serviceNowParameters(ServiceNowParameters serviceNowParameters) {
            Object oldValue = this.serviceNowParameters;
            this.serviceNowParameters = serviceNowParameters;
            handleUnionValueChange(Type.SERVICE_NOW_PARAMETERS, oldValue, this.serviceNowParameters);
            return this;
        }

        public final SnowflakeParameters.Builder getSnowflakeParameters() {
            return snowflakeParameters != null ? snowflakeParameters.toBuilder() : null;
        }

        public final void setSnowflakeParameters(SnowflakeParameters.BuilderImpl snowflakeParameters) {
            Object oldValue = this.snowflakeParameters;
            this.snowflakeParameters = snowflakeParameters != null ? snowflakeParameters.build() : null;
            handleUnionValueChange(Type.SNOWFLAKE_PARAMETERS, oldValue, this.snowflakeParameters);
        }

        @Override
        public final Builder snowflakeParameters(SnowflakeParameters snowflakeParameters) {
            Object oldValue = this.snowflakeParameters;
            this.snowflakeParameters = snowflakeParameters;
            handleUnionValueChange(Type.SNOWFLAKE_PARAMETERS, oldValue, this.snowflakeParameters);
            return this;
        }

        public final SparkParameters.Builder getSparkParameters() {
            return sparkParameters != null ? sparkParameters.toBuilder() : null;
        }

        public final void setSparkParameters(SparkParameters.BuilderImpl sparkParameters) {
            Object oldValue = this.sparkParameters;
            this.sparkParameters = sparkParameters != null ? sparkParameters.build() : null;
            handleUnionValueChange(Type.SPARK_PARAMETERS, oldValue, this.sparkParameters);
        }

        @Override
        public final Builder sparkParameters(SparkParameters sparkParameters) {
            Object oldValue = this.sparkParameters;
            this.sparkParameters = sparkParameters;
            handleUnionValueChange(Type.SPARK_PARAMETERS, oldValue, this.sparkParameters);
            return this;
        }

        public final SqlServerParameters.Builder getSqlServerParameters() {
            return sqlServerParameters != null ? sqlServerParameters.toBuilder() : null;
        }

        public final void setSqlServerParameters(SqlServerParameters.BuilderImpl sqlServerParameters) {
            Object oldValue = this.sqlServerParameters;
            this.sqlServerParameters = sqlServerParameters != null ? sqlServerParameters.build() : null;
            handleUnionValueChange(Type.SQL_SERVER_PARAMETERS, oldValue, this.sqlServerParameters);
        }

        @Override
        public final Builder sqlServerParameters(SqlServerParameters sqlServerParameters) {
            Object oldValue = this.sqlServerParameters;
            this.sqlServerParameters = sqlServerParameters;
            handleUnionValueChange(Type.SQL_SERVER_PARAMETERS, oldValue, this.sqlServerParameters);
            return this;
        }

        public final TeradataParameters.Builder getTeradataParameters() {
            return teradataParameters != null ? teradataParameters.toBuilder() : null;
        }

        public final void setTeradataParameters(TeradataParameters.BuilderImpl teradataParameters) {
            Object oldValue = this.teradataParameters;
            this.teradataParameters = teradataParameters != null ? teradataParameters.build() : null;
            handleUnionValueChange(Type.TERADATA_PARAMETERS, oldValue, this.teradataParameters);
        }

        @Override
        public final Builder teradataParameters(TeradataParameters teradataParameters) {
            Object oldValue = this.teradataParameters;
            this.teradataParameters = teradataParameters;
            handleUnionValueChange(Type.TERADATA_PARAMETERS, oldValue, this.teradataParameters);
            return this;
        }

        public final TwitterParameters.Builder getTwitterParameters() {
            return twitterParameters != null ? twitterParameters.toBuilder() : null;
        }

        public final void setTwitterParameters(TwitterParameters.BuilderImpl twitterParameters) {
            Object oldValue = this.twitterParameters;
            this.twitterParameters = twitterParameters != null ? twitterParameters.build() : null;
            handleUnionValueChange(Type.TWITTER_PARAMETERS, oldValue, this.twitterParameters);
        }

        @Override
        public final Builder twitterParameters(TwitterParameters twitterParameters) {
            Object oldValue = this.twitterParameters;
            this.twitterParameters = twitterParameters;
            handleUnionValueChange(Type.TWITTER_PARAMETERS, oldValue, this.twitterParameters);
            return this;
        }

        public final AmazonOpenSearchParameters.Builder getAmazonOpenSearchParameters() {
            return amazonOpenSearchParameters != null ? amazonOpenSearchParameters.toBuilder() : null;
        }

        public final void setAmazonOpenSearchParameters(AmazonOpenSearchParameters.BuilderImpl amazonOpenSearchParameters) {
            Object oldValue = this.amazonOpenSearchParameters;
            this.amazonOpenSearchParameters = amazonOpenSearchParameters != null ? amazonOpenSearchParameters.build() : null;
            handleUnionValueChange(Type.AMAZON_OPEN_SEARCH_PARAMETERS, oldValue, this.amazonOpenSearchParameters);
        }

        @Override
        public final Builder amazonOpenSearchParameters(AmazonOpenSearchParameters amazonOpenSearchParameters) {
            Object oldValue = this.amazonOpenSearchParameters;
            this.amazonOpenSearchParameters = amazonOpenSearchParameters;
            handleUnionValueChange(Type.AMAZON_OPEN_SEARCH_PARAMETERS, oldValue, this.amazonOpenSearchParameters);
            return this;
        }

        public final ExasolParameters.Builder getExasolParameters() {
            return exasolParameters != null ? exasolParameters.toBuilder() : null;
        }

        public final void setExasolParameters(ExasolParameters.BuilderImpl exasolParameters) {
            Object oldValue = this.exasolParameters;
            this.exasolParameters = exasolParameters != null ? exasolParameters.build() : null;
            handleUnionValueChange(Type.EXASOL_PARAMETERS, oldValue, this.exasolParameters);
        }

        @Override
        public final Builder exasolParameters(ExasolParameters exasolParameters) {
            Object oldValue = this.exasolParameters;
            this.exasolParameters = exasolParameters;
            handleUnionValueChange(Type.EXASOL_PARAMETERS, oldValue, this.exasolParameters);
            return this;
        }

        public final DatabricksParameters.Builder getDatabricksParameters() {
            return databricksParameters != null ? databricksParameters.toBuilder() : null;
        }

        public final void setDatabricksParameters(DatabricksParameters.BuilderImpl databricksParameters) {
            Object oldValue = this.databricksParameters;
            this.databricksParameters = databricksParameters != null ? databricksParameters.build() : null;
            handleUnionValueChange(Type.DATABRICKS_PARAMETERS, oldValue, this.databricksParameters);
        }

        @Override
        public final Builder databricksParameters(DatabricksParameters databricksParameters) {
            Object oldValue = this.databricksParameters;
            this.databricksParameters = databricksParameters;
            handleUnionValueChange(Type.DATABRICKS_PARAMETERS, oldValue, this.databricksParameters);
            return this;
        }

        @Override
        public DataSourceParameters build() {
            return new DataSourceParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DataSourceParameters#type()
     */
    public enum Type {
        AMAZON_ELASTICSEARCH_PARAMETERS,

        ATHENA_PARAMETERS,

        AURORA_PARAMETERS,

        AURORA_POSTGRE_SQL_PARAMETERS,

        AWS_IOT_ANALYTICS_PARAMETERS,

        JIRA_PARAMETERS,

        MARIA_DB_PARAMETERS,

        MY_SQL_PARAMETERS,

        ORACLE_PARAMETERS,

        POSTGRE_SQL_PARAMETERS,

        PRESTO_PARAMETERS,

        RDS_PARAMETERS,

        REDSHIFT_PARAMETERS,

        S3_PARAMETERS,

        SERVICE_NOW_PARAMETERS,

        SNOWFLAKE_PARAMETERS,

        SPARK_PARAMETERS,

        SQL_SERVER_PARAMETERS,

        TERADATA_PARAMETERS,

        TWITTER_PARAMETERS,

        AMAZON_OPEN_SEARCH_PARAMETERS,

        EXASOL_PARAMETERS,

        DATABRICKS_PARAMETERS,

        UNKNOWN_TO_SDK_VERSION
    }
}
