/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.model.DataSourceSummary;
import software.amazon.awssdk.services.quicksight.model.SearchDataSourcesRequest;
import software.amazon.awssdk.services.quicksight.model.SearchDataSourcesResponse;

public class SearchDataSourcesIterable
implements SdkIterable<SearchDataSourcesResponse> {
    private final QuickSightClient client;
    private final SearchDataSourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchDataSourcesIterable(QuickSightClient client, SearchDataSourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchDataSourcesResponseFetcher();
    }

    public Iterator<SearchDataSourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataSourceSummary> dataSourceSummaries() {
        Function<SearchDataSourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataSourceSummaries() != null) {
                return response.dataSourceSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchDataSourcesResponseFetcher
    implements SyncPageFetcher<SearchDataSourcesResponse> {
        private SearchDataSourcesResponseFetcher() {
        }

        public boolean hasNextPage(SearchDataSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchDataSourcesResponse nextPage(SearchDataSourcesResponse previousPage) {
            if (previousPage == null) {
                return SearchDataSourcesIterable.this.client.searchDataSources(SearchDataSourcesIterable.this.firstRequest);
            }
            return SearchDataSourcesIterable.this.client.searchDataSources((SearchDataSourcesRequest)((Object)SearchDataSourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

