/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AggregationFunction;
import software.amazon.awssdk.services.quicksight.model.ColumnIdentifier;
import software.amazon.awssdk.services.quicksight.model.FilterNullOption;
import software.amazon.awssdk.services.quicksight.model.NumericFilterSelectAllOptions;
import software.amazon.awssdk.services.quicksight.model.NumericRangeFilterValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NumericRangeFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NumericRangeFilter> {
    private static final SdkField<String> FILTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterId").getter(NumericRangeFilter.getter(NumericRangeFilter::filterId)).setter(NumericRangeFilter.setter(Builder::filterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterId").build()}).build();
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Column").getter(NumericRangeFilter.getter(NumericRangeFilter::column)).setter(NumericRangeFilter.setter(Builder::column)).constructor(ColumnIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()}).build();
    private static final SdkField<Boolean> INCLUDE_MINIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeMinimum").getter(NumericRangeFilter.getter(NumericRangeFilter::includeMinimum)).setter(NumericRangeFilter.setter(Builder::includeMinimum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeMinimum").build()}).build();
    private static final SdkField<Boolean> INCLUDE_MAXIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeMaximum").getter(NumericRangeFilter.getter(NumericRangeFilter::includeMaximum)).setter(NumericRangeFilter.setter(Builder::includeMaximum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeMaximum").build()}).build();
    private static final SdkField<NumericRangeFilterValue> RANGE_MINIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RangeMinimum").getter(NumericRangeFilter.getter(NumericRangeFilter::rangeMinimum)).setter(NumericRangeFilter.setter(Builder::rangeMinimum)).constructor(NumericRangeFilterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangeMinimum").build()}).build();
    private static final SdkField<NumericRangeFilterValue> RANGE_MAXIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RangeMaximum").getter(NumericRangeFilter.getter(NumericRangeFilter::rangeMaximum)).setter(NumericRangeFilter.setter(Builder::rangeMaximum)).constructor(NumericRangeFilterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangeMaximum").build()}).build();
    private static final SdkField<String> SELECT_ALL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectAllOptions").getter(NumericRangeFilter.getter(NumericRangeFilter::selectAllOptionsAsString)).setter(NumericRangeFilter.setter(Builder::selectAllOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectAllOptions").build()}).build();
    private static final SdkField<AggregationFunction> AGGREGATION_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AggregationFunction").getter(NumericRangeFilter.getter(NumericRangeFilter::aggregationFunction)).setter(NumericRangeFilter.setter(Builder::aggregationFunction)).constructor(AggregationFunction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationFunction").build()}).build();
    private static final SdkField<String> NULL_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NullOption").getter(NumericRangeFilter.getter(NumericRangeFilter::nullOptionAsString)).setter(NumericRangeFilter.setter(Builder::nullOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_ID_FIELD, COLUMN_FIELD, INCLUDE_MINIMUM_FIELD, INCLUDE_MAXIMUM_FIELD, RANGE_MINIMUM_FIELD, RANGE_MAXIMUM_FIELD, SELECT_ALL_OPTIONS_FIELD, AGGREGATION_FUNCTION_FIELD, NULL_OPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String filterId;
    private final ColumnIdentifier column;
    private final Boolean includeMinimum;
    private final Boolean includeMaximum;
    private final NumericRangeFilterValue rangeMinimum;
    private final NumericRangeFilterValue rangeMaximum;
    private final String selectAllOptions;
    private final AggregationFunction aggregationFunction;
    private final String nullOption;

    private NumericRangeFilter(BuilderImpl builder) {
        this.filterId = builder.filterId;
        this.column = builder.column;
        this.includeMinimum = builder.includeMinimum;
        this.includeMaximum = builder.includeMaximum;
        this.rangeMinimum = builder.rangeMinimum;
        this.rangeMaximum = builder.rangeMaximum;
        this.selectAllOptions = builder.selectAllOptions;
        this.aggregationFunction = builder.aggregationFunction;
        this.nullOption = builder.nullOption;
    }

    public final String filterId() {
        return this.filterId;
    }

    public final ColumnIdentifier column() {
        return this.column;
    }

    public final Boolean includeMinimum() {
        return this.includeMinimum;
    }

    public final Boolean includeMaximum() {
        return this.includeMaximum;
    }

    public final NumericRangeFilterValue rangeMinimum() {
        return this.rangeMinimum;
    }

    public final NumericRangeFilterValue rangeMaximum() {
        return this.rangeMaximum;
    }

    public final NumericFilterSelectAllOptions selectAllOptions() {
        return NumericFilterSelectAllOptions.fromValue(this.selectAllOptions);
    }

    public final String selectAllOptionsAsString() {
        return this.selectAllOptions;
    }

    public final AggregationFunction aggregationFunction() {
        return this.aggregationFunction;
    }

    public final FilterNullOption nullOption() {
        return FilterNullOption.fromValue(this.nullOption);
    }

    public final String nullOptionAsString() {
        return this.nullOption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.column());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeMinimum());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeMaximum());
        hashCode = 31 * hashCode + Objects.hashCode(this.rangeMinimum());
        hashCode = 31 * hashCode + Objects.hashCode(this.rangeMaximum());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectAllOptionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationFunction());
        hashCode = 31 * hashCode + Objects.hashCode(this.nullOptionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumericRangeFilter)) {
            return false;
        }
        NumericRangeFilter other = (NumericRangeFilter)obj;
        return Objects.equals(this.filterId(), other.filterId()) && Objects.equals(this.column(), other.column()) && Objects.equals(this.includeMinimum(), other.includeMinimum()) && Objects.equals(this.includeMaximum(), other.includeMaximum()) && Objects.equals(this.rangeMinimum(), other.rangeMinimum()) && Objects.equals(this.rangeMaximum(), other.rangeMaximum()) && Objects.equals(this.selectAllOptionsAsString(), other.selectAllOptionsAsString()) && Objects.equals(this.aggregationFunction(), other.aggregationFunction()) && Objects.equals(this.nullOptionAsString(), other.nullOptionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NumericRangeFilter").add("FilterId", (Object)this.filterId()).add("Column", (Object)this.column()).add("IncludeMinimum", (Object)this.includeMinimum()).add("IncludeMaximum", (Object)this.includeMaximum()).add("RangeMinimum", (Object)this.rangeMinimum()).add("RangeMaximum", (Object)this.rangeMaximum()).add("SelectAllOptions", (Object)this.selectAllOptionsAsString()).add("AggregationFunction", (Object)this.aggregationFunction()).add("NullOption", (Object)this.nullOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterId": {
                return Optional.ofNullable(clazz.cast(this.filterId()));
            }
            case "Column": {
                return Optional.ofNullable(clazz.cast(this.column()));
            }
            case "IncludeMinimum": {
                return Optional.ofNullable(clazz.cast(this.includeMinimum()));
            }
            case "IncludeMaximum": {
                return Optional.ofNullable(clazz.cast(this.includeMaximum()));
            }
            case "RangeMinimum": {
                return Optional.ofNullable(clazz.cast(this.rangeMinimum()));
            }
            case "RangeMaximum": {
                return Optional.ofNullable(clazz.cast(this.rangeMaximum()));
            }
            case "SelectAllOptions": {
                return Optional.ofNullable(clazz.cast(this.selectAllOptionsAsString()));
            }
            case "AggregationFunction": {
                return Optional.ofNullable(clazz.cast(this.aggregationFunction()));
            }
            case "NullOption": {
                return Optional.ofNullable(clazz.cast(this.nullOptionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NumericRangeFilter, T> g) {
        return obj -> g.apply((NumericRangeFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterId;
        private ColumnIdentifier column;
        private Boolean includeMinimum;
        private Boolean includeMaximum;
        private NumericRangeFilterValue rangeMinimum;
        private NumericRangeFilterValue rangeMaximum;
        private String selectAllOptions;
        private AggregationFunction aggregationFunction;
        private String nullOption;

        private BuilderImpl() {
        }

        private BuilderImpl(NumericRangeFilter model) {
            this.filterId(model.filterId);
            this.column(model.column);
            this.includeMinimum(model.includeMinimum);
            this.includeMaximum(model.includeMaximum);
            this.rangeMinimum(model.rangeMinimum);
            this.rangeMaximum(model.rangeMaximum);
            this.selectAllOptions(model.selectAllOptions);
            this.aggregationFunction(model.aggregationFunction);
            this.nullOption(model.nullOption);
        }

        public final String getFilterId() {
            return this.filterId;
        }

        public final void setFilterId(String filterId) {
            this.filterId = filterId;
        }

        @Override
        public final Builder filterId(String filterId) {
            this.filterId = filterId;
            return this;
        }

        public final ColumnIdentifier.Builder getColumn() {
            return this.column != null ? this.column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final Boolean getIncludeMinimum() {
            return this.includeMinimum;
        }

        public final void setIncludeMinimum(Boolean includeMinimum) {
            this.includeMinimum = includeMinimum;
        }

        @Override
        public final Builder includeMinimum(Boolean includeMinimum) {
            this.includeMinimum = includeMinimum;
            return this;
        }

        public final Boolean getIncludeMaximum() {
            return this.includeMaximum;
        }

        public final void setIncludeMaximum(Boolean includeMaximum) {
            this.includeMaximum = includeMaximum;
        }

        @Override
        public final Builder includeMaximum(Boolean includeMaximum) {
            this.includeMaximum = includeMaximum;
            return this;
        }

        public final NumericRangeFilterValue.Builder getRangeMinimum() {
            return this.rangeMinimum != null ? this.rangeMinimum.toBuilder() : null;
        }

        public final void setRangeMinimum(NumericRangeFilterValue.BuilderImpl rangeMinimum) {
            this.rangeMinimum = rangeMinimum != null ? rangeMinimum.build() : null;
        }

        @Override
        public final Builder rangeMinimum(NumericRangeFilterValue rangeMinimum) {
            this.rangeMinimum = rangeMinimum;
            return this;
        }

        public final NumericRangeFilterValue.Builder getRangeMaximum() {
            return this.rangeMaximum != null ? this.rangeMaximum.toBuilder() : null;
        }

        public final void setRangeMaximum(NumericRangeFilterValue.BuilderImpl rangeMaximum) {
            this.rangeMaximum = rangeMaximum != null ? rangeMaximum.build() : null;
        }

        @Override
        public final Builder rangeMaximum(NumericRangeFilterValue rangeMaximum) {
            this.rangeMaximum = rangeMaximum;
            return this;
        }

        public final String getSelectAllOptions() {
            return this.selectAllOptions;
        }

        public final void setSelectAllOptions(String selectAllOptions) {
            this.selectAllOptions = selectAllOptions;
        }

        @Override
        public final Builder selectAllOptions(String selectAllOptions) {
            this.selectAllOptions = selectAllOptions;
            return this;
        }

        @Override
        public final Builder selectAllOptions(NumericFilterSelectAllOptions selectAllOptions) {
            this.selectAllOptions(selectAllOptions == null ? null : selectAllOptions.toString());
            return this;
        }

        public final AggregationFunction.Builder getAggregationFunction() {
            return this.aggregationFunction != null ? this.aggregationFunction.toBuilder() : null;
        }

        public final void setAggregationFunction(AggregationFunction.BuilderImpl aggregationFunction) {
            this.aggregationFunction = aggregationFunction != null ? aggregationFunction.build() : null;
        }

        @Override
        public final Builder aggregationFunction(AggregationFunction aggregationFunction) {
            this.aggregationFunction = aggregationFunction;
            return this;
        }

        public final String getNullOption() {
            return this.nullOption;
        }

        public final void setNullOption(String nullOption) {
            this.nullOption = nullOption;
        }

        @Override
        public final Builder nullOption(String nullOption) {
            this.nullOption = nullOption;
            return this;
        }

        @Override
        public final Builder nullOption(FilterNullOption nullOption) {
            this.nullOption(nullOption == null ? null : nullOption.toString());
            return this;
        }

        public NumericRangeFilter build() {
            return new NumericRangeFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NumericRangeFilter> {
        public Builder filterId(String var1);

        public Builder column(ColumnIdentifier var1);

        default public Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return this.column((ColumnIdentifier)((ColumnIdentifier.Builder)ColumnIdentifier.builder().applyMutation(column)).build());
        }

        public Builder includeMinimum(Boolean var1);

        public Builder includeMaximum(Boolean var1);

        public Builder rangeMinimum(NumericRangeFilterValue var1);

        default public Builder rangeMinimum(Consumer<NumericRangeFilterValue.Builder> rangeMinimum) {
            return this.rangeMinimum((NumericRangeFilterValue)((NumericRangeFilterValue.Builder)NumericRangeFilterValue.builder().applyMutation(rangeMinimum)).build());
        }

        public Builder rangeMaximum(NumericRangeFilterValue var1);

        default public Builder rangeMaximum(Consumer<NumericRangeFilterValue.Builder> rangeMaximum) {
            return this.rangeMaximum((NumericRangeFilterValue)((NumericRangeFilterValue.Builder)NumericRangeFilterValue.builder().applyMutation(rangeMaximum)).build());
        }

        public Builder selectAllOptions(String var1);

        public Builder selectAllOptions(NumericFilterSelectAllOptions var1);

        public Builder aggregationFunction(AggregationFunction var1);

        default public Builder aggregationFunction(Consumer<AggregationFunction.Builder> aggregationFunction) {
            return this.aggregationFunction((AggregationFunction)((AggregationFunction.Builder)AggregationFunction.builder().applyMutation(aggregationFunction)).build());
        }

        public Builder nullOption(String var1);

        public Builder nullOption(FilterNullOption var1);
    }
}

