/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SelectAllValueOptions {
    ALL_VALUES("ALL_VALUES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SelectAllValueOptions> VALUE_MAP;
    private final String value;

    private SelectAllValueOptions(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SelectAllValueOptions fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SelectAllValueOptions> knownValues() {
        EnumSet<SelectAllValueOptions> knownValues = EnumSet.allOf(SelectAllValueOptions.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SelectAllValueOptions.class, SelectAllValueOptions::toString);
    }
}

