/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.TemplateSourceEntity;
import software.amazon.awssdk.services.quicksight.model.TemplateVersionDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTemplateRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateTemplateRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateTemplateRequest.getter(UpdateTemplateRequest::awsAccountId)).setter(UpdateTemplateRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateId").getter(UpdateTemplateRequest.getter(UpdateTemplateRequest::templateId)).setter(UpdateTemplateRequest.setter(Builder::templateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("TemplateId").build()}).build();
    private static final SdkField<TemplateSourceEntity> SOURCE_ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceEntity").getter(UpdateTemplateRequest.getter(UpdateTemplateRequest::sourceEntity)).setter(UpdateTemplateRequest.setter(Builder::sourceEntity)).constructor(TemplateSourceEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEntity").build()}).build();
    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionDescription").getter(UpdateTemplateRequest.getter(UpdateTemplateRequest::versionDescription)).setter(UpdateTemplateRequest.setter(Builder::versionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateTemplateRequest.getter(UpdateTemplateRequest::name)).setter(UpdateTemplateRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<TemplateVersionDefinition> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Definition").getter(UpdateTemplateRequest.getter(UpdateTemplateRequest::definition)).setter(UpdateTemplateRequest.setter(Builder::definition)).constructor(TemplateVersionDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, TEMPLATE_ID_FIELD, SOURCE_ENTITY_FIELD, VERSION_DESCRIPTION_FIELD, NAME_FIELD, DEFINITION_FIELD));
    private final String awsAccountId;
    private final String templateId;
    private final TemplateSourceEntity sourceEntity;
    private final String versionDescription;
    private final String name;
    private final TemplateVersionDefinition definition;

    private UpdateTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.templateId = builder.templateId;
        this.sourceEntity = builder.sourceEntity;
        this.versionDescription = builder.versionDescription;
        this.name = builder.name;
        this.definition = builder.definition;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String templateId() {
        return this.templateId;
    }

    public final TemplateSourceEntity sourceEntity() {
        return this.sourceEntity;
    }

    public final String versionDescription() {
        return this.versionDescription;
    }

    public final String name() {
        return this.name;
    }

    public final TemplateVersionDefinition definition() {
        return this.definition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEntity());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTemplateRequest)) {
            return false;
        }
        UpdateTemplateRequest other = (UpdateTemplateRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.templateId(), other.templateId()) && Objects.equals(this.sourceEntity(), other.sourceEntity()) && Objects.equals(this.versionDescription(), other.versionDescription()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.definition(), other.definition());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTemplateRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("TemplateId", (Object)this.templateId()).add("SourceEntity", (Object)this.sourceEntity()).add("VersionDescription", (Object)this.versionDescription()).add("Name", (Object)this.name()).add("Definition", (Object)this.definition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "TemplateId": {
                return Optional.ofNullable(clazz.cast(this.templateId()));
            }
            case "SourceEntity": {
                return Optional.ofNullable(clazz.cast(this.sourceEntity()));
            }
            case "VersionDescription": {
                return Optional.ofNullable(clazz.cast(this.versionDescription()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTemplateRequest, T> g) {
        return obj -> g.apply((UpdateTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String templateId;
        private TemplateSourceEntity sourceEntity;
        private String versionDescription;
        private String name;
        private TemplateVersionDefinition definition;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTemplateRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.templateId(model.templateId);
            this.sourceEntity(model.sourceEntity);
            this.versionDescription(model.versionDescription);
            this.name(model.name);
            this.definition(model.definition);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getTemplateId() {
            return this.templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final TemplateSourceEntity.Builder getSourceEntity() {
            return this.sourceEntity != null ? this.sourceEntity.toBuilder() : null;
        }

        public final void setSourceEntity(TemplateSourceEntity.BuilderImpl sourceEntity) {
            this.sourceEntity = sourceEntity != null ? sourceEntity.build() : null;
        }

        @Override
        public final Builder sourceEntity(TemplateSourceEntity sourceEntity) {
            this.sourceEntity = sourceEntity;
            return this;
        }

        public final String getVersionDescription() {
            return this.versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final TemplateVersionDefinition.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(TemplateVersionDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(TemplateVersionDefinition definition) {
            this.definition = definition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTemplateRequest build() {
            return new UpdateTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTemplateRequest> {
        public Builder awsAccountId(String var1);

        public Builder templateId(String var1);

        public Builder sourceEntity(TemplateSourceEntity var1);

        default public Builder sourceEntity(Consumer<TemplateSourceEntity.Builder> sourceEntity) {
            return this.sourceEntity((TemplateSourceEntity)((TemplateSourceEntity.Builder)TemplateSourceEntity.builder().applyMutation(sourceEntity)).build());
        }

        public Builder versionDescription(String var1);

        public Builder name(String var1);

        public Builder definition(TemplateVersionDefinition var1);

        default public Builder definition(Consumer<TemplateVersionDefinition.Builder> definition) {
            return this.definition((TemplateVersionDefinition)((TemplateVersionDefinition.Builder)TemplateVersionDefinition.builder().applyMutation(definition)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

