/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ColumnDataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CastColumnTypeOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CastColumnTypeOperation> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColumnName").getter(CastColumnTypeOperation.getter(CastColumnTypeOperation::columnName)).setter(CastColumnTypeOperation.setter(Builder::columnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()}).build();
    private static final SdkField<String> NEW_COLUMN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewColumnType").getter(CastColumnTypeOperation.getter(CastColumnTypeOperation::newColumnTypeAsString)).setter(CastColumnTypeOperation.setter(Builder::newColumnType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewColumnType").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(CastColumnTypeOperation.getter(CastColumnTypeOperation::format)).setter(CastColumnTypeOperation.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD, NEW_COLUMN_TYPE_FIELD, FORMAT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String columnName;
    private final String newColumnType;
    private final String format;

    private CastColumnTypeOperation(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.newColumnType = builder.newColumnType;
        this.format = builder.format;
    }

    public final String columnName() {
        return this.columnName;
    }

    public final ColumnDataType newColumnType() {
        return ColumnDataType.fromValue(this.newColumnType);
    }

    public final String newColumnTypeAsString() {
        return this.newColumnType;
    }

    public final String format() {
        return this.format;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.columnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.newColumnTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.format());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CastColumnTypeOperation)) {
            return false;
        }
        CastColumnTypeOperation other = (CastColumnTypeOperation)obj;
        return Objects.equals(this.columnName(), other.columnName()) && Objects.equals(this.newColumnTypeAsString(), other.newColumnTypeAsString()) && Objects.equals(this.format(), other.format());
    }

    public final String toString() {
        return ToString.builder((String)"CastColumnTypeOperation").add("ColumnName", (Object)this.columnName()).add("NewColumnType", (Object)this.newColumnTypeAsString()).add("Format", (Object)this.format()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColumnName": {
                return Optional.ofNullable(clazz.cast(this.columnName()));
            }
            case "NewColumnType": {
                return Optional.ofNullable(clazz.cast(this.newColumnTypeAsString()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.format()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CastColumnTypeOperation, T> g) {
        return obj -> g.apply((CastColumnTypeOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String columnName;
        private String newColumnType;
        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(CastColumnTypeOperation model) {
            this.columnName(model.columnName);
            this.newColumnType(model.newColumnType);
            this.format(model.format);
        }

        public final String getColumnName() {
            return this.columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        @Transient
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final String getNewColumnType() {
            return this.newColumnType;
        }

        public final void setNewColumnType(String newColumnType) {
            this.newColumnType = newColumnType;
        }

        @Override
        @Transient
        public final Builder newColumnType(String newColumnType) {
            this.newColumnType = newColumnType;
            return this;
        }

        @Override
        @Transient
        public final Builder newColumnType(ColumnDataType newColumnType) {
            this.newColumnType(newColumnType == null ? null : newColumnType.toString());
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        @Transient
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public CastColumnTypeOperation build() {
            return new CastColumnTypeOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CastColumnTypeOperation> {
        public Builder columnName(String var1);

        public Builder newColumnType(String var1);

        public Builder newColumnType(ColumnDataType var1);

        public Builder format(String var1);
    }
}

