/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.ThemeConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateThemeRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateThemeRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateThemeRequest.getter(UpdateThemeRequest::awsAccountId)).setter(UpdateThemeRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> THEME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThemeId").getter(UpdateThemeRequest.getter(UpdateThemeRequest::themeId)).setter(UpdateThemeRequest.setter(Builder::themeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ThemeId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateThemeRequest.getter(UpdateThemeRequest::name)).setter(UpdateThemeRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> BASE_THEME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseThemeId").getter(UpdateThemeRequest.getter(UpdateThemeRequest::baseThemeId)).setter(UpdateThemeRequest.setter(Builder::baseThemeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseThemeId").build()}).build();
    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionDescription").getter(UpdateThemeRequest.getter(UpdateThemeRequest::versionDescription)).setter(UpdateThemeRequest.setter(Builder::versionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").build()}).build();
    private static final SdkField<ThemeConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(UpdateThemeRequest.getter(UpdateThemeRequest::configuration)).setter(UpdateThemeRequest.setter(Builder::configuration)).constructor(ThemeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, THEME_ID_FIELD, NAME_FIELD, BASE_THEME_ID_FIELD, VERSION_DESCRIPTION_FIELD, CONFIGURATION_FIELD));
    private final String awsAccountId;
    private final String themeId;
    private final String name;
    private final String baseThemeId;
    private final String versionDescription;
    private final ThemeConfiguration configuration;

    private UpdateThemeRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.themeId = builder.themeId;
        this.name = builder.name;
        this.baseThemeId = builder.baseThemeId;
        this.versionDescription = builder.versionDescription;
        this.configuration = builder.configuration;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String themeId() {
        return this.themeId;
    }

    public final String name() {
        return this.name;
    }

    public final String baseThemeId() {
        return this.baseThemeId;
    }

    public final String versionDescription() {
        return this.versionDescription;
    }

    public final ThemeConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.themeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseThemeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThemeRequest)) {
            return false;
        }
        UpdateThemeRequest other = (UpdateThemeRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.themeId(), other.themeId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.baseThemeId(), other.baseThemeId()) && Objects.equals(this.versionDescription(), other.versionDescription()) && Objects.equals(this.configuration(), other.configuration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateThemeRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("ThemeId", (Object)this.themeId()).add("Name", (Object)this.name()).add("BaseThemeId", (Object)this.baseThemeId()).add("VersionDescription", (Object)this.versionDescription()).add("Configuration", (Object)this.configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "ThemeId": {
                return Optional.ofNullable(clazz.cast(this.themeId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "BaseThemeId": {
                return Optional.ofNullable(clazz.cast(this.baseThemeId()));
            }
            case "VersionDescription": {
                return Optional.ofNullable(clazz.cast(this.versionDescription()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateThemeRequest, T> g) {
        return obj -> g.apply((UpdateThemeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String themeId;
        private String name;
        private String baseThemeId;
        private String versionDescription;
        private ThemeConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThemeRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.themeId(model.themeId);
            this.name(model.name);
            this.baseThemeId(model.baseThemeId);
            this.versionDescription(model.versionDescription);
            this.configuration(model.configuration);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        @Transient
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getThemeId() {
            return this.themeId;
        }

        public final void setThemeId(String themeId) {
            this.themeId = themeId;
        }

        @Override
        @Transient
        public final Builder themeId(String themeId) {
            this.themeId = themeId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getBaseThemeId() {
            return this.baseThemeId;
        }

        public final void setBaseThemeId(String baseThemeId) {
            this.baseThemeId = baseThemeId;
        }

        @Override
        @Transient
        public final Builder baseThemeId(String baseThemeId) {
            this.baseThemeId = baseThemeId;
            return this;
        }

        public final String getVersionDescription() {
            return this.versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        @Transient
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final ThemeConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(ThemeConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        @Transient
        public final Builder configuration(ThemeConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateThemeRequest build() {
            return new UpdateThemeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateThemeRequest> {
        public Builder awsAccountId(String var1);

        public Builder themeId(String var1);

        public Builder name(String var1);

        public Builder baseThemeId(String var1);

        public Builder versionDescription(String var1);

        public Builder configuration(ThemeConfiguration var1);

        default public Builder configuration(Consumer<ThemeConfiguration.Builder> configuration) {
            return this.configuration((ThemeConfiguration)((ThemeConfiguration.Builder)ThemeConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

