/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.ResourcePermission;
import software.amazon.awssdk.services.quicksight.model.UpdateResourcePermissionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAnalysisPermissionsRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateAnalysisPermissionsRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateAnalysisPermissionsRequest.getter(UpdateAnalysisPermissionsRequest::awsAccountId)).setter(UpdateAnalysisPermissionsRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> ANALYSIS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisId").getter(UpdateAnalysisPermissionsRequest.getter(UpdateAnalysisPermissionsRequest::analysisId)).setter(UpdateAnalysisPermissionsRequest.setter(Builder::analysisId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AnalysisId").build()}).build();
    private static final SdkField<List<ResourcePermission>> GRANT_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GrantPermissions").getter(UpdateAnalysisPermissionsRequest.getter(UpdateAnalysisPermissionsRequest::grantPermissions)).setter(UpdateAnalysisPermissionsRequest.setter(Builder::grantPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourcePermission>> REVOKE_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RevokePermissions").getter(UpdateAnalysisPermissionsRequest.getter(UpdateAnalysisPermissionsRequest::revokePermissions)).setter(UpdateAnalysisPermissionsRequest.setter(Builder::revokePermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevokePermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, ANALYSIS_ID_FIELD, GRANT_PERMISSIONS_FIELD, REVOKE_PERMISSIONS_FIELD));
    private final String awsAccountId;
    private final String analysisId;
    private final List<ResourcePermission> grantPermissions;
    private final List<ResourcePermission> revokePermissions;

    private UpdateAnalysisPermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.analysisId = builder.analysisId;
        this.grantPermissions = builder.grantPermissions;
        this.revokePermissions = builder.revokePermissions;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String analysisId() {
        return this.analysisId;
    }

    public final boolean hasGrantPermissions() {
        return this.grantPermissions != null && !(this.grantPermissions instanceof SdkAutoConstructList);
    }

    public final List<ResourcePermission> grantPermissions() {
        return this.grantPermissions;
    }

    public final boolean hasRevokePermissions() {
        return this.revokePermissions != null && !(this.revokePermissions instanceof SdkAutoConstructList);
    }

    public final List<ResourcePermission> revokePermissions() {
        return this.revokePermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGrantPermissions() ? this.grantPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRevokePermissions() ? this.revokePermissions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAnalysisPermissionsRequest)) {
            return false;
        }
        UpdateAnalysisPermissionsRequest other = (UpdateAnalysisPermissionsRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.analysisId(), other.analysisId()) && this.hasGrantPermissions() == other.hasGrantPermissions() && Objects.equals(this.grantPermissions(), other.grantPermissions()) && this.hasRevokePermissions() == other.hasRevokePermissions() && Objects.equals(this.revokePermissions(), other.revokePermissions());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAnalysisPermissionsRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("AnalysisId", (Object)this.analysisId()).add("GrantPermissions", this.hasGrantPermissions() ? this.grantPermissions() : null).add("RevokePermissions", this.hasRevokePermissions() ? this.revokePermissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "AnalysisId": {
                return Optional.ofNullable(clazz.cast(this.analysisId()));
            }
            case "GrantPermissions": {
                return Optional.ofNullable(clazz.cast(this.grantPermissions()));
            }
            case "RevokePermissions": {
                return Optional.ofNullable(clazz.cast(this.revokePermissions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAnalysisPermissionsRequest, T> g) {
        return obj -> g.apply((UpdateAnalysisPermissionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String analysisId;
        private List<ResourcePermission> grantPermissions = DefaultSdkAutoConstructList.getInstance();
        private List<ResourcePermission> revokePermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAnalysisPermissionsRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.analysisId(model.analysisId);
            this.grantPermissions(model.grantPermissions);
            this.revokePermissions(model.revokePermissions);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        @Transient
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAnalysisId() {
            return this.analysisId;
        }

        public final void setAnalysisId(String analysisId) {
            this.analysisId = analysisId;
        }

        @Override
        @Transient
        public final Builder analysisId(String analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        public final List<ResourcePermission.Builder> getGrantPermissions() {
            List<ResourcePermission.Builder> result = UpdateResourcePermissionListCopier.copyToBuilder(this.grantPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGrantPermissions(Collection<ResourcePermission.BuilderImpl> grantPermissions) {
            this.grantPermissions = UpdateResourcePermissionListCopier.copyFromBuilder(grantPermissions);
        }

        @Override
        @Transient
        public final Builder grantPermissions(Collection<ResourcePermission> grantPermissions) {
            this.grantPermissions = UpdateResourcePermissionListCopier.copy(grantPermissions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder grantPermissions(ResourcePermission ... grantPermissions) {
            this.grantPermissions(Arrays.asList(grantPermissions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder grantPermissions(Consumer<ResourcePermission.Builder> ... grantPermissions) {
            this.grantPermissions(Stream.of(grantPermissions).map(c -> (ResourcePermission)((ResourcePermission.Builder)ResourcePermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourcePermission.Builder> getRevokePermissions() {
            List<ResourcePermission.Builder> result = UpdateResourcePermissionListCopier.copyToBuilder(this.revokePermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRevokePermissions(Collection<ResourcePermission.BuilderImpl> revokePermissions) {
            this.revokePermissions = UpdateResourcePermissionListCopier.copyFromBuilder(revokePermissions);
        }

        @Override
        @Transient
        public final Builder revokePermissions(Collection<ResourcePermission> revokePermissions) {
            this.revokePermissions = UpdateResourcePermissionListCopier.copy(revokePermissions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder revokePermissions(ResourcePermission ... revokePermissions) {
            this.revokePermissions(Arrays.asList(revokePermissions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder revokePermissions(Consumer<ResourcePermission.Builder> ... revokePermissions) {
            this.revokePermissions(Stream.of(revokePermissions).map(c -> (ResourcePermission)((ResourcePermission.Builder)ResourcePermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAnalysisPermissionsRequest build() {
            return new UpdateAnalysisPermissionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAnalysisPermissionsRequest> {
        public Builder awsAccountId(String var1);

        public Builder analysisId(String var1);

        public Builder grantPermissions(Collection<ResourcePermission> var1);

        public Builder grantPermissions(ResourcePermission ... var1);

        public Builder grantPermissions(Consumer<ResourcePermission.Builder> ... var1);

        public Builder revokePermissions(Collection<ResourcePermission> var1);

        public Builder revokePermissions(ResourcePermission ... var1);

        public Builder revokePermissions(Consumer<ResourcePermission.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

