/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TextQualifier {
    DOUBLE_QUOTE("DOUBLE_QUOTE"),
    SINGLE_QUOTE("SINGLE_QUOTE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TextQualifier(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TextQualifier fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TextQualifier.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TextQualifier> knownValues() {
        return Stream.of(TextQualifier.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

