/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.quicksight.model.ColumnGroup;
import software.amazon.awssdk.services.quicksight.model.ColumnGroupListCopier;
import software.amazon.awssdk.services.quicksight.model.ColumnLevelPermissionRule;
import software.amazon.awssdk.services.quicksight.model.ColumnLevelPermissionRuleListCopier;
import software.amazon.awssdk.services.quicksight.model.DataSetImportMode;
import software.amazon.awssdk.services.quicksight.model.DataSetUsageConfiguration;
import software.amazon.awssdk.services.quicksight.model.FieldFolder;
import software.amazon.awssdk.services.quicksight.model.FieldFolderMapCopier;
import software.amazon.awssdk.services.quicksight.model.LogicalTable;
import software.amazon.awssdk.services.quicksight.model.LogicalTableMapCopier;
import software.amazon.awssdk.services.quicksight.model.OutputColumn;
import software.amazon.awssdk.services.quicksight.model.OutputColumnListCopier;
import software.amazon.awssdk.services.quicksight.model.PhysicalTable;
import software.amazon.awssdk.services.quicksight.model.PhysicalTableMapCopier;
import software.amazon.awssdk.services.quicksight.model.RowLevelPermissionDataSet;
import software.amazon.awssdk.services.quicksight.model.RowLevelPermissionTagConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSet> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DataSet.getter(DataSet::arn)).setter(DataSet.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetId").getter(DataSet.getter(DataSet::dataSetId)).setter(DataSet.setter(Builder::dataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DataSet.getter(DataSet::name)).setter(DataSet.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(DataSet.getter(DataSet::createdTime)).setter(DataSet.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(DataSet.getter(DataSet::lastUpdatedTime)).setter(DataSet.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<Map<String, PhysicalTable>> PHYSICAL_TABLE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("PhysicalTableMap").getter(DataSet.getter(DataSet::physicalTableMap)).setter(DataSet.setter(Builder::physicalTableMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalTableMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhysicalTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, LogicalTable>> LOGICAL_TABLE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("LogicalTableMap").getter(DataSet.getter(DataSet::logicalTableMap)).setter(DataSet.setter(Builder::logicalTableMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalTableMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogicalTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<OutputColumn>> OUTPUT_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OutputColumns").getter(DataSet.getter(DataSet::outputColumns)).setter(DataSet.setter(Builder::outputColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputColumn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IMPORT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImportMode").getter(DataSet.getter(DataSet::importModeAsString)).setter(DataSet.setter(Builder::importMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportMode").build()}).build();
    private static final SdkField<Long> CONSUMED_SPICE_CAPACITY_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ConsumedSpiceCapacityInBytes").getter(DataSet.getter(DataSet::consumedSpiceCapacityInBytes)).setter(DataSet.setter(Builder::consumedSpiceCapacityInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedSpiceCapacityInBytes").build()}).build();
    private static final SdkField<List<ColumnGroup>> COLUMN_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnGroups").getter(DataSet.getter(DataSet::columnGroups)).setter(DataSet.setter(Builder::columnGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, FieldFolder>> FIELD_FOLDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("FieldFolders").getter(DataSet.getter(DataSet::fieldFolders)).setter(DataSet.setter(Builder::fieldFolders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldFolders").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldFolder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<RowLevelPermissionDataSet> ROW_LEVEL_PERMISSION_DATA_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RowLevelPermissionDataSet").getter(DataSet.getter(DataSet::rowLevelPermissionDataSet)).setter(DataSet.setter(Builder::rowLevelPermissionDataSet)).constructor(RowLevelPermissionDataSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowLevelPermissionDataSet").build()}).build();
    private static final SdkField<RowLevelPermissionTagConfiguration> ROW_LEVEL_PERMISSION_TAG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RowLevelPermissionTagConfiguration").getter(DataSet.getter(DataSet::rowLevelPermissionTagConfiguration)).setter(DataSet.setter(Builder::rowLevelPermissionTagConfiguration)).constructor(RowLevelPermissionTagConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowLevelPermissionTagConfiguration").build()}).build();
    private static final SdkField<List<ColumnLevelPermissionRule>> COLUMN_LEVEL_PERMISSION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnLevelPermissionRules").getter(DataSet.getter(DataSet::columnLevelPermissionRules)).setter(DataSet.setter(Builder::columnLevelPermissionRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnLevelPermissionRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnLevelPermissionRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataSetUsageConfiguration> DATA_SET_USAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSetUsageConfiguration").getter(DataSet.getter(DataSet::dataSetUsageConfiguration)).setter(DataSet.setter(Builder::dataSetUsageConfiguration)).constructor(DataSetUsageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetUsageConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DATA_SET_ID_FIELD, NAME_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, PHYSICAL_TABLE_MAP_FIELD, LOGICAL_TABLE_MAP_FIELD, OUTPUT_COLUMNS_FIELD, IMPORT_MODE_FIELD, CONSUMED_SPICE_CAPACITY_IN_BYTES_FIELD, COLUMN_GROUPS_FIELD, FIELD_FOLDERS_FIELD, ROW_LEVEL_PERMISSION_DATA_SET_FIELD, ROW_LEVEL_PERMISSION_TAG_CONFIGURATION_FIELD, COLUMN_LEVEL_PERMISSION_RULES_FIELD, DATA_SET_USAGE_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String dataSetId;
    private final String name;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;
    private final Map<String, PhysicalTable> physicalTableMap;
    private final Map<String, LogicalTable> logicalTableMap;
    private final List<OutputColumn> outputColumns;
    private final String importMode;
    private final Long consumedSpiceCapacityInBytes;
    private final List<ColumnGroup> columnGroups;
    private final Map<String, FieldFolder> fieldFolders;
    private final RowLevelPermissionDataSet rowLevelPermissionDataSet;
    private final RowLevelPermissionTagConfiguration rowLevelPermissionTagConfiguration;
    private final List<ColumnLevelPermissionRule> columnLevelPermissionRules;
    private final DataSetUsageConfiguration dataSetUsageConfiguration;

    private DataSet(BuilderImpl builder) {
        this.arn = builder.arn;
        this.dataSetId = builder.dataSetId;
        this.name = builder.name;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.physicalTableMap = builder.physicalTableMap;
        this.logicalTableMap = builder.logicalTableMap;
        this.outputColumns = builder.outputColumns;
        this.importMode = builder.importMode;
        this.consumedSpiceCapacityInBytes = builder.consumedSpiceCapacityInBytes;
        this.columnGroups = builder.columnGroups;
        this.fieldFolders = builder.fieldFolders;
        this.rowLevelPermissionDataSet = builder.rowLevelPermissionDataSet;
        this.rowLevelPermissionTagConfiguration = builder.rowLevelPermissionTagConfiguration;
        this.columnLevelPermissionRules = builder.columnLevelPermissionRules;
        this.dataSetUsageConfiguration = builder.dataSetUsageConfiguration;
    }

    public final String arn() {
        return this.arn;
    }

    public final String dataSetId() {
        return this.dataSetId;
    }

    public final String name() {
        return this.name;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final boolean hasPhysicalTableMap() {
        return this.physicalTableMap != null && !(this.physicalTableMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, PhysicalTable> physicalTableMap() {
        return this.physicalTableMap;
    }

    public final boolean hasLogicalTableMap() {
        return this.logicalTableMap != null && !(this.logicalTableMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, LogicalTable> logicalTableMap() {
        return this.logicalTableMap;
    }

    public final boolean hasOutputColumns() {
        return this.outputColumns != null && !(this.outputColumns instanceof SdkAutoConstructList);
    }

    public final List<OutputColumn> outputColumns() {
        return this.outputColumns;
    }

    public final DataSetImportMode importMode() {
        return DataSetImportMode.fromValue(this.importMode);
    }

    public final String importModeAsString() {
        return this.importMode;
    }

    public final Long consumedSpiceCapacityInBytes() {
        return this.consumedSpiceCapacityInBytes;
    }

    public final boolean hasColumnGroups() {
        return this.columnGroups != null && !(this.columnGroups instanceof SdkAutoConstructList);
    }

    public final List<ColumnGroup> columnGroups() {
        return this.columnGroups;
    }

    public final boolean hasFieldFolders() {
        return this.fieldFolders != null && !(this.fieldFolders instanceof SdkAutoConstructMap);
    }

    public final Map<String, FieldFolder> fieldFolders() {
        return this.fieldFolders;
    }

    public final RowLevelPermissionDataSet rowLevelPermissionDataSet() {
        return this.rowLevelPermissionDataSet;
    }

    public final RowLevelPermissionTagConfiguration rowLevelPermissionTagConfiguration() {
        return this.rowLevelPermissionTagConfiguration;
    }

    public final boolean hasColumnLevelPermissionRules() {
        return this.columnLevelPermissionRules != null && !(this.columnLevelPermissionRules instanceof SdkAutoConstructList);
    }

    public final List<ColumnLevelPermissionRule> columnLevelPermissionRules() {
        return this.columnLevelPermissionRules;
    }

    public final DataSetUsageConfiguration dataSetUsageConfiguration() {
        return this.dataSetUsageConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhysicalTableMap() ? this.physicalTableMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogicalTableMap() ? this.logicalTableMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputColumns() ? this.outputColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.importModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumedSpiceCapacityInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnGroups() ? this.columnGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFieldFolders() ? this.fieldFolders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.rowLevelPermissionDataSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowLevelPermissionTagConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnLevelPermissionRules() ? this.columnLevelPermissionRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetUsageConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSet)) {
            return false;
        }
        DataSet other = (DataSet)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.dataSetId(), other.dataSetId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && this.hasPhysicalTableMap() == other.hasPhysicalTableMap() && Objects.equals(this.physicalTableMap(), other.physicalTableMap()) && this.hasLogicalTableMap() == other.hasLogicalTableMap() && Objects.equals(this.logicalTableMap(), other.logicalTableMap()) && this.hasOutputColumns() == other.hasOutputColumns() && Objects.equals(this.outputColumns(), other.outputColumns()) && Objects.equals(this.importModeAsString(), other.importModeAsString()) && Objects.equals(this.consumedSpiceCapacityInBytes(), other.consumedSpiceCapacityInBytes()) && this.hasColumnGroups() == other.hasColumnGroups() && Objects.equals(this.columnGroups(), other.columnGroups()) && this.hasFieldFolders() == other.hasFieldFolders() && Objects.equals(this.fieldFolders(), other.fieldFolders()) && Objects.equals(this.rowLevelPermissionDataSet(), other.rowLevelPermissionDataSet()) && Objects.equals(this.rowLevelPermissionTagConfiguration(), other.rowLevelPermissionTagConfiguration()) && this.hasColumnLevelPermissionRules() == other.hasColumnLevelPermissionRules() && Objects.equals(this.columnLevelPermissionRules(), other.columnLevelPermissionRules()) && Objects.equals(this.dataSetUsageConfiguration(), other.dataSetUsageConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DataSet").add("Arn", (Object)this.arn()).add("DataSetId", (Object)this.dataSetId()).add("Name", (Object)this.name()).add("CreatedTime", (Object)this.createdTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("PhysicalTableMap", this.hasPhysicalTableMap() ? this.physicalTableMap() : null).add("LogicalTableMap", this.hasLogicalTableMap() ? this.logicalTableMap() : null).add("OutputColumns", this.hasOutputColumns() ? this.outputColumns() : null).add("ImportMode", (Object)this.importModeAsString()).add("ConsumedSpiceCapacityInBytes", (Object)this.consumedSpiceCapacityInBytes()).add("ColumnGroups", this.hasColumnGroups() ? this.columnGroups() : null).add("FieldFolders", this.hasFieldFolders() ? this.fieldFolders() : null).add("RowLevelPermissionDataSet", (Object)this.rowLevelPermissionDataSet()).add("RowLevelPermissionTagConfiguration", (Object)this.rowLevelPermissionTagConfiguration()).add("ColumnLevelPermissionRules", this.hasColumnLevelPermissionRules() ? this.columnLevelPermissionRules() : null).add("DataSetUsageConfiguration", (Object)this.dataSetUsageConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "DataSetId": {
                return Optional.ofNullable(clazz.cast(this.dataSetId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "PhysicalTableMap": {
                return Optional.ofNullable(clazz.cast(this.physicalTableMap()));
            }
            case "LogicalTableMap": {
                return Optional.ofNullable(clazz.cast(this.logicalTableMap()));
            }
            case "OutputColumns": {
                return Optional.ofNullable(clazz.cast(this.outputColumns()));
            }
            case "ImportMode": {
                return Optional.ofNullable(clazz.cast(this.importModeAsString()));
            }
            case "ConsumedSpiceCapacityInBytes": {
                return Optional.ofNullable(clazz.cast(this.consumedSpiceCapacityInBytes()));
            }
            case "ColumnGroups": {
                return Optional.ofNullable(clazz.cast(this.columnGroups()));
            }
            case "FieldFolders": {
                return Optional.ofNullable(clazz.cast(this.fieldFolders()));
            }
            case "RowLevelPermissionDataSet": {
                return Optional.ofNullable(clazz.cast(this.rowLevelPermissionDataSet()));
            }
            case "RowLevelPermissionTagConfiguration": {
                return Optional.ofNullable(clazz.cast(this.rowLevelPermissionTagConfiguration()));
            }
            case "ColumnLevelPermissionRules": {
                return Optional.ofNullable(clazz.cast(this.columnLevelPermissionRules()));
            }
            case "DataSetUsageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataSetUsageConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSet, T> g) {
        return obj -> g.apply((DataSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String dataSetId;
        private String name;
        private Instant createdTime;
        private Instant lastUpdatedTime;
        private Map<String, PhysicalTable> physicalTableMap = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, LogicalTable> logicalTableMap = DefaultSdkAutoConstructMap.getInstance();
        private List<OutputColumn> outputColumns = DefaultSdkAutoConstructList.getInstance();
        private String importMode;
        private Long consumedSpiceCapacityInBytes;
        private List<ColumnGroup> columnGroups = DefaultSdkAutoConstructList.getInstance();
        private Map<String, FieldFolder> fieldFolders = DefaultSdkAutoConstructMap.getInstance();
        private RowLevelPermissionDataSet rowLevelPermissionDataSet;
        private RowLevelPermissionTagConfiguration rowLevelPermissionTagConfiguration;
        private List<ColumnLevelPermissionRule> columnLevelPermissionRules = DefaultSdkAutoConstructList.getInstance();
        private DataSetUsageConfiguration dataSetUsageConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSet model) {
            this.arn(model.arn);
            this.dataSetId(model.dataSetId);
            this.name(model.name);
            this.createdTime(model.createdTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.physicalTableMap(model.physicalTableMap);
            this.logicalTableMap(model.logicalTableMap);
            this.outputColumns(model.outputColumns);
            this.importMode(model.importMode);
            this.consumedSpiceCapacityInBytes(model.consumedSpiceCapacityInBytes);
            this.columnGroups(model.columnGroups);
            this.fieldFolders(model.fieldFolders);
            this.rowLevelPermissionDataSet(model.rowLevelPermissionDataSet);
            this.rowLevelPermissionTagConfiguration(model.rowLevelPermissionTagConfiguration);
            this.columnLevelPermissionRules(model.columnLevelPermissionRules);
            this.dataSetUsageConfiguration(model.dataSetUsageConfiguration);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDataSetId() {
            return this.dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        @Transient
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Map<String, PhysicalTable.Builder> getPhysicalTableMap() {
            Map<String, PhysicalTable.Builder> result = PhysicalTableMapCopier.copyToBuilder(this.physicalTableMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPhysicalTableMap(Map<String, PhysicalTable.BuilderImpl> physicalTableMap) {
            this.physicalTableMap = PhysicalTableMapCopier.copyFromBuilder(physicalTableMap);
        }

        @Override
        @Transient
        public final Builder physicalTableMap(Map<String, PhysicalTable> physicalTableMap) {
            this.physicalTableMap = PhysicalTableMapCopier.copy(physicalTableMap);
            return this;
        }

        public final Map<String, LogicalTable.Builder> getLogicalTableMap() {
            Map<String, LogicalTable.Builder> result = LogicalTableMapCopier.copyToBuilder(this.logicalTableMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setLogicalTableMap(Map<String, LogicalTable.BuilderImpl> logicalTableMap) {
            this.logicalTableMap = LogicalTableMapCopier.copyFromBuilder(logicalTableMap);
        }

        @Override
        @Transient
        public final Builder logicalTableMap(Map<String, LogicalTable> logicalTableMap) {
            this.logicalTableMap = LogicalTableMapCopier.copy(logicalTableMap);
            return this;
        }

        public final List<OutputColumn.Builder> getOutputColumns() {
            List<OutputColumn.Builder> result = OutputColumnListCopier.copyToBuilder(this.outputColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputColumns(Collection<OutputColumn.BuilderImpl> outputColumns) {
            this.outputColumns = OutputColumnListCopier.copyFromBuilder(outputColumns);
        }

        @Override
        @Transient
        public final Builder outputColumns(Collection<OutputColumn> outputColumns) {
            this.outputColumns = OutputColumnListCopier.copy(outputColumns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputColumns(OutputColumn ... outputColumns) {
            this.outputColumns(Arrays.asList(outputColumns));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputColumns(Consumer<OutputColumn.Builder> ... outputColumns) {
            this.outputColumns(Stream.of(outputColumns).map(c -> (OutputColumn)((OutputColumn.Builder)OutputColumn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getImportMode() {
            return this.importMode;
        }

        public final void setImportMode(String importMode) {
            this.importMode = importMode;
        }

        @Override
        @Transient
        public final Builder importMode(String importMode) {
            this.importMode = importMode;
            return this;
        }

        @Override
        @Transient
        public final Builder importMode(DataSetImportMode importMode) {
            this.importMode(importMode == null ? null : importMode.toString());
            return this;
        }

        public final Long getConsumedSpiceCapacityInBytes() {
            return this.consumedSpiceCapacityInBytes;
        }

        public final void setConsumedSpiceCapacityInBytes(Long consumedSpiceCapacityInBytes) {
            this.consumedSpiceCapacityInBytes = consumedSpiceCapacityInBytes;
        }

        @Override
        @Transient
        public final Builder consumedSpiceCapacityInBytes(Long consumedSpiceCapacityInBytes) {
            this.consumedSpiceCapacityInBytes = consumedSpiceCapacityInBytes;
            return this;
        }

        public final List<ColumnGroup.Builder> getColumnGroups() {
            List<ColumnGroup.Builder> result = ColumnGroupListCopier.copyToBuilder(this.columnGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnGroups(Collection<ColumnGroup.BuilderImpl> columnGroups) {
            this.columnGroups = ColumnGroupListCopier.copyFromBuilder(columnGroups);
        }

        @Override
        @Transient
        public final Builder columnGroups(Collection<ColumnGroup> columnGroups) {
            this.columnGroups = ColumnGroupListCopier.copy(columnGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder columnGroups(ColumnGroup ... columnGroups) {
            this.columnGroups(Arrays.asList(columnGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder columnGroups(Consumer<ColumnGroup.Builder> ... columnGroups) {
            this.columnGroups(Stream.of(columnGroups).map(c -> (ColumnGroup)((ColumnGroup.Builder)ColumnGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, FieldFolder.Builder> getFieldFolders() {
            Map<String, FieldFolder.Builder> result = FieldFolderMapCopier.copyToBuilder(this.fieldFolders);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFieldFolders(Map<String, FieldFolder.BuilderImpl> fieldFolders) {
            this.fieldFolders = FieldFolderMapCopier.copyFromBuilder(fieldFolders);
        }

        @Override
        @Transient
        public final Builder fieldFolders(Map<String, FieldFolder> fieldFolders) {
            this.fieldFolders = FieldFolderMapCopier.copy(fieldFolders);
            return this;
        }

        public final RowLevelPermissionDataSet.Builder getRowLevelPermissionDataSet() {
            return this.rowLevelPermissionDataSet != null ? this.rowLevelPermissionDataSet.toBuilder() : null;
        }

        public final void setRowLevelPermissionDataSet(RowLevelPermissionDataSet.BuilderImpl rowLevelPermissionDataSet) {
            this.rowLevelPermissionDataSet = rowLevelPermissionDataSet != null ? rowLevelPermissionDataSet.build() : null;
        }

        @Override
        @Transient
        public final Builder rowLevelPermissionDataSet(RowLevelPermissionDataSet rowLevelPermissionDataSet) {
            this.rowLevelPermissionDataSet = rowLevelPermissionDataSet;
            return this;
        }

        public final RowLevelPermissionTagConfiguration.Builder getRowLevelPermissionTagConfiguration() {
            return this.rowLevelPermissionTagConfiguration != null ? this.rowLevelPermissionTagConfiguration.toBuilder() : null;
        }

        public final void setRowLevelPermissionTagConfiguration(RowLevelPermissionTagConfiguration.BuilderImpl rowLevelPermissionTagConfiguration) {
            this.rowLevelPermissionTagConfiguration = rowLevelPermissionTagConfiguration != null ? rowLevelPermissionTagConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder rowLevelPermissionTagConfiguration(RowLevelPermissionTagConfiguration rowLevelPermissionTagConfiguration) {
            this.rowLevelPermissionTagConfiguration = rowLevelPermissionTagConfiguration;
            return this;
        }

        public final List<ColumnLevelPermissionRule.Builder> getColumnLevelPermissionRules() {
            List<ColumnLevelPermissionRule.Builder> result = ColumnLevelPermissionRuleListCopier.copyToBuilder(this.columnLevelPermissionRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnLevelPermissionRules(Collection<ColumnLevelPermissionRule.BuilderImpl> columnLevelPermissionRules) {
            this.columnLevelPermissionRules = ColumnLevelPermissionRuleListCopier.copyFromBuilder(columnLevelPermissionRules);
        }

        @Override
        @Transient
        public final Builder columnLevelPermissionRules(Collection<ColumnLevelPermissionRule> columnLevelPermissionRules) {
            this.columnLevelPermissionRules = ColumnLevelPermissionRuleListCopier.copy(columnLevelPermissionRules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder columnLevelPermissionRules(ColumnLevelPermissionRule ... columnLevelPermissionRules) {
            this.columnLevelPermissionRules(Arrays.asList(columnLevelPermissionRules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder columnLevelPermissionRules(Consumer<ColumnLevelPermissionRule.Builder> ... columnLevelPermissionRules) {
            this.columnLevelPermissionRules(Stream.of(columnLevelPermissionRules).map(c -> (ColumnLevelPermissionRule)((ColumnLevelPermissionRule.Builder)ColumnLevelPermissionRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DataSetUsageConfiguration.Builder getDataSetUsageConfiguration() {
            return this.dataSetUsageConfiguration != null ? this.dataSetUsageConfiguration.toBuilder() : null;
        }

        public final void setDataSetUsageConfiguration(DataSetUsageConfiguration.BuilderImpl dataSetUsageConfiguration) {
            this.dataSetUsageConfiguration = dataSetUsageConfiguration != null ? dataSetUsageConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder dataSetUsageConfiguration(DataSetUsageConfiguration dataSetUsageConfiguration) {
            this.dataSetUsageConfiguration = dataSetUsageConfiguration;
            return this;
        }

        public DataSet build() {
            return new DataSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSet> {
        public Builder arn(String var1);

        public Builder dataSetId(String var1);

        public Builder name(String var1);

        public Builder createdTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder physicalTableMap(Map<String, PhysicalTable> var1);

        public Builder logicalTableMap(Map<String, LogicalTable> var1);

        public Builder outputColumns(Collection<OutputColumn> var1);

        public Builder outputColumns(OutputColumn ... var1);

        public Builder outputColumns(Consumer<OutputColumn.Builder> ... var1);

        public Builder importMode(String var1);

        public Builder importMode(DataSetImportMode var1);

        public Builder consumedSpiceCapacityInBytes(Long var1);

        public Builder columnGroups(Collection<ColumnGroup> var1);

        public Builder columnGroups(ColumnGroup ... var1);

        public Builder columnGroups(Consumer<ColumnGroup.Builder> ... var1);

        public Builder fieldFolders(Map<String, FieldFolder> var1);

        public Builder rowLevelPermissionDataSet(RowLevelPermissionDataSet var1);

        default public Builder rowLevelPermissionDataSet(Consumer<RowLevelPermissionDataSet.Builder> rowLevelPermissionDataSet) {
            return this.rowLevelPermissionDataSet((RowLevelPermissionDataSet)((RowLevelPermissionDataSet.Builder)RowLevelPermissionDataSet.builder().applyMutation(rowLevelPermissionDataSet)).build());
        }

        public Builder rowLevelPermissionTagConfiguration(RowLevelPermissionTagConfiguration var1);

        default public Builder rowLevelPermissionTagConfiguration(Consumer<RowLevelPermissionTagConfiguration.Builder> rowLevelPermissionTagConfiguration) {
            return this.rowLevelPermissionTagConfiguration((RowLevelPermissionTagConfiguration)((RowLevelPermissionTagConfiguration.Builder)RowLevelPermissionTagConfiguration.builder().applyMutation(rowLevelPermissionTagConfiguration)).build());
        }

        public Builder columnLevelPermissionRules(Collection<ColumnLevelPermissionRule> var1);

        public Builder columnLevelPermissionRules(ColumnLevelPermissionRule ... var1);

        public Builder columnLevelPermissionRules(Consumer<ColumnLevelPermissionRule.Builder> ... var1);

        public Builder dataSetUsageConfiguration(DataSetUsageConfiguration var1);

        default public Builder dataSetUsageConfiguration(Consumer<DataSetUsageConfiguration.Builder> dataSetUsageConfiguration) {
            return this.dataSetUsageConfiguration((DataSetUsageConfiguration)((DataSetUsageConfiguration.Builder)DataSetUsageConfiguration.builder().applyMutation(dataSetUsageConfiguration)).build());
        }
    }
}

