/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.model.AnalysisSummary;
import software.amazon.awssdk.services.quicksight.model.ListAnalysesRequest;
import software.amazon.awssdk.services.quicksight.model.ListAnalysesResponse;

public class ListAnalysesIterable
implements SdkIterable<ListAnalysesResponse> {
    private final QuickSightClient client;
    private final ListAnalysesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAnalysesIterable(QuickSightClient client, ListAnalysesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAnalysesResponseFetcher();
    }

    public Iterator<ListAnalysesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AnalysisSummary> analysisSummaryList() {
        Function<ListAnalysesResponse, Iterator> getIterator = response -> {
            if (response != null && response.analysisSummaryList() != null) {
                return response.analysisSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAnalysesResponseFetcher
    implements SyncPageFetcher<ListAnalysesResponse> {
        private ListAnalysesResponseFetcher() {
        }

        public boolean hasNextPage(ListAnalysesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAnalysesResponse nextPage(ListAnalysesResponse previousPage) {
            if (previousPage == null) {
                return ListAnalysesIterable.this.client.listAnalyses(ListAnalysesIterable.this.firstRequest);
            }
            return ListAnalysesIterable.this.client.listAnalyses((ListAnalysesRequest)((Object)ListAnalysesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

