/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataSetImportMode {
    SPICE("SPICE"),
    DIRECT_QUERY("DIRECT_QUERY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataSetImportMode> VALUE_MAP;
    private final String value;

    private DataSetImportMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataSetImportMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataSetImportMode> knownValues() {
        EnumSet<DataSetImportMode> knownValues = EnumSet.allOf(DataSetImportMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataSetImportMode.class, DataSetImportMode::toString);
    }
}

