/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DashboardUIState {
    EXPANDED("EXPANDED"),
    COLLAPSED("COLLAPSED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DashboardUIState> VALUE_MAP;
    private final String value;

    private DashboardUIState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DashboardUIState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DashboardUIState> knownValues() {
        EnumSet<DashboardUIState> knownValues = EnumSet.allOf(DashboardUIState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DashboardUIState.class, DashboardUIState::toString);
    }
}

