/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.CredentialPair;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceCredentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceCredentials> {
    private static final SdkField<CredentialPair> CREDENTIAL_PAIR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CredentialPair").getter(DataSourceCredentials.getter(DataSourceCredentials::credentialPair)).setter(DataSourceCredentials.setter(Builder::credentialPair)).constructor(CredentialPair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CredentialPair").build()}).build();
    private static final SdkField<String> COPY_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CopySourceArn").getter(DataSourceCredentials.getter(DataSourceCredentials::copySourceArn)).setter(DataSourceCredentials.setter(Builder::copySourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopySourceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIAL_PAIR_FIELD, COPY_SOURCE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final CredentialPair credentialPair;
    private final String copySourceArn;

    private DataSourceCredentials(BuilderImpl builder) {
        this.credentialPair = builder.credentialPair;
        this.copySourceArn = builder.copySourceArn;
    }

    public final CredentialPair credentialPair() {
        return this.credentialPair;
    }

    public final String copySourceArn() {
        return this.copySourceArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialPair());
        hashCode = 31 * hashCode + Objects.hashCode(this.copySourceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceCredentials)) {
            return false;
        }
        DataSourceCredentials other = (DataSourceCredentials)obj;
        return Objects.equals(this.credentialPair(), other.credentialPair()) && Objects.equals(this.copySourceArn(), other.copySourceArn());
    }

    public final String toString() {
        return ToString.builder((String)"DataSourceCredentials").add("CredentialPair", (Object)this.credentialPair()).add("CopySourceArn", (Object)this.copySourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CredentialPair": {
                return Optional.ofNullable(clazz.cast(this.credentialPair()));
            }
            case "CopySourceArn": {
                return Optional.ofNullable(clazz.cast(this.copySourceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceCredentials, T> g) {
        return obj -> g.apply((DataSourceCredentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CredentialPair credentialPair;
        private String copySourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceCredentials model) {
            this.credentialPair(model.credentialPair);
            this.copySourceArn(model.copySourceArn);
        }

        public final CredentialPair.Builder getCredentialPair() {
            return this.credentialPair != null ? this.credentialPair.toBuilder() : null;
        }

        @Override
        public final Builder credentialPair(CredentialPair credentialPair) {
            this.credentialPair = credentialPair;
            return this;
        }

        public final void setCredentialPair(CredentialPair.BuilderImpl credentialPair) {
            this.credentialPair = credentialPair != null ? credentialPair.build() : null;
        }

        public final String getCopySourceArn() {
            return this.copySourceArn;
        }

        @Override
        public final Builder copySourceArn(String copySourceArn) {
            this.copySourceArn = copySourceArn;
            return this;
        }

        public final void setCopySourceArn(String copySourceArn) {
            this.copySourceArn = copySourceArn;
        }

        public DataSourceCredentials build() {
            return new DataSourceCredentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceCredentials> {
        public Builder credentialPair(CredentialPair var1);

        default public Builder credentialPair(Consumer<CredentialPair.Builder> credentialPair) {
            return this.credentialPair((CredentialPair)((CredentialPair.Builder)CredentialPair.builder().applyMutation(credentialPair)).build());
        }

        public Builder copySourceArn(String var1);
    }
}

