/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.ThemeAlias;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateThemeAliasResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, CreateThemeAliasResponse> {
    private static final SdkField<ThemeAlias> THEME_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ThemeAlias").getter(CreateThemeAliasResponse.getter(CreateThemeAliasResponse::themeAlias)).setter(CreateThemeAliasResponse.setter(Builder::themeAlias)).constructor(ThemeAlias::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeAlias").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(CreateThemeAliasResponse.getter(CreateThemeAliasResponse::status)).setter(CreateThemeAliasResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(CreateThemeAliasResponse.getter(CreateThemeAliasResponse::requestId)).setter(CreateThemeAliasResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THEME_ALIAS_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));
    private final ThemeAlias themeAlias;
    private final Integer status;
    private final String requestId;

    private CreateThemeAliasResponse(BuilderImpl builder) {
        super(builder);
        this.themeAlias = builder.themeAlias;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    public final ThemeAlias themeAlias() {
        return this.themeAlias;
    }

    public final Integer status() {
        return this.status;
    }

    public final String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.themeAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThemeAliasResponse)) {
            return false;
        }
        CreateThemeAliasResponse other = (CreateThemeAliasResponse)((Object)obj);
        return Objects.equals(this.themeAlias(), other.themeAlias()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.requestId(), other.requestId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateThemeAliasResponse").add("ThemeAlias", (Object)this.themeAlias()).add("Status", (Object)this.status()).add("RequestId", (Object)this.requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ThemeAlias": {
                return Optional.ofNullable(clazz.cast(this.themeAlias()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateThemeAliasResponse, T> g) {
        return obj -> g.apply((CreateThemeAliasResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private ThemeAlias themeAlias;
        private Integer status;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThemeAliasResponse model) {
            super(model);
            this.themeAlias(model.themeAlias);
            this.status(model.status);
            this.requestId(model.requestId);
        }

        public final ThemeAlias.Builder getThemeAlias() {
            return this.themeAlias != null ? this.themeAlias.toBuilder() : null;
        }

        @Override
        public final Builder themeAlias(ThemeAlias themeAlias) {
            this.themeAlias = themeAlias;
            return this;
        }

        public final void setThemeAlias(ThemeAlias.BuilderImpl themeAlias) {
            this.themeAlias = themeAlias != null ? themeAlias.build() : null;
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public CreateThemeAliasResponse build() {
            return new CreateThemeAliasResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateThemeAliasResponse> {
        public Builder themeAlias(ThemeAlias var1);

        default public Builder themeAlias(Consumer<ThemeAlias.Builder> themeAlias) {
            return this.themeAlias((ThemeAlias)((ThemeAlias.Builder)ThemeAlias.builder().applyMutation(themeAlias)).build());
        }

        public Builder status(Integer var1);

        public Builder requestId(String var1);
    }
}

