/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AccountCustomization;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAccountCustomizationRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateAccountCustomizationRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateAccountCustomizationRequest.getter(UpdateAccountCustomizationRequest::awsAccountId)).setter(UpdateAccountCustomizationRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(UpdateAccountCustomizationRequest.getter(UpdateAccountCustomizationRequest::namespace)).setter(UpdateAccountCustomizationRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("namespace").build()}).build();
    private static final SdkField<AccountCustomization> ACCOUNT_CUSTOMIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccountCustomization").getter(UpdateAccountCustomizationRequest.getter(UpdateAccountCustomizationRequest::accountCustomization)).setter(UpdateAccountCustomizationRequest.setter(Builder::accountCustomization)).constructor(AccountCustomization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountCustomization").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, NAMESPACE_FIELD, ACCOUNT_CUSTOMIZATION_FIELD));
    private final String awsAccountId;
    private final String namespace;
    private final AccountCustomization accountCustomization;

    private UpdateAccountCustomizationRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.namespace = builder.namespace;
        this.accountCustomization = builder.accountCustomization;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final AccountCustomization accountCustomization() {
        return this.accountCustomization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountCustomization());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountCustomizationRequest)) {
            return false;
        }
        UpdateAccountCustomizationRequest other = (UpdateAccountCustomizationRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.accountCustomization(), other.accountCustomization());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAccountCustomizationRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("Namespace", (Object)this.namespace()).add("AccountCustomization", (Object)this.accountCustomization()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "AccountCustomization": {
                return Optional.ofNullable(clazz.cast(this.accountCustomization()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountCustomizationRequest, T> g) {
        return obj -> g.apply((UpdateAccountCustomizationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String namespace;
        private AccountCustomization accountCustomization;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountCustomizationRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.namespace(model.namespace);
            this.accountCustomization(model.accountCustomization);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final AccountCustomization.Builder getAccountCustomization() {
            return this.accountCustomization != null ? this.accountCustomization.toBuilder() : null;
        }

        @Override
        public final Builder accountCustomization(AccountCustomization accountCustomization) {
            this.accountCustomization = accountCustomization;
            return this;
        }

        public final void setAccountCustomization(AccountCustomization.BuilderImpl accountCustomization) {
            this.accountCustomization = accountCustomization != null ? accountCustomization.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccountCustomizationRequest build() {
            return new UpdateAccountCustomizationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAccountCustomizationRequest> {
        public Builder awsAccountId(String var1);

        public Builder namespace(String var1);

        public Builder accountCustomization(AccountCustomization var1);

        default public Builder accountCustomization(Consumer<AccountCustomization.Builder> accountCustomization) {
            return this.accountCustomization((AccountCustomization)((AccountCustomization.Builder)AccountCustomization.builder().applyMutation(accountCustomization)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

