/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SqlServerParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SqlServerParameters> {
    private static final SdkField<String> HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Host").getter(SqlServerParameters.getter(SqlServerParameters::host)).setter(SqlServerParameters.setter(Builder::host)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(SqlServerParameters.getter(SqlServerParameters::port)).setter(SqlServerParameters.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(SqlServerParameters.getter(SqlServerParameters::database)).setter(SqlServerParameters.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD, PORT_FIELD, DATABASE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String host;
    private final Integer port;
    private final String database;

    private SqlServerParameters(BuilderImpl builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.database = builder.database;
    }

    public final String host() {
        return this.host;
    }

    public final Integer port() {
        return this.port;
    }

    public final String database() {
        return this.database;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.host());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlServerParameters)) {
            return false;
        }
        SqlServerParameters other = (SqlServerParameters)obj;
        return Objects.equals(this.host(), other.host()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.database(), other.database());
    }

    public final String toString() {
        return ToString.builder((String)"SqlServerParameters").add("Host", (Object)this.host()).add("Port", (Object)this.port()).add("Database", (Object)this.database()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Host": {
                return Optional.ofNullable(clazz.cast(this.host()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SqlServerParameters, T> g) {
        return obj -> g.apply((SqlServerParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String host;
        private Integer port;
        private String database;

        private BuilderImpl() {
        }

        private BuilderImpl(SqlServerParameters model) {
            this.host(model.host);
            this.port(model.port);
            this.database(model.database);
        }

        public final String getHost() {
            return this.host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getDatabase() {
            return this.database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        public SqlServerParameters build() {
            return new SqlServerParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SqlServerParameters> {
        public Builder host(String var1);

        public Builder port(Integer var1);

        public Builder database(String var1);
    }
}

