/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The combination of user name and password that are used as credentials.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CredentialPair implements SdkPojo, Serializable, ToCopyableBuilder<CredentialPair.Builder, CredentialPair> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(CredentialPair::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(CredentialPair::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<List<DataSourceParameters>> ALTERNATE_DATA_SOURCE_PARAMETERS_FIELD = SdkField
            .<List<DataSourceParameters>> builder(MarshallingType.LIST)
            .memberName("AlternateDataSourceParameters")
            .getter(getter(CredentialPair::alternateDataSourceParameters))
            .setter(setter(Builder::alternateDataSourceParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlternateDataSourceParameters")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceParameters> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceParameters::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD,
            PASSWORD_FIELD, ALTERNATE_DATA_SOURCE_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String username;

    private final String password;

    private final List<DataSourceParameters> alternateDataSourceParameters;

    private CredentialPair(BuilderImpl builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.alternateDataSourceParameters = builder.alternateDataSourceParameters;
    }

    /**
     * <p>
     * User name.
     * </p>
     * 
     * @return User name.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * Password.
     * </p>
     * 
     * @return Password.
     */
    public final String password() {
        return password;
    }

    /**
     * Returns true if the AlternateDataSourceParameters property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasAlternateDataSourceParameters() {
        return alternateDataSourceParameters != null && !(alternateDataSourceParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of alternate data source parameters that you want to share for these credentials. The credentials are
     * applied in tandem with the data source parameters when you copy a data source by using a create or update
     * request. The API operation compares the <code>DataSourceParameters</code> structure that's in the request with
     * the structures in the <code>AlternateDataSourceParameters</code> allow list. If the structures are an exact
     * match, the request is allowed to use the new data source with the existing credentials. If the
     * <code>AlternateDataSourceParameters</code> list is null, the <code>DataSourceParameters</code> originally used
     * with these <code>Credentials</code> is automatically allowed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAlternateDataSourceParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A set of alternate data source parameters that you want to share for these credentials. The credentials
     *         are applied in tandem with the data source parameters when you copy a data source by using a create or
     *         update request. The API operation compares the <code>DataSourceParameters</code> structure that's in the
     *         request with the structures in the <code>AlternateDataSourceParameters</code> allow list. If the
     *         structures are an exact match, the request is allowed to use the new data source with the existing
     *         credentials. If the <code>AlternateDataSourceParameters</code> list is null, the
     *         <code>DataSourceParameters</code> originally used with these <code>Credentials</code> is automatically
     *         allowed.
     */
    public final List<DataSourceParameters> alternateDataSourceParameters() {
        return alternateDataSourceParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(hasAlternateDataSourceParameters() ? alternateDataSourceParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CredentialPair)) {
            return false;
        }
        CredentialPair other = (CredentialPair) obj;
        return Objects.equals(username(), other.username()) && Objects.equals(password(), other.password())
                && hasAlternateDataSourceParameters() == other.hasAlternateDataSourceParameters()
                && Objects.equals(alternateDataSourceParameters(), other.alternateDataSourceParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CredentialPair")
                .add("Username", username())
                .add("Password", password())
                .add("AlternateDataSourceParameters", hasAlternateDataSourceParameters() ? alternateDataSourceParameters() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "AlternateDataSourceParameters":
            return Optional.ofNullable(clazz.cast(alternateDataSourceParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CredentialPair, T> g) {
        return obj -> g.apply((CredentialPair) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CredentialPair> {
        /**
         * <p>
         * User name.
         * </p>
         * 
         * @param username
         *        User name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * Password.
         * </p>
         * 
         * @param password
         *        Password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * A set of alternate data source parameters that you want to share for these credentials. The credentials are
         * applied in tandem with the data source parameters when you copy a data source by using a create or update
         * request. The API operation compares the <code>DataSourceParameters</code> structure that's in the request
         * with the structures in the <code>AlternateDataSourceParameters</code> allow list. If the structures are an
         * exact match, the request is allowed to use the new data source with the existing credentials. If the
         * <code>AlternateDataSourceParameters</code> list is null, the <code>DataSourceParameters</code> originally
         * used with these <code>Credentials</code> is automatically allowed.
         * </p>
         * 
         * @param alternateDataSourceParameters
         *        A set of alternate data source parameters that you want to share for these credentials. The
         *        credentials are applied in tandem with the data source parameters when you copy a data source by using
         *        a create or update request. The API operation compares the <code>DataSourceParameters</code> structure
         *        that's in the request with the structures in the <code>AlternateDataSourceParameters</code> allow
         *        list. If the structures are an exact match, the request is allowed to use the new data source with the
         *        existing credentials. If the <code>AlternateDataSourceParameters</code> list is null, the
         *        <code>DataSourceParameters</code> originally used with these <code>Credentials</code> is automatically
         *        allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alternateDataSourceParameters(Collection<DataSourceParameters> alternateDataSourceParameters);

        /**
         * <p>
         * A set of alternate data source parameters that you want to share for these credentials. The credentials are
         * applied in tandem with the data source parameters when you copy a data source by using a create or update
         * request. The API operation compares the <code>DataSourceParameters</code> structure that's in the request
         * with the structures in the <code>AlternateDataSourceParameters</code> allow list. If the structures are an
         * exact match, the request is allowed to use the new data source with the existing credentials. If the
         * <code>AlternateDataSourceParameters</code> list is null, the <code>DataSourceParameters</code> originally
         * used with these <code>Credentials</code> is automatically allowed.
         * </p>
         * 
         * @param alternateDataSourceParameters
         *        A set of alternate data source parameters that you want to share for these credentials. The
         *        credentials are applied in tandem with the data source parameters when you copy a data source by using
         *        a create or update request. The API operation compares the <code>DataSourceParameters</code> structure
         *        that's in the request with the structures in the <code>AlternateDataSourceParameters</code> allow
         *        list. If the structures are an exact match, the request is allowed to use the new data source with the
         *        existing credentials. If the <code>AlternateDataSourceParameters</code> list is null, the
         *        <code>DataSourceParameters</code> originally used with these <code>Credentials</code> is automatically
         *        allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alternateDataSourceParameters(DataSourceParameters... alternateDataSourceParameters);

        /**
         * <p>
         * A set of alternate data source parameters that you want to share for these credentials. The credentials are
         * applied in tandem with the data source parameters when you copy a data source by using a create or update
         * request. The API operation compares the <code>DataSourceParameters</code> structure that's in the request
         * with the structures in the <code>AlternateDataSourceParameters</code> allow list. If the structures are an
         * exact match, the request is allowed to use the new data source with the existing credentials. If the
         * <code>AlternateDataSourceParameters</code> list is null, the <code>DataSourceParameters</code> originally
         * used with these <code>Credentials</code> is automatically allowed.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DataSourceParameters>.Builder} avoiding the
         * need to create one manually via {@link List<DataSourceParameters>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataSourceParameters>.Builder#build()} is called immediately
         * and its result is passed to {@link #alternateDataSourceParameters(List<DataSourceParameters>)}.
         * 
         * @param alternateDataSourceParameters
         *        a consumer that will call methods on {@link List<DataSourceParameters>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alternateDataSourceParameters(List<DataSourceParameters>)
         */
        Builder alternateDataSourceParameters(Consumer<DataSourceParameters.Builder>... alternateDataSourceParameters);
    }

    static final class BuilderImpl implements Builder {
        private String username;

        private String password;

        private List<DataSourceParameters> alternateDataSourceParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CredentialPair model) {
            username(model.username);
            password(model.password);
            alternateDataSourceParameters(model.alternateDataSourceParameters);
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final Collection<DataSourceParameters.Builder> getAlternateDataSourceParameters() {
            if (alternateDataSourceParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return alternateDataSourceParameters != null ? alternateDataSourceParameters.stream()
                    .map(DataSourceParameters::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder alternateDataSourceParameters(Collection<DataSourceParameters> alternateDataSourceParameters) {
            this.alternateDataSourceParameters = DataSourceParametersListCopier.copy(alternateDataSourceParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternateDataSourceParameters(DataSourceParameters... alternateDataSourceParameters) {
            alternateDataSourceParameters(Arrays.asList(alternateDataSourceParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternateDataSourceParameters(
                Consumer<DataSourceParameters.Builder>... alternateDataSourceParameters) {
            alternateDataSourceParameters(Stream.of(alternateDataSourceParameters)
                    .map(c -> DataSourceParameters.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAlternateDataSourceParameters(
                Collection<DataSourceParameters.BuilderImpl> alternateDataSourceParameters) {
            this.alternateDataSourceParameters = DataSourceParametersListCopier.copyFromBuilder(alternateDataSourceParameters);
        }

        @Override
        public CredentialPair build() {
            return new CredentialPair(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
