/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataSetResponse extends QuickSightResponse implements
        ToCopyableBuilder<CreateDataSetResponse.Builder, CreateDataSetResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CreateDataSetResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetId").getter(getter(CreateDataSetResponse::dataSetId)).setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()).build();

    private static final SdkField<String> INGESTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IngestionArn").getter(getter(CreateDataSetResponse::ingestionArn)).setter(setter(Builder::ingestionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionArn").build()).build();

    private static final SdkField<String> INGESTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IngestionId").getter(getter(CreateDataSetResponse::ingestionId)).setter(setter(Builder::ingestionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionId").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(CreateDataSetResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(CreateDataSetResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DATA_SET_ID_FIELD,
            INGESTION_ARN_FIELD, INGESTION_ID_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));

    private final String arn;

    private final String dataSetId;

    private final String ingestionArn;

    private final String ingestionId;

    private final String requestId;

    private final Integer status;

    private CreateDataSetResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.dataSetId = builder.dataSetId;
        this.ingestionArn = builder.ingestionArn;
        this.ingestionId = builder.ingestionId;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID for the dataset that you want to create. This ID is unique per AWS Region for each AWS account.
     * </p>
     * 
     * @return The ID for the dataset that you want to create. This ID is unique per AWS Region for each AWS account.
     */
    public final String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * The ARN for the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.
     * </p>
     * 
     * @return The ARN for the ingestion, which is triggered as a result of dataset creation if the import mode is
     *         SPICE.
     */
    public final String ingestionArn() {
        return ingestionArn;
    }

    /**
     * <p>
     * The ID of the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.
     * </p>
     * 
     * @return The ID of the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.
     */
    public final String ingestionId() {
        return ingestionId;
    }

    /**
     * <p>
     * The AWS request ID for this operation.
     * </p>
     * 
     * @return The AWS request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionArn());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionId());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSetResponse)) {
            return false;
        }
        CreateDataSetResponse other = (CreateDataSetResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(dataSetId(), other.dataSetId())
                && Objects.equals(ingestionArn(), other.ingestionArn()) && Objects.equals(ingestionId(), other.ingestionId())
                && Objects.equals(requestId(), other.requestId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataSetResponse").add("Arn", arn()).add("DataSetId", dataSetId())
                .add("IngestionArn", ingestionArn()).add("IngestionId", ingestionId()).add("RequestId", requestId())
                .add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "IngestionArn":
            return Optional.ofNullable(clazz.cast(ingestionArn()));
        case "IngestionId":
            return Optional.ofNullable(clazz.cast(ingestionId()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSetResponse, T> g) {
        return obj -> g.apply((CreateDataSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDataSetResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID for the dataset that you want to create. This ID is unique per AWS Region for each AWS account.
         * </p>
         * 
         * @param dataSetId
         *        The ID for the dataset that you want to create. This ID is unique per AWS Region for each AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * The ARN for the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.
         * </p>
         * 
         * @param ingestionArn
         *        The ARN for the ingestion, which is triggered as a result of dataset creation if the import mode is
         *        SPICE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionArn(String ingestionArn);

        /**
         * <p>
         * The ID of the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.
         * </p>
         * 
         * @param ingestionId
         *        The ID of the ingestion, which is triggered as a result of dataset creation if the import mode is
         *        SPICE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionId(String ingestionId);

        /**
         * <p>
         * The AWS request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The AWS request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String arn;

        private String dataSetId;

        private String ingestionArn;

        private String ingestionId;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSetResponse model) {
            super(model);
            arn(model.arn);
            dataSetId(model.dataSetId);
            ingestionArn(model.ingestionArn);
            ingestionId(model.ingestionId);
            requestId(model.requestId);
            status(model.status);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        public final String getIngestionArn() {
            return ingestionArn;
        }

        @Override
        public final Builder ingestionArn(String ingestionArn) {
            this.ingestionArn = ingestionArn;
            return this;
        }

        public final void setIngestionArn(String ingestionArn) {
            this.ingestionArn = ingestionArn;
        }

        public final String getIngestionId() {
            return ingestionId;
        }

        @Override
        public final Builder ingestionId(String ingestionId) {
            this.ingestionId = ingestionId;
            return this;
        }

        public final void setIngestionId(String ingestionId) {
            this.ingestionId = ingestionId;
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Integer getStatus() {
            return status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public CreateDataSetResponse build() {
            return new CreateDataSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
