/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AnalysisSummary;
import software.amazon.awssdk.services.quicksight.model.AnalysisSummaryListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAnalysesResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, ListAnalysesResponse> {
    private static final SdkField<List<AnalysisSummary>> ANALYSIS_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnalysisSummaryList").getter(ListAnalysesResponse.getter(ListAnalysesResponse::analysisSummaryList)).setter(ListAnalysesResponse.setter(Builder::analysisSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalysisSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAnalysesResponse.getter(ListAnalysesResponse::nextToken)).setter(ListAnalysesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(ListAnalysesResponse.getter(ListAnalysesResponse::status)).setter(ListAnalysesResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(ListAnalysesResponse.getter(ListAnalysesResponse::requestId)).setter(ListAnalysesResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));
    private final List<AnalysisSummary> analysisSummaryList;
    private final String nextToken;
    private final Integer status;
    private final String requestId;

    private ListAnalysesResponse(BuilderImpl builder) {
        super(builder);
        this.analysisSummaryList = builder.analysisSummaryList;
        this.nextToken = builder.nextToken;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    public boolean hasAnalysisSummaryList() {
        return this.analysisSummaryList != null && !(this.analysisSummaryList instanceof SdkAutoConstructList);
    }

    public List<AnalysisSummary> analysisSummaryList() {
        return this.analysisSummaryList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer status() {
        return this.status;
    }

    public String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnalysesResponse)) {
            return false;
        }
        ListAnalysesResponse other = (ListAnalysesResponse)((Object)obj);
        return Objects.equals(this.analysisSummaryList(), other.analysisSummaryList()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.requestId(), other.requestId());
    }

    public String toString() {
        return ToString.builder((String)"ListAnalysesResponse").add("AnalysisSummaryList", this.analysisSummaryList()).add("NextToken", (Object)this.nextToken()).add("Status", (Object)this.status()).add("RequestId", (Object)this.requestId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnalysisSummaryList": {
                return Optional.ofNullable(clazz.cast(this.analysisSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAnalysesResponse, T> g) {
        return obj -> g.apply((ListAnalysesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private List<AnalysisSummary> analysisSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer status;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnalysesResponse model) {
            super(model);
            this.analysisSummaryList(model.analysisSummaryList);
            this.nextToken(model.nextToken);
            this.status(model.status);
            this.requestId(model.requestId);
        }

        public final Collection<AnalysisSummary.Builder> getAnalysisSummaryList() {
            return this.analysisSummaryList != null ? (Collection)this.analysisSummaryList.stream().map(AnalysisSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder analysisSummaryList(Collection<AnalysisSummary> analysisSummaryList) {
            this.analysisSummaryList = AnalysisSummaryListCopier.copy(analysisSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisSummaryList(AnalysisSummary ... analysisSummaryList) {
            this.analysisSummaryList(Arrays.asList(analysisSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisSummaryList(Consumer<AnalysisSummary.Builder> ... analysisSummaryList) {
            this.analysisSummaryList(Stream.of(analysisSummaryList).map(c -> (AnalysisSummary)((AnalysisSummary.Builder)AnalysisSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAnalysisSummaryList(Collection<AnalysisSummary.BuilderImpl> analysisSummaryList) {
            this.analysisSummaryList = AnalysisSummaryListCopier.copyFromBuilder(analysisSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public ListAnalysesResponse build() {
            return new ListAnalysesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAnalysesResponse> {
        public Builder analysisSummaryList(Collection<AnalysisSummary> var1);

        public Builder analysisSummaryList(AnalysisSummary ... var1);

        public Builder analysisSummaryList(Consumer<AnalysisSummary.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder status(Integer var1);

        public Builder requestId(String var1);
    }
}

